/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.jdbc;

import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCreator;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementSetter;
import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import com.kingdee.eas.fi.rpt.jdbc.SqlProvider;
import com.kingdee.eas.fi.rpt.jdbc.StatementCreatorUtils;
import com.kingdee.eas.fi.rpt.jdbc.exception.InvalidDataAccessApiUsageException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PreparedStatementCreatorFactory {
    private final String sql;
    private final List declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;

    public PreparedStatementCreatorFactory(String sql) {
        this.sql = sql;
        this.declaredParameters = new LinkedList();
    }

    public PreparedStatementCreatorFactory(String sql, int[] types) {
        this.sql = sql;
        this.declaredParameters = SqlParameter.sqlTypesToAnonymousParameterList(types);
    }

    public PreparedStatementCreatorFactory(String sql, List declaredParameters) {
        this.sql = sql;
        this.declaredParameters = declaredParameters;
    }

    public void addParameter(SqlParameter param) {
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.EMPTY_LIST);
    }

    public PreparedStatementCreator newPreparedStatementCreator(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.EMPTY_LIST);
    }

    public PreparedStatementSetter newPreparedStatementSetter(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.EMPTY_LIST);
    }

    public PreparedStatementSetter newPreparedStatementSetter(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.EMPTY_LIST);
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider {
        private final List parameters;

        public PreparedStatementCreatorImpl(List parameters) {
            this.parameters = parameters;
            if (this.parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException("SQL [" + PreparedStatementCreatorFactory.this.sql + "]: given " + this.parameters.size() + " parameters but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
            }
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = null;
            ps = PreparedStatementCreatorFactory.this.resultSetType == 1003 && !PreparedStatementCreatorFactory.this.updatableResults ? con.prepareStatement(PreparedStatementCreatorFactory.this.sql) : con.prepareStatement(PreparedStatementCreatorFactory.this.sql, PreparedStatementCreatorFactory.this.resultSetType, PreparedStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            this.setValues(ps);
            return ps;
        }

        @Override
        public void setValues(PreparedStatement ps) throws SQLException {
            for (int i = 0; i < this.parameters.size(); ++i) {
                SqlParameter declaredParameter = (SqlParameter)PreparedStatementCreatorFactory.this.declaredParameters.get(i);
                Object in = this.parameters.get(i);
                int sqlColIndx = i + 1;
                StatementCreatorUtils.setParameterValue(ps, sqlColIndx, declaredParameter, in);
            }
        }

        @Override
        public String getSql() {
            return PreparedStatementCreatorFactory.this.sql;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("PreparedStatementCreatorFactory.PreparedStatementCreatorImpl: sql=[");
            buf.append(PreparedStatementCreatorFactory.this.sql).append("]; parameters=").append(this.parameters);
            return buf.toString();
        }

        @Override
        public Object[] getArgs() {
            if (this.parameters != null && !this.parameters.isEmpty()) {
                return this.parameters.toArray();
            }
            return null;
        }
    }
}

