/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.jdbc.statement;

import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractCslStatement {
    private static final int MAXNUM = 1000;
    private int addBatchNum = 0;

    protected final void afterAddBatch() throws SQLException {
        if (this.getStatement() == null) {
            return;
        }
        if (this.addBatchNum >= 1000) {
            this.getStatement().executeBatch();
            this.getStatement().clearBatch();
            this.addBatchNum = 0;
        }
    }

    protected void addBatch(String sql) throws SQLException {
        if (this.getStatement() == null || StringUtils.isEmpty((String)sql)) {
            return;
        }
        this.getStatement().addBatch(sql);
        this.addBatchNum();
        this.afterAddBatch();
    }

    protected final void addBatchNum() {
        ++this.addBatchNum;
    }

    public final int[] executeBatch() throws SQLException {
        if (this.getStatement() == null) {
            return null;
        }
        int[] v = this.getStatement().executeBatch();
        this.addBatchNum = 0;
        return v;
    }

    public final void clearBatch() throws SQLException {
        if (this.getStatement() == null) {
            return;
        }
        this.getStatement().clearBatch();
        this.addBatchNum = 0;
    }

    public abstract Statement getStatement();
}

