/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.rptdata;

import com.kingdee.eas.fi.rpt.RptDataInfo;
import com.kingdee.eas.fi.rpt.rptdata.RptDataUtil;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RptDataMerge {
    private static final Logger log = Logger.getLogger(RptDataMerge.class);

    public RptDataInfo merge(RptDataInfo oldInfo, RptDataInfo newInfo) {
        if (oldInfo == null || newInfo == null || newInfo.getId() == null) {
            return newInfo;
        }
        newInfo = (RptDataInfo)newInfo.clone();
        Timestamp oldServerCalcStartTime = oldInfo.getServerCalcStartTime();
        Timestamp newServerCalcStartTime = newInfo.getServerCalcStartTime();
        long oldServerCalcFinishTime = oldInfo.getServerCalcFinishTime();
        long newServerCalcFinishTime = newInfo.getServerCalcFinishTime();
        Timestamp oldCalcStartTime = oldInfo.getCalcStartTime();
        Timestamp newCalcStartTime = newInfo.getCalcStartTime();
        long oldCalcFinishTime = oldInfo.getCalcFinishTime();
        long newCalcFinishTime = newInfo.getCalcFinishTime();
        if (oldCalcFinishTime == Long.MAX_VALUE) {
            oldCalcFinishTime = 0L;
        }
        if (newCalcFinishTime == Long.MAX_VALUE) {
            newCalcFinishTime = 0L;
        }
        Timestamp serverCalcStartTime = newServerCalcStartTime;
        long serverCalcFinishTime = newServerCalcFinishTime;
        Timestamp calcStartTime = newCalcStartTime;
        long calcFinishTime = newCalcFinishTime;
        boolean isSerial = false;
        if (oldServerCalcStartTime.getTime() + oldServerCalcFinishTime <= newServerCalcStartTime.getTime()) {
            serverCalcStartTime = oldServerCalcStartTime;
            serverCalcFinishTime = oldServerCalcFinishTime + newServerCalcFinishTime;
            isSerial = true;
        }
        if (oldCalcStartTime.getTime() + oldCalcFinishTime <= newCalcStartTime.getTime()) {
            calcStartTime = oldCalcStartTime;
            calcFinishTime = oldCalcFinishTime + newCalcFinishTime;
            isSerial = true;
        }
        newInfo.setCalcFinishTime(calcFinishTime);
        newInfo.setCalcStartTime(calcStartTime);
        newInfo.setServerCalcFinishTime(serverCalcFinishTime);
        newInfo.setServerCalcStartTime(serverCalcStartTime);
        if (isSerial) {
            Properties oldFormulas = RptDataUtil.convertProperties(oldInfo.getFormulaDetail());
            Properties newFormulas = RptDataUtil.convertProperties(newInfo.getFormulaDetail());
            int newFormulaNum = newInfo.getTotalFormulaNum();
            Object formulaName2 = null;
            String formulaNum = null;
            for (Object formulaName2 : oldFormulas.keySet()) {
                if (!(formulaName2 instanceof String)) continue;
                formulaNum = oldFormulas.getProperty((String)formulaName2);
                try {
                    if (newFormulas.containsKey(formulaName2)) {
                        int oldNum = Integer.parseInt(oldFormulas.getProperty((String)formulaName2));
                        int newNum = Integer.parseInt(newFormulas.getProperty((String)formulaName2));
                        newFormulas.put(formulaName2, "" + (oldNum + newNum));
                        newFormulaNum += oldNum;
                        continue;
                    }
                    newFormulas.put(formulaName2, formulaNum);
                    newFormulaNum += Integer.parseInt(formulaNum);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            newInfo.setFormulaDetail(RptDataUtil.convertProperies2String(newFormulas));
            newInfo.setTotalFormulaNum(newFormulaNum);
        }
        return newInfo;
    }
}

