/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.sqlUtil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.IDBCenter;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.sqlGetData.FillSqlGetDataHelp;
import com.kingdee.eas.fi.rpt.ISqlUtilFacade;
import com.kingdee.eas.fi.rpt.Parster;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.SqlUtilFacadeFactory;
import com.kingdee.eas.fi.rpt.sqlUtil.FillingEngine;
import com.kingdee.eas.fi.rpt.sqlUtil.SimpleFilter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.SqlResult;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SqlResultFillter
extends FillingEngine {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.sqlUtil.SqlResultFillter");
    public static final String endFlag = "**end**";
    public static final int width = 200;
    public static final int height = 2000;
    public static final int MAXROW = 20000;
    private List sqlRanges;
    private boolean calCurPage;
    List handledLists = null;
    private IReportPropertyAdapter adapt = null;
    private ReportVariables vars = null;
    private Context ctx = null;

    public SqlResultFillter(Book book, boolean calCurPage) {
        super(book);
        this.calCurPage = calCurPage;
        this.sqlRanges = new ArrayList();
        this.handledLists = new ArrayList();
    }

    public SqlResultFillter(Context ctx, Book book, boolean calCurPage, ReportBaseInfo reportInfo) {
        super(book);
        this.calCurPage = calCurPage;
        this.sqlRanges = new ArrayList();
        this.handledLists = new ArrayList();
        this.vars = ReportVariables.loadFromBook((Book)book);
        if (reportInfo instanceof ReportInfo) {
            this.adapt = new RptReportPropertyAdapter((ReportInfo)reportInfo);
        } else if (reportInfo instanceof CslReportInfo) {
            this.adapt = new CSLPropertyAdapter((CslReportInfo)reportInfo, ctx);
        }
        this.ctx = ctx;
    }

    public SqlResultFillter(Context ctx, Book book, boolean calCurPage, ReportVariables vars, IReportPropertyAdapter adapt) {
        super(book);
        this.calCurPage = calCurPage;
        this.sqlRanges = new ArrayList();
        this.handledLists = new ArrayList();
        this.vars = vars;
        this.adapt = adapt;
        this.ctx = ctx;
    }

    public void beforeFillRusult() {
        this.book.getUndoManager().enable(false);
        this.sqlRanges.clear();
        this.handledLists.clear();
    }

    public void afterFillRusult() {
        this.book.getUndoManager().enable(true);
    }

    public void afterCalculate() {
        this.clearSQLRanges();
    }

    public void clearSQLRanges() {
        for (int i = 0; i < this.sqlRanges.size(); ++i) {
            Range range = (Range)this.sqlRanges.get(i);
            range.setValue(null);
        }
    }

    public SqlResult getSqlResult(String sql) {
        sql = this.parseSql(sql);
        SqlResult rs = null;
        try {
            rs = this.getISqlUtilFacade().execute(sql);
        }
        catch (BOSException exp) {
            exp.printStackTrace();
        }
        return rs;
    }

    private ISqlUtilFacade getISqlUtilFacade() throws BOSException {
        ISqlUtilFacade isql = null;
        isql = this.ctx == null ? SqlUtilFacadeFactory.getRemoteInstance() : SqlUtilFacadeFactory.getLocalInstance(this.ctx);
        return isql;
    }

    private void contractiRows(int startRowIndex, int contractSize, Sheet sheet) {
        if (startRowIndex < 0 || contractSize <= 0) {
            return;
        }
        int maxRowIndex = sheet.getRows().getMaxIntMark();
        if (startRowIndex >= maxRowIndex + 1) {
            sheet.getRowRange(startRowIndex - contractSize, startRowIndex).clear(true, true, true, true);
            return;
        }
        int tmp = maxRowIndex - startRowIndex;
        Range orginalRange = sheet.getRowRange(startRowIndex, maxRowIndex);
        boolean isCut = orginalRange.copy();
        Range newRange = sheet.getRowRange(startRowIndex - contractSize, maxRowIndex - contractSize);
        if (isCut) {
            orginalRange.clear(true, true, true, true);
            newRange.paste(PasteMode.ALL);
            int begin = maxRowIndex - contractSize + 1;
            if (begin > maxRowIndex) {
                begin = maxRowIndex;
            }
            sheet.getRowRange(begin, maxRowIndex).clear(true, true, true, true);
            this.copyItemFormula(false, sheet, startRowIndex, maxRowIndex, startRowIndex - contractSize, maxRowIndex - contractSize);
        }
    }

    private void contractiCols(int startColIndex, int contractSize, Sheet sheet) {
        if (startColIndex < 0 || contractSize <= 0) {
            return;
        }
        int maxColIndex = sheet.getCols().getMaxIntMark();
        if (startColIndex >= maxColIndex) {
            sheet.getColRange(startColIndex - contractSize, startColIndex).clear(true, true, true, true);
            return;
        }
        int tmp = maxColIndex - startColIndex;
        Range orginalRange = sheet.getColRange(startColIndex, maxColIndex);
        boolean isCut = orginalRange.copy();
        Range newRange = sheet.getColRange(startColIndex - contractSize, maxColIndex - contractSize);
        if (isCut) {
            orginalRange.clear(true, true, true, true);
            newRange.paste(PasteMode.ALL);
        }
    }

    private void expandRows(boolean isFirstCal, int startRowIndex, int expandSize, Sheet sheet) {
        if (startRowIndex < 0 || expandSize <= 0) {
            return;
        }
        int maxRowIndex = sheet.getRows().getMaxIntMark();
        if (startRowIndex >= maxRowIndex) {
            return;
        }
        int tmp = maxRowIndex - startRowIndex;
        int begin = isFirstCal ? startRowIndex + 1 : startRowIndex;
        Range orginalRange = sheet.getRowRange(begin, maxRowIndex);
        boolean isCut = orginalRange.copy();
        Range newRange = sheet.getRowRange(begin + expandSize, startRowIndex + expandSize + tmp);
        if (isCut) {
            orginalRange.clear(true, true, true, true);
            newRange.paste(PasteMode.ALL);
            this.copyItemFormula(true, sheet, begin, maxRowIndex, begin + expandSize, startRowIndex + expandSize + tmp);
        }
    }

    private void copyItemFormula(boolean isExpand, Sheet sheet, int fromBegin, int fromEnd, int toBegin, int toEnd) {
        int maxColum = sheet.getCols().getMaxIntMark();
        if (isExpand) {
            int i = fromEnd;
            int j = 0;
            while (i >= fromBegin) {
                Row fromRow = sheet.getRow(i, true);
                Row toRow = sheet.getRow(toEnd - j, true);
                this.copyRowItemFormula(maxColum, fromRow, toRow);
                --i;
                ++j;
            }
        } else {
            int i = fromBegin;
            int j = 0;
            while (i <= fromEnd) {
                Row fromRow = sheet.getRow(i, true);
                Row toRow = sheet.getRow(toBegin + j, true);
                this.copyRowItemFormula(maxColum, fromRow, toRow);
                ++i;
                ++j;
            }
        }
    }

    private void copyRowItemFormula(int maxColum, Row fromRow, Row toRow) {
        int max = maxColum;
        for (int i = 0; i < max; ++i) {
            Cell cell = fromRow.getCell(i, true);
            Cell toCell = toRow.getCell(i, true);
            Object obj = null;
            if (cell != null) {
                obj = cell.getUserObjectValue("ITEM");
            }
            if (cell == null || toCell == null || obj == null) continue;
            toCell.setUserObject("ITEM", obj);
            cell.setUserObject("ITEM", null);
        }
    }

    private void expandColumns(int startColumnIndex, int expandSize, Sheet sheet) {
        if (startColumnIndex < 0 || expandSize <= 0) {
            return;
        }
        int maxColumnIndex = sheet.getCols().getMaxIntMark();
        if (startColumnIndex >= maxColumnIndex) {
            return;
        }
        Range orginalRange = sheet.getColRange(startColumnIndex + 1, maxColumnIndex);
        boolean isCut = orginalRange.cut();
        int tmp = maxColumnIndex - startColumnIndex;
        Range newRange = sheet.getColRange(startColumnIndex + expandSize + 1, startColumnIndex + expandSize + tmp);
        if (isCut) {
            orginalRange.clear(true, true, true, true);
            newRange.paste(PasteMode.ALL);
        }
    }

    public Range searchNextRange(Sheet sheet, List handledRanges) {
        int rowCount = sheet.getRows().getMaxIntMark() + 1;
        int columnCount = sheet.getCols().getMaxIntMark() + 1;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                String[] params;
                String model;
                Point point = new Point(j, i);
                Range range = sheet.getRange(i, j);
                String formula = range.getFormula();
                if (formula == null || formula.indexOf("=executeSQL") < 0 || this.isExist(point, handledRanges) || (model = (params = this.handleSQLFormula(formula))[2]).length() != 2 || !model.endsWith("1")) continue;
                return range;
            }
        }
        return null;
    }

    private boolean isExist(Point point, List ranges) {
        for (int i = 0; i < ranges.size(); ++i) {
            Range range = (Range)ranges.get(i);
            int height = range.getBounds().getRow();
            int width = range.getBounds().getCol();
            if (point.x != width || point.y != height) continue;
            return true;
        }
        return false;
    }

    public void fillSheetResult(Sheet sheet) {
        boolean end = false;
        while (!end) {
            Range range = this.searchNextRange(sheet, this.handledLists);
            if (range != null) {
                this.handledLists.add(range);
                this.fillResult(range);
                continue;
            }
            end = true;
        }
    }

    public void fillBookResult() {
        for (int k = 0; k < this.book.getSheetCount(); ++k) {
            Sheet sheet = this.book.getSheet(k);
            this.fillSheetResult(sheet);
        }
    }

    public void fillResult() {
        this.beforeFillRusult();
        if (this.calCurPage) {
            this.fillSheetResult(this.book.getActiveSheet());
        } else {
            this.fillBookResult();
        }
        SimpleFilter engine = new SimpleFilter(this.ctx, this.book, this.calCurPage, this.handledLists, this.vars, this.adapt);
        engine.fillResult();
        this.afterFillRusult();
    }

    private int getOriginalEnd(Sheet sheet, int beginX, int beginY) {
        int maxRowIndex = sheet.getRows().getMaxIntMark();
        for (int i = 0; i <= maxRowIndex; ++i) {
            Range range = sheet.getRange(i + beginX, beginY);
            String value = range.getText();
            if (value == null || !endFlag.equals(value.trim())) continue;
            return i + beginX;
        }
        return -1;
    }

    private int getOriginalColEnd(Sheet sheet, int beginX, int beginY) {
        int maxColIndex = sheet.getCols().getMaxIntMark();
        for (int i = 0; i <= maxColIndex; ++i) {
            Range range = sheet.getRange(beginX, beginY + i);
            String value = range.getText();
            if (value == null || !endFlag.equals(value.trim())) continue;
            return i + beginX;
        }
        return -1;
    }

    private void expendOrContractRows(int rowSize, Sheet sheet, int y, int x, int colSize) {
        int beginEnd = this.getOriginalEnd(sheet, y, x);
        if (beginEnd - y - 1 > rowSize) {
            int contractSize = beginEnd - y - rowSize - 1;
            sheet.getRowRange(beginEnd, beginEnd + 1).setHidden(false, true);
            sheet.getRange(y + 1, x, beginEnd, x + colSize - 1).clear(true, true, true, true);
            this.contractiRows(beginEnd + 1, contractSize, sheet);
        } else if (beginEnd - y - 1 < rowSize) {
            int expSize = beginEnd < 0 ? rowSize - beginEnd : rowSize - (beginEnd - y - 1);
            int startIndex = y;
            boolean isFirstCol = true;
            if (beginEnd > 0) {
                startIndex = beginEnd + 1;
                sheet.getRowRange(beginEnd, beginEnd + 1).setHidden(false, true);
                isFirstCol = false;
            }
            this.expandRows(isFirstCol, startIndex, expSize, sheet);
        }
    }

    private void expendOrContractCols(int colSize, Sheet sheet, int y, int x) {
        int beginEnd = this.getOriginalColEnd(sheet, y, x);
        if (beginEnd - x - 1 > colSize) {
            int contractSize = beginEnd - x - colSize;
            this.contractiRows(beginEnd + 1, contractSize, sheet);
        } else if (beginEnd - x - 1 < colSize) {
            int expSize = beginEnd < 0 ? colSize - beginEnd : colSize - beginEnd + 1;
            this.expandColumns(x, expSize, sheet);
        }
    }

    public void fillResult(Range sqlRange) {
        String formula = sqlRange.getFormula();
        String[] params = this.handleSQLFormula(formula);
        if (params != null) {
            String sql = params[0];
            int showField = Integer.parseInt(params[1].trim());
            int clearColumn = Integer.parseInt(params[2].trim());
            clearColumn = 0;
            Sheet sheet = this.book.getSheet(this.getSheetName(sqlRange));
            FillSqlGetDataHelp sqlHelp = new FillSqlGetDataHelp(this.ctx, sheet, null, null, this.vars, this.adapt, this.book);
            sql = sqlHelp.getExeSql(sql);
            int x = sqlRange.getBounds().getCol();
            int y = sqlRange.getBounds().getRow();
            IRowSet rowset = null;
            if (params.length == 5) {
                try {
                    sql = this.parseSql(sql);
                    String dbCenterNumber = params[4];
                    DBCenterInfo dbCenter = this.getDbCenterInfo(dbCenterNumber);
                    rowset = this.getISqlUtilFacade().excuteQueryByDbCenter(dbCenter, sql, null);
                }
                catch (EASBizException e) {
                    logger.error((Object)"getDBCenterInfo: ", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getDBCenterInfo: ", (Throwable)e);
                }
            } else {
                SqlResult rs = this.getSqlResult(sql);
                rowset = this.getLastRowSet(rs);
            }
            int rowSize = rowset.size();
            if (rowset != null && rowSize > -1) {
                ResultSetMetaData meta = null;
                int colSize = 0;
                try {
                    meta = rowset.getMetaData();
                    colSize = meta.getColumnCount();
                }
                catch (SQLException e) {
                    return;
                }
                Integer rowHeight = new Integer(Sheet.getRowHeight((Sheet)sheet, (int)(y + 1)));
                HashMap<String, Object> styleMap = new HashMap<String, Object>();
                styleMap.put("rowHeight", rowHeight);
                HashMap<Integer, Style> saMap = new HashMap<Integer, Style>();
                styleMap.put("sa", saMap);
                HashMap<Integer, MessagedValidate> colValidMap = new HashMap<Integer, MessagedValidate>();
                styleMap.put("colValid", colValidMap);
                for (int i = 0; i < colSize; ++i) {
                    MessagedValidate colValid = sheet.getValidations().getValidate(y + 1, x + i);
                    colValidMap.put(x + i, colValid);
                    Style sa = sheet.getCell(y + 1, x + i, true).getStyle();
                    saMap.put(x + i, sa);
                }
                this.expendOrContractRows(rowSize, sheet, y, x, colSize);
                if (showField == 1) {
                    this.fillHead(sheet, rowset, x, y, styleMap);
                }
                this.fillBody(sheet, rowset, x, y, showField, clearColumn, styleMap);
                sheet.getRange(y + 2 + rowSize + showField, x, y + 2 + rowSize + showField, x + colSize - 1).clear(true, true, true, true);
            }
        }
    }

    private IDBCenter getDBCenterInstance() throws BOSException {
        if (this.ctx != null) {
            return DBCenterFactory.getLocalInstance((Context)this.ctx);
        }
        return DBCenterFactory.getRemoteInstance();
    }

    private DBCenterInfo getDbCenterInfo(String dbCenterNumber) throws EASBizException, BOSException {
        DBCenterInfo dbCenter = this.getDBCenterInstance().getDBCenterInfo("where number = '" + dbCenterNumber + "'");
        if (dbCenter != null && !StringUtils.isEmpty((String)dbCenter.getDbPassWord())) {
            String secret = new String(Base64.decode((String)dbCenter.getDbPassWord()));
            dbCenter.setDbPassWord(secret);
        }
        return dbCenter;
    }

    public void fillBody(Sheet sheet, IRowSet rs, int x, int y, int showField, int clearColumn, Map<String, Object> styleMap) {
        try {
            int c = rs.getMetaData().getColumnCount();
            int j = 0;
            if (clearColumn > 0) {
                Range range = sheet.getRange(y + showField + 1, x, y + showField + 20000, x + c - 1);
                range.clear(true, true, false, false);
            }
            Integer rowHeight = null;
            MessagedValidate colValid = null;
            ShareStyleAttributes sa = null;
            ValidationList sheetValids = sheet.getValidations();
            rowHeight = new Integer(styleMap.get("rowHeight").toString());
            while (rs.next()) {
                for (int i = 0; i < c; ++i) {
                    StyleAttributes saInnerBorder;
                    Object object = rs.getObject(i + 1);
                    Cell cell = sheet.getCell(y + j + showField + 1, x + i, true);
                    if (object != null && object.toString().startsWith("=")) {
                        String formula = object.toString().replaceAll("\\\\\"", "\"");
                        cell.setFormula(formula);
                    } else {
                        cell.setValue(new Variant(object));
                    }
                    Range rang = sheet.getRange(cell);
                    colValid = (MessagedValidate)((Map)styleMap.get("colValid")).get(x + i);
                    sheetValids.insertValidation(colValid, (SortedCellBlockArray)rang);
                    sa = (ShareStyleAttributes)((Map)styleMap.get("sa")).get(x + i);
                    StyleAttributes saOuterBorder = saInnerBorder = Styles.getSA((ShareStyleAttributes)sa);
                    saOuterBorder.setDirty(StyleAttributes.getAllBits());
                    saInnerBorder.setDirty(StyleAttributes.getAllBits());
                    rang.setStyle(saOuterBorder, saInnerBorder);
                }
                sheet.getRowSpans().setSpanAttribute(new Span(y + j + showField + 1, y + j + showField + 1), null, rowHeight, null, null, null, null);
                ++j;
            }
            for (int v = 0; v < c; ++v) {
                Cell cell = sheet.getCell(j + y + showField + 1, x + v, true);
                cell.setValue(new Variant((Object)endFlag));
            }
            sheet.getRowRange(y + j + showField + 1, y + j + showField + 1).setHidden(true, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public IRowSet getLastRowSet(SqlResult rs) {
        if (rs != null && rs.getRowSets().size() > 0) {
            int size = rs.getRowSets().size();
            return (IRowSet)rs.getRowSets().get(size - 1);
        }
        return null;
    }

    private void fillHead(Sheet sheet, IRowSet rs, int x, int y, Map<String, Object> styleMap) {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int c = meta.getColumnCount();
            Integer rowHeight = null;
            MessagedValidate colValid = null;
            ShareStyleAttributes sa = null;
            ValidationList sheetValids = sheet.getValidations();
            rowHeight = new Integer(styleMap.get("rowHeight").toString());
            for (int i = 0; i < c; ++i) {
                StyleAttributes saInnerBorder;
                Range rang2 = sheet.getRange(y + 1, x + i);
                rang2.setValue(new Variant((Object)meta.getColumnName(i + 1)));
                colValid = (MessagedValidate)((Map)styleMap.get("colValid")).get(x + i);
                sheetValids.insertValidation(colValid, (SortedCellBlockArray)rang2);
                sa = (ShareStyleAttributes)((Map)styleMap.get("sa")).get(x + i);
                StyleAttributes saOuterBorder = saInnerBorder = Styles.getSA((ShareStyleAttributes)sa);
                saOuterBorder.setDirty(StyleAttributes.getAllBits());
                saInnerBorder.setDirty(StyleAttributes.getAllBits());
                rang2.setStyle(saOuterBorder, saInnerBorder);
            }
            sheet.getRowSpans().setSpanAttribute(new Span(y + 1, y + 1), null, rowHeight, null, null, null, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getSheetName(Range rang) {
        String temp = rang.getName(true);
        String[] ss = temp.split("!");
        return ss[0].replaceAll("'", "");
    }

    public String parseSql(String sql) {
        Parster parster = new Parster(sql, this.book);
        return parster.getSql();
    }

    private String[] handleSQLFormula(String formula) {
        int length;
        String[] ss;
        if (this.checkIsSQLFormula(formula) && (formula = StringUtils.replace((String)formula, (String)"=executeSQL", (String)"")).length() > 0 && formula.indexOf("#") >= 0 && (ss = (formula = formula.substring(1, (length = formula.length()) - 1)).split("#")).length >= 3) {
            ss[0] = ss[0].substring(1);
            ss[1] = this.clear(ss[1]);
            ss[2] = this.clear(ss[2]);
            if (ss.length == 5) {
                ss[4] = this.clear(ss[4]);
            }
            return ss;
        }
        return null;
    }

    private String clear(String ss) {
        ss = StringUtils.replace((String)ss, (String)"\"", (String)"");
        ss = StringUtils.replace((String)ss, (String)",", (String)"");
        return ss;
    }

    private boolean checkIsSQLFormula(String formula) {
        return formula != null && formula.startsWith("=executeSQL");
    }

    public void addSqlRange(Sheet sheet) {
        Range range = null;
        for (int i = 0; i < 2000; ++i) {
            for (int j = 0; j < 200; ++j) {
                range = sheet.getRange(i, j);
                this.addSqlRange(range);
            }
        }
    }

    public void addSqlRange(Range range) {
        if (range.getFormula() != null && range.getFormula().indexOf("=executeSQL") >= 0) {
            this.sqlRanges.add(range);
        }
    }

    public void addSqlRange(Book book) {
        for (int k = 0; k < book.getSheetCount(); ++k) {
            Sheet sheet = book.getSheet(k);
            this.addSqlRange(sheet);
        }
    }

    public void addSqlRange() {
        this.addSqlRange(this.book);
    }

    @Override
    protected boolean execute() {
        return false;
    }
}

