/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AcctountAsstItemParser {
    private static final char DONE = '\uffff';
    private static final char METONYMY = '\'';
    String line = "";
    StringCharacterIterator strit;
    int pos = 0;
    List tokens = new ArrayList();

    public static AccountAsstItem parse(String line) throws ParseException {
        return AcctountAsstItemParser.parse(line, true);
    }

    public static AccountAsstItem parse(String line, boolean isParseQuote) throws ParseException {
        AcctountAsstItemParser parser = new AcctountAsstItemParser();
        parser.line = line;
        parser.parse1(isParseQuote);
        return parser.parse();
    }

    private AccountAsstItem parse() throws ParseException {
        if (this.tokens == null) {
            return null;
        }
        AccountAsstItem result = new AccountAsstItem();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            String token = (String)this.tokens.get(i);
            if (token.matches("\\||:|#|&|,|;")) {
                sb.append(token);
                continue;
            }
            sb.append(i);
        }
        String l = sb.toString();
        int pos = (l = l.replaceAll("\\|\\|", "\\| \\|")).indexOf(124);
        if (pos <= -1) {
            this.parseAccountNumber(l, result);
            return result;
        }
        this.parseAccountNumber(l.substring(0, pos), result);
        l = l.substring(pos + 1);
        AsstItem item = null;
        StringTokenizer st = new StringTokenizer(l, "|");
        ArrayList<AsstItem> assts = new ArrayList<AsstItem>(1);
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i % 2 == 0) {
                item = new AsstItem();
                assts.add(item);
                item.asstTypeNumber = this.readToken(st.nextToken());
            } else {
                this.parseAsst(st.nextToken(), item);
            }
            ++i;
        }
        if (assts.size() > 0) {
            result.asstItems = new AsstItem[assts.size()];
            for (i = 0; i < assts.size(); ++i) {
                result.asstItems[i] = (AsstItem)assts.get(i);
            }
        }
        return result;
    }

    private void parseAccountNumber(String string, AccountAsstItem result) {
        String[] ss = string.split("\\||\\,|\\;");
        Range[] ranges = new Range[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            Range r = new Range();
            this.parseRange(ss[i], r);
            ranges[i] = r;
            if (i != 0) continue;
            result.startNumber = r.startNumber;
            result.endNumber = r.endNumber;
        }
        result.accounts = ranges;
    }

    private void parseAsst(String line, AsstItem item) {
        int pos = line.lastIndexOf(35);
        if (pos < 0) {
            this.parseRange(line, item);
            return;
        }
        this.parseRange(line.substring(pos + 1), item);
        String l = line.substring(0, pos);
        StringTokenizer st = new StringTokenizer(l, "&");
        ArrayList<Group> groups = new ArrayList<Group>(1);
        int i = 0;
        while (st.hasMoreTokens()) {
            String gp = st.nextToken();
            pos = gp.lastIndexOf(35);
            Group group = new Group();
            groups.add(group);
            if (pos < 0) {
                this.parseRange(gp, group);
            } else {
                this.parseRange(gp.substring(pos + 1), group);
                group.standardNumber = this.readToken(gp.substring(0, pos));
            }
            ++i;
        }
        if (groups.size() > 0) {
            item.group = new Group[groups.size()];
            for (i = 0; i < groups.size(); ++i) {
                item.group[i] = (Group)groups.get(i);
            }
        }
    }

    private void parseRange(String line, Range range) {
        int pos = line.indexOf(58);
        if (pos > -1) {
            range.startNumber = this.readToken(line.substring(0, pos));
            range.endNumber = this.readToken(line.substring(pos + 1));
        } else {
            range.endNumber = range.startNumber = this.readToken(line);
        }
    }

    private String readToken(String num) {
        Matcher m = Pattern.compile("\\d+").matcher(num);
        StringBuffer sb = new StringBuffer();
        int last = 0;
        while (m.find()) {
            sb.append(num.substring(last, m.start()));
            last = m.end();
            sb.append((String)this.tokens.get(Integer.parseInt(m.group())));
        }
        return sb.toString();
    }

    private List parse1() throws ParseException {
        return this.parse1(true);
    }

    private List parse1(boolean isHandleQuote) throws ParseException {
        this.strit = new StringCharacterIterator(this.line);
        char c = '\uffff';
        do {
            if (Character.isWhitespace(c = (char)this.strit.current())) continue;
            if (c == ',' || c == ':' || c == '|' || c == '#' || c == '&' || c == ';') {
                this.tokens.add("" + c);
                continue;
            }
            if (isHandleQuote && c == '\'') {
                this.readQuotedString();
                continue;
            }
            this.readString();
        } while (this.strit.next() != '\uffff');
        return this.tokens;
    }

    private void readQuotedString() throws ParseException {
        char c = '\uffff';
        StringBuffer sb = new StringBuffer();
        while (true) {
            if ((c = (char)this.strit.next()) == '\uffff') {
                throw new ParseException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"261_AcctountAsstItemParser"), this.strit.getIndex());
            }
            if (c == '\'' && this.strit.next() != '\'') {
                this.tokens.add(sb.toString());
                this.strit.previous();
                return;
            }
            sb.append(c);
        }
    }

    private void readString() {
        char c = '\uffff';
        StringBuffer sb = new StringBuffer();
        while (true) {
            if ((c = (char)this.strit.current()) == ';' || c == ',' || c == ':' || c == '|' || c == '#' || c == '&' || c == '\uffff') {
                if (c != '\uffff') {
                    this.strit.previous();
                }
                this.tokens.add(sb.toString().trim());
                return;
            }
            sb.append(c);
            this.strit.next();
        }
    }

    public class Group
    extends Range {
        public String standardNumber;

        @Override
        public String toString() {
            if (StringUtils.isEmpty((String)this.standardNumber)) {
                return super.toString();
            }
            return this.standardNumber + "#" + super.toString();
        }
    }

    public class AsstItem
    extends Range {
        public String asstTypeNumber;
        public Group[] group;

        @Override
        public String toString() {
            if (this.group == null || this.group.length < 1) {
                return this.asstTypeNumber + '|' + super.toString();
            }
            String r = "";
            for (int i = 0; i < this.group.length; ++i) {
                r = i == 0 ? this.group[i].toString() : r + '&' + this.group[i].toString();
            }
            return this.asstTypeNumber + '|' + r + '#' + super.toString();
        }
    }

    public class AccountAsstItem
    extends Range {
        public Range[] accounts;
        public AsstItem[] asstItems;

        @Override
        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < this.accounts.length; ++i) {
                sb.append(this.accounts[i].toString());
                if (this.accounts.length - 1 <= i) continue;
                sb.append(',');
            }
            if (this.asstItems == null || this.asstItems.length < 1) {
                return sb.toString();
            }
            sb.append('|');
            for (i = 0; i < this.asstItems.length; ++i) {
                AsstItem item = this.asstItems[i];
                if (i == 0) {
                    sb.append(item.toString());
                    continue;
                }
                sb.append('|').append(item.toString());
            }
            return sb.toString();
        }

        public String toOldString() {
            if (this.asstItems == null || this.asstItems.length < 1) {
                return super.toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString()).append('|');
            for (int i = 0; i < this.asstItems.length; ++i) {
                AsstItem item = this.asstItems[i];
                if (i == 0) {
                    sb.append(item.toString());
                    continue;
                }
                sb.append('|').append(item.toString());
            }
            return sb.toString();
        }
    }

    public class Range
    implements Serializable {
        private static final long serialVersionUID = -6230238072154413232L;
        public String startNumber;
        public String endNumber;

        public String toString() {
            if (StringUtils.isEmpty((String)this.startNumber) && StringUtils.isEmpty((String)this.endNumber)) {
                return "";
            }
            if (StringUtils.isEmpty((String)this.startNumber)) {
                return this.endNumber;
            }
            if (StringUtils.isEmpty((String)this.endNumber)) {
                return this.startNumber;
            }
            if (this.endNumber == this.startNumber || this.endNumber.equals(this.startNumber)) {
                return this.startNumber;
            }
            return this.startNumber + ":" + this.endNumber;
        }
    }
}

