/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class CachingMap
implements Map,
Serializable {
    private final Map targetMap;

    public CachingMap() {
        this(false);
    }

    public CachingMap(boolean weakKeys) {
        AbstractMap internalMap = weakKeys ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(internalMap);
    }

    public CachingMap(boolean weakKeys, int size) {
        AbstractMap internalMap = weakKeys ? new WeakHashMap(size) : new HashMap(size);
        this.targetMap = Collections.synchronizedMap(internalMap);
    }

    public CachingMap(Map targetMap) {
        this.targetMap = targetMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    public Object put(Object key, Object value) {
        return this.targetMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.targetMap.remove(key);
    }

    public void putAll(Map t) {
        this.targetMap.putAll(t);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    public Set keySet() {
        return this.targetMap.keySet();
    }

    public Collection values() {
        return this.targetMap.values();
    }

    public Set entrySet() {
        return this.targetMap.entrySet();
    }

    public Object get(Object key) {
        return this.targetMap.get(key);
    }

    public String toString() {
        return "CachingMap [" + this.getClass().getName() + "]:" + this.targetMap;
    }
}

