/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckReport {
    private static final Logger log = Logger.getLogger((String)CheckReport.class.getName());
    private static final int MAX_ROW = 5000;
    private static final int MAX_COL = 500;
    private static final Set normalReportSet = new HashSet();
    private static final Set CSLReportSet = new HashSet();

    public static StringBuffer checkReport(Context ctx, int year, int period, int maxRow, int maxCol) throws BOSException {
        maxRow = maxRow == 0 ? 5000 : maxRow;
        maxCol = maxCol == 0 ? 500 : maxCol;
        String kql = "select id, number, name, sourceType, data, currency.number, currency.name, orgTree.number, orgTree.name, orgUnit.number, orgUnit.name, company.name, template.id, template.number, template.name, template.templateType, template.data where year = " + year + " and period = " + period;
        CslReportCollection cslreportCollection = CslReportFactory.getLocalInstance((Context)ctx).getCslReportCollection(kql);
        StringBuffer error = new StringBuffer();
        for (CslReportInfo report : cslreportCollection) {
            byte[] reportData = report.getData();
            try {
                Book book = IOHelper.unpackBook(reportData);
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (sheet.getMaxRowIndex() + 1 <= maxRow && sheet.getMaxColIndex() + 1 <= maxCol) continue;
                    int row = sheet.getMaxRowIndex() + 1;
                    int col = sheet.getMaxColIndex() + 1;
                    if (CSLReportSet.contains(report.getSourceType().getName())) {
                        error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"311_CheckReport", (Locale)ctx.getOriginLocale()) + report.getOrgTree().getName()).append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"312_CheckReport", (Locale)ctx.getOriginLocale())).append(report.getOrgUnit().getName()).append(" ");
                    } else {
                        error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"313_CheckReport", (Locale)ctx.getOriginLocale()) + report.getOrgUnit().getName()).append(" ");
                    }
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"314_CheckReport", (Locale)ctx.getOriginLocale()) + report.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"315_CheckReport", (Locale)ctx.getOriginLocale()) + report.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"316_CheckReport", (Locale)ctx.getOriginLocale()) + (Object)((Object)report.getSourceType()) + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"317_CheckReport", (Locale)ctx.getOriginLocale()) + report.getCurrency().getName() + " " + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"318_CheckReport", (Locale)ctx.getOriginLocale()) + row + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"319_CheckReport", (Locale)ctx.getOriginLocale()) + col + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"320_CheckReport", (Locale)ctx.getOriginLocale()));
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex.getMessage());
            }
            TemplateInfo template = report.getTemplate();
            byte[] templateData = template.getData();
            try {
                Book book = IOHelper.unpackBook(templateData);
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (sheet.getMaxRowIndex() + 1 <= maxRow && sheet.getMaxColIndex() + 1 <= maxCol) continue;
                    int row = sheet.getMaxRowIndex() + 1;
                    int col = sheet.getMaxColIndex() + 1;
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"321_CheckReport", (Locale)ctx.getOriginLocale()) + template.getName() + " " + template.getNumber() + " " + (Object)((Object)template.getTemplateType()) + " " + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"322_CheckReport", (Locale)ctx.getOriginLocale()) + row + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"323_CheckReport", (Locale)ctx.getOriginLocale()) + col + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"320_CheckReport", (Locale)ctx.getOriginLocale()));
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex.getMessage());
            }
        }
        return error;
    }

    static {
        normalReportSet.add("NORMAL");
        normalReportSet.add("DYNAMICNORMALREPORT");
        normalReportSet.add("MULTIDYNAMICNORMALREPORT");
        CSLReportSet.add("SUM");
        CSLReportSet.add("MANUSCRIPT");
        CSLReportSet.add("CONSOLIDATION");
        CSLReportSet.add("DYNAMICSUMREPORT");
        CSLReportSet.add("DYNAMICCSLREPORT");
        CSLReportSet.add("MULTIDYNAMICSUMREPORT");
        CSLReportSet.add("MULTIDYNAMICMNSREPORT");
        CSLReportSet.add("MULTIDYNAMICCSLREPORT");
    }
}

