/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportServiceFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.FormulaMoveTool;
import com.kingdee.eas.fi.rpt.GenerateSolution;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.ExpressionSpread;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.styleinherit.StyleInheritDecorator;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.InterAndExchFormulaParse;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class FillSheetAssistant {
    private static final int ACCT_ORGNUMBER_INDEX = 1;
    private static final int INCASHFLOW_ORGNUMBER_INDEX = 1;
    private static final Logger logger = Logger.getLogger(FillSheetAssistant.class);

    public boolean fillSheet(Sheet sheet, int x, int y, boolean isVertical, List data) {
        if (sheet == null || data == null) {
            return false;
        }
        try {
            Map<String, Object> styles = this.getFirstRowStyle(sheet);
            Map filledCompanyIds = CslRptUtil.getFilledCompanyIdMap((Sheet)sheet, (int)x, (int)y, (boolean)true);
            int removedRowCount = this.removeRow(sheet, filledCompanyIds, data);
            int index = 0;
            while (index < data.size() && filledCompanyIds.size() > 0) {
                OrgUnitInfo oi = (OrgUnitInfo)data.get(index);
                if (filledCompanyIds.containsKey(oi.getId().toString())) {
                    data.remove(index);
                    continue;
                }
                ++index;
            }
            if (CSLParamUtil.getBooleanCslParamValue(null, (String)"KEY_CSLPARAM_IsFillSheetByCol")) {
                int filledSize = filledCompanyIds.size() - removedRowCount;
                if (filledSize > 0) {
                    this.removeBlankRows(sheet, x, y, isVertical, filledSize);
                }
                this.setFirstRowStyle(sheet, styles);
                this.fillSheetByCol(sheet, x, y, isVertical, data, false);
            } else {
                this.setFirstRowStyle(sheet, styles);
                this.fillSheetWithAllDataInList(sheet, x, y, isVertical, data, false);
            }
            styles.clear();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return true;
    }

    private void removeBlankRows(Sheet sheet, int x, int y, boolean isVertical, int filledSize) {
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        if (iPosLeft < 0) {
            iPosLeft = x;
        } else {
            x = iPosLeft;
        }
        if (iPosTop < 0) {
            iPosTop = y;
        } else {
            y = iPosTop;
        }
        int offset = 0;
        int maxVaildLines = sheet.getMaxColIndex() - iPosLeft;
        if (isVertical) {
            maxVaildLines = sheet.getMaxRowIndex() - iPosTop;
        }
        int fillSize = 0;
        int row = 0;
        while (offset < maxVaildLines) {
            Range range = null;
            if (isVertical) {
                range = sheet.getRange(iPosTop + 1 + offset, iPosLeft);
                row = iPosTop + 1 + offset;
            } else {
                range = sheet.getRange(iPosLeft + 1 + offset, iPosTop);
                row = iPosLeft + 1 + offset;
            }
            ItemFormula itemFormula = (ItemFormula)range.getUserObject("ITEM");
            String tmpCompanyId = null;
            if (itemFormula != null) {
                tmpCompanyId = itemFormula.getExt("16");
                if (StringUtils.isEmpty((String)tmpCompanyId)) {
                    UserObjectHelper.getUnprotectedRange(sheet.getRowRange(row, row)).delete();
                    offset = 0;
                    fillSize = 0;
                    continue;
                }
                ++offset;
                ++fillSize;
                continue;
            }
            if (filledSize == fillSize) break;
            UserObjectHelper.getUnprotectedRange(sheet.getRowRange(row, row)).delete();
            offset = 0;
            fillSize = 0;
        }
    }

    private int removeRow(Sheet sheet, Map filledCompanyIds, List data) {
        ArrayList<Integer> removeRows = new ArrayList<Integer>();
        HashSet<String> companyIds = new HashSet<String>();
        for (Object company : data) {
            companyIds.add(((OrgUnitInfo)company).getId().toString());
        }
        for (Object companyId : filledCompanyIds.keySet()) {
            if (companyIds.contains(companyId)) continue;
            removeRows.add((Integer)filledCompanyIds.get(companyId));
        }
        Object[] sortRow = new Integer[removeRows.size()];
        removeRows.toArray(sortRow);
        Arrays.sort((Object[])sortRow);
        for (int i = sortRow.length - 1; i >= 0; --i) {
            UserObjectHelper.getUnprotectedRange(sheet.getRowRange(((Integer)sortRow[i]).intValue(), ((Integer)sortRow[i]).intValue())).delete();
        }
        return sortRow.length;
    }

    public void fillSheetWithAllDataInList(Sheet sheet, int x, int y, boolean isVertical, List data, boolean isAuto) {
        this.fillSheetWithAllDataInList(sheet, x, y, isVertical, data, isAuto, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillSheetByOverlay(Sheet sheet, int x, int y, boolean isVertical, List data, boolean isAppend, boolean isAuto) {
        if (isAppend) {
            this.fillSheet(sheet, x, y, isVertical, data);
            return true;
        }
        if (sheet == null || data == null) {
            return false;
        }
        boolean autoCalculate = sheet.getBook().isAutoCalculate();
        sheet.getBook().setCalculate(false);
        try {
            sheet.getBook().getUndoManager().enable(false);
            sheet.getBook().setSkipListeners(true);
            sheet.getBook().getUndoManager().startGroup();
            int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
            int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
            if (iPosLeft < 0) {
                iPosLeft = x;
            } else {
                x = iPosLeft;
            }
            if (iPosTop < 0) {
                iPosTop = y;
            } else {
                y = iPosTop;
            }
            boolean hasFormula = false;
            Range tmpRange = sheet.getRange(iPosTop + 1, iPosLeft);
            ItemFormula itemFormula = (ItemFormula)tmpRange.getUserObject("ITEM");
            if (itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getExt("16"))) {
                hasFormula = true;
            }
            int endIndex = iPosTop + 2;
            int startIndex = iPosTop + 2;
            ItemFormula tmpItemFormula = null;
            int i = startIndex;
            while (i <= sheet.getMaxRowIndex() && (tmpItemFormula = (ItemFormula)(tmpRange = sheet.getRange(i, iPosLeft)).getUserObject("ITEM")) != null && !StringUtils.isEmpty((String)tmpItemFormula.getExt("16"))) {
                endIndex = i++;
            }
            if (startIndex <= endIndex) {
                UserObjectHelper.getUnprotectedRange(sheet.getRowRange(startIndex, endIndex)).delete();
            }
            boolean isInvest = hasFormula;
            this.fillSheetWithAllDataInList(sheet, x, y, isVertical, data, isAuto, isInvest, hasFormula);
            if (hasFormula) {
                Map firstLineFormulaMap = new HashMap();
                int filledNum = 0;
                int needToFillNum = 0;
                if (isVertical) {
                    firstLineFormulaMap = this.getFirstLineFormula(sheet, iPosLeft, iPosTop, false);
                    needToFillNum = sheet.getMaxRowIndex() - iPosTop;
                }
                this.resetFormula(sheet, x, y, iPosLeft, iPosTop, firstLineFormulaMap, needToFillNum, filledNum, false);
            }
        }
        finally {
            sheet.getBook().setSkipListeners(false);
            sheet.getBook().getUndoManager().enable(true);
            sheet.getBook().getUndoManager().endGroup();
            sheet.getBook().setCalculate(autoCalculate);
        }
        return true;
    }

    public boolean fillSheetByOverlay(Sheet sheet, int x, int y, boolean isVertical, List data, boolean isAppend) {
        return this.fillSheetByOverlay(sheet, x, y, isVertical, data, isAppend, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSheetWithAllDataInList(Sheet sheet, int x, int y, boolean isVertical, List data, boolean isAuto, boolean isInvest, boolean deleteFirstLine) {
        Book book = sheet.getBook();
        boolean isAutoCal = book.isAutoCalculate();
        try {
            book.getUndoManager().startGroup();
            book.getUndoManager().enable(false);
            book.setAutoCalculate(false);
            int rowIndex = 0;
            Range tmpRange = null;
            int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
            int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
            if (iPosLeft < 0) {
                iPosLeft = x;
            } else {
                x = iPosLeft;
            }
            if (iPosTop < 0) {
                iPosTop = y;
            } else {
                y = iPosTop;
            }
            int offset = isVertical ? sheet.getMaxRowIndex() - iPosTop : sheet.getMaxColIndex() - iPosLeft;
            Map firstLineFormulaMap = new HashMap();
            if (isVertical) {
                firstLineFormulaMap = this.getFirstLineFormula(sheet, iPosLeft, iPosTop, isInvest);
                if (data.size() == 0 && !this.isFilledCompany(sheet, iPosLeft, iPosTop)) {
                    UserObjectHelper.getUnprotectedRange(sheet.getRange(iPosLeft + 1, iPosLeft, iPosTop + 1, sheet.getMaxColIndex())).clear(true, true, false, false);
                }
            }
            int needToFillNum = 0;
            int filledNum = 0;
            if (!isInvest) {
                int[] nums = this.getFormulaNumNeedToFill(sheet, x, y, data);
                filledNum = nums[0];
                needToFillNum = nums[1];
            }
            ArrayList newList = new ArrayList();
            newList.addAll(data);
            while (data.size() > 0) {
                Range range = null;
                if (isVertical) {
                    y = iPosTop + 1 + rowIndex + filledNum;
                    range = sheet.getRange(y, x);
                    boolean hasFormula = false;
                    tmpRange = sheet.getRange(y, iPosLeft);
                    ItemFormula itemFormula = (ItemFormula)tmpRange.getUserObject("ITEM");
                    if (itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getExt("16"))) {
                        hasFormula = true;
                    }
                    if (deleteFirstLine && hasFormula) {
                        UserObjectHelper.getUnprotectedRange(sheet.getRowRange(iPosTop + 2, iPosTop + 2)).insert(true, InsertType.FLLOW_UP_STYLE);
                        UserObjectHelper.getUnprotectedRange(sheet.getRowRange(iPosTop + 1, iPosTop + 1)).delete();
                        deleteFirstLine = false;
                        continue;
                    }
                    if (!hasFormula && rowIndex != 0) {
                        UserObjectHelper.getUnprotectedRange(sheet.getRowRange(y, y)).insert(true, InsertType.NOSTYLE);
                        range = sheet.getRange(y, x);
                    }
                } else {
                    x = iPosLeft + 1 + offset;
                    range = sheet.getRange(x, y);
                }
                ItemFormula itemFormula = (ItemFormula)range.getUserObject("ITEM");
                Object cellValue = range.getValue().getValue();
                String tmpCompanyId = null;
                if (itemFormula != null && cellValue != null && !StringUtils.isEmpty((String)cellValue.toString())) {
                    tmpCompanyId = itemFormula.getExt("16");
                }
                if (StringUtils.isEmpty(tmpCompanyId)) {
                    OrgUnitInfo oi = (OrgUnitInfo)data.remove(0);
                    range.setIgnoreProtected(true);
                    range.setValue(new Variant((Object)(oi.getNumber() + "-" + oi.getName())));
                    itemFormula = new ItemFormula();
                    itemFormula.putExt("16", oi.getId().toString());
                    itemFormula.putExt("26", oi.getNumber());
                    range.setUserObject("ITEM", (Object)itemFormula);
                    this.fillAcctAC(sheet, oi, iPosLeft, iPosTop, rowIndex + 1 + filledNum, isVertical, isInvest);
                    range.setIgnoreProtected(false);
                }
                ++rowIndex;
            }
            this.resetFormula(sheet, x, y, iPosLeft, iPosTop, firstLineFormulaMap, needToFillNum, filledNum, isInvest);
            boolean acctRowIndex = false;
            if (isVertical && y > iPosTop) {
                boolean isAutoFillDigit;
                StyleDecoratorHeightOrWidth srcSytleInherit = new StyleDecoratorHeightOrWidth(new RptSheetSytleInherit());
                StyleDecoratorValidation sytleInherit = new StyleDecoratorValidation(srcSytleInherit);
                int startCol = iPosLeft;
                BookProperties p = BookProperties.loadFromBook(book);
                boolean bl = isAutoFillDigit = p != null && p.isAutoFillDigit();
                if (isAutoFillDigit && startCol > 0) {
                    --startCol;
                }
                RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
                Point standardPoint = new Point(iPosLeft, iPosTop);
                styleParam.setStandardPoint(standardPoint);
                styleParam.setStartRow(iPosTop + 2);
                styleParam.setEndRow(y);
                styleParam.setStartColumn(startCol);
                styleParam.setEndColumn(sheet.getMaxColIndex());
                styleParam.setVerticalInherit(true);
                sytleInherit.regionInheritStyleByDefaultPoint(sheet, styleParam);
                if (!isAuto) {
                    RptUtil.calcRange(iPosTop + 1, iPosLeft, y, sheet.getMaxColIndex(), sheet);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            book.getUndoManager().endGroup();
            book.getUndoManager().enable(true);
            book.setAutoCalculate(isAutoCal);
        }
    }

    public void fillSheetWithAllDataInList(Sheet sheet, int x, int y, boolean isVertical, List data, boolean isAuto, boolean isInvest) {
        this.fillSheetWithAllDataInList(sheet, x, y, isVertical, data, isAuto, isInvest, false);
    }

    private void setFirstRowStyle(Sheet sheet, Map<String, Object> styles) {
        if (styles != null && !styles.isEmpty()) {
            int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
            int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
            if (iPosLeft < 0 || iPosTop < 0) {
                return;
            }
            Map cellStryles = (Map)styles.get("cellStyles");
            if (cellStryles != null && !cellStryles.isEmpty()) {
                for (Object col : cellStryles.keySet()) {
                    StyleAttributes saInnerBorder;
                    StyleAttributes saOuterBorder = saInnerBorder = Styles.getSA((ShareStyleAttributes)((ShareStyleAttributes)cellStryles.get(col)));
                    saOuterBorder.setDirty(StyleAttributes.getAllBits());
                    saInnerBorder.setDirty(StyleAttributes.getAllBits());
                    UserObjectHelper.getUnprotectedRange(sheet.getRange(iPosTop + 1, ((Integer)col).intValue())).setStyle(saOuterBorder, saInnerBorder);
                }
            }
            Integer rowHeight = (Integer)styles.get("rowHeight");
            sheet.getRowSpans().setSpanAttribute(new Span(iPosTop + 1, iPosTop + 1), null, rowHeight, null, null, null, null);
        }
    }

    private Map<String, Object> getFirstRowStyle(Sheet sheet) {
        HashMap<String, Object> styles = new HashMap<String, Object>();
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        if (iPosLeft < 0 || iPosTop < 0) {
            return styles;
        }
        int startCol = iPosLeft;
        boolean isFillDigit = BookProperties.loadFromBook(sheet.getBook()).isAutoFillDigit();
        if (isFillDigit && iPosLeft - 1 >= 0) {
            --startCol;
        }
        Cell cell = null;
        HashMap<Integer, Style> cellStyles = new HashMap<Integer, Style>();
        for (int col = startCol; col <= sheet.getMaxColIndex(); ++col) {
            cell = sheet.getCell(iPosTop + 1, col, true);
            if (cell.getStyle() == null) continue;
            cellStyles.put(col, cell.getStyle());
        }
        styles.put("cellStyles", cellStyles);
        styles.put("rowHeight", new Integer(Sheet.getRowHeight((Sheet)sheet, (int)(iPosTop + 1))));
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSheetByCol(Sheet sheet, int x, int y, boolean isVertical, List data, boolean isAutoFill) {
        Book book = sheet.getBook();
        boolean isAutoCal = book.isAutoCalculate();
        try {
            book.getUndoManager().startGroup();
            book.getUndoManager().enable(false);
            book.setAutoCalculate(false);
            int bpLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
            int bpTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
            if (bpLeft < 0) {
                bpLeft = x;
            } else {
                x = bpLeft;
            }
            if (bpTop < 0) {
                bpTop = y;
            } else {
                y = bpTop;
            }
            Map firstLineFormulaMap = new HashMap();
            if (isVertical) {
                firstLineFormulaMap = this.getFirstLineFormula(sheet, bpLeft, bpTop, false);
                if (data.size() == 0 && !this.isFilledCompany(sheet, bpLeft, bpTop)) {
                    UserObjectHelper.getUnprotectedRange(sheet.getRange(bpTop + 1, bpLeft, bpTop + 1, sheet.getMaxColIndex())).clear(true, true, false, false);
                }
            }
            int offset = isVertical ? sheet.getMaxRowIndex() - bpTop : sheet.getMaxColIndex() - bpLeft;
            int needToFillNum = 0;
            int filledNum = 0;
            int[] nums = this.getFormulaNumNeedToFill(sheet, x, y, data);
            filledNum = nums[0];
            needToFillNum = nums[1];
            ArrayList newList = new ArrayList();
            newList.addAll(data);
            int rowIndex = 0;
            while (newList.size() > 0) {
                String tmpCompanyId;
                Range range = null;
                if (isVertical) {
                    y = bpTop + 1 + rowIndex + filledNum;
                    range = sheet.getRange(y, x);
                    boolean hasFormula = false;
                    ItemFormula itemFormula = (ItemFormula)sheet.getRange(y, bpLeft).getUserObject("ITEM");
                    if (itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getExt("16"))) {
                        hasFormula = true;
                    }
                    if (!hasFormula && rowIndex != 0) {
                        UserObjectHelper.getUnprotectedRange(sheet.getRowRange(y, y)).insert(true, newList.size() == 1 ? InsertType.FLLOW_DOWN_STYLE : InsertType.NOSTYLE);
                        range = sheet.getRange(y, x);
                    }
                } else {
                    x = bpLeft + 1 + offset;
                    range = sheet.getRange(x, y);
                }
                ItemFormula itemFormula = (ItemFormula)range.getUserObject("ITEM");
                String string = tmpCompanyId = itemFormula != null ? itemFormula.getExt("16") : null;
                if (StringUtils.isEmpty((String)tmpCompanyId)) {
                    OrgUnitInfo oi = (OrgUnitInfo)newList.remove(0);
                    range.setIgnoreProtected(true);
                    range.setValue(new Variant((Object)(oi.getNumber() + "-" + oi.getName())));
                    itemFormula = new ItemFormula();
                    itemFormula.putExt("16", oi.getId().toString());
                    itemFormula.putExt("26", oi.getNumber());
                    range.setUserObject("ITEM", (Object)itemFormula);
                    this.fillAcctACAndReplaceAll(sheet, oi, bpLeft, bpTop, rowIndex + 1 + filledNum, isVertical, false);
                    range.setIgnoreProtected(false);
                }
                ++rowIndex;
            }
            this.resetFormula(sheet, x, y, bpLeft, bpTop, firstLineFormulaMap, needToFillNum, filledNum, false);
            if (isVertical && y > bpTop) {
                boolean isAutoFillDigit;
                int startCol = bpLeft;
                BookProperties p = BookProperties.loadFromBook(book);
                boolean bl = isAutoFillDigit = p != null && p.isAutoFillDigit();
                if (isAutoFillDigit && startCol > 0) {
                    --startCol;
                }
                StyleInheritDecorator sytleInherit = new StyleDecoratorHeightOrWidth(new RptSheetSytleInherit());
                sytleInherit = new StyleDecoratorValidation(sytleInherit);
                RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
                Point standardPoint = new Point(bpLeft, bpTop);
                styleParam.setStandardPoint(standardPoint);
                styleParam.setStartRow(bpTop + 2);
                styleParam.setEndRow(y);
                styleParam.setStartColumn(startCol);
                styleParam.setEndColumn(sheet.getMaxColIndex());
                styleParam.setVerticalInherit(true);
                sytleInherit.regionInheritStyleByDefaultPoint(sheet, styleParam);
                if (!isAutoFill) {
                    RptUtil.calcRange(bpTop + 1, bpLeft, y, sheet.getMaxColIndex(), sheet);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            book.getUndoManager().endGroup();
            book.getUndoManager().enable(true);
            book.setAutoCalculate(isAutoCal);
        }
    }

    private int[] getFormulaNumNeedToFill(Sheet sheet, int x, int y, List data) {
        int dataSizeBeforeRemove = data.size();
        Set filledCompanyIds = CslRptUtil.getFilledCompanyIds((Sheet)sheet, (int)x, (int)y, (boolean)true);
        int filledNum = filledCompanyIds.size();
        int needToFillNum = dataSizeBeforeRemove + filledNum;
        int[] nums = new int[]{filledNum, needToFillNum};
        return nums;
    }

    protected void resetFormula(Sheet sheet, int x, int y, int iPosLeft, int iPosTop, Map firstLineFormulaMap, int needToFillNum, int filledNum, boolean isInvest) {
        if (needToFillNum == 0) {
            return;
        }
        Range rg = null;
        int extX = sheet.getMaxColIndex() + 1;
        for (int i = iPosLeft + 1; i < extX; ++i) {
            rg = sheet.getRange(isInvest ? iPosTop + 2 : iPosTop + 1, i);
            if (!firstLineFormulaMap.containsKey((isInvest ? iPosTop + 2 : iPosTop + 1) + "" + i)) continue;
            String formula = firstLineFormulaMap.get((isInvest ? iPosTop + 2 : iPosTop + 1) + "" + i).toString();
            try {
                Expression expression = ExcelFormulaPaserHelper.parse(formula);
                boolean isHavSpecialExpr = ExcelFormulaPaserHelper.isHavSpecialExpr(expression);
                boolean isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)formula);
                if (isExcelFunction) {
                    this.fillOtherFormula(sheet, iPosLeft, iPosTop, needToFillNum, rg, i, isInvest);
                    continue;
                }
                if (!isHavSpecialExpr) continue;
                if (isHavSpecialExpr && ExcelFormulaPaserHelper.isHavCommonRptExpr(expression)) {
                    this.fillCompanyToformula(sheet, iPosLeft, iPosTop, needToFillNum, filledNum, i, formula, isInvest);
                    continue;
                }
                if (!isHavSpecialExpr) continue;
                this.fillOtherFormula(sheet, iPosLeft, iPosTop, needToFillNum, rg, i, isInvest);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"resetFormula error", (Throwable)e);
            }
        }
    }

    protected void fillOtherFormula(Sheet sheet, int iPosLeft, int iPosTop, int needToFillNum, Range rg, int i, boolean isInvest) {
        if (iPosTop + 1 == iPosTop + needToFillNum) {
            return;
        }
        rg.setIgnoreProtected(true);
        FillType resultType = new FillType(0);
        CellBlock dstBlock = CellBlock.getNewCellBlock((int)0, (int)0);
        dstBlock.setRowCol(isInvest ? iPosTop + 2 : iPosTop + 1, i, iPosTop + needToFillNum, i);
        rg.fill(dstBlock, FillType.DEFAULT_EXCEPT_FORMAT, resultType);
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isProtect = false;
        String proPass = null;
        if (pro != null && pro.isProtected()) {
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
            isProtect = true;
        }
        sheet.getRange(isInvest ? iPosTop + 2 : iPosTop + 1, i, iPosTop + needToFillNum, i).setValue(null);
        if (isProtect) {
            pro.startWithEncryptedPassword(proPass);
        }
    }

    protected void fillCompanyToformula(Sheet sheet, int iPosLeft, int iPosTop, int needToFillNum, int filledNum, int i, String formula, boolean isInvest) {
        int startRow = iPosTop + filledNum;
        for (int j = startRow = isInvest ? startRow + 2 : startRow + 1; j <= iPosTop + needToFillNum; ++j) {
            ItemFormula itemFormula;
            String tmpCompanyId = null;
            Range rangeForOrg = null;
            Range rangeForFill = null;
            rangeForOrg = sheet.getRange(j, iPosLeft);
            rangeForFill = UserObjectHelper.getUnprotectedRange(sheet.getRange(j, i));
            String tempFormula = rangeForFill.getFormula();
            if (StringUtils.isEmpty((String)tempFormula)) {
                tempFormula = formula;
            }
            if ((itemFormula = (ItemFormula)rangeForOrg.getUserObject("ITEM")) != null) {
                tmpCompanyId = itemFormula.getExt("26");
            }
            tempFormula = this.fillFormulaWithOrgUnitNumber(tempFormula, tmpCompanyId);
            tempFormula = this.getFormulaIncreaseFormula(tempFormula, j - startRow + filledNum);
            rangeForFill.setFormula(tempFormula);
        }
    }

    protected Map getFirstLineFormula(Sheet sheet, int iPosLeft, int iPosTop, boolean isInvest) {
        HashMap<String, String> firstLineFormulaMap = new HashMap<String, String>();
        int extX = sheet.getMaxColIndex() + 1;
        String exp = "";
        boolean isFilledCompany = this.isFilledCompany(sheet, iPosLeft, iPosTop);
        boolean isFirstNumSpecial = false;
        ItemFormula itemFormula = (ItemFormula)sheet.getRange(iPosTop + 1, iPosLeft).getUserObject("ITEM");
        if (itemFormula != null && itemFormula.getExt("26") != null && itemFormula.getExt("26").indexOf("@") >= 0) {
            isFirstNumSpecial = true;
        }
        for (int i = iPosLeft + 1; i < extX; ++i) {
            Range range1 = UserObjectHelper.getUnprotectedRange(sheet.getRange(iPosTop + 1, i));
            exp = CslRptUtil.resetAndGetFormula((Range)range1);
            Range r = UserObjectHelper.getUnprotectedRange(sheet.getRange(iPosTop, i));
            if (!StringUtils.isEmpty((String)exp) && (!isFilledCompany || !isFirstNumSpecial && exp.contains("@") || BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)sheet, (String)exp))) {
                r.setUserObject("FormulaExp", (Object)exp);
            } else if (r.getUserObject("FormulaExp") != null) {
                exp = CslRptUtil.resetAndGetUserObject((Range)r, (String)"FormulaExp");
            } else if (isInvest && !StringUtils.isEmpty((String)exp) && (exp.toLowerCase().indexOf("acctac") != -1 || exp.toLowerCase().indexOf("incashflow") != -1)) {
                r.setUserObject("FormulaExp", (Object)exp);
            }
            if (StringUtils.isEmpty((String)exp) || CslRptUtil.isBigDecimal((Object)exp)) continue;
            firstLineFormulaMap.put((isInvest ? iPosTop + 2 : iPosTop + 1) + "" + i, exp);
        }
        return firstLineFormulaMap;
    }

    private void fillAcctACAndReplaceAll(Sheet table, OrgUnitInfo oi, int left, int top, int offset, boolean isVertical, boolean isInvest) {
        int extX = table.getMaxColIndex() + 1;
        String exp = null;
        String orgNumber = oi.getNumber();
        boolean isNumSpecial = false;
        if (orgNumber.indexOf("@") >= 0) {
            isNumSpecial = true;
            orgNumber = orgNumber.replaceAll("@", "##");
        }
        if (isVertical) {
            for (int i = left + 1; i < extX; ++i) {
                boolean isContain;
                exp = null;
                Range range = table.getRange(top, i);
                if (range.getUserObject("FormulaExp") != null) {
                    exp = range.getUserObject("FormulaExp").toString();
                }
                if (StringUtils.isEmpty(exp) || CslRptUtil.isBigDecimal((Object)exp)) continue;
                if (exp.toLowerCase().indexOf("acctac") != -1 || exp.toLowerCase().indexOf("incashflow") != -1) {
                    exp = this.fillFormulaWithOrgUnitNumber(exp, orgNumber);
                }
                boolean bl = isContain = !StringUtils.isEmpty((String)exp) && exp.contains("@");
                if (isContain) {
                    exp = exp.replaceAll("@", oi.getNumber());
                }
                if (isNumSpecial) {
                    exp = exp.replaceAll("##", "@");
                }
                range = table.getRange(top + offset, i);
                range.setIgnoreProtected(true);
                range.setFormula(exp);
                range.setIgnoreProtected(false);
            }
        }
    }

    private void fillAcctAC(Sheet table, OrgUnitInfo oi, int left, int top, int offset, boolean isVertical, boolean isInvest) {
        int extX = table.getMaxColIndex() + 1;
        boolean isNumSpecial = false;
        String srcOiNumber = oi.getNumber();
        String OiNumber = Matcher.quoteReplacement(srcOiNumber);
        if (srcOiNumber.indexOf("@") >= 0) {
            isNumSpecial = true;
            srcOiNumber = srcOiNumber.replaceAll("@", "##");
        }
        String exp = null;
        if (isVertical) {
            for (int i = left + 1; i < extX; ++i) {
                exp = null;
                Range range = table.getRange(top, i);
                if (range.getUserObject("FormulaExp") != null) {
                    exp = range.getUserObject("FormulaExp").toString();
                }
                if (StringUtils.isEmpty(exp) || !exp.trim().startsWith("=")) continue;
                if (exp.toLowerCase().indexOf("acctac") != -1 || exp.toLowerCase().indexOf("incashflow") != -1) {
                    exp = this.fillFormulaWithOrgUnitNumber(exp, srcOiNumber);
                }
                if (exp.indexOf("@") > 0) {
                    exp = exp.replaceAll("@", OiNumber);
                }
                if (isNumSpecial) {
                    exp = exp.replaceAll("##", "@");
                }
                range = table.getRange(top + offset, i);
                range.setIgnoreProtected(true);
                range.setFormula(exp);
                range.setIgnoreProtected(false);
            }
        }
    }

    private String getFormulaIncreaseFormula(String curFormual, int rowIndex) {
        GenerateSolution solution = new GenerateSolution();
        solution.setCellRowEnable(true);
        solution.setCellRowAspect(1);
        solution.setFormulaEnable(false);
        solution.setFormulaStep(0);
        solution.setCellRowStep(rowIndex);
        String formatFormual = "";
        try {
            formatFormual = FormulaMoveTool.formatFormaulBysolution(solution, curFormual);
            if (!formatFormual.startsWith("=")) {
                formatFormual = "=" + formatFormual;
            }
        }
        catch (Exception e) {
            logger.error((Object)"inheritformual:range formual is error:", (Throwable)e);
        }
        return formatFormual;
    }

    private String fillFormulaWithOrgUnitNumber(String exp, String orgUnitNumber) {
        try {
            Expression expression = ExcelFormulaPaserHelper.parse(exp);
            WalkHandler handler = new WalkHandler(orgUnitNumber);
            ExcelFormulaPaserHelper.walk(expression, handler);
            return "=" + ExcelFormulaPaserHelper.toReducedBracketsString(expression);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getIncreaseExp(String orgExp, int increase) {
        try {
            Expression exp = ExcelFormulaPaserHelper.parse(orgExp);
            ExpressionSpread espSpread = new ExpressionSpread(exp, 1, increase);
            while (increase-- > 0 && espSpread.hasNext()) {
                orgExp = espSpread.next().toString();
            }
            exp = null;
            espSpread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!orgExp.startsWith("=")) {
            return "=" + orgExp;
        }
        return orgExp;
    }

    public List clipCompanyByFilledComp(boolean isNotAuto, Set filledCompanyIds, Object[] res, String companyId, boolean isFillOwnCompany) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < res.length; ++i) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)res[i];
            boolean isFilled = filledCompanyIds.contains(orgUnitInfo.getId().toString());
            if (!isFilled && !isFillOwnCompany && companyId != null && companyId.equals(orgUnitInfo.getId().toString())) {
                isFilled = true;
            }
            boolean isIsBizUnit = false;
            if (isNotAuto) {
                if (orgUnitInfo instanceof CompanyOrgUnitInfo) {
                    CompanyOrgUnitInfo companyorgUnitInfo = (CompanyOrgUnitInfo)orgUnitInfo;
                    isIsBizUnit = companyorgUnitInfo.isIsBizUnit();
                } else if (orgUnitInfo instanceof ProfitCenterOrgUnitInfo) {
                    ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = (ProfitCenterOrgUnitInfo)orgUnitInfo;
                    isIsBizUnit = profitCenterOrgUnitInfo.isIsBizUnit();
                }
                if (isFilled || !isIsBizUnit) continue;
                companyList.add(res[i]);
                continue;
            }
            if (isFilled) continue;
            companyList.add(res[i]);
        }
        return companyList;
    }

    public Object[] getCompanysByFormulas(Context ctx, Sheet sheet, ReportBaseInfo reportInfo, IReportPropertyAdapter adapter, OrgUnitInfo company, String orgTreeId, boolean isProfitCenter) {
        block8: {
            try {
                Map filterParamMap;
                Map dataMap;
                List<String> firstLineFormulas;
                int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
                int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
                if (iPosLeft < 0 || iPosTop < 0 || (firstLineFormulas = this.getFirstLineFormulas(sheet, iPosLeft, iPosTop)).isEmpty()) break block8;
                String isOnlyFillHavingDataItemStr = NewRptUtil.getInterExchFillParamValue((Context)ctx, (Sheet)sheet, null);
                logger.error((Object)("firstLineFormulas:" + firstLineFormulas.toArray().toString()));
                if (StringUtils.isEmpty((String)isOnlyFillHavingDataItemStr)) {
                    return null;
                }
                try {
                    DynamicTemplateUtility.resumSheetFormulas((Sheet)sheet, firstLineFormulas);
                }
                catch (Exception e) {
                    logger.error((Object)"resumSheetFormulas error.", (Throwable)e);
                }
                ReportVariables vars = ReportVariables.loadFromBook((Book)sheet.getBook());
                InterAndExchFormulaParse formulaPars = new InterAndExchFormulaParse(ctx, firstLineFormulas, vars, adapter, sheet.getSheetName(), company);
                if ("false".equalsIgnoreCase(isOnlyFillHavingDataItemStr)) {
                    return null;
                }
                if ("auto".equalsIgnoreCase(isOnlyFillHavingDataItemStr) && !this.checkFormulas(firstLineFormulas, formulaPars.handleFormulas)) {
                    logger.error((Object)"checkFormulas no pass.");
                    return null;
                }
                formulaPars.formulaParse(sheet);
                if (!(!formulaPars.isAccordFillItem() || formulaPars.getAcctCashFormulasMap().isEmpty() && formulaPars.getAcctFormulaMap().isEmpty() || (dataMap = (ctx == null ? CslReportServiceFacadeFactory.getRemoteInstance() : CslReportServiceFacadeFactory.getLocalInstance((Context)ctx)).getDynItemData(filterParamMap = this.createFilterParamMap(ctx, formulaPars, vars, sheet, company, orgTreeId, isProfitCenter))).get("isExecuteError") != null && ((Boolean)dataMap.get("isExecuteError")).booleanValue())) {
                    Object[] companyInfos = (Object[])dataMap.get("fillItemSet");
                    return companyInfos;
                }
            }
            catch (Exception e) {
                logger.error((Object)"getCompanysByFormulas error.", (Throwable)e);
            }
        }
        return null;
    }

    private boolean checkFormulas(List<String> firstLineFormulas, Set<String> formulaNames) {
        for (String formula : firstLineFormulas) {
            if (ExcelFormulaPaserHelper.isSpecialInFormulas(formula, formulaNames, 0)) continue;
            return false;
        }
        return true;
    }

    public Map createFilterParamMap(Context ctx, InterAndExchFormulaParse formulaPars, ReportVariables vars, Sheet sheet, OrgUnitInfo company, String orgTreeId, boolean isProfitCenter) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("acctFormulaFilter", formulaPars.getAcctFormulaMap());
        paramMap.put("acctCashFormulaFilter", formulaPars.getAcctCashFormulasMap());
        paramMap.put("currentUnit", company);
        RptSheetParamInfo rptSheetParamInfo = null;
        rptSheetParamInfo = ctx != null ? VariablesHelper.variables2SheetParams((ReportVariables)vars, (String)sheet.getSheetName(), (boolean)true, (Context)ctx) : VariablesHelper.variables2SheetParams((ReportVariables)vars, (String)sheet.getSheetName(), (boolean)true, null);
        paramMap.put("isIncludingUnposted", rptSheetParamInfo.isIsIncludingUnposted());
        paramMap.put("isInterAndExch", true);
        paramMap.put("isProfitCenter", isProfitCenter);
        if (!StringUtils.isEmpty((String)orgTreeId)) {
            paramMap.put("orgTreeId", orgTreeId);
        }
        return paramMap;
    }

    public List<String> getFirstLineFormulas(Sheet sheet, int basePointX, int basePointY) throws Exception {
        ArrayList<String> firstLineFormulas = new ArrayList<String>();
        boolean isFirstFilled = false;
        ItemFormula itemFormula = (ItemFormula)sheet.getRange(basePointY + 1, basePointX).getUserObject("ITEM");
        if (itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getExt("16"))) {
            isFirstFilled = true;
        }
        for (int col = basePointX + 1; col <= sheet.getMaxColIndex(); ++col) {
            Object formula = sheet.getRange(basePointY, col).getUserObject("FormulaExp");
            String headFormula = formula != null ? formula.toString() : null;
            String firstLineFormula = sheet.getRange(basePointY + 1, col).getFormula();
            if (isFirstFilled && !StringUtils.isEmpty((String)headFormula)) {
                this.addFormula(firstLineFormulas, headFormula);
                continue;
            }
            if (!StringUtils.isEmpty((String)firstLineFormula) && firstLineFormula.indexOf("@") > 0) {
                this.addFormula(firstLineFormulas, firstLineFormula);
                continue;
            }
            if (!StringUtils.isEmpty((String)headFormula)) {
                this.addFormula(firstLineFormulas, headFormula);
                continue;
            }
            if (StringUtils.isEmpty((String)firstLineFormula)) continue;
            this.addFormula(firstLineFormulas, firstLineFormula);
        }
        return firstLineFormulas;
    }

    private void addFormula(List<String> firstLineFormulas, String formula) {
        String curFormula = formula.toLowerCase();
        if (!(curFormula.indexOf("acct") < 0 && curFormula.indexOf("incashflow") < 0 && curFormula.indexOf("@") < 0 || CslRptUtil.isBigDecimal((Object)curFormula))) {
            firstLineFormulas.add(formula);
        }
    }

    protected boolean isFilledCompany(Sheet sheet, int iPosLeft, int iPosTop) {
        ItemFormula itemFormula = (ItemFormula)sheet.getRange(iPosTop + 1, iPosLeft).getUserObject("ITEM");
        if (itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getExt("16"))) {
            return true;
        }
        Variant value = sheet.getRange(iPosTop + 1, iPosLeft).getValue();
        return value != null && !value.equals(Variant.nullVariant) && !StringUtils.isEmpty((String)value.toString());
    }

    private class WalkHandler
    implements IExpressionHandler {
        private String orgUnitNumber;

        public WalkHandler(String orgUnitNumber) {
            this.orgUnitNumber = orgUnitNumber;
        }

        @Override
        public void handle(Expression expr) {
            if (expr instanceof FunctionExpr) {
                FunctionExpr fExpr = (FunctionExpr)expr;
                if ("acctac".equalsIgnoreCase(fExpr.funcionName)) {
                    fExpr.parameters.set(1, new StringExpr(this.orgUnitNumber));
                } else if ("incashflow".equalsIgnoreCase(fExpr.funcionName)) {
                    fExpr.parameters.set(1, new StringExpr(this.orgUnitNumber));
                }
            }
        }
    }
}

