/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeCollection;
import com.kingdee.eas.fi.vc.BillTypeFactory;
import com.kingdee.eas.fi.vc.BusinessTypeCollection;
import com.kingdee.eas.fi.vc.BusinessTypeFactory;
import com.kingdee.eas.fi.vc.app.AbstractBusinessTypeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BusinessTypeControllerBean
extends AbstractBusinessTypeControllerBean {
    private static final long serialVersionUID = 508940598307595443L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.BusinessTypeControllerBean");

    protected BusinessTypeCollection _getBusinessTypeCollection(Context ctx, int subSystem, int businessNumber) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BusinessTypeCollection _getBusinessTypeCollection(Context ctx, int subSystem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("seq"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("subSystem"));
        selector.add(new SelectorItemInfo("className"));
        selector.add(new SelectorItemInfo("permissionItem"));
        selector.add(new SelectorItemInfo("operatorName"));
        selector.add(new SelectorItemInfo("operator"));
        selector.add(new SelectorItemInfo("isBill"));
        selector.add(new SelectorItemInfo("isRuleUseF7"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)subSystem, CompareType.EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("seq"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        BusinessTypeCollection businessTypeCollection = BusinessTypeFactory.getLocalInstance(ctx).getBusinessTypeCollection(view);
        BillTypeCollection billTypeCollection = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection(subSystem);
        return businessTypeCollection;
    }

    @Override
    protected BusinessTypeCollection _getOperatorCollection(Context ctx, int subSystem, String businessNumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("seq"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("subSystem"));
        selector.add(new SelectorItemInfo("className"));
        selector.add(new SelectorItemInfo("permissionItem"));
        selector.add(new SelectorItemInfo("operatorName"));
        selector.add(new SelectorItemInfo("operator"));
        selector.add(new SelectorItemInfo("isBill"));
        selector.add(new SelectorItemInfo("dateFilterUI"));
        selector.add(new SelectorItemInfo("linkQueryUI"));
        selector.add(new SelectorItemInfo("isSelfLog"));
        selector.add(new SelectorItemInfo("billEditUI"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)subSystem, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)businessNumber, CompareType.EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("seq"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        BusinessTypeCollection businessTypeCollection = BusinessTypeFactory.getLocalInstance(ctx).getBusinessTypeCollection(view);
        return businessTypeCollection;
    }

    @Override
    protected Map _getBusinessTypeMap(Context ctx) throws BOSException, EASBizException {
        return this._getBusinessTypeMap(ctx, false);
    }

    @Override
    protected Map _getBusinessTypeMap(Context ctx, boolean isGLSmart) throws BOSException, EASBizException {
        HashMap businessTypeMap = new HashMap();
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        Locale loc = ctx.getLocale();
        String locStr = loc.toString();
        sql.append("  select distinct fsubsystem,fnumber,fname_" + locStr + " from (  ");
        sql.append("  select distinct fsubsystem,to_char(fnumber) fnumber,fname_" + locStr + " from T_VC_BusinessType where fnumber is not null  ");
        if (isGLSmart) {
            sql.append(" and  fisglsmart = '1' ");
        }
        sql.append("  union all ");
        sql.append("  select distinct fsubsystem,to_char(fbosobjecttype) fnumber,fname_" + locStr + " from T_VC_BillType where fbosobjecttype is not null and  fisglsmart = '1'");
        if (isGLSmart) {
            sql.append(" and  fisglsmart = '1' ");
        }
        sql.append(") T order by fsubsystem ");
        try {
            cn = this.getConnection(ctx);
            psStmt = cn.prepareStatement(sql.toString());
            rs = psStmt.executeQuery();
            HashSet<String> busiTypeSet = new HashSet<String>();
            ArrayList busiTypeList = new ArrayList();
            int preSubSystem = 0;
            int subSystem = 0;
            while (rs.next()) {
                subSystem = rs.getInt("fsubsystem");
                if (preSubSystem == 0) {
                    preSubSystem = subSystem;
                } else if (preSubSystem != subSystem) {
                    businessTypeMap.put(preSubSystem, busiTypeList);
                    busiTypeList = new ArrayList();
                    preSubSystem = subSystem;
                }
                HashMap<String, Object> busiTypeMap = new HashMap<String, Object>();
                String fnumber = rs.getString("fnumber");
                String fname = rs.getString("fname_" + locStr);
                String key = subSystem + fnumber;
                if (busiTypeSet.contains(key)) continue;
                busiTypeSet.add(key);
                busiTypeMap.put("number", fnumber);
                busiTypeMap.put("name", fname);
                busiTypeMap.put("isDefault", false);
                busiTypeList.add(busiTypeMap);
            }
            if (preSubSystem == subSystem && subSystem != 0) {
                businessTypeMap.put(preSubSystem, busiTypeList);
                busiTypeList = new ArrayList();
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return businessTypeMap;
    }
}

