/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmartAccountUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.SmartAccountUtils");
    private static Map<String, Integer> maxBillNumberMap = null;
    public static final int defaultCount = 60;
    public static final int strLimitLength = 1500;
    public static SelectorItemCollection voucerSic = new SelectorItemCollection();

    public static int getMaxBillNumber(Context ctx, int subSystem, String operatorNumber) throws BOSException, EASBizException {
        int num = 60;
        String key = String.valueOf(subSystem) + operatorNumber;
        if (maxBillNumberMap != null) {
            num = maxBillNumberMap.get(key) == null ? 60 : maxBillNumberMap.get(key);
        } else {
            maxBillNumberMap = new HashMap<String, Integer>();
            String sql = "select FSubSystem,FOperatorNumber,FNumber from T_VC_VoucherBillNumber";
            try {
                ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
                IRowSet rs = dataAccess.getRowSet(sql);
                StringBuilder sb = new StringBuilder();
                while (rs.next()) {
                    int subSystemValue = rs.getInt("FSubSystem");
                    String operator = rs.getString("FOperatorNumber");
                    int number = rs.getInt("FNumber");
                    if (number > 0) {
                        maxBillNumberMap.put(sb.append(String.valueOf(subSystemValue)).append(operator).toString(), number);
                    }
                    sb.setLength(0);
                }
                if (maxBillNumberMap.containsKey(key)) {
                    num = maxBillNumberMap.get(key);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException("getMaxBillNumberMap sql error:", (Throwable)e);
            }
        }
        return num;
    }

    public static void clearCach() {
        maxBillNumberMap = null;
    }

    public static List<List> splitIdList(List idList, int batchCount) {
        ArrayList<List> result = new ArrayList<List>();
        int flag = 1;
        ArrayList ids = new ArrayList();
        result.add(ids);
        for (Object obj : idList) {
            if (flag <= batchCount) {
                ids.add(obj);
            } else {
                flag = 1;
                ids = new ArrayList();
                ids.add(obj);
                result.add(ids);
            }
            ++flag;
        }
        return result;
    }

    static {
        voucerSic.add(new SelectorItemInfo("id"));
        voucerSic.add(new SelectorItemInfo("number"));
        voucerSic.add(new SelectorItemInfo("bizDate"));
    }
}

