/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.vc.BusinessTypeInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.app.AbstractSmartAccountingProcess;
import com.kingdee.eas.fi.vc.app.ISmartAccountingProcess;
import com.kingdee.eas.fi.vc.app.dap.DAPTransmitRecorderForBillsAndRules;
import com.kingdee.eas.fi.vc.app.dap.NoRuleRecorder;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmartAccountingBillTransfom
extends AbstractSmartAccountingProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.SmartAccountingBillTransfom");

    private BOTMappingCollection getDapRulesSelected(Context ctx, String[] botpRuleId) throws BOSException, EASBizException {
        BOTMappingCollection dapRulesSelected = new BOTMappingCollection();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("name");
        sic.add("alias");
        sic.add("srcEntityName");
        sic.add("destEntityName");
        sic.add("description");
        sic.add("defineSys");
        sic.add("lastUpdateTime");
        sic.add("isTempSave");
        sic.add("isShowEditUI");
        sic.add("extConfig");
        sic.add("mappingType");
        sic.add("extRule.id");
        sic.add("extRule.filter");
        sic.add("extRule.dataFilter");
        sic.add("extRule.isEffected");
        sic.add("extRule.org.id");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtils.arrayToString((Object[])botpRuleId, (String)","), CompareType.INCLUDE));
        evi.setFilter(fi);
        dapRulesSelected = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(evi);
        return dapRulesSelected;
    }

    @Override
    public Map process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        BOTMappingCollection btpRulesSelected = null;
        String companyID = paramMap.get("companyID").toString();
        SmartAccountEntryBusinessInfo busiInfo = (SmartAccountEntryBusinessInfo)paramMap.get("busiInfo");
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        String srcBosType = busiType.getNumber();
        String desBosType = busiType.getOperator();
        int subSystem = busiType.getSubSystem().getValue();
        String botpRuleIds = null;
        if (paramMap.get("botpRuleIds") != null) {
            botpRuleIds = paramMap.get("botpRuleIds").toString();
        }
        String[] botpRuleList = null;
        if (botpRuleIds != null) {
            botpRuleList = botpRuleIds.split(",");
        }
        btpRulesSelected = VcDapUtil.getDAPRulesBySrcAndDestType(ctx, srcBosType, desBosType, DefineSysEnum.BTP, VcDapUtil.getTransmitContext(ctx, companyID));
        if (botpRuleList != null && botpRuleList.length > 0) {
            BOTMappingCollection btpRulesSelectedNew = new BOTMappingCollection();
            block0: for (int i = 0; i < botpRuleList.length; ++i) {
                for (int j = 0; j < btpRulesSelected.size(); ++j) {
                    if (!btpRulesSelected.get(j).getId().toString().equals(botpRuleList[i])) continue;
                    btpRulesSelectedNew.add(btpRulesSelected.get(j));
                    continue block0;
                }
            }
            btpRulesSelected = btpRulesSelectedNew;
        }
        List billList = (List)paramMap.get("billList");
        Object[] billIds = billList.toArray(new String[billList.size()]);
        if (btpRulesSelected == null || btpRulesSelected.size() == 0) {
            NoRuleRecorder recorder = new NoRuleRecorder(companyID, ctx, (String[])billIds);
            recorder.record(ctx, srcBosType, subSystem);
        } else {
            String[] entrysName = new String[]{VcDapUtil.getBillMainEntryName(srcBosType)};
            CoreBillBaseCollection sourceBillCollection = VcDapUtil.getSrcCollectionByIds(ctx, billIds, null);
            List entriesKeys = VcDapUtil.getSelectEntryIDs(sourceBillCollection, entrysName[0]);
            ctx.put((Object)"sourceBillCollection", (Object)sourceBillCollection);
            ctx.put((Object)"entriesKeys", (Object)entriesKeys);
            ctx.put((Object)"entrysName", (Object)entrysName);
            DAPTransmitRecorderForBillsAndRules recorder = VcDapUtil.checkBotMapping(ctx, companyID, (String[])billIds, entrysName, entriesKeys, btpRulesSelected);
            recorder.setBotCol(btpRulesSelected);
            recorder.transformBill(ctx, srcBosType, subSystem);
        }
        return result;
    }

    @Override
    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK, PeriodInfo periodInfo) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK, periodInfo);
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id where " + filterSql;
        }
        logger.error((Object)("\u667a\u80fd\u6838\u7b97\u5355\u636e\u8f6c\u6362\u83b7\u53d6\u5355\u636e\u7684sql\uff1a" + filterSql));
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        result = this.getSourceBillRowSet(ctx, iexec.getSQL());
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK, PeriodInfo periodInfo) throws BOSException, EASBizException {
        SmartAccountEntryBusinessInfo busiInfo = (SmartAccountEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        OrgUnitInfo companyInfo = (OrgUnitInfo)ctx.get((Object)"companyInfo");
        if (periodInfo == null) {
            try {
                periodInfo = GlUtils.getCurrentPeriod((Context)ctx, (String)companyInfo.getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)("SmartAccounting BillTransform GetFilter Error:" + e.getMessage()));
                periodInfo = null;
            }
        }
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartAccountingProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, companyInfo, periodInfo);
        }
        catch (Exception e) {
            throw new BOSException("SmartAccountingBillTransform use bizClass:" + className + "  getFilter error,please biz department check\uff01", (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ( ").append(filterSql).append(" )");
            }
        } else {
            result.append(filterSql);
        }
        return result.toString();
    }
}

