/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.VoucherRowSetProvider;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmartAccountingFileVoucherQueryDelegate
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.SmartAccountingFileVoucherQueryDelegate");
    private String[] voucherIds;
    private Context ctx = null;
    private VoucherPrintSettingInfo printSetting;

    public SmartAccountingFileVoucherQueryDelegate(Context ctx, List voucherIds) {
        this.voucherIds = voucherIds.toArray(new String[voucherIds.size()]);
        this.ctx = ctx;
        try {
            String function = "fi.gl.voucher.printSetting";
            UserSettingObject userSetObj = UserSettingFactory.getRemoteInstance().getValue(null, function);
            HashMap setting = null;
            if (userSetObj != null) {
                setting = userSetObj.getData();
            }
            if (setting == null) {
                setting = new HashMap();
            }
            this.printSetting = this.toVoucherPrintSettingInfo(setting);
        }
        catch (Exception e) {
            logger.error((Object)"qeury voucher print setting error!", (Throwable)e);
        }
    }

    public VoucherCollection getPrintVoucherCollection(String[] ids, VoucherPrintSettingInfo printSetting) throws BOSException, EASBizException {
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        v.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SorterItemCollection sorters = v.getSorter();
        sorters.add(new SorterItemInfo("id"));
        if (printSetting.isDebitCredit()) {
            SorterItemInfo sorterItem = new SorterItemInfo("entries.entryDC");
            sorterItem.setSortType(SortType.DESCEND);
            sorters.add(sorterItem);
        }
        sorters.add(new SorterItemInfo("entries.seq"));
        if (printSetting.isPrintAssistant()) {
            sorters.add(new SorterItemInfo("entries.assistRecords.seq"));
        }
        SelectorItemCollection sic = VoucherInfo.getPrintSelector((boolean)printSetting.isPrintAssistant(), (boolean)printSetting.isPrintCashFlow(), (boolean)printSetting.isPrintCashflowMeOrOther());
        v.getSelector().addObjectCollection((IObjectCollection)sic);
        VoucherCollection vchColl = VoucherFactory.getRemoteInstance().getVoucherCollection(v);
        return this.sortVoucherCollection(vchColl, ids);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            VoucherCollection vchCol = this.getPrintVoucherCollection(this.voucherIds, this.printSetting);
            VoucherCollection col = new VoucherCollection();
            for (VoucherInfo voucherInfo : vchCol) {
                VoucherInfo info = this.handle(voucherInfo, this.printSetting);
                col.add(info);
            }
            Locale locale = this.ctx.getLocale();
            VoucherRowSetProvider provider = new VoucherRowSetProvider(locale, col, this.printSetting);
            return provider.getRowSet(ds.getID());
        }
        catch (Exception e) {
            logger.error((Object)"print voucher error!", (Throwable)e);
            return null;
        }
    }

    public VoucherCollection sortVoucherCollection(VoucherCollection voucherColl, String[] voucherIds) {
        VoucherCollection vouColl = new VoucherCollection();
        for (int i = 0; i < voucherIds.length; ++i) {
            vouColl.add(voucherColl.get((Object)BOSUuid.read((String)voucherIds[i])));
        }
        return vouColl;
    }

    protected VoucherInfo handle(VoucherInfo info, VoucherPrintSettingInfo printSetting) {
        return info;
    }

    public VoucherPrintSettingInfo toVoucherPrintSettingInfo(Map userSetting) {
        VoucherPrintSettingInfo setting = new VoucherPrintSettingInfo();
        setting.setPrintCashFlow("true".equals(userSetting.get("printCashflow") == null ? "false" : userSetting.get("printCashflow").toString()));
        setting.setPrintCashflowMeOrOther("true".equals(userSetting.get("cashPrintAtAccount") == null ? "false" : userSetting.get("cashPrintAtAccount").toString()));
        setting.setPrintAssistant("true".equals(userSetting.get("printAsst") == null ? "false" : userSetting.get("printAsst").toString()));
        setting.setDebitCredit("true".equals(userSetting.get("debitCredit") == null ? "false" : userSetting.get("debitCredit").toString()));
        setting.setShowAsstFullName("true".equals(userSetting.get("showFullAsstName") == null ? "false" : userSetting.get("showFullAsstName").toString()));
        setting.setShowAsstNumber("true".equals(userSetting.get("showAsstNumber") == null ? "false" : userSetting.get("showAsstNumber").toString()));
        setting.setAutoMachAsstTemplate("true".equals(userSetting.get("asstAutoTemplate") == null ? "false" : userSetting.get("asstAutoTemplate").toString()));
        setting.setAutoMachMulCurrencyTemplate("true".equals(userSetting.get("currencyAutoTemplate") == null ? "false" : userSetting.get("currencyAutoTemplate").toString()));
        setting.setPrintCashflowMeOrOther("true".equals(setting.isPrintCashFlow()) && !"true".equals(userSetting.get("cashPrintAtOppAccount") == null ? "false" : userSetting.get("cashPrintAtOppAccount").toString()));
        setting.setShowAccountNumber("true".equals(userSetting.get("showAccountNumber") == null ? "false" : userSetting.get("showAccountNumber").toString()));
        setting.setShowAccountFullName("true".equals(userSetting.get("showFullAccountName") == null ? "false" : userSetting.get("showFullAccountName").toString()));
        setting.setSumByAccountLevel("true".equals(userSetting.get("isAccountLevel") == null ? "false" : userSetting.get("isAccountLevel").toString()));
        setting.setSumDetailSameAsst("true".equals(userSetting.get("isSumDetailSameAsst") == null ? "false" : userSetting.get("isSumDetailSameAsst").toString()));
        setting.setSumByAccountDC("true".equals(userSetting.get("sumByAccountDC") == null ? "false" : userSetting.get("sumByAccountDC").toString()));
        setting.setNotShowAmountIsZero("true".equals(userSetting.get("notShowAmountIsZero") == null ? "false" : userSetting.get("notShowAmountIsZero").toString()));
        if (userSetting.get("accountLevel") != null && !StringUtils.isEmpty((String)userSetting.get("accountLevel").toString())) {
            setting.setAccountLevel(new BigDecimal(userSetting.get("accountLevel").toString()).intValue());
        }
        return setting;
    }
}

