/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BusinessTypeFactory;
import com.kingdee.eas.fi.vc.ISmartAccountEntryBusiness;
import com.kingdee.eas.fi.vc.ISmartAccountEntryCompany;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessFactory;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyFactory;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyInfo;
import com.kingdee.eas.fi.vc.SmartAccountScheduleFactory;
import com.kingdee.eas.fi.vc.SmartAccountScheduleInfo;
import com.kingdee.eas.fi.vc.SmartAccountScheduleStateEnum;
import com.kingdee.eas.fi.vc.SmartAccountingFacadeFactory;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaInfo;
import com.kingdee.eas.fi.vc.app.AbstractSmartAccountingSchemaControllerBean;
import com.kingdee.eas.fi.vc.app.ISmartAccountRuleF7Param;
import com.kingdee.eas.fi.vc.app.SmartAccountJobSchedulerServerUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmartAccountingSchemaControllerBean
extends AbstractSmartAccountingSchemaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.SmartAccountingSchemaControllerBean");

    @Override
    protected String _stopBackTask(Context ctx, String smartAccountingID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _startBackTask(Context ctx, String smartAccountingID) throws BOSException, EASBizException {
        String result = "";
        try {
            WfEventListenerStateManager.getInstance().enableEventListener();
            result = SmartAccountingFacadeFactory.getLocalInstance(ctx).processBackTask(smartAccountingID);
        }
        catch (Exception e) {
            String string = "";
        }
        return result;
    }

    @Override
    protected String _ImmediExeAutoTask(Context ctx, String smartAccountingID, String businessEntryID, String companyEntryID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getImplementClass(Context ctx, SmartAccountEntryBusinessInfo smartAccountEntryBusinessInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object[] _fetchInitData(Context ctx, Object[] param) throws BOSException, EASBizException {
        Object[] result = new Object[4];
        boolean isGLSmart = false;
        if (param != null && param.length > 0) {
            isGLSmart = (Boolean)param[0];
        }
        result[0] = this.getSubSystemList(ctx, isGLSmart);
        result[1] = this.getBusinessTypeMap(ctx, isGLSmart);
        result[2] = this.getOperatorTypeMap(ctx, isGLSmart);
        result[3] = this.getRuleF7ParamMap(ctx);
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SmartAccountingSchemaInfo smartAccounting = (SmartAccountingSchemaInfo)model;
        return this._submitInternal(ctx, smartAccounting);
    }

    protected IObjectPK _submitInternal(Context ctx, SmartAccountingSchemaInfo smartAccounting) throws BOSException, EASBizException {
        ObjectUuidPK oldPK = new ObjectUuidPK(smartAccounting.getId());
        this.deleteAllCompanyEntries(ctx, oldPK.toString());
        this.deleteAllBusinessEntries(ctx, oldPK.toString());
        smartAccounting.put("name_" + ctx.getLocale(), smartAccounting.getName());
        IObjectPK smartAccountingPK = super._submit(ctx, (IObjectValue)smartAccounting);
        smartAccounting.put("id", smartAccountingPK.getKeyValue("id"));
        Iterator iteratorBusinessEntry = smartAccounting.getSmartAccountEntriesBusiness().iterator();
        Iterator iteratorCompanyEntry = smartAccounting.getSmartAccountEntriesCompany().iterator();
        ISmartAccountEntryBusiness iBusinessEntry = SmartAccountEntryBusinessFactory.getLocalInstance(ctx);
        ISmartAccountEntryCompany iCompanyEntry = SmartAccountEntryCompanyFactory.getLocalInstance(ctx);
        StringBuffer sb = new StringBuffer();
        while (iteratorBusinessEntry.hasNext()) {
            SmartAccountEntryBusinessInfo business_entry = (SmartAccountEntryBusinessInfo)iteratorBusinessEntry.next();
            if (StringUtils.isEmpty((String)business_entry.getFilterSql()) && !StringUtils.isEmpty((String)business_entry.getFilter())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)"filterRuleError", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{business_entry.getSeq()})));
            }
            if ("scpz".equals(business_entry.getOperatorNumber())) {
                business_entry.setBusinessType(null);
            }
            business_entry.setSmartAccounting(smartAccounting);
            iBusinessEntry.submit((CoreBaseInfo)business_entry);
        }
        while (iteratorCompanyEntry.hasNext()) {
            SmartAccountEntryCompanyInfo company_entry = (SmartAccountEntryCompanyInfo)iteratorCompanyEntry.next();
            company_entry.setSmartAccounting(smartAccounting);
            iCompanyEntry.submit((CoreBaseInfo)company_entry);
        }
        if (smartAccounting.getBackSchedule() != null) {
            String scheduleID = smartAccounting.getBackSchedule().getId().toString();
            String sbSql = "update t_vc_smartaccountschedule set fsmartaccountid = ? where fid = ?";
            SmartAccountScheduleInfo scheduleInfo = (SmartAccountScheduleInfo)SmartAccountScheduleFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(scheduleID));
            scheduleInfo.put("smartAccount", smartAccounting.getId().toString());
            SmartAccountScheduleFactory.getLocalInstance(ctx).submit((CoreBaseInfo)scheduleInfo);
            if (scheduleInfo.getJobDefID() != null) {
                SmartAccountJobSchedulerServerUtil.removeJob(ctx, scheduleInfo);
                scheduleInfo.setJobDefID(null);
                scheduleInfo.setStatus(SmartAccountScheduleStateEnum.UNACTIVE);
                if (scheduleInfo.getId() != null) {
                    SmartAccountScheduleFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(scheduleInfo.getId()), (CoreBaseInfo)scheduleInfo);
                }
            }
        }
        return smartAccountingPK;
    }

    protected Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    protected void deleteAllCompanyEntries(Context ctx, String smartAccountID) throws BOSException, EASBizException {
        String sbSql = "delete from t_vc_smartaccountentrycompany where fsmartaccoutingid = ?";
        Object[] params = new Object[]{smartAccountID};
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])params);
    }

    protected void deleteAllBusinessEntries(Context ctx, String smartAccountID) throws BOSException, EASBizException {
        String sbSql = "delete from t_vc_smartaccountentrybusiness where fsmartaccountingid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql);
            ps.setString(1, smartAccountID);
            sbSql = null;
            ps.executeUpdate();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteAllBusinessEntries(ctx, pk.toString());
        this.deleteAllCompanyEntries(ctx, pk.toString());
        super._delete(ctx, pk);
        this.deleteSchemaScheduleRef(ctx, pk);
    }

    private void deleteSchemaScheduleRef(Context ctx, IObjectPK smartAccountPk) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"delete from t_vc_smartaccountschedule where fsmartaccountid = ?", (Object[])new Object[]{smartAccountPk.toString()});
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._getValue(ctx, pk, SmartAccountingSchemaInfo.getDefaultSelector());
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return this.getSmartAccountInternal(ctx, pk, selector);
    }

    private SmartAccountingSchemaInfo getSmartAccountInternal(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)selector);
        SmartAccountingSchemaInfo smartAccountInfo = null;
        smartAccountInfo = (SmartAccountingSchemaInfo)super._getValue(ctx, pk, sic);
        return smartAccountInfo;
    }

    protected Map getOperatorTypeMap(Context ctx, boolean isGLSmart) throws BOSException, EASBizException {
        HashMap operatorTypeMap = new HashMap();
        ArrayList operatorList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        Locale loc = ctx.getLocale();
        String locStr = loc.toString();
        String geneVoucher = EASResource.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)"geneVoucher", (Locale)loc);
        sql.append(" select * from ( ");
        sql.append(" select fsubsystem,to_char(fnumber) fnumber,to_char(foperatorNumber) foperatorNumber,to_char(foperatorName_" + locStr + ") fname,to_char(fdatafilterui) fdataFilterUI,fseq  from t_vc_businesstype  ");
        if (isGLSmart) {
            sql.append(" where fisglsmart = '1' ");
        }
        sql.append(" union all ");
        sql.append(" select fsubsystem,to_char(fbosobjecttype) fnumber ,to_char('scpz') foperatorNumber,to_char('" + geneVoucher + "') fname,to_char('') fdataFilterUI,fseq from t_vc_billtype ");
        if (isGLSmart) {
            sql.append(" where fisglsmart = '1' ");
        }
        sql.append(" ) T   order by fsubsystem ,fnumber,fseq ");
        try {
            ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
            IRowSet rs = dataAccess.getRowSet(sql.toString());
            String preNumber = null;
            String number = null;
            int preSubSystem = 0;
            int subSystem = 0;
            while (rs.next()) {
                String fdataFilterUI;
                String fname;
                String foperator;
                HashMap<String, String> opeMap = new HashMap<String, String>();
                number = rs.getString("fnumber");
                subSystem = rs.getInt("fsubsystem");
                if (subSystem != 32) {
                    if (preNumber == null && preSubSystem == 0) {
                        preNumber = number;
                        preSubSystem = subSystem;
                    } else if (!preNumber.equals(number) || preSubSystem != subSystem) {
                        if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                            ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                        } else {
                            operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                        }
                        operatorList = new ArrayList();
                        preNumber = number;
                        preSubSystem = subSystem;
                    }
                    foperator = rs.getString("foperatorNumber");
                    fname = rs.getString("fname");
                    fdataFilterUI = rs.getString("fdataFilterUI");
                    opeMap.put("number", foperator);
                    opeMap.put("name", fname);
                    opeMap.put("dataFilterUI", fdataFilterUI);
                    operatorList.add(opeMap);
                    continue;
                }
                if (preNumber == null && preSubSystem == 0) {
                    preNumber = number;
                    preSubSystem = subSystem;
                } else if (!preNumber.equals(number) || preSubSystem != subSystem) {
                    if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                        ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                    } else {
                        operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                    }
                    operatorList = new ArrayList();
                    preNumber = number;
                    preSubSystem = subSystem;
                }
                foperator = rs.getString("foperatorNumber");
                fname = rs.getString("fname");
                fdataFilterUI = rs.getString("fdataFilterUI");
                if ("\u751f\u6210\u5229\u6da6\u4e2d\u5fc3\u51ed\u8bc1".equals(fname)) continue;
                opeMap.put("number", foperator);
                opeMap.put("name", fname);
                opeMap.put("dataFilterUI", fdataFilterUI);
                operatorList.add(opeMap);
            }
            if (preNumber.equals(number) && number != null && preSubSystem == subSystem && subSystem != 0) {
                if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                    ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                } else {
                    operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                }
                operatorList = new ArrayList();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return operatorTypeMap;
    }

    private List getSubSystemList(Context ctx, boolean isGLSmart) throws BOSException, EASBizException {
        ArrayList subSystemList = new ArrayList();
        ArrayList<SystemEnum> result = new ArrayList<SystemEnum>();
        String sql = "select distinct t.FSubSystem from ( select FSubSystem from T_VC_SubSystem ";
        sql = sql + " union  ";
        sql = sql + " select  FSubSystem from  T_VC_BUSINESSTYPE ";
        if (isGLSmart) {
            sql = sql + "  where fisglsmart = '1' ";
        }
        sql = sql + ") t";
        try {
            ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
            IRowSet rs = dataAccess.getRowSet(sql);
            while (rs.next()) {
                int subSystemValue = rs.getInt("FSubSystem");
                if (SystemEnum.getEnum((int)subSystemValue) != null) {
                    SystemEnum subSystemEnum = SystemEnum.getEnum((int)subSystemValue);
                    result.add(subSystemEnum);
                    continue;
                }
                if (subSystemValue != 666) continue;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map getBusinessTypeMap(Context ctx, boolean isGLSmart) throws BOSException, EASBizException {
        Map businessTypeM = new HashMap();
        businessTypeM = BusinessTypeFactory.getLocalInstance(ctx).getBusinessTypeMap(isGLSmart);
        return businessTypeM;
    }

    private Map getRuleF7ParamMap(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Map> ruleF7ParamMap = new HashMap<String, Map>();
        StringBuffer sql = new StringBuffer("SELECT fruleF7ConfigClass,FSubSystem,FNUMBER,FOPERATORNUMBER  FROM t_vc_businesstype where FISRULEUSEF7 = 1 and fruleF7ConfigClass is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String subsystem = rs.getString("FSubSystem");
                String businessNumber = rs.getString("FNUMBER");
                String operatorNumber = rs.getString("FOPERATORNUMBER");
                StringBuffer key = new StringBuffer(subsystem);
                key.append(businessNumber).append(operatorNumber);
                String ruleF7ConfigClass = rs.getString("fruleF7ConfigClass");
                Map ruleF7Param = null;
                try {
                    ISmartAccountRuleF7Param ruleF7ParamInstance = (ISmartAccountRuleF7Param)Class.forName(ruleF7ConfigClass).newInstance();
                    ruleF7Param = ruleF7ParamInstance.getRuleF7Param();
                }
                catch (InstantiationException e) {
                    logger.error((Object)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
                if (ruleF7Param == null) continue;
                ruleF7ParamMap.put(key.toString(), ruleF7Param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ruleF7ParamMap;
    }

    @Override
    protected boolean _existsNumber(Context ctx, String number) throws BOSException, EASBizException {
        boolean exist = false;
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        String sql = "SELECT TOP 1 1 FROM T_VC_SmartAccountingSchema where FNumber=? ";
        try {
            cn = this.getConnection(ctx);
            psStmt = cn.prepareStatement(sql);
            psStmt.setString(1, number);
            rs = psStmt.executeQuery();
            if (rs.next()) {
                exist = true;
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return exist;
    }

    @Override
    protected boolean _sameBuisnessExistsDiffSchema(Context ctx, String company, int subSystem, String businessNumber, String operatorNumber) throws BOSException, EASBizException {
        return false;
    }
}

