/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyCollection;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyInfo;
import com.kingdee.eas.fi.vc.SmartAccountingReportFactory;
import com.kingdee.eas.fi.vc.SmartAccountingReportInfo;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaFactory;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaInfo;
import com.kingdee.eas.fi.vc.SmartAccountingStateEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SmartAccountingSchemaUtils {
    private static Logger logger = Logger.getLogger(SmartAccountingSchemaUtils.class);
    private static String resource = "com.kingdee.eas.fi.vc.SmartAccountingResource";

    public static String createGuuid(Context ctx) {
        String id = UUID.randomUUID().toString();
        id = id.replaceAll("-", "");
        return id;
    }

    public static String getFirstReportIDByGuuid(Context ctx, String guuid) throws BOSException {
        String reportID = null;
        String sql = " select top 1 fid from T_VC_SmartAccountingReport where fguuid= ? and fstatus = 0 order by fseq ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{guuid});
            if (rs.next()) {
                reportID = rs.getString("fid");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return reportID;
    }

    public static MutexParameter getTaskMutexParameter(Context ctx, String dcName, String schemaID, String businessEntryID, String companyID, String userId, String actionResName, String actionDetail, MutexLockType type) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        if (businessEntryID != null) {
            mp.setMutexName("GL_SmartAccounting_" + schemaID + "_" + businessEntryID + "_" + companyID);
        } else {
            mp.setMutexName("GL_SmartAccounting_" + schemaID);
        }
        String actionName = ResourceBase.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)actionResName, (Locale)ctx.getLocale());
        if (actionDetail != null && actionDetail.trim().length() > 0) {
            actionName = actionName + "[" + actionDetail.trim() + "]";
        }
        mp.setActionName(actionName);
        if (companyID != null) {
            mp.setOrgUnitID(BOSUuid.read((String)companyID));
        }
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(type);
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = ResourceBase.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)"GL_SmartAccounting", (Locale)ctx.getLocale());
        mp.setDescription(description);
        return mp;
    }

    public static List getSchemaAllTaskInfo(Context ctx, String schemaID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int seq = 1;
        if (schemaID == null) {
            return null;
        }
        SmartAccountingSchemaInfo schemaInfo = SmartAccountingSchemaFactory.getLocalInstance(ctx).getSmartAccountingSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID));
        if (schemaInfo != null) {
            Iterator busiItr = schemaInfo.getSmartAccountEntriesBusiness().iterator();
            SmartAccountEntryCompanyCollection comCol = schemaInfo.getSmartAccountEntriesCompany();
            while (busiItr.hasNext()) {
                SmartAccountEntryBusinessInfo busi = (SmartAccountEntryBusinessInfo)busiItr.next();
                for (int i = 0; i < comCol.size(); ++i) {
                    SmartAccountEntryCompanyInfo com = comCol.get(i);
                    HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
                    temp.put("schema", schemaInfo);
                    temp.put("businessEntry", busi);
                    temp.put("companyEntry", com);
                    temp.put("seq", Integer.valueOf(seq++));
                    result.add(temp);
                }
            }
        }
        return result;
    }

    public static List getSchemaAllTaskID(Context ctx, String schemaID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int seq = 1;
        if (schemaID == null) {
            return null;
        }
        SmartAccountingSchemaInfo schemaInfo = SmartAccountingSchemaFactory.getLocalInstance(ctx).getSmartAccountingSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID));
        if (schemaInfo != null) {
            Iterator busiItr = schemaInfo.getSmartAccountEntriesBusiness().iterator();
            Iterator comItr = schemaInfo.getSmartAccountEntriesCompany().iterator();
            while (busiItr.hasNext()) {
                String busiID = ((SmartAccountEntryBusinessInfo)busiItr.next()).getId().toString();
                while (comItr.hasNext()) {
                    String comID = ((SmartAccountEntryCompanyInfo)comItr.next()).getId().toString();
                    String com = ((SmartAccountEntryCompanyInfo)comItr.next()).getCompany().getId().toString();
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    temp.put("schema", schemaID);
                    temp.put("businessEntry", busiID);
                    temp.put("companyEntry", comID);
                    temp.put("company", com);
                    temp.put("seq", seq++);
                    result.add(temp);
                }
            }
        }
        return result;
    }

    public static EntityViewInfo getSmartAccountReportByParam(String schemaID, String businessID, String companyID, String reportID) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("smartAccounting", (Object)schemaID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("businessEntry", (Object)businessID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)reportID, CompareType.EQUALS));
        evi.setFilter(fi);
        return evi;
    }

    public static String record(Context ctx, SmartAccountingSchemaInfo schema, SmartAccountEntryBusinessInfo busiInfo, SmartAccountEntryCompanyInfo comInfo, int status, String result, int sucessCount, int failureCount, UserInfo exeUser, String reportID, String uuid, int seq) throws BOSException, EASBizException {
        String reportPK;
        block22: {
            SmartAccountingReportInfo reportInfo = null;
            CoreBaseCollection reportCollection = null;
            DateFormat df = DateFormat.getDateInstance(1, Locale.CHINA);
            String schemaID = schema.getId().toString();
            String businessID = busiInfo.getId().toString();
            String companyID = null;
            if (comInfo != null && comInfo.getCompany() != null) {
                companyID = comInfo.getCompany().getId().toString();
            }
            reportPK = "";
            try {
                if (reportID != null) {
                    EntityViewInfo evi = SmartAccountingSchemaUtils.getSmartAccountReportByParam(schemaID, businessID, companyID, reportID);
                    reportCollection = SmartAccountingReportFactory.getLocalInstance(ctx).getCollection(evi);
                    CoreBaseCollection vrcNew = new CoreBaseCollection();
                    if (reportCollection.size() > 0) {
                        SmartAccountingReportInfo info = (SmartAccountingReportInfo)reportCollection.get(0);
                        if (status == 1) {
                            info.setStatus(SmartAccountingStateEnum.STATE_PROCESS);
                            info.setExeStartTime(new Date());
                        } else if (status == 2) {
                            info.setStatus(SmartAccountingStateEnum.STATE_FINISHED);
                            info.setExeEndTime(new Date());
                            if (sucessCount != 0) {
                                info.setSuccessCount(sucessCount);
                            }
                            if (failureCount != 0) {
                                info.setFailureCount(failureCount);
                            }
                            info.setResult(result);
                        }
                        reportInfo = info;
                    } else {
                        reportInfo = new SmartAccountingReportInfo();
                        reportInfo.setSubSystem(busiInfo.getSubSystem());
                        reportInfo.setBusinessNumber(busiInfo.getBusinessNumber());
                        reportInfo.setOperatorNumber(busiInfo.getOperatorNumber());
                        Date date = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String strDate = sdf.format(date);
                        try {
                            date = sdf.parse(strDate);
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                        if (status == 1) {
                            reportInfo.setStatus(SmartAccountingStateEnum.STATE_PROCESS);
                            reportInfo.setExeStartTime(new Date());
                        } else if (status == 2) {
                            reportInfo.setStatus(SmartAccountingStateEnum.STATE_FINISHED);
                            reportInfo.setExeEndTime(new Date());
                        }
                        reportInfo.setExeStartTime(date);
                        reportInfo.setSmartAccounting(schema);
                        reportInfo.setBusinessEntry(busiInfo);
                        reportInfo.setCompanyEntry(comInfo);
                        if (companyID != null) {
                            reportInfo.setCompany(comInfo.getCompany());
                        }
                        reportInfo.setUser(exeUser);
                        reportInfo.setBusinessType(busiInfo.getBusinessType());
                        reportInfo.setBillType(busiInfo.getBillType());
                        reportInfo.setGuuID(uuid);
                        reportInfo.setSeq(seq);
                    }
                } else {
                    reportInfo = new SmartAccountingReportInfo();
                    reportInfo.setSubSystem(busiInfo.getSubSystem());
                    reportInfo.setBusinessNumber(busiInfo.getBusinessNumber());
                    reportInfo.setOperatorNumber(busiInfo.getOperatorNumber());
                    Date date = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String strDate = sdf.format(date);
                    try {
                        date = sdf.parse(strDate);
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                    reportInfo.setStatus(SmartAccountingStateEnum.STATE_WAITING);
                    reportInfo.setExeStartTime(date);
                    reportInfo.setSmartAccounting(schema);
                    reportInfo.setBusinessEntry(busiInfo);
                    reportInfo.setCompanyEntry(comInfo);
                    if (companyID != null) {
                        reportInfo.setCompany(comInfo.getCompany());
                    }
                    reportInfo.setUser(exeUser);
                    reportInfo.setBusinessType(busiInfo.getBusinessType());
                    reportInfo.setBillType(busiInfo.getBillType());
                    reportInfo.setGuuID(uuid);
                    reportInfo.setSeq(seq);
                }
                if (reportInfo != null) {
                    reportPK = SmartAccountingReportFactory.getLocalInstance(ctx).submitReportNew(reportInfo).toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)"smart report update exception.", (Throwable)e);
                if (reportID == null) break block22;
                SmartAccountingSchemaUtils.repairSmartReportStatus(ctx, reportID, null, SmartAccountingStateEnum.getEnum(status));
                return reportID;
            }
        }
        return reportPK.toString();
    }

    public static String recordByID(Context ctx, String schemaID, String busiInfoID, String comInfoID, String companyID, String subSystem, String businessNumber, String operatorNumber, String billTypeID, String businessTypeID, UserInfo exeUser, String uuid, int seq) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("schemaID", schemaID);
        paramMap.put("busiInfoID", busiInfoID);
        paramMap.put("companyID", companyID);
        paramMap.put("subSystem", subSystem);
        paramMap.put("businessNumber", businessNumber);
        paramMap.put("operatorNumber", operatorNumber);
        paramMap.put("exeUserID", exeUser.getId().toString());
        paramMap.put("comInfoID", comInfoID);
        paramMap.put("billTypeID", billTypeID);
        paramMap.put("businessTypeID", businessTypeID);
        paramMap.put("uuid", uuid);
        paramMap.put("seq", seq);
        SmartAccountingReportFactory.getLocalInstance(ctx).insertNew(paramMap, null);
        return null;
    }

    public static String recordByIDNew(Context ctx, String schemaID, String busiInfoID, String comInfoID, String companyID, String subSystem, String businessNumber, String operatorNumber, String billTypeID, String businessTypeID, UserInfo exeUser, String uuid, int seq) throws BOSException, EASBizException {
        Object reportInfo = null;
        Object reportCollection = null;
        DateFormat df = DateFormat.getDateInstance(1, Locale.CHINA);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strDate = sdf.format(date);
        try {
            date = sdf.parse(strDate);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String sql = " insert into T_VC_SmartAccountingReport(FID ,FSmartAccountingID ,FSmartAccountingEntryID ,FCompanyID ,FSubSystem ,FBusinessNumber ,FOperatorNumber ,FExecutor   ,FStatus ,FSmartAccountCompanyEntryID ,FBillTypeID ,FBusinessTypeID,FGuuID ,FSeq ) values(newbosid('D6248D4A'),?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{schemaID, busiInfoID, companyID, subSystem, businessNumber, operatorNumber, exeUser.getId().toString(), 0, comInfoID, billTypeID, businessTypeID, uuid, seq});
        return null;
    }

    public static List cancelTask(Context ctx, List paramList, UserInfo cancelUser) throws BOSException, EASBizException {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<ObjectUuidPK> canCancelIds = new ArrayList<ObjectUuidPK>();
        String schemaIds = "";
        String busiEntryIds = "";
        String comEntryIds = "";
        HashSet<String> schemaSet = new HashSet<String>();
        HashSet<String> busiSet = new HashSet<String>();
        HashSet<String> comSet = new HashSet<String>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i2 = 0; i2 < paramList.size(); ++i2) {
            Map temp = (Map)paramList.get(i2);
            schemaIds = temp.get("schemaID").toString();
            busiEntryIds = temp.get("busiEntryID").toString();
            comEntryIds = temp.get("compEntryID").toString();
            schemaSet.add(schemaIds);
            busiSet.add(busiEntryIds);
            comSet.add(comEntryIds);
            keyList.add(temp.get("schemaID").toString() + temp.get("busiEntryID").toString() + temp.get("compEntryID").toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("smartAccounting", schemaSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("businessEntry", busiSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("companyEntry", comSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.setSelector(SmartAccountingReportInfo.getDefaultSelectorForRegister());
        CoreBaseCollection reportCollection = SmartAccountingReportFactory.getLocalInstance(ctx).getCollection(evi);
        HashMap<String, SmartAccountingReportInfo> reportMap = new HashMap<String, SmartAccountingReportInfo>();
        for (i = 0; i < reportCollection.size(); ++i) {
            SmartAccountingReportInfo temp = (SmartAccountingReportInfo)reportCollection.get(i);
            String key = temp.getSmartAccounting().getId().toString() + temp.getBusinessEntry().getId().toString() + temp.getCompanyEntry().getId().toString();
            reportMap.put(key, temp);
        }
        for (i = 0; i < keyList.size(); ++i) {
            SmartAccountingReportInfo reportInfo = (SmartAccountingReportInfo)reportMap.get(keyList.get(i));
            if (reportInfo == null) continue;
            if (reportInfo.getUser().getId().toString().equals(cancelUser.getId().toString())) {
                canCancelIds.add(new ObjectUuidPK(reportInfo.getId().toString()));
                continue;
            }
            String error = MessageFormat.format(EASResource.getString((String)resource, (String)"schemaMsg4", (Locale)ctx.getOriginLocale()), reportInfo.getSmartAccounting().getName(), reportInfo.getCompany().getName());
            String opeStr = "";
            opeStr = reportInfo.getBusinessType() == null ? MessageFormat.format(EASResource.getString((String)resource, (String)"schemaMsg5", (Locale)ctx.getOriginLocale()), reportInfo.getBillType().getName(), reportInfo.getUser().getName()) : MessageFormat.format(EASResource.getString((String)resource, (String)"schemaMsg6", (Locale)ctx.getOriginLocale()), reportInfo.getBusinessType().getName(), reportInfo.getBusinessType().getOperatorName(), reportInfo.getUser().getName());
            result.add(error + opeStr);
        }
        if (canCancelIds.size() > 0) {
            IObjectPK[] idPK = new IObjectPK[canCancelIds.size()];
            for (int i3 = 0; i3 < canCancelIds.size(); ++i3) {
                idPK[i3] = (IObjectPK)canCancelIds.get(i3);
            }
            SmartAccountingReportFactory.getLocalInstance(ctx).deleteNew(idPK);
        }
        return result;
    }

    public static List cancelTaskSingle(Context ctx, List paramList, UserInfo cancelUser) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        IObjectPK[] canCancelIds = new IObjectPK[]{};
        String schemaIds = "";
        String busiEntryIds = "";
        String comEntryIds = "";
        ArrayList keyList = new ArrayList();
        if (paramList.size() > 0) {
            Map param = (Map)paramList.get(0);
            schemaIds = param.get("schemaID").toString();
            busiEntryIds = param.get("busiEntryID").toString();
            comEntryIds = param.get("compEntryID").toString();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("smartAccounting", (Object)schemaIds, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("businessEntry", (Object)busiEntryIds, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("companyEntry", (Object)comEntryIds, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
            evi.setFilter(fi);
            evi.setSelector(SmartAccountingReportInfo.getDefaultSelectorForRegister());
            CoreBaseCollection reportCollection = SmartAccountingReportFactory.getLocalInstance(ctx).getCollection(evi);
            for (int i = 0; i < reportCollection.size(); ++i) {
                String opeStr;
                String error;
                SmartAccountingReportInfo reportInfo = (SmartAccountingReportInfo)reportCollection.get(i);
                if (reportInfo == null) {
                    error = ResourceBase.getString((String)resource, (String)"schemaMsg4", (Locale)ctx.getLocale(), (Object[])new String[]{reportInfo.getSmartAccounting().getName(), reportInfo.getCompany().getName()});
                    opeStr = "";
                    opeStr = reportInfo.getBusinessType() == null ? ResourceBase.getString((String)resource, (String)"notCancel1", (Locale)ctx.getLocale(), (Object[])new String[]{reportInfo.getBillType().getName()}) : ResourceBase.getString((String)resource, (String)"notCancel2", (Locale)ctx.getLocale(), (Object[])new String[]{reportInfo.getBusinessType().getName(), reportInfo.getBusinessType().getOperatorName()});
                    result.add(error);
                    continue;
                }
                if (reportInfo.getUser().getId().toString().equals(cancelUser.getId().toString())) {
                    canCancelIds[canCancelIds.length] = new ObjectUuidPK(reportInfo.getId().toString());
                    continue;
                }
                error = ResourceBase.getString((String)resource, (String)"schemaMsg4", (Locale)ctx.getLocale(), (Object[])new String[]{reportInfo.getSmartAccounting().getName(), reportInfo.getCompany().getName()});
                opeStr = "";
                opeStr = reportInfo.getBusinessType() == null ? ResourceBase.getString((String)resource, (String)"schemaMsg5", (Locale)ctx.getLocale(), (Object[])new String[]{reportInfo.getBillType().getName(), reportInfo.getUser().getName()}) : ResourceBase.getString((String)resource, (String)"schemaMsg6", (Locale)ctx.getLocale(), (Object[])new String[]{reportInfo.getBusinessType().getName(), reportInfo.getBusinessType().getOperatorName(), reportInfo.getUser().getName()});
                result.add(error);
            }
            if (canCancelIds.length > 0) {
                SmartAccountingReportFactory.getLocalInstance(ctx).deleteNew(canCancelIds);
            }
        }
        return result;
    }

    public static void repairSmartReportStatus(Context ctx, String reportId, String result, SmartAccountingStateEnum status) throws BOSException {
        StringBuilder repairSql = new StringBuilder("update T_VC_SMARTACCOUNTINGREPORT set FSTATUS = ?");
        Timestamp formatNowDate = SmartAccountingSchemaUtils.getFormatNowDate();
        Object[] params = null;
        if (status == SmartAccountingStateEnum.STATE_PROCESS) {
            repairSql.append(",FEXESTARTTIME=? ");
            params = new Object[]{status.getValue(), formatNowDate, reportId};
        } else if (status == SmartAccountingStateEnum.STATE_FINISHED) {
            result = StringUtils.isEmpty((String)result) ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"smartreport_status_repair", (Locale)ctx.getOriginLocale()) : result;
            repairSql.append(",FEXEENDTIME=?,FRESULT=?");
            params = new Object[]{status.getValue(), formatNowDate, result, reportId};
        } else {
            return;
        }
        repairSql.append(" where fid = ? ");
        try {
            DbUtil.execute((Context)ctx, (String)repairSql.toString(), (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)"repair smart report status exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void repairSmartReportStatusByGuuid(Context ctx, String guuid, String result) throws BOSException {
        result = StringUtils.isEmpty((String)result) ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"smartreport_status_repair", (Locale)ctx.getOriginLocale()) : result;
        String repairSql = "update T_VC_SMARTACCOUNTINGREPORT set FSTATUS = 2,FEXEENDTIME = ?,FRESULT=?  where FGUUID = ?";
        Timestamp formatNowDate = SmartAccountingSchemaUtils.getFormatNowDate();
        try {
            DbUtil.execute((Context)ctx, (String)repairSql, (Object[])new Object[]{formatNowDate, result, guuid});
        }
        catch (BOSException e) {
            logger.error((Object)"repair smart report status exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void repairHistSmartReportStatus(Context ctx, String schemaId, String businessId, String companyId, String guuid, String result) throws BOSException {
        result = StringUtils.isEmpty((String)result) ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"smartreport_status_repair", (Locale)ctx.getOriginLocale()) : result;
        String repairSql = "update t_vc_smartaccountingreport set fstatus = 2,fresult=? where FSMARTACCOUNTINGID = ? and FSMARTACCOUNTINGENTRYID = ? and FCOMPANYID = ? and fstatus in(0,1) and FGUUID <> ?";
        try {
            DbUtil.execute((Context)ctx, (String)repairSql, (Object[])new Object[]{result, schemaId, businessId, companyId, guuid});
        }
        catch (Exception e) {
            logger.error((Object)"repair smart report status exception.", (Throwable)e);
        }
    }

    private static Timestamp getFormatNowDate() {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        return timestamp;
    }
}

