/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.vc.app.AbstractSmartAccountingProcess;
import com.kingdee.eas.fi.vc.app.SmartAccountUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmartAccountingVoucherAudit
extends AbstractSmartAccountingProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.SmartAccountingVoucherAudit");

    @Override
    public Map process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ArrayList idList = new ArrayList();
        String billID = null;
        Map billIdAndNumber = new HashMap();
        if (this.isBatchDeal()) {
            idList = (ArrayList)paramMap.get("billList");
            billIdAndNumber = (Map)paramMap.get("billIdAndNumber");
        } else {
            billID = paramMap.get("billID").toString();
        }
        String auditorID = paramMap.get("userID").toString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dealBills", new ArrayList());
        try {
            if (this.isBatchDeal()) {
                int batchNum = paramMap.get("batchNum") == null ? Integer.valueOf(60) : paramMap.get("batchNum");
                if (paramMap.get("batchNum") != null) {
                    List<List> splitIdList = SmartAccountUtils.splitIdList(idList, batchNum);
                    for (List ids : splitIdList) {
                        try {
                            VoucherFactory.getLocalInstance((Context)ctx).auditVoucherCollection(ids, BOSUuid.read((String)auditorID));
                            ((List)result.get("dealBills")).addAll(ids);
                        }
                        catch (VoucherException e) {
                            logger.error((Object)e);
                            String message = e.getMessage();
                            for (Object id : ids) {
                                if (message.indexOf((String)billIdAndNumber.get(id)) > 0) {
                                    result.put((String)id, message);
                                    continue;
                                }
                                ((List)result.get("dealBills")).add(id);
                            }
                        }
                    }
                }
            } else if (!StringUtils.isEmpty((String)billID)) {
                VoucherFactory.getLocalInstance((Context)ctx).auditVoucher((IObjectPK)new ObjectUuidPK(billID), BOSUuid.read((String)auditorID));
            }
        }
        catch (Exception e) {
            result.put("error", e.getMessage());
        }
        return result;
    }

    @Override
    public boolean isBatchDeal() {
        return true;
    }

    @Override
    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK, PeriodInfo periodInfo) throws BOSException, EASBizException {
        List ids = new ArrayList();
        String filter = "";
        if (filterSql != null) {
            String oql = "select id where " + filterSql;
            IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
            IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, oql);
            String sql = iexec.getSQL();
            int distinctIndex = sql.indexOf("DISTINCT");
            int fromIndex = sql.indexOf("FROM");
            if (distinctIndex < 0 || distinctIndex > fromIndex) {
                sql = sql.replaceFirst("SELECT", "SELECT DISTINCT");
            }
            filter = sql;
        }
        StringBuffer sql = new StringBuffer("select v.fid,v.fnumber from t_gl_voucher v, t_bd_vouchertypes vt where 1 = 1 and vt.fid = v.FVoucherTypeID ");
        if (periodInfo == null) {
            periodInfo = GlUtils.getCurrentPeriod((Context)ctx, (String)companyID);
        }
        if (filter != null && filter.length() > 0) {
            sql.append(" and v.fid in ( ").append(filter).append(" ) ");
        }
        Integer audited = new Integer(1);
        sql.append(" and v.FCompanyID =  '").append(companyID).append("' ");
        sql.append(" and v.FPeriodID = '").append(periodInfo.getId().toString()).append("' ");
        sql.append(" and v.FBizStatus = '").append(audited).append("' ");
        sql.append(" order by vt.fnumber,v.fnumber ");
        ids = this.getSourceBillRowSetNumber(ctx, sql.toString());
        return ids;
    }
}

