/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.eas.common.PrintConfigFacadeFactory;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class SmartAccountingVoucherFileNoteUserConfig {
    private static Logger log = LogUtil.getPackageLogger(SmartAccountingVoucherFileNoteUserConfig.class);
    private static String FILENAME = "NoteUserConfig.xml";
    private static String TAG_ROOT = "UserConfig";
    private static String TAG_USER = "User";
    private static String TAG_DEFAULT = "DefaultTemplate";
    private static String ATT_NAME = "name";
    private static String ATT_ORGFILTER = "orgFilter";
    private HashMap _mapDefaultTemplate;
    private boolean _isDirty = false;

    public SmartAccountingVoucherFileNoteUserConfig(Context ctx, Element root, String dirPathText) {
        this.fromXml(ctx, root, dirPathText);
    }

    private void fromXml(Context ctx, Element root, String dirPathText) {
        Info info;
        this._mapDefaultTemplate = new HashMap();
        if (root == null) {
            return;
        }
        for (Element nodeUser : root.getChildren(TAG_USER)) {
            String user = nodeUser.getAttributeValue(ATT_NAME);
            if (StringUtil.isEmptyString((String)user)) continue;
            info = new Info();
            String strOrgFilter = nodeUser.getAttributeValue(ATT_ORGFILTER);
            info.isOrgFilter = "true".equals(strOrgFilter);
            Element nodeDef = nodeUser.getChild(TAG_DEFAULT);
            String defaultTemplate = null;
            try {
                defaultTemplate = PrintConfigFacadeFactory.getRemoteInstance().getDefaultTemplate(user, dirPathText);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (nodeDef != null) {
                info.defaultTemplate = nodeDef.getTextTrim();
            }
            if (!StringUtil.isEmptyString((String)defaultTemplate)) {
                info.defaultTemplate = defaultTemplate;
            }
            this._mapDefaultTemplate.put(user, info);
        }
        try {
            String userOrgStr = ctx.get((Object)"") + " " + ctx.getUserName();
            String defaultTemplate = PrintConfigFacadeFactory.getRemoteInstance().getDefaultTemplate(userOrgStr, dirPathText);
            if (!StringUtil.isEmptyString((String)defaultTemplate)) {
                info = new Info();
                info.defaultTemplate = defaultTemplate;
                this._mapDefaultTemplate.put(userOrgStr, info);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private Element toXml() {
        Element root = new Element(TAG_ROOT);
        for (String key : this._mapDefaultTemplate.keySet()) {
            Element nodeUser = new Element(TAG_USER);
            nodeUser.setAttribute(ATT_NAME, key);
            Info info = (Info)this._mapDefaultTemplate.get(key);
            if (info.isOrgFilter) {
                nodeUser.setAttribute(ATT_ORGFILTER, "true");
            }
            Element nodeDef = new Element(TAG_DEFAULT);
            nodeDef.addContent(info.defaultTemplate);
            nodeUser.addContent((Content)nodeDef);
            root.addContent((Content)nodeUser);
        }
        return root;
    }

    private Info getInfo(String user) {
        return (Info)this._mapDefaultTemplate.get(user);
    }

    private Info getNotNullInfo(String user) {
        Info info = this.getInfo(user);
        if (info == null) {
            info = new Info();
            this._mapDefaultTemplate.put(user, info);
        }
        return info;
    }

    private void syncExistable(String user) {
        Info info = this.getInfo(user);
        if (info == null) {
            return;
        }
        if (!StringUtil.isEmptyString((String)info.defaultTemplate)) {
            return;
        }
        if (info.isOrgFilter) {
            return;
        }
        this._mapDefaultTemplate.remove(user);
    }

    public String getDefaultTemplateName(String user) {
        Info info = this.getInfo(user);
        return info == null ? null : SmartAccountingVoucherFileNoteUserConfig.cnulls(info.defaultTemplate);
    }

    public static String cnulls(String str) {
        if (str == null || "null".equals(str)) {
            return "";
        }
        return str;
    }

    public void putDefaultTemplateName(String user, String defaultTemplateName) {
        Info info = this.getNotNullInfo(user);
        info.defaultTemplate = defaultTemplateName;
        this.syncExistable(user);
        this._isDirty = true;
    }

    public void removeDefaultTemplateName(String user) {
        Info info = this.getInfo(user);
        if (info != null) {
            info.defaultTemplate = null;
            this.syncExistable(user);
            this._isDirty = true;
        }
    }

    public boolean isOrgFilter(String user) {
        Info info = this.getInfo(user);
        return info == null ? false : info.isOrgFilter;
    }

    public void putOrgFilter(String user, boolean isOrgFilter) {
        Info info = this.getNotNullInfo(user);
        info.isOrgFilter = isOrgFilter;
        this.syncExistable(user);
        this._isDirty = true;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public static SmartAccountingVoucherFileNoteUserConfig load(Context ctx, IBizStorage sto, String dirPathText) {
        Element root = null;
        try {
            byte[] bs = BizStorageUtil.readFile((IBizStorage)sto, (String)PathUtil.makeChildPath((String)dirPathText, (String)FILENAME));
            root = XmlUtil.loadXmlBytes((byte[])bs);
        }
        catch (NotFoundException ex1) {
            log.debug((Object)("\u8be5\u8def\u5f84\u4e0b\u7684\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd9\u662f\u9884\u671f\u7684\u5f02\u5e38\u3002" + dirPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        return new SmartAccountingVoucherFileNoteUserConfig(ctx, root, dirPathText);
    }

    private static class Info {
        private String defaultTemplate;
        private boolean isOrgFilter;

        private Info() {
        }
    }
}

