/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.bos.ctrl.print.config.ui.AbstractStartLocationModel;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.eas.fi.vc.app.SmartAccountingVoucherFileNoteStart;
import com.kingdee.eas.fi.vc.app.SmartAccountingVoucherFilePaperPringConfig;
import com.kingdee.eas.fi.vc.app.SmartAccoutingVoucherFileNotePrintConfig;
import java.util.Iterator;
import java.util.Map;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.log4j.Logger;
import sun.print.SunAlternateMedia;

public class SmartAccountingVoucherFilePringConfigChange
implements IConfigChangeListener {
    private static Logger log = LogUtil.getLogger(SmartAccountingVoucherFilePringConfigChange.class);
    private boolean _enabled;
    private KDPrinter _printer;
    private IBizStorage _localStorage;
    private String _currentTemplatePath;
    private SmartAccoutingVoucherFileNotePrintConfig _config;
    private String _oriPrinterName;
    private AbstractStartLocationModel locationModel;
    private SmartAccountingVoucherFilePaperPringConfig _paperConfig;
    private SmartAccountingVoucherFilePaperPringConfig.PaperInfo _templatePaperInfo;
    private SmartAccountingVoucherFilePaperPringConfig.PaperInfo _oriPaperInfo;

    public void setPrinter(KDPrinter printer) {
        this._printer = printer;
    }

    public void setCurrentTemplatePath(String p) {
        this._currentTemplatePath = p;
    }

    public void setLocalStorage(IBizStorage sto) {
        this._localStorage = sto;
    }

    public void initValue(PrintJobConfig printJobConfig) {
        if (this.isEnvironmentOk()) {
            this._oriPrinterName = this.getPrinterName();
            if (this._oriPrinterName == null) {
                return;
            }
            String key = SmartAccoutingVoucherFileNotePrintConfig.createKey(this._currentTemplatePath, this._oriPrinterName);
            this.getConfig().updateDate(key);
            this.getConfig().save(this._localStorage);
            this._templatePaperInfo = new SmartAccountingVoucherFilePaperPringConfig.PaperInfo();
            SmartAccountingVoucherFilePringConfigChange.keepPaperSetting(printJobConfig, this._templatePaperInfo);
            key = this._currentTemplatePath;
            SmartAccountingVoucherFilePaperPringConfig.PaperInfo info = this.getPaperConfig().getInfo(key);
            if (info != null) {
                SmartAccountingVoucherFilePringConfigChange.changePaperSetting(printJobConfig, info);
                this._oriPaperInfo = new SmartAccountingVoucherFilePaperPringConfig.PaperInfo();
                SmartAccountingVoucherFilePringConfigChange.keepPaperSetting(printJobConfig, this._oriPaperInfo);
            }
            this.getPaperConfig().updateDate(key);
            this.getPaperConfig().save(this._localStorage);
        }
    }

    private SmartAccoutingVoucherFileNotePrintConfig getConfig() {
        if (this._config == null) {
            this._config = SmartAccoutingVoucherFileNotePrintConfig.load(this._localStorage);
            this.locationModel = new SmartAccountingVoucherFileNoteStart();
            this.startLocationLoad();
        }
        return this._config;
    }

    private SmartAccountingVoucherFilePaperPringConfig getPaperConfig() {
        if (this._paperConfig == null) {
            this._paperConfig = SmartAccountingVoucherFilePaperPringConfig.load(this._localStorage);
        }
        return this._paperConfig;
    }

    private boolean isEnvironmentOk() {
        return this._currentTemplatePath != null && this._localStorage != null && this._printer != null;
    }

    private void startLocationLoad() {
        Iterator iter = this._config.getIters();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            float[] loaction = this._config.getPrinterOffset(key);
            String[] noteAndPrint = key.split("@");
            if (!StringUtil.equals((String)this._currentTemplatePath, (String)noteAndPrint[0])) continue;
            this.locationModel.setStartValues((Object)noteAndPrint[1], loaction);
        }
        this._printer.getPrintConfig().setStartLocationModel(this.locationModel);
    }

    private static void keepPaperSetting(PrintJobConfig printJobConfig, SmartAccountingVoucherFilePaperPringConfig.PaperInfo info) {
        Media media = (Media)printJobConfig.getPrintRequestAttributeSet().get(Media.class);
        if (media == MediaSizeNameExtend.CUSTOM) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)MediaSizeNameExtend.CUSTOM);
            info.setCustomPaper(ms.getX(1000), ms.getY(1000));
        } else {
            info.setPaperName(media.toString());
        }
        OrientationRequested oriReq = (OrientationRequested)printJobConfig.getPrintRequestAttributeSet().get(OrientationRequested.class);
        if (oriReq == OrientationRequested.LANDSCAPE) {
            info.setLandscape();
        } else if (oriReq == OrientationRequested.PORTRAIT) {
            info.setPortrait();
        }
        String mediaTrayValue = "auto_select";
        if (printJobConfig.getPrintRequestAttributeSet().get(SunAlternateMedia.class) != null) {
            SunAlternateMedia mediaTray = (SunAlternateMedia)printJobConfig.getPrintRequestAttributeSet().get(SunAlternateMedia.class);
            mediaTrayValue = mediaTray.getMedia().toString();
        }
        info.setMediaTray(mediaTrayValue);
        ZoomScaleInfo zsi = (ZoomScaleInfo)printJobConfig.getPrintRequestAttributeSet().get(ZoomScaleInfo.class);
        if (zsi == null) {
            info.setScale(1.0);
        } else {
            info.setScale(zsi.getScale());
        }
    }

    private static void changePaperSetting(PrintJobConfig printJobConfig, SmartAccountingVoucherFilePaperPringConfig.PaperInfo info) {
        block11: {
            if (info.isCustomPaper()) {
                float width = info.getPaperWidth();
                float height = info.getPaperHeight();
                MediaSizeNameExtend media = MediaSizeNameExtend.CUSTOM;
                MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
                if (ms == null) {
                    new FreeMediaSize(width, height, 1000, (MediaSizeName)media);
                } else if (ms instanceof FreeMediaSize) {
                    ((FreeMediaSize)ms).setXY(width, height, 1000);
                }
                printJobConfig.addAttribute((Attribute)media);
            } else {
                MediaSizeName msn = KDPrinterUtils.getMediaSizeName((String)info.getPaperName());
                printJobConfig.addAttribute((Attribute)msn);
            }
            Object mediaTrays = null;
            try {
                mediaTrays = printJobConfig.getPrinter().getPrintService().getSupportedAttributeValues(Media.class, null, null);
                if (mediaTrays == null || !(mediaTrays instanceof Media[])) break block11;
                MediaTray mt = MediaTray.LARGE_CAPACITY;
                Media[] temp = (Media[])mediaTrays;
                for (int i = 0; i < temp.length; ++i) {
                    Media medium = temp[i];
                    if (!(medium instanceof MediaTray) || !medium.toString().equals(info.getMediaTray())) continue;
                    mt = (MediaTray)medium;
                    printJobConfig.addAttribute((Attribute)new SunAlternateMedia(mt));
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (info.isLandscape()) {
            printJobConfig.addAttribute((Attribute)OrientationRequested.LANDSCAPE);
        } else if (info.isPortrait()) {
            printJobConfig.addAttribute((Attribute)OrientationRequested.PORTRAIT);
        }
        printJobConfig.addAttribute((Attribute)new ZoomScaleInfo(info.getScale()));
    }

    public void configChanged() {
    }

    public void configWillChange() {
    }

    public void configOver() {
        if (!this._enabled) {
            return;
        }
        if (!this.isEnvironmentOk()) {
            return;
        }
        String pName = this.getPrinterName();
        if (pName == null) {
            return;
        }
        this.savePriterConfig();
        this.savePaperSettingConfig();
    }

    private void savePriterConfig() {
        Map content = this.locationModel.getStartContent();
        for (String key : content.keySet()) {
            float[] offset = (float[])content.get(key);
            key = SmartAccoutingVoucherFileNotePrintConfig.createKey(this._currentTemplatePath, key);
            this.getConfig().setPrinterOffset(key, offset[0], offset[1]);
        }
        this.getConfig().save(this._localStorage);
    }

    private void savePaperSettingConfig() {
        String key = this._currentTemplatePath;
        boolean dirty = false;
        SmartAccountingVoucherFilePaperPringConfig.PaperInfo printerPaperInfo = new SmartAccountingVoucherFilePaperPringConfig.PaperInfo();
        SmartAccountingVoucherFilePringConfigChange.keepPaperSetting(this._printer.getPrintConfig().getJobsConfigs()[0], printerPaperInfo);
        if (printerPaperInfo.infoEquals(this._templatePaperInfo)) {
            if (this.getPaperConfig().contains(key)) {
                this.getPaperConfig().removeInfo(key);
                dirty = true;
            }
        } else if (!printerPaperInfo.infoEquals(this._oriPaperInfo)) {
            this.getPaperConfig().setInfo(key, printerPaperInfo);
            dirty = true;
        }
        if (dirty) {
            this.getPaperConfig().save(this._localStorage);
        }
    }

    private String getPrinterName() {
        try {
            return this._printer.getPrintConfig().getPrintService().getName();
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u5f53\u524d\u6253\u5370\u673a\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void setHandlerEnabled(boolean enabled) {
        this._enabled = enabled;
    }
}

