/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.base.wssc.image.pojo.BillImageInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.FileState;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherFileRec;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherFileRecFactory;
import com.kingdee.eas.fi.gl.VoucherFileRecInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.vc.app.AbstractSmartAccountingProcess;
import com.kingdee.eas.fi.vc.app.SmartAccountingFileVoucherQueryDelegate;
import com.kingdee.eas.fi.vc.app.SmartAccountingVoucherFileKdNoteHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;

public class SmartAccountingVoucherFileRec
extends AbstractSmartAccountingProcess {
    private String resource = "com.kingdee.eas.fi.vc.VCResource";

    @Override
    public Map process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String flag = BOSUuid.create((String)"DDDDFFFF").toString();
        String reportID = paramMap.get("reportID").toString();
        result.put("error", "");
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(paramMap.get("userID").toString()));
        String filterSql = paramMap.get("filterSql") == null ? "" : paramMap.get("filterSql").toString();
        String companyID = paramMap.get("companyID").toString();
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isEmpty((String)filterSql)) {
            PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(null, (String)companyID);
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)currentPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        } else {
            String[] filterStr = filterSql.split(" and ");
            for (int i = 0; i < filterStr.length; ++i) {
                String name = filterStr[i].split("=")[0].trim();
                String value = filterStr[i].split("=")[1].trim();
                value = value.replaceAll("'", "");
                if (name.indexOf("bizDate") > -1) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date bizDate = new Date();
                    try {
                        bizDate = sdf.parse(value);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDate, CompareType.LESS_EQUALS));
                }
                if (name.indexOf("voucherType") > -1) {
                    filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)value));
                }
                if (name.indexOf("number") > -1) {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)value, CompareType.LESS_EQUALS));
                }
                if (name.indexOf("creator") <= -1) continue;
                filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)value));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5));
        filter.getFilterItems().add(new FilterItemInfo("fileState", (Object)0));
        IVoucher voucherFactory = VoucherFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection voucherSelector = new SelectorItemCollection();
        voucherSelector.add("*");
        voucherSelector.add("company.id");
        voucherSelector.add("company.name");
        voucherSelector.add("company.number");
        voucherSelector.add("period.number");
        voucherSelector.add("voucherType.name");
        VoucherCollection vhColl = voucherFactory.getVoucherCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)voucherSelector, null));
        VoucherFileRecInfo recInfo = null;
        CoreBaseCollection coll = new CoreBaseCollection();
        ArrayList<BillImageInfo> billImageList = new ArrayList<BillImageInfo>();
        IVoucherFileRec fileRecFac = VoucherFileRecFactory.getLocalInstance((Context)ctx);
        IBillImageFacade billImgFac = BillImageFacadeFactory.getLocalInstance((Context)ctx);
        SmartAccountingVoucherFileKdNoteHelper webServerHelper = this.getKDNoteWebServerHelper(ctx);
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        String directory = System.getProperty("eas.properties.dir");
        File file = new File(directory + "/voucherFilePicTemp");
        if (!file.exists() && !file.isDirectory()) {
            file.mkdir();
        } else {
            File[] files = file.listFiles();
            if (files.length > 100) {
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
        }
        try {
            if (vhColl != null) {
                int n = vhColl.size();
                for (int m = 0; m < n; ++m) {
                    VoucherInfo voucherInfo = vhColl.get(m);
                    if (FileState.FILED.equals((Object)voucherInfo.getFileState())) {
                        errorMsg = MessageFormat.format(EASResource.getString((String)this.resource, (String)"voucherFileRecd"), voucherInfo.getNumber());
                        ++failure;
                    } else if (FileState.FILING.equals((Object)voucherInfo.getFileState())) {
                        HashSet<String> idSet = new HashSet<String>();
                        idSet.add(voucherInfo.getId().toString());
                        this.voucherImageCancelFile(ctx, idSet, true);
                    }
                    ArrayList<String> voucherQueryIds = new ArrayList<String>();
                    voucherQueryIds.add(voucherInfo.getId().toString());
                    SmartAccountingFileVoucherQueryDelegate queryDelegate = new SmartAccountingFileVoucherQueryDelegate(ctx, voucherQueryIds);
                    List<BufferedImage> buffImgList = webServerHelper.outBufferedImg(ctx, "/FI/GL/Voucher/yx_vch_print.r1-print", queryDelegate);
                    if (buffImgList == null || buffImgList.size() == 0) {
                        errorMsg = MessageFormat.format(EASResource.getString((String)this.resource, (String)"voucherFileRecErr"), voucherInfo.getNumber());
                        ++failure;
                    }
                    if (errorMsg.length() == 0) {
                        BillImageInfo info = new BillImageInfo();
                        info.setBillId(voucherInfo.getId().toString());
                        info.setImageCount(buffImgList.size());
                        HashMap<String, String> model = new HashMap<String, String>();
                        model.put("companyNumber", voucherInfo.getCompany().getNumber());
                        model.put("voucherbr", voucherInfo.getCompany().getName());
                        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd");
                        model.put("voucherDate", dateFmt.format(voucherInfo.getBookedDate()));
                        model.put("periodNumber", dateFmt.format(voucherInfo.getBookedDate()));
                        model.put("voucherType", voucherInfo.getVoucherType().getName());
                        model.put("totalAmount", voucherInfo.getLocalCreditAmount().toString());
                        String displayDate = new SimpleDateFormat("yyyy-MM-dd").format(voucherInfo.getBookedDate());
                        model.put("Year", displayDate.substring(0, 4));
                        model.put("Month", displayDate.substring(5, 7));
                        model.put("Day", displayDate.substring(8, 10));
                        model.put("VoucherNo", voucherInfo.getNumber());
                        info.setModel(model);
                        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                        int imgSize = 0;
                        FileOutputStream fileOut = null;
                        int j = buffImgList.size();
                        for (int i = 0; i < j; ++i) {
                            BufferedImage buffImg = buffImgList.get(i);
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            try {
                                boolean suc = ImageIO.write((RenderedImage)buffImg, "jpg", out);
                                fileOut = new FileOutputStream(new File(file, voucherInfo.getCompany().getName() + "_" + displayDate + "_" + voucherInfo.getNumber() + "_sn" + i + ".jpg"));
                            }
                            catch (IOException e) {
                                throw new BOSException(e.getMessage());
                            }
                            byte[] bs = out.toByteArray();
                            try {
                                fileOut.write(bs);
                                fileOut.flush();
                                fileOut.close();
                            }
                            catch (IOException e) {
                                throw new BOSException(e.getMessage());
                            }
                            imgSize += bs.length;
                            StringBuffer numSeq = new StringBuffer();
                            numSeq.append(voucherInfo.getCompany().getNumber());
                            numSeq.append("-");
                            numSeq.append(new SimpleDateFormat("yyyy-MM-dd").format(voucherInfo.getBookedDate()));
                            numSeq.append("-");
                            numSeq.append(i + 1);
                            map.put(numSeq.toString(), bs);
                        }
                        info.setBillImageSize(imgSize);
                        info.setImageMap(map);
                        billImageList.add(info);
                        recInfo = new VoucherFileRecInfo();
                        recInfo.setCompany(voucherInfo.getCompany());
                        recInfo.setVoucher(voucherInfo);
                        recInfo.setVoucherImg(false);
                        recInfo.setAttachmentImg(false);
                        recInfo.setCreator(user);
                        recInfo.setNumber(flag);
                        recInfo.setBizDate(new Date());
                        recInfo.setCreateTime(new Timestamp(recInfo.getBizDate().getTime()));
                        recInfo.setReportID(reportID);
                        recInfo.setState(1);
                        coll.add((CoreBaseInfo)recInfo);
                        if (m > 0 && m % 100 == 0) {
                            billImgFac.saveBillImages(billImageList);
                            billImageList.clear();
                            fileRecFac.addnewBatchData(coll);
                            coll.clear();
                        }
                        voucherInfo.setFileState(FileState.FILING);
                        voucherFactory.update((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), (CoreBaseInfo)voucherInfo);
                        ++success;
                        continue;
                    }
                    recInfo = new VoucherFileRecInfo();
                    recInfo.setCompany(voucherInfo.getCompany());
                    recInfo.setVoucher(voucherInfo);
                    recInfo.setVoucherImg(false);
                    recInfo.setAttachmentImg(false);
                    recInfo.setCreator(user);
                    recInfo.setNumber(flag);
                    recInfo.setBizDate(new Date());
                    recInfo.setCreateTime(new Timestamp(recInfo.getBizDate().getTime()));
                    recInfo.setReportID(reportID);
                    recInfo.setState(0);
                    recInfo.setExceptionMsg(errorMsg);
                    coll.add((CoreBaseInfo)recInfo);
                    if (m <= 0 || m % 100 != 0) continue;
                    billImgFac.saveBillImages(billImageList);
                    billImageList.clear();
                    fileRecFac.addnewBatchData(coll);
                    coll.clear();
                }
            } else {
                errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)"noBillOrSource", (Locale)ctx.getOriginLocale());
                result.put("error", errorMsg);
            }
            billImgFac.saveBillImages(billImageList);
            fileRecFac.addnewBatchData(coll);
        }
        catch (BOSException e) {
            int n = vhColl.size();
            for (int m = 0; m < n; ++m) {
                VoucherInfo voucherInfo = vhColl.get(m);
                voucherInfo.setFileState(FileState.NOTFILED);
                voucherFactory.update((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), (CoreBaseInfo)voucherInfo);
            }
            success = 0;
            failure = vhColl.size();
            errorMsg = e.getMessage();
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("failure", failure);
        return result;
    }

    @Override
    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK, PeriodInfo periodInfo) throws BOSException, EASBizException {
        ArrayList ids = new ArrayList();
        HashMap<String, String> tt = new HashMap<String, String>();
        tt.put("id", "aaaaaaaaaa");
        tt.put("number", "bbbbbbbbb");
        ids.add(tt);
        return ids;
    }

    private Map voucherImageCancelFile(Context ctx, Set idSet, boolean ignoreFiling) throws BOSException, EASBizException {
        StringBuffer error = new StringBuffer();
        int success = 0;
        int failure = 0;
        HashSet<String> companyPermSet = new HashSet<String>();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        VoucherCollection voucherColl = VoucherFactory.getRemoteInstance().getVoucherCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
        int j = voucherColl.size();
        for (int i = 0; i < j; ++i) {
            VoucherInfo voucherInfo = voucherColl.get(i);
            if (!companyPermSet.contains(voucherInfo.getCompany().getId().toString())) {
                PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()), "multiorg_gl_voucherfile02_cancelfile");
                companyPermSet.add(voucherInfo.getCompany().getId().toString());
            }
            if (FileState.NOTFILED.equals((Object)voucherInfo.getFileState())) {
                error.append(MessageFormat.format(EASResource.getString((String)this.resource, (String)"voucherFileRecFail"), voucherInfo.getNumber())).append("\r\n");
                idSet.remove(voucherInfo.getId().toString());
                ++failure;
                continue;
            }
            if (!FileState.FILING.equals((Object)voucherInfo.getFileState()) || ignoreFiling) continue;
            error.append(MessageFormat.format(EASResource.getString((String)this.resource, (String)"voucherIsFileRecing"), voucherInfo.getNumber())).append("\r\n");
            idSet.remove(voucherInfo.getId().toString());
            ++failure;
        }
        success = voucherColl.size() - failure;
        FilterInfo mapFilter = new FilterInfo();
        mapFilter.getFilterItems().add(new FilterItemInfo("billID", (Object)idSet, CompareType.INCLUDE));
        IBillImageFacade billImgFac = BillImageFacadeFactory.getRemoteInstance();
        BillImageMapCollection imgMapColl = BillImageMapFactory.getRemoteInstance().getBillImageMapCollection(EntityViewInfo.getInstance((FilterInfo)mapFilter, null, null));
        int j2 = imgMapColl.size();
        for (int i = 0; i < j2; ++i) {
            BillImageMapInfo mapInfo = imgMapColl.get(i);
            billImgFac.deleteBillImage(mapInfo.getImageNumber(), "3", user.getNumber(), "voucherCancelImage");
            DbUtil.execute((Context)ctx, (String)"update t_gl_voucher set ffileState=? where fid=?", (Object[])new Object[]{0, mapInfo.getBillID()});
            DbUtil.execute((Context)ctx, (String)"delete from t_gl_voucherfilerec where fvoucherid=?", (Object[])new Object[]{mapInfo.getBillID()});
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("error", error.toString());
        ret.put("success", success);
        ret.put("failure", failure);
        return ret;
    }

    private String _file(Context ctx, String[] companyids) throws BOSException, EASBizException {
        String flag = BOSUuid.create((String)"DDDDFFFF").toString();
        for (String cpid : companyids) {
            PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(null, (String)cpid);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)currentPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)cpid));
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5));
            filter.getFilterItems().add(new FilterItemInfo("fileState", (Object)0));
        }
        return flag;
    }

    private String _file(Context ctx, String[] companyids, Date date, String voucherTypeId, String voucherNumber, String creatorId) throws BOSException, EASBizException {
        String flag = BOSUuid.create((String)"DDDDFFFF").toString();
        int j = companyids.length;
        for (int i = 0; i < j; ++i) {
            FilterInfo filter = new FilterInfo();
            if (date != null) {
                filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)date, CompareType.LESS_EQUALS));
            }
            if (voucherTypeId != null) {
                filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
            }
            if (voucherNumber != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)voucherNumber, CompareType.LESS_EQUALS));
            }
            if (creatorId != null) {
                filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)creatorId));
            }
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5));
            filter.getFilterItems().add(new FilterItemInfo("fileState", (Object)0));
        }
        return flag;
    }

    public SmartAccountingVoucherFileKdNoteHelper getKDNoteWebServerHelper(Context ctx) {
        IBizContext bizContext;
        SmartAccountingVoucherFileKdNoteHelper webServerHelper = (SmartAccountingVoucherFileKdNoteHelper)ctx.get((Object)"node_server");
        if (webServerHelper == null && (bizContext = this.getBizContext(ctx)) != null) {
            webServerHelper = (SmartAccountingVoucherFileKdNoteHelper)ctx.get((Object)"node_Server");
        }
        return webServerHelper;
    }

    public IBizContext getBizContext(Context ctx) {
        IBizContext biaContext = (IBizContext)ctx.get((Object)"rpt_ctx");
        if (biaContext != null) {
            return biaContext;
        }
        try {
            SmartAccountingVoucherFileKdNoteHelper nodeWeb = new SmartAccountingVoucherFileKdNoteHelper();
            nodeWeb.setBosContext(ctx);
            nodeWeb.setContextProvider(new IContextProvider(){

                public IBizContext getBizContext(Context bosCtx) {
                    IBizContext ctx = (IBizContext)bosCtx.get((Object)"rpt_ctx");
                    if (ctx != null) {
                        return ctx;
                    }
                    try {
                        ctx = KDNoteHelper.makeContext((Context)bosCtx);
                        bosCtx.put((Object)"rpt_ctx", (Object)ctx);
                    }
                    catch (ConnectException e) {
                        return null;
                    }
                    return ctx;
                }
            });
            ctx.put((Object)"node_Server", (Object)nodeWeb);
            return nodeWeb.getThisBizContext();
        }
        catch (Exception e) {
            return null;
        }
    }
}

