/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.FilterTypeEnum;
import com.kingdee.eas.fi.vc.UnVoucheredFilterInfo;
import com.kingdee.eas.fi.vc.app.AbstractUnVoucheredFilterControllerBean;
import com.kingdee.eas.fi.vc.app.VoucherCenterException;
import org.apache.log4j.Logger;

public class UnVoucheredFilterControllerBean
extends AbstractUnVoucheredFilterControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.UnVoucheredFilterControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UnVoucheredFilterInfo info = (UnVoucheredFilterInfo)model;
        if (info.getUser() == null || info.getUser().getId() == null) {
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            info.setUser(user);
        }
        this.checkFilter(ctx, info);
        return super._save(ctx, model);
    }

    private void checkFilter(Context ctx, UnVoucheredFilterInfo info) throws BOSException, EASBizException {
        if (info.getCompany() == null || info.getCompany().getId() == null || info.getSubSystem() == null || info.getBillType() == null || info.getBillType().getId() == null || info.getFilterType() == null) {
            throw new VoucherCenterException(VoucherCenterException.BFS_CHECKEMPTY);
        }
        if (info.getFilterType().equals((Object)FilterTypeEnum.VOUCHERED_PART) && (info.getFilter() == null || info.getFilter().trim().length() == 0 || info.getFilter().trim().equals("()"))) {
            throw new VoucherCenterException(VoucherCenterException.BFS_CHECKFILTER);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)new Integer(info.getSubSystem().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)info.getBillType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)info.getUser().getId().toString()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            throw new VoucherCenterException(VoucherCenterException.BFS_CHECKDUPLICATE);
        }
    }
}

