/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeCollection;
import com.kingdee.eas.fi.vc.BillTypeFactory;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.FilterTypeEnum;
import com.kingdee.eas.fi.vc.UnVoucheredFilterCollection;
import com.kingdee.eas.fi.vc.UnVoucheredFilterFactory;
import com.kingdee.eas.fi.vc.UnVoucheredFilterInfo;
import com.kingdee.eas.fi.vc.app.AbstractVoucherCenterFacadeControllerBean;
import com.kingdee.eas.fi.vc.app.IVCUnVoucheredBillID;
import com.kingdee.eas.fi.vc.app.VCVoucheredCount;
import com.kingdee.eas.fi.vc.app.dap.BaseRecorder;
import com.kingdee.eas.fi.vc.app.dap.DAPTransmitRecorder;
import com.kingdee.eas.fi.vc.app.dap.DAPTransmitRecorderForBillsAndRules;
import com.kingdee.eas.fi.vc.app.dap.NoRuleRecorder;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherCenterFacadeControllerBean
extends AbstractVoucherCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.VoucherCenterFacadeControllerBean");
    protected static final String VOUCHERTYPE = "2652E01E";
    public static final String VOUCHER_SUCCEED = "voucherSucceed";
    public static final String VOUCHER_FAILED = "voucherFailed";

    @Override
    protected int _getVoucheredCount(Context ctx, String companyId, String periodId, int subSystemValue) throws BOSException, EASBizException {
        int result = 0;
        try {
            result = new VCVoucheredCount().getVCVouveredCount(ctx, companyId, periodId, subSystemValue);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected List<Map> _getUnVoucheredCount(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, int subSystemValue) throws BOSException, EASBizException {
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(companyInfo.getId());
        ArrayList<Map> result = new ArrayList<Map>();
        if (this.isNeedRalteAccount(ctx, subSystemValue) && !SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.getEnum((int)subSystemValue), (CompanyOrgUnitInfo)companyInfo)) {
            return result;
        }
        BillTypeCollection billTypeCollection = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection(subSystemValue);
        Iterator it = billTypeCollection.iterator();
        while (it.hasNext()) {
            StringBuffer sql;
            boolean hasFunctionPermission;
            BillTypeInfo billTypeInfo = (BillTypeInfo)it.next();
            String bosType = billTypeInfo.getBosObjectType();
            String queryPK = billTypeInfo.getQueryPK();
            String permissionItem = billTypeInfo.getPermissionItem();
            if (!StringUtils.isEmpty((String)permissionItem) && !(hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem)) || (sql = this.getUnVoucheredCountSql(ctx, companyInfo, periodInfo, queryPK, bosType, subSystemValue)) == null || sql.length() == 0) continue;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int rowCount = 0;
            try {
                while (rowSet.next()) {
                    rowCount = rowSet.getInt("count");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            if (rowCount == 0) continue;
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("company", companyInfo);
            itemMap.put("bill", billTypeInfo);
            itemMap.put("count", rowCount);
            result.add(itemMap);
        }
        return result;
    }

    private boolean isNeedRalteAccount(Context ctx, int subSystem) throws BOSException {
        String sql = "select 1 from T_VC_SubSystem where FSubSystem = ? and FNeedRalteAccount = 1";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{subSystem});
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private StringBuffer getUnVoucheredCountSql(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, String queryPK, String bosType, int subSystemValue) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        UnVoucheredFilterInfo unVoucheredFilterInfo = this.getUnVoucheredFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
        String filterByUser = "";
        if (unVoucheredFilterInfo != null) {
            filterByUser = unVoucheredFilterInfo.getFilter();
            if (unVoucheredFilterInfo.getFilterType() == FilterTypeEnum.VOUCHERED_NONE) {
                filterByUser = "id is null";
            }
        }
        if (StringUtils.isEmpty((String)filterByUser)) {
            String className = this.getImplementClass(ctx, bosType, subSystemValue);
            if (className == null || "".equals(className)) {
                return null;
            }
            String billIDFilter = "";
            try {
                billIDFilter = ((IVCUnVoucheredBillID)Class.forName(className).newInstance()).getUnVoucheredBillID(ctx, companyInfo, periodInfo);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            if (StringUtils.isEmpty((String)billIDFilter)) {
                return null;
            }
            sqlBuf.append(" select count(1) as count from( select distinct fid from (").append(billIDFilter).append(") as temp ) as tmp ");
        } else {
            String filter = this._getUnVoucheredBillFilter(ctx, companyInfo, periodInfo, bosType, subSystemValue);
            if (StringUtils.isEmpty((String)filter)) {
                return null;
            }
            String oql = "select id where " + filter;
            logger.info((Object)oql);
            IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
            IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, oql);
            String sql = iexec.getSQL();
            int distinctIndex = sql.indexOf("DISTINCT");
            int fromIndex = sql.indexOf("FROM");
            if (distinctIndex < 0 || distinctIndex > fromIndex) {
                sql = sql.replaceFirst("SELECT", "SELECT DISTINCT");
            }
            sqlBuf.append(" select count(1) as count from (").append(sql).append(") as tmp ");
        }
        return sqlBuf;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, IMetaDataPK queryPK, String oql) throws BOSException {
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(oql);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        return exec;
    }

    @Override
    protected String _getUnVoucheredBillFilter(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, String bosType, int subSystemValue) throws BOSException, EASBizException {
        UnVoucheredFilterInfo unVoucheredFilterInfo;
        String className = this.getImplementClass(ctx, bosType, subSystemValue);
        if (className == null || "".equals(className)) {
            return null;
        }
        String billIDFilter = "";
        try {
            billIDFilter = ((IVCUnVoucheredBillID)Class.forName(className).newInstance()).getUnVoucheredBillID(ctx, companyInfo, periodInfo);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        String filterByUser = "";
        if (BOSObjectFactory.getContextFromThread() != null && BOSObjectFactory.getContextFromThread().get((Object)"isBackTask") != null && ctx.get((Object)"isSmartAccounting") != null) {
            if (subSystemValue == 2) {
                unVoucheredFilterInfo = this.getUnVoucheredFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
                if (BOSObjectFactory.getContextFromThread().get((Object)"filter") != null) {
                    filterByUser = BOSObjectFactory.getContextFromThread().get((Object)"filter").toString();
                }
                String filterByUserUn = "";
                if (unVoucheredFilterInfo != null) {
                    logger.error((Object)("smartAccounting \u8bb0\u8d26\u4e2d\u5fc3\u65b9\u6848unVoucheredFilterInfo,filter:" + unVoucheredFilterInfo.getFilter()));
                    filterByUserUn = unVoucheredFilterInfo.getFilter();
                    if (unVoucheredFilterInfo.getFilterType() == FilterTypeEnum.VOUCHERED_NONE) {
                        filterByUserUn = "id is null";
                    }
                    filterByUser = filterByUser.length() == 0 ? filterByUserUn : " ( " + filterByUser + " ) and ( " + filterByUserUn + " ) ";
                    logger.error((Object)("smartAccounting \u8bb0\u8d26\u4e2d\u5fc3\u65b9\u6848unVoucheredFilterInfo,filterByUser:" + filterByUser));
                }
            } else if (BOSObjectFactory.getContextFromThread().get((Object)"filter") != null) {
                filterByUser = BOSObjectFactory.getContextFromThread().get((Object)"filter").toString();
            }
        } else {
            unVoucheredFilterInfo = this.getUnVoucheredFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
            if (unVoucheredFilterInfo != null) {
                filterByUser = unVoucheredFilterInfo.getFilter();
                if (unVoucheredFilterInfo.getFilterType() == FilterTypeEnum.VOUCHERED_NONE) {
                    filterByUser = "id is null";
                }
            }
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterByUser != null && !"".equals(filterByUser)) {
                result.append(" and ( ").append(filterByUser).append(" )");
            }
        } else {
            result.append(filterByUser);
        }
        logger.error((Object)("smartAccounting getUnVoucheredBillFilter,resultSql:" + result));
        return result.toString();
    }

    private String getImplementClass(Context ctx, String bosType, int subSystemValue) throws BOSException {
        String sql = "select FClassName from T_VC_UnVoucheredBillID where FBOSObjectType = ? and FSubSystem = ? ";
        String className = "";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bosType, subSystemValue});
            while (rowSet.next()) {
                className = rowSet.getString("FClassName");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return className;
    }

    private UnVoucheredFilterInfo getUnVoucheredFilterInfo(Context ctx, String companyId, String bosType, int subSystemValue) throws BOSException {
        UnVoucheredFilterInfo unVoucheredFilterInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("filterType"));
        selector.add(new SelectorItemInfo("filter"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType.bosObjectType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)subSystemValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        UnVoucheredFilterCollection coll = UnVoucheredFilterFactory.getLocalInstance(ctx).getUnVoucheredFilterCollection(view);
        if (coll.size() > 0) {
            unVoucheredFilterInfo = coll.get(0);
        }
        return unVoucheredFilterInfo;
    }

    @Override
    protected void _voucher(Context ctx, String companyId, String bosType, int subSystem, String[] billIds, String[] botpRuleId, String type) throws BOSException, EASBizException {
        String sql = "select FIsSupportMultiBotp from t_vc_billtype where FSUBSYSTEM=? and FBOSOBJECTTYPE = ?";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{subSystem, bosType});
        boolean isSupportMultiBotp = false;
        try {
            if (result.next()) {
                int value = result.getInt(1);
                isSupportMultiBotp = value == 1;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query billtype FIsSupportMultiBotp error", (Throwable)e);
        }
        this.voucher(ctx, companyId, bosType, subSystem, billIds, botpRuleId, type, isSupportMultiBotp);
    }

    @Override
    protected void _voucher(Context ctx, String companyId, String bosType, int subSystem, String[] billIds, String[] botpRuleId, String type, boolean isSupportMultiBotp) throws BOSException, EASBizException {
        BOTMappingCollection dapRulesSelected = null;
        dapRulesSelected = (BOTMappingCollection)this._getRulesByCompanyAndBOSType(ctx, companyId, bosType, type);
        boolean isRuleEmpty = false;
        boolean bl = isRuleEmpty = botpRuleId != null && botpRuleId.length == 1 && "".equals(botpRuleId[0]);
        if (botpRuleId != null && botpRuleId.length > 0 && !isRuleEmpty) {
            BOTMappingCollection dapRulesSelectedNew = new BOTMappingCollection();
            block0: for (int i = 0; i < botpRuleId.length; ++i) {
                for (int j = 0; j < dapRulesSelected.size(); ++j) {
                    if (!dapRulesSelected.get(j).getId().toString().equals(botpRuleId[i])) continue;
                    dapRulesSelectedNew.add(dapRulesSelected.get(j));
                    continue block0;
                }
            }
            dapRulesSelected = dapRulesSelectedNew;
        }
        if (dapRulesSelected == null || dapRulesSelected.size() == 0) {
            logger.error((Object)"\u751f\u6210\u51ed\u8bc1\uff0c\u83b7\u53d6\u5230\u7684dap\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bb0\u5f55\u65e0dap\u89c4\u5219\u65e5\u5fd7");
            NoRuleRecorder recorder = new NoRuleRecorder(companyId, ctx, billIds);
            recorder.record(ctx, bosType, subSystem);
        } else {
            String[] entrysName = new String[]{VcDapUtil.getBillMainEntryName(bosType)};
            CoreBillBaseCollection sourceBillCollection = VcDapUtil.getSrcCollectionByIds(ctx, billIds, null);
            List entriesKeys = VcDapUtil.getSelectEntryIDs(sourceBillCollection, entrysName[0]);
            DAPTransmitRecorderForBillsAndRules recorder = VcDapUtil.checkBotMapping(ctx, companyId, billIds, entrysName, entriesKeys, dapRulesSelected);
            recorder.setBotCol(dapRulesSelected);
            recorder.generateVoucher(ctx, bosType, subSystem, type, isSupportMultiBotp);
        }
    }

    private BOTMappingCollection getDapRulesSelected(Context ctx, String[] botpRuleId) throws BOSException, EASBizException {
        BOTMappingCollection dapRulesSelected = new BOTMappingCollection();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("name");
        sic.add("alias");
        sic.add("srcEntityName");
        sic.add("destEntityName");
        sic.add("description");
        sic.add("defineSys");
        sic.add("lastUpdateTime");
        sic.add("isTempSave");
        sic.add("isShowEditUI");
        sic.add("extConfig");
        sic.add("mappingType");
        sic.add("extRule.id");
        sic.add("extRule.filter");
        sic.add("extRule.dataFilter");
        sic.add("extRule.isEffected");
        sic.add("extRule.org.id");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtils.arrayToString((Object[])botpRuleId, (String)","), CompareType.INCLUDE));
        evi.setFilter(fi);
        dapRulesSelected = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(evi);
        return dapRulesSelected;
    }

    @Override
    protected void _voucherSingle(Context ctx, String companyId, List list) throws BOSException, EASBizException {
        DAPTransmitRecorder recorder = new DAPTransmitRecorder(companyId, ctx);
        recorder.generateVoucher(ctx, list);
    }

    @Override
    protected int _getVoucheredBillCount(Context ctx, String companyId, String bosType, int subSystemValue) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer buf = new StringBuffer().append("select count(1) as voucherCount from t_vc_VoucherReport where ").append("fCompanyId = '").append(companyId).append("'").append(" and fUserId = '").append(userId).append("'").append(" and fBillTypeId = (").append("select fid from t_vc_billType where ").append("FBOSObjectType = '").append(bosType).append("'").append(" and FSubSystem = ").append(subSystemValue).append(")").append(" and fVoucherState = 0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        int count = 0;
        try {
            while (rs.next()) {
                count = rs.getInt("voucherCount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return count;
    }

    @Override
    protected IObjectCollection _getRulesByCompanyAndBOSType(Context ctx, String companyId, String bosType, String desType) throws BOSException, EASBizException {
        String badDeptBosType = null;
        if (bosType.equals("C9C8D8AF")) {
            badDeptBosType = bosType;
            bosType = "3C41FD86";
        }
        String desBosType = VOUCHERTYPE;
        DefineSysEnum sysEnum = DefineSysEnum.DAP;
        if (desType != null && desType.equals("PCA")) {
            desBosType = "D6952559";
            sysEnum = DefineSysEnum.DAPPC;
        }
        BOTMappingCollection col = VcDapUtil.getDAPRulesBySrcAndDestType(ctx, bosType, desBosType, sysEnum, VcDapUtil.getTransmitContext(ctx, companyId));
        if (badDeptBosType != null) {
            for (int i = col.size() - 1; i >= 0; --i) {
                String viewStr;
                BOTMappingInfo mappingInfo = col.get(i);
                EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping((BOTMappingInfo)mappingInfo);
                if (view != null && ((viewStr = view.toString()).contains("verificationType = 111") || viewStr.contains("verificationType = 112"))) continue;
                col.removeObject(i);
            }
        }
        return col;
    }

    @Override
    protected void _voucherForNewTrans(Context ctx, BaseRecorder recorder) throws BOSException, EASBizException {
        recorder.generateVoucherCallbackByFacade();
    }
}

