/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.dap.IDAPTransformerWrapper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.IAfterImageStateUpdateHandler;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.vc.AbstractSmartAccountingDetailRPTInfo;
import com.kingdee.eas.fi.vc.AbstractVoucherReportInfo;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.BusinessTypeInfo;
import com.kingdee.eas.fi.vc.IVoucherCenterFacade;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTFactory;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailStateEnum;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaInfo;
import com.kingdee.eas.fi.vc.VoucherCenterFacadeFactory;
import com.kingdee.eas.fi.vc.VoucherReportFactory;
import com.kingdee.eas.fi.vc.VoucherReportInfo;
import com.kingdee.eas.fi.vc.VoucherStateEnum;
import com.kingdee.eas.fi.vc.app.SmartAccountingException;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class BaseRecorder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.dap.BaseRecorder");
    public static final String VOUCHER_SUCCEED = "voucherSucceed";
    public static final String VOUCHER_FAILED = "voucherFailed";
    private static int MAXGENERATEVOUCHERNUM = 5000;
    private static IVoucherCenterFacade facade = null;
    private int saftyNumber = 0;
    private static final int MAX_NUMBER = 50;
    private Context ctx = null;
    private OrgUnitInfo company = null;
    private CompanyOrgUnitInfo companyOrg = null;
    private String resource = "com.kingdee.eas.fi.vc.VCResource";
    private IObjectPK[] srcBillPKs = null;
    private String[] srcBillIds = null;
    private IObjectPK[] rulePKs = null;
    private ICoreBillBase icbb = null;
    private String status = null;
    private String desBosType = null;
    private VoucherCollection voucherCol = null;
    private PcVoucherCollection pcVoucherCol = null;
    private CoreBillBaseCollection billCol = null;
    private BTPTransformResult btpResult = null;
    private DAPTransformResult dapResult = null;
    private List dapResultList = null;
    private BOTRelationCollection botpCol = null;
    private String failMsg = null;
    private int subSystem = -1;
    private BillTypeInfo billType = null;
    private BusinessTypeInfo businessType = null;
    private Map maxBillNumberMap = null;
    private String voucherType = null;
    private boolean isUpdate = false;

    public BaseRecorder(Context ctx, String companyId) throws BOSException, EASBizException {
        OrgUnitInfo company;
        facade = VoucherCenterFacadeFactory.getLocalInstance(ctx);
        this.ctx = ctx;
        this.company = company = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select id where id='" + companyId + "'");
    }

    public BaseRecorder(Context ctx, String companyId, boolean isUpdate) throws BOSException, EASBizException {
        this(ctx, companyId);
        this.isUpdate = isUpdate;
    }

    public int getMaxBillNumber(Context ctx, int subSystem, String businessNumber, String operatorNumber) throws BOSException, EASBizException {
        Map result = new HashMap();
        int num = MAXGENERATEVOUCHERNUM;
        if (this.maxBillNumberMap != null) {
            result = this.maxBillNumberMap;
        } else {
            String sql = "select FSubSystem,FBusinessNumber,FOperatorNumber,FNumber from T_VC_VoucherBillNumber ";
            try {
                ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
                IRowSet rs = dataAccess.getRowSet(sql);
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    int subSystemValue = rs.getInt("FSubSystem");
                    String business = rs.getString("FBusinessNumber");
                    String operator = rs.getString("FOperatorNumber");
                    int number = rs.getInt("FNumber");
                    row.put("businessNumber", business);
                    row.put("operatorNumber", operator);
                    row.put("number", number);
                    result.put(subSystemValue, row);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException("getMaxBillNumberMap sql error:", (Throwable)e);
            }
        }
        if (result.get(subSystem) != null && businessNumber == null && operatorNumber == null) {
            num = (Integer)((Map)result.get(subSystem)).get("number");
        }
        return num;
    }

    public BaseRecorder transformBill(Context ctx, BaseRecorder recorder) {
        block6: {
            HashMap messageMap = new HashMap();
            try {
                this.srcBillPKs = recorder.srcBillPKs;
                this.srcBillIds = recorder.srcBillIds;
                this.desBosType = recorder.desBosType;
                this.rulePKs = recorder.rulePKs;
                this.billCol = VcDapUtil.getSrcCollectionByIds(ctx, this.srcBillIds, new String[]{"number", "bizDate"});
                this.btpResult = (BTPTransformResult)EJBTransactionProxy.invokeByManual((Object)recorder, (String)"transforBillForTranstation", (Class[])new Class[]{Context.class, IObjectPK[].class, String[].class, String.class, IObjectPK[].class, HashMap.class}, (Object[])new Object[]{ctx, this.srcBillPKs, this.srcBillIds, this.desBosType, this.rulePKs, messageMap}, (int)0);
                this.status = VOUCHER_SUCCEED;
            }
            catch (Exception e) {
                this.status = VOUCHER_FAILED;
                if (messageMap.get("message") != null) {
                    this.failMsg = (String)messageMap.get("message");
                }
                if (e instanceof BOSException && e.getCause() != null) {
                    this.failMsg = e.getCause().getMessage();
                    if (this.failMsg == null) {
                        this.failMsg = e.getMessage() == null ? EASResource.getString((String)this.resource, (String)"unhnownErr") : e.getMessage();
                    }
                } else {
                    this.failMsg = e.getMessage();
                }
                if (this.failMsg == null || this.failMsg.length() <= 1000) break block6;
                this.failMsg = this.failMsg.substring(0, 990) + "...";
            }
        }
        return this;
    }

    public BTPTransformResult transforBillForTranstation(Context ctx, IObjectPK[] srcBillPKs, String[] srcBillIds, String desBosType, IObjectPK[] rulePKs, HashMap message) throws BOSException, EASBizException, SmartAccountingException, BTPException {
        String srcBosType = VcDapUtil.getBOSTypeById(srcBillPKs[0].toString()).toString();
        Object[] entrieNames = VcDapUtil.getBillMainEntryNames(srcBosType).toArray(new String[0]);
        logger.error((Object)("smartacct entriesNames:" + Arrays.toString((Object[])entrieNames)));
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = null;
        try {
            if (srcBillPKs != null && srcBillPKs[0] != null && srcBillIds != null) {
                ArrayList<String> srcIdList = new ArrayList<String>();
                for (int i = 0; i < srcBillIds.length; ++i) {
                    if (srcBillIds[i] == null) continue;
                    srcIdList.add(srcBillIds[i].toString());
                }
                boolean isReBuild = this._checkRebuild(ctx, srcIdList, null, rulePKs[0].toString());
                if (!isReBuild) {
                    throw new SmartAccountingException(SmartAccountingException.BILLHASBUILDED);
                }
            }
            CoreBillBaseCollection srcBillCollection = iBOTMapping.getNewBillCollectionByType(srcBosType, srcBillIds, (String[])entrieNames, new ArrayList(), null);
            ArrayList entriesKeys = new ArrayList();
            for (int i = 0; i < entrieNames.length; ++i) {
                entriesKeys.addAll(VcDapUtil.getSelectEntryIDs(srcBillCollection, (String)entrieNames[i]));
            }
            IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(rulePKs[0], ctx);
            btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(srcBillIds, (String[])entrieNames, entriesKeys, BaseRecorder.getBOTPSelectors(mappingInfo), desBosType, rulePKs[0], mappingInfo.getSrcEntityName());
        }
        catch (Exception e) {
            if (e instanceof BOSException && e.getCause() != null) {
                this.failMsg = e.getCause().getMessage();
                if (this.failMsg == null) {
                    this.failMsg = e.getMessage() == null ? EASResource.getString((String)this.resource, (String)"unhnownErr") : e.getMessage();
                }
            } else {
                this.failMsg = e.getMessage();
            }
            if (this.failMsg != null && this.failMsg.length() > 1000) {
                this.failMsg = this.failMsg.substring(0, 990) + "...";
            }
            message.put("message", this.failMsg);
            throw new BOSException((Throwable)e);
        }
        return btpResult;
    }

    public void transformBill(IObjectPK[] srcBillPKs, String[] srcBillIds, String desBosType, IObjectPK[] rulePKs, int subSystem) throws BOSException, EASBizException {
        this.srcBillIds = srcBillIds;
        this.srcBillPKs = srcBillPKs;
        this.rulePKs = rulePKs;
        this.subSystem = subSystem;
        this.billCol = VcDapUtil.getSrcCollectionByIds(this.ctx, srcBillIds, new String[]{"number", "bizDate"});
        this.businessType = VcDapUtil.getBusinessTypeByNumber(this.ctx, VcDapUtil.getBOSTypeById(srcBillPKs[0].toString()).toString(), subSystem, desBosType);
        this.desBosType = desBosType;
        int maxNumber = this.getMaxBillNumber(this.ctx, subSystem, this.businessType.getNumber(), this.businessType.getOperator());
        BaseRecorder resRec = null;
        if (srcBillPKs.length > maxNumber) {
            Object[] newSrcBillPKs = BaseRecorder.splitAry(srcBillPKs, maxNumber);
            try {
                BaseRecorder implInstance = new BaseRecorder(this.ctx, this.company.getId().toString());
                for (int i = 0; i < newSrcBillPKs.length; ++i) {
                    this.srcBillPKs = (IObjectPK[])newSrcBillPKs[i];
                    resRec = (BaseRecorder)EJBTransactionProxy.invokeByManual((Object)implInstance, (String)"transformBill", (Class[])new Class[]{Context.class, BaseRecorder.class}, (Object[])new Object[]{this.ctx, this}, (int)3);
                    this.status = resRec.status;
                    this.btpResult = resRec.btpResult;
                    this.failMsg = resRec.failMsg;
                    this.recordDetailLog();
                }
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
        }
        try {
            BaseRecorder implInstance = new BaseRecorder(this.ctx, this.company.getId().toString());
            resRec = (BaseRecorder)EJBTransactionProxy.invokeByManual((Object)implInstance, (String)"transformBill", (Class[])new Class[]{Context.class, BaseRecorder.class}, (Object[])new Object[]{this.ctx, this}, (int)3);
            this.status = resRec.status;
            this.btpResult = resRec.btpResult;
            this.failMsg = resRec.failMsg;
            this.recordDetailLog();
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    public void generatePCVoucher(IObjectPK[] srcBillPKs, IObjectPK[] rulePKs, ICoreBillBase icbb, int subSystem) throws BOSException, EASBizException {
        this.srcBillPKs = srcBillPKs;
        this.rulePKs = rulePKs;
        this.icbb = icbb;
        this.subSystem = subSystem;
        this.businessType = VcDapUtil.getBusinessTypeByNumber(this.ctx, VcDapUtil.getBOSTypeById(srcBillPKs[0].toString()).toString(), subSystem, "scpcpz");
        this.voucherType = "PCA";
        int maxNumber = this.getMaxBillNumber(this.ctx, subSystem, this.businessType.getNumber(), this.businessType.getOperator());
        BaseRecorder resRec = null;
        if (srcBillPKs.length > maxNumber) {
            Object[] newSrcBillPKs = BaseRecorder.splitAry(srcBillPKs, maxNumber);
            try {
                BaseRecorder implInstance = new BaseRecorder(this.ctx, this.company.getId().toString());
                for (int i = 0; i < newSrcBillPKs.length; ++i) {
                    this.srcBillPKs = (IObjectPK[])newSrcBillPKs[i];
                    resRec = (BaseRecorder)EJBTransactionProxy.invokeByManual((Object)implInstance, (String)"generateVoucherByType", (Class[])new Class[]{Context.class, BaseRecorder.class}, (Object[])new Object[]{this.ctx, this}, (int)3);
                    this.status = resRec.status;
                    this.dapResult = resRec.dapResult;
                    this.failMsg = resRec.failMsg;
                    if (this.failMsg.length() == 0) {
                        this.pcVoucherCol = (PcVoucherCollection)this.dapResult.getVoucherCollection();
                    }
                    this.recordPC();
                }
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
        }
        try {
            BaseRecorder implInstance = new BaseRecorder(this.ctx, this.company.getId().toString());
            resRec = (BaseRecorder)EJBTransactionProxy.invokeByManual((Object)implInstance, (String)"generateVoucherByType", (Class[])new Class[]{Context.class, BaseRecorder.class}, (Object[])new Object[]{this.ctx, this}, (int)3);
            this.status = resRec.status;
            this.dapResult = resRec.dapResult;
            this.failMsg = resRec.failMsg;
            if (this.failMsg.length() == 0) {
                this.pcVoucherCol = (PcVoucherCollection)this.dapResult.getVoucherCollection();
            }
            this.recordPC();
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    public void generateVoucher(IObjectPK[] srcBillPKs, IObjectPK[] rulePKs, ICoreBillBase icbb, int subSystem) throws BOSException, EASBizException {
        this.srcBillPKs = srcBillPKs;
        this.rulePKs = rulePKs;
        this.icbb = icbb;
        this.subSystem = subSystem;
        this.billType = VcDapUtil.getBillTypeByBOSType(this.ctx, VcDapUtil.getBOSTypeById(srcBillPKs[0].toString()).toString(), subSystem);
        int maxNumber = this.getMaxBillNumber(this.ctx, subSystem, null, null);
        logger.error((Object)("\u5f00\u59cb\u6b63\u5f0f\u751f\u6210\u51ed\u8bc1 \u5355\u636ePK\u5217\u8868\uff0csrcBillPKs\uff1a" + srcBillPKs + ",\u89c4\u5219\u5217\u8868\uff0crulePKs\uff1a" + rulePKs));
        logger.error((Object)("\u5f00\u59cb\u6b63\u5f0f\u751f\u6210\u51ed\u8bc1 maxNumber\uff1a" + maxNumber));
        if (srcBillPKs.length > maxNumber) {
            Object[] newSrcBillPKs = BaseRecorder.splitAry(srcBillPKs, maxNumber);
            logger.error((Object)("\u5f00\u59cb\u6b63\u5f0f\u751f\u6210\u51ed\u8bc1\uff0c\u5355\u636e\u62c6\u5206\u6210\u591a\u4e2a\uff0c\u5171" + newSrcBillPKs.length + "\u4e2a\uff0c newSrcBillPKs\uff1a" + newSrcBillPKs));
            for (int i = 0; i < newSrcBillPKs.length; ++i) {
                this.srcBillPKs = (IObjectPK[])newSrcBillPKs[i];
                logger.error((Object)"\u751f\u6210\u51ed\u8bc1 facade.voucherForNewTrans");
                facade.voucherForNewTrans(this);
                logger.error((Object)"\u5f00\u59cb\u6b63\u5f0f\u751f\u6210\u51ed\u8bc1\uff0c\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\uff01");
                this.record();
            }
        } else {
            logger.error((Object)"\u751f\u6210\u51ed\u8bc1 facade.voucherForNewTrans");
            facade.voucherForNewTrans(this);
            logger.error((Object)"\u5f00\u59cb\u6b63\u5f0f\u751f\u6210\u51ed\u8bc1\uff0c\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\uff01");
            this.record();
        }
    }

    private static Object[] splitAry(IObjectPK[] ary, int subSize) {
        int count = ary.length % subSize == 0 ? ary.length / subSize : ary.length / subSize + 1;
        ArrayList subAryList = new ArrayList();
        for (int i = 0; i < count; ++i) {
            int index = i * subSize;
            ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
            for (int j = 0; j < subSize && index < ary.length; ++j) {
                list.add(ary[index++]);
            }
            subAryList.add(list);
        }
        Object[] subAry = new Object[subAryList.size()];
        for (int i = 0; i < subAryList.size(); ++i) {
            List subList = (List)subAryList.get(i);
            IObjectPK[] subAryItem = new IObjectPK[subList.size()];
            for (int j = 0; j < subList.size(); ++j) {
                subAryItem[j] = (IObjectPK)subList.get(j);
            }
            subAry[i] = subAryItem;
        }
        return subAry;
    }

    public void billTransformCallbackByFacade() {
        block5: {
            try {
                DAPTransformResult result = this.icbb.generateVoucher(this.srcBillPKs, this.rulePKs[0], null);
                this.status = VOUCHER_SUCCEED;
                this.voucherCol = (VoucherCollection)result.getVoucherCollection();
            }
            catch (Exception e) {
                this.status = VOUCHER_FAILED;
                if (e instanceof BOSException && e.getCause() != null) {
                    this.failMsg = e.getCause().getMessage();
                    if (this.failMsg == null) {
                        this.failMsg = e.getMessage() == null ? EASResource.getString((String)this.resource, (String)"unhnownErr") : e.getMessage();
                    }
                } else {
                    this.failMsg = e.getMessage();
                }
                if (this.failMsg.length() <= 1000) break block5;
                this.failMsg = this.failMsg.substring(0, 990) + "...";
            }
        }
    }

    public IDAPTransformerWrapper getDapWrapper(Context ctx) throws BOSException {
        IDAPTransformerWrapper wrapper = null;
        if (SPManager.isSPInstalled((String)"DAPServerProvider")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("DAPServerProvider");
            try {
                Constructor constructor = spInfo.getProviderClass().getConstructor(Context.class);
                Object dapWrapper = constructor.newInstance(ctx);
                return (IDAPTransformerWrapper)dapWrapper;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return wrapper;
    }

    private DAPTransformResult generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK[] botMappingPKs, String type) throws BOSException, EASBizException {
        IDAPTransformer wrapper = DAPTransformerFactory.getLocalInstance((Context)ctx);
        ctx.put((Object)"smartAccountingVoucher", (Object)true);
        if (wrapper != null) {
            DAPVoucherTypeEnum voucherType = null;
            if (type != null) {
                if (type.equals("GL")) {
                    voucherType = DAPVoucherTypeEnum.FIVoucher;
                } else if (type.equals("PCA")) {
                    voucherType = DAPVoucherTypeEnum.PCVoucher;
                } else if (type.equals("MA")) {
                    voucherType = DAPVoucherTypeEnum.MAVoucher;
                }
            } else {
                voucherType = DAPVoucherTypeEnum.FIVoucher;
            }
            if (botMappingPKs != null) {
                return wrapper.transform((CoreBillBaseCollection)sourceBillCollection, voucherType, botMappingPKs[0]);
            }
            return wrapper.transform((CoreBillBaseCollection)sourceBillCollection, voucherType);
        }
        return null;
    }

    protected boolean _checkRebuild(Context ctx, List srcBillIdList, List destBillIdList, String mappingId) throws BOSException, EASBizException {
        String destId;
        BOSObjectType destType;
        if (srcBillIdList == null || srcBillIdList.size() == 0 || StringUtils.isEmpty((String)mappingId)) {
            throw new BOSException("Invalid parameter! SrcBillIdList or mappingId is invalid!");
        }
        BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(mappingId, ctx);
        BOSObjectType destBosType = null;
        destBosType = mappingInfo.getDestEntity() == null ? BOSObjectType.create((String)mappingInfo.getDestEntityName()) : mappingInfo.getDestEntity().getBOSType();
        if (destBillIdList != null && destBillIdList.size() > 0 && !destBosType.equals((Object)(destType = BOSUuid.read((String)(destId = destBillIdList.get(0).toString())).getType()))) {
            throw new BOSException("Invalid parameter! DestBillId doesn't match the mappingInfo!");
        }
        String reBuildControl = "";
        String extconfig = mappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
        if (extconfig != null && !extconfig.equals("")) {
            try {
                info = processor.marshallingExtConfig(extconfig);
                reBuildControl = info.getReBuildControl();
                if (reBuildControl.equals("2") && this.hasReBuild(ctx, srcBillIdList, destBillIdList, destBosType.toString())) {
                    return false;
                }
            }
            catch (DocumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean hasReBuild(Context ctx, List idlist, List destList, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        if (destList != null && destList.size() > 0) {
            String destbillIds = StringUtils.arrayToString((Object[])destList.toArray(), (String)",");
            filterBill.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destbillIds, CompareType.NOTINCLUDE));
        }
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    private List mutiGenerateVoucher(Context ctx, List sourceBillCollection, IObjectPK[] botMappingPKs, String type) throws BOSException, EASBizException {
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        ctx.put((Object)"smartAccountingVoucher", (Object)true);
        if (wrapper != null) {
            DAPVoucherTypeEnum voucherType = null;
            if (type != null) {
                if (type.equals("GL")) {
                    voucherType = DAPVoucherTypeEnum.FIVoucher;
                } else if (type.equals("PCA")) {
                    voucherType = DAPVoucherTypeEnum.PCVoucher;
                } else if (type.equals("MA")) {
                    voucherType = DAPVoucherTypeEnum.MAVoucher;
                }
            } else {
                voucherType = DAPVoucherTypeEnum.FIVoucher;
            }
            if (botMappingPKs != null) {
                return wrapper.transform(sourceBillCollection, voucherType, botMappingPKs);
            }
        }
        return null;
    }

    public DAPTransformResult generateVoucherByType(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK[] botMappingPKs, SelectorItemCollection botpSelectors, String type) throws BOSException, EASBizException {
        if (botMappingPKs != null && botMappingPKs[0] != null && sourceBillPkList != null) {
            ArrayList<String> srcIdList = new ArrayList<String>();
            for (int i = 0; i < sourceBillPkList.length; ++i) {
                if (sourceBillPkList[i] == null) continue;
                srcIdList.add(sourceBillPkList[i].toString());
            }
            boolean isReBuild = this._checkRebuild(ctx, srcIdList, null, botMappingPKs[0].toString());
            if (!isReBuild) {
                throw new SmartAccountingException(SmartAccountingException.VOUCHERHASBUILDED);
            }
        }
        CoreBillBaseCollection allSourceBillCollection = new CoreBillBaseCollection();
        int total = sourceBillPkList.length;
        int step = 500;
        Object[] partSourceBillPkList = total < step ? new IObjectPK[total] : new IObjectPK[step];
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (botpSelectors != null) {
            entityViewInfo.put("selector", (Object)botpSelectors);
        }
        int i = 0;
        int j = 0;
        while (i < total) {
            partSourceBillPkList[j] = sourceBillPkList[i];
            if (j == step - 1 || i == total - 1) {
                FilterInfo filterInfo = new FilterInfo();
                StringBuffer sbMaskString = new StringBuffer();
                String strIdLists = StringUtils.arrayToString((Object[])partSourceBillPkList, (String)",");
                sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
                filterInfo.setMaskString(sbMaskString.toString());
                entityViewInfo.setFilter(filterInfo);
                CoreBillBaseCollection partSourceBillCollection = this.icbb.getCoreBillBaseCollection(entityViewInfo);
                allSourceBillCollection.addCollection(partSourceBillCollection);
                partSourceBillPkList = total - i - 1 > 0 && total - i - 1 < step ? new IObjectPK[total - i - 1] : new IObjectPK[step];
                j = -1;
            }
            ++i;
            ++j;
        }
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        for (int i2 = 0; i2 < sourceBillPkList.length; ++i2) {
            if (sourceBillPkList[i2] == null) continue;
            sourceBillCollection.add(allSourceBillCollection.get((Object)BOSUuid.read((String)sourceBillPkList[i2].toString())));
        }
        return this.generateVoucher(ctx, (IObjectCollection)sourceBillCollection, botMappingPKs, type);
    }

    public List generateMutiVoucherByType(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK[] botMappingPKs, SelectorItemCollection botpSelectors, String type) throws BOSException, EASBizException {
        CoreBillBaseCollection allSourceBillCollection = new CoreBillBaseCollection();
        int total = sourceBillPkList.length;
        int step = 500;
        Object[] partSourceBillPkList = total < step ? new IObjectPK[total] : new IObjectPK[step];
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (botpSelectors != null) {
            entityViewInfo.put("selector", (Object)botpSelectors);
        }
        int i = 0;
        int j = 0;
        while (i < total) {
            partSourceBillPkList[j] = sourceBillPkList[i];
            if (j == step - 1 || i == total - 1) {
                FilterInfo filterInfo = new FilterInfo();
                StringBuffer sbMaskString = new StringBuffer();
                String strIdLists = StringUtils.arrayToString((Object[])partSourceBillPkList, (String)",");
                sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
                filterInfo.setMaskString(sbMaskString.toString());
                entityViewInfo.setFilter(filterInfo);
                CoreBillBaseCollection partSourceBillCollection = this.icbb.getCoreBillBaseCollection(entityViewInfo);
                allSourceBillCollection.addCollection(partSourceBillCollection);
                partSourceBillPkList = total - i - 1 > 0 && total - i - 1 < step ? new IObjectPK[total - i - 1] : new IObjectPK[step];
                j = -1;
            }
            ++i;
            ++j;
        }
        ArrayList<CoreBillBaseCollection> sourceBillColList = new ArrayList<CoreBillBaseCollection>();
        for (j = 0; j < botMappingPKs.length; ++j) {
            CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
            for (int i2 = 0; i2 < sourceBillPkList.length; ++i2) {
                if (sourceBillPkList[i2] == null) continue;
                sourceBillCollection.add(allSourceBillCollection.get((Object)BOSUuid.read((String)sourceBillPkList[i2].toString())));
            }
            sourceBillColList.add(sourceBillCollection);
        }
        return this.mutiGenerateVoucher(ctx, sourceBillColList, botMappingPKs, type);
    }

    public BaseRecorder generateVoucherByType(Context ctx, BaseRecorder recorder) throws BOSException, EASBizException {
        block5: {
            this.srcBillPKs = recorder.srcBillPKs;
            this.rulePKs = recorder.rulePKs;
            this.voucherType = recorder.voucherType;
            this.icbb = recorder.icbb;
            try {
                DAPTransformResult result;
                this.dapResult = result = this.generateVoucherByType(ctx, this.srcBillPKs, this.rulePKs, null, this.voucherType);
                this.status = VOUCHER_SUCCEED;
            }
            catch (Exception e) {
                this.status = VOUCHER_FAILED;
                if (e instanceof BOSException && e.getCause() != null) {
                    this.failMsg = e.getCause().getMessage();
                    if (this.failMsg == null) {
                        this.failMsg = e.getMessage() == null ? EASResource.getString((String)this.resource, (String)"unhnownErr") : e.getMessage();
                    }
                } else {
                    this.failMsg = e.getMessage();
                }
                if (this.failMsg.length() <= 1000) break block5;
                this.failMsg = this.failMsg.substring(0, 990) + "...";
            }
        }
        return this;
    }

    public void generatePcVoucher() {
        block5: {
            try {
                IDAPTransformerWrapper dap = this.getDapWrapper(this.ctx);
                DAPTransformResult result = this.generateVoucherByType(this.ctx, this.srcBillPKs, this.rulePKs, null, "PCA");
                this.status = VOUCHER_SUCCEED;
                this.pcVoucherCol = (PcVoucherCollection)result.getVoucherCollection();
            }
            catch (Exception e) {
                this.status = VOUCHER_FAILED;
                if (e instanceof BOSException && e.getCause() != null) {
                    this.failMsg = e.getCause().getMessage();
                    if (this.failMsg == null) {
                        this.failMsg = e.getMessage() == null ? EASResource.getString((String)this.resource, (String)"unhnownErr") : e.getMessage();
                    }
                } else {
                    this.failMsg = e.getMessage();
                }
                if (this.failMsg.length() <= 1000) break block5;
                this.failMsg = this.failMsg.substring(0, 990) + "...";
            }
        }
    }

    public static SelectorItemCollection getBOTPSelectors(BOTMappingInfo mappingInfo) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingInfo == null) {
            return sic;
        }
        List autoSelectors = new ArrayList();
        ArrayList<String> sysSelectors = new ArrayList<String>();
        ArrayList<String> userSelectors = new ArrayList<String>();
        HashSet<String> goodSelectors = new HashSet<String>();
        String extconfig = mappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = mappingInfo.getExtConfigInfo();
        autoSelectors = BotUtil.getSrcBillPropList((BOTMappingInfo)mappingInfo);
        if (info != null) {
            String selectorsString = info.getSelectors();
            String userSelectorsString = info.getUserSelectors();
            if (selectorsString == null || selectorsString.equals("")) {
                Collections.sort(autoSelectors);
                if (autoSelectors != null && autoSelectors.size() > 0) {
                    for (int i = 0; i < autoSelectors.size(); ++i) {
                        sic.add(autoSelectors.get(i).toString());
                    }
                }
                return sic;
            }
            String[] selectorsArray = selectorsString.split(",");
            for (int j = 0; j < selectorsArray.length; ++j) {
                sysSelectors.add(selectorsArray[j]);
            }
            if (userSelectorsString != null && !userSelectorsString.equals("")) {
                String[] userSelectorsArray = userSelectorsString.split(",");
                for (int j = 0; j < userSelectorsArray.length; ++j) {
                    userSelectors.add(userSelectorsArray[j]);
                }
            }
            goodSelectors.addAll(sysSelectors);
            goodSelectors.addAll(userSelectors);
            goodSelectors.addAll(autoSelectors);
            for (String property : goodSelectors) {
                sic.add(property);
            }
        } else {
            Collections.sort(autoSelectors);
            if (autoSelectors != null && autoSelectors.size() > 0) {
                for (int i = 0; i < autoSelectors.size(); ++i) {
                    sic.add(autoSelectors.get(i).toString());
                }
            }
            return sic;
        }
        return sic;
    }

    public void generateVoucherCallbackByFacade() {
        block9: {
            try {
                if (this.rulePKs.length == 1) {
                    BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)this.ctx).getMappingInfo(this.rulePKs[0], this.ctx);
                    SelectorItemCollection botpSelector = BaseRecorder.getBOTPSelectors(mappingInfo);
                    DAPTransformResult result = this.icbb.generateVoucher(this.srcBillPKs, this.rulePKs[0], botpSelector);
                    this.voucherCol = (VoucherCollection)result.getVoucherCollection();
                    logger.error((Object)("SmartAccounting BaseRecorder,subsytem\u4e3a2\uff0c5 \u751f\u6210\u51ed\u8bc1:voucherCol" + this.voucherCol));
                    this.botpCol = result.getRelationCollection();
                    this.dapResult = result;
                    logger.error((Object)("SmartAccounting BaseRecorder,subsytem\u4e3a2\uff0c5 \u751f\u6210\u51ed\u8bc1:result" + result));
                } else {
                    ArrayList<SelectorItemCollection> botpSelectorsList = new ArrayList<SelectorItemCollection>(this.rulePKs.length);
                    for (int i = 0; i < this.rulePKs.length; ++i) {
                        BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)this.ctx).getMappingInfo(this.rulePKs[i], this.ctx);
                        SelectorItemCollection botpSelector = BaseRecorder.getBOTPSelectors(mappingInfo);
                        botpSelectorsList.add(botpSelector);
                    }
                    List resultList = this.icbb.generateVoucher(this.srcBillPKs, this.rulePKs, botpSelectorsList);
                    this.dealResultList(resultList);
                }
                this.status = VOUCHER_SUCCEED;
                if (this.voucherCol != null) {
                    String userId = this.ctx.getCaller().toString();
                    Object instInfo = null;
                    IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                    WfEngine wfEngine = WfEngine.getEngine((Context)this.ctx);
                }
            }
            catch (Exception e) {
                this.status = VOUCHER_FAILED;
                if (e instanceof BOSException && e.getCause() != null) {
                    this.failMsg = e.getCause().getMessage();
                    if (this.failMsg == null) {
                        this.failMsg = e.getMessage() == null ? EASResource.getString((String)this.resource, (String)"unhnownErr") : e.getMessage();
                    }
                } else {
                    this.failMsg = e.getMessage();
                }
                if (this.failMsg.length() <= 1000) break block9;
                this.failMsg = this.failMsg.substring(0, 990) + "...";
            }
        }
    }

    private void dealResultList(List resultList) {
        this.dapResultList = resultList;
        if (resultList != null) {
            for (int i = 0; i < resultList.size(); ++i) {
                DAPTransformResult result = (DAPTransformResult)resultList.get(i);
                if (this.voucherCol == null || this.voucherCol.size() == 0) {
                    this.voucherCol = (VoucherCollection)result.getVoucherCollection();
                } else {
                    this.voucherCol.addCollection((VoucherCollection)result.getVoucherCollection());
                }
                if (this.botpCol == null || this.botpCol.size() == 0) {
                    this.botpCol = result.getRelationCollection();
                    continue;
                }
                this.botpCol.addCollection(result.getRelationCollection());
            }
        }
    }

    private boolean activeWorkflow(Context ctx, IEnactmentService service, WfEngine engine, ProcessInstInfo instInfo, String billIDStr) throws BOSException {
        ++this.saftyNumber;
        logger.error((Object)("start activeWorkflow!billIDStr:" + billIDStr + ";instInfo.getyCode():" + (instInfo == null ? instInfo : instInfo.getCode())));
        ObjectUuidPK billID = null;
        String[] checkers = null;
        String checkerName = "";
        if (instInfo != null && this.saftyNumber <= 50) {
            try {
                int length;
                int i;
                Object obj = service.getProcessContext(instInfo.getProcInstId(), "autoApprove");
                if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    return true;
                }
                billID = new ObjectUuidPK(billIDStr);
                AssignmentInfo[] assignments = engine.getAssignmentAllByProcInstId(instInfo.getProcInstId());
                boolean is_FYBX_UploadImageNode = false;
                if (assignments != null) {
                    for (i = 0; i < assignments.length; ++i) {
                        if (!this.isCurrent(assignments[i])) continue;
                        if ("afterImageUpload".equalsIgnoreCase(assignments[i].getBizOperation()) || "ImageUploadEvent".equalsIgnoreCase(assignments[i].getBizOperation()) || "actionImageUpload".equalsIgnoreCase(assignments[i].getBizOperation())) {
                            is_FYBX_UploadImageNode = true;
                            ctx.setCaller((IObjectPK)new ObjectUuidPK(assignments[i].getAssignInfo().getPersonUserID()));
                            break;
                        }
                        if (!assignments[i].getBizFunction().equals("WsscCommonFunction") || !assignments[i].getBizOperation().equals("afterImageReadyHandler")) continue;
                        logger.error((Object)"\u662f\u5171\u4eab\u57fa\u7840\u63d0\u4f9b\u7684\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9,\u66f4\u65b0\u8282\u70b9\u5904\u7406\u4eba,\u5e76\u89e6\u53d1\u5de5\u4f5c\u6d41!");
                        IObjectPK trueCaller = ctx.getCaller();
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(assignments[i].getAssignInfo().getPersonUserID()));
                        IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
                        iBillImageMap.afterImageReady(BOSUuid.read((String)billIDStr));
                        ctx.setCaller(trueCaller);
                        return true;
                    }
                }
                if (is_FYBX_UploadImageNode) {
                    checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)billID.getObjectType().toString(), IAfterImageStateUpdateHandler.class);
                    if (checkers == null || checkers.length == 0) {
                        return true;
                    }
                    for (i = 0; i < checkers.length; ++i) {
                        checkerName = checkers[i];
                        ((IAfterImageStateUpdateHandler)Class.forName(checkerName).newInstance()).handler(ctx, billID);
                    }
                    return true;
                }
                String procInstId = instInfo.getProcInstId();
                ProcessInstInfo[] childrenProcessInsts = engine.getProcessInstancesByParentProcInstId(procInstId);
                int n = length = childrenProcessInsts == null ? 0 : childrenProcessInsts.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    if (!this.activeWorkflow(ctx, service, engine, childrenProcessInsts[i2], billIDStr)) continue;
                    return true;
                }
            }
            catch (EASDBException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return false;
    }

    private boolean isCurrent(AssignmentInfo assignmentInfo) {
        WfAssignmentState state = assignmentInfo.getAssignInfo().getState();
        return WfAssignmentState.ASSIGNED.equals((Object)state) || WfAssignmentState.ACCEPTED.equals((Object)state);
    }

    public void recordDetailLog() throws BOSException, EASBizException {
        CoreBaseCollection vrc = null;
        ArrayList billIds = new ArrayList();
        SmartAccountingSchemaInfo schemaInfo = (SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo");
        UserInfo userInfo = (UserInfo)BOSObjectFactory.getContextFromThread().get((Object)"userInfo");
        boolean isAutoProcess = Boolean.valueOf(BOSObjectFactory.getContextFromThread().get((Object)"isAutoProcess").toString());
        vrc = new CoreBaseCollection();
        CoreBillBaseCollection srcBillCol = VcDapUtil.getSrcCollectionByIds(this.ctx, this.srcBillIds, new String[]{"number", "bizDate"});
        SmartAccountingDetailRPTInfo vrii = null;
        if (VOUCHER_SUCCEED.equals(this.status)) {
            IObjectCollection billCollection = this.btpResult.getBills();
            this.botpCol = this.btpResult.getBOTRelationCollection();
            HashMap<String, CoreBillBaseInfo> desBillIdInfoMap = new HashMap<String, CoreBillBaseInfo>();
            int len = srcBillCol.size();
            for (int i = 0; i < len; ++i) {
                CoreBillBaseInfo desBillInfo;
                CoreBillBaseInfo srcBillInfo = srcBillCol.get(i);
                if (billCollection.size() == 1) {
                    desBillInfo = (CoreBillBaseInfo)billCollection.getObject(0);
                    vrii = new SmartAccountingDetailRPTInfo();
                    vrii.put("company", this.company);
                    if (this.billType != null) {
                        vrii.setSubSystem(this.billType.getSubSystem());
                        vrii.setBusinessType(this.billType.getId().toString());
                        vrii.setBusinessNumber(this.billType.getBosObjectType());
                    } else {
                        vrii.setSubSystem(this.businessType.getSubSystem());
                        vrii.setBusinessType(this.businessType.getId().toString());
                        vrii.setBusinessNumber(this.businessType.getNumber());
                    }
                    vrii.setOperatorNumber(this.desBosType);
                    vrii.setBillID(srcBillInfo.get("id").toString());
                    vrii.setBillNumber((String)srcBillInfo.get("number"));
                    vrii.setBizDate((Date)srcBillInfo.get("bizDate"));
                    vrii.setVoucherState(VoucherStateEnum.success);
                    vrii.setTargetBillID(desBillInfo.getId().toString());
                    if (desBillInfo.getNumber() != null) {
                        vrii.setTargetBillNumber(desBillInfo.getNumber().toString());
                    } else {
                        ICoreBillBase billBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)new BOSObjectType("A70BC00F"));
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("number"));
                        CoreBillBaseInfo baseInfo = (CoreBillBaseInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(desBillInfo.getId()), sic);
                        if (baseInfo.getNumber() != null) {
                            desBillInfo = baseInfo;
                        }
                    }
                    vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
                    vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                    if (isAutoProcess) {
                        vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                    } else {
                        vrii.setUser(userInfo);
                    }
                    vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                    vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                    vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                    SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                    vrc.addObject((IObjectValue)vrii);
                    continue;
                }
                desBillInfo = null;
                String desBillId = null;
                int bill_size = this.botpCol.size();
                for (int j = 0; j < bill_size; ++j) {
                    if (!this.botpCol.get(j).getSrcObjectID().equals(srcBillInfo.get("id").toString())) continue;
                    desBillId = this.botpCol.get(j).getDestObjectID();
                    break;
                }
                if (desBillIdInfoMap.get(desBillId) == null) {
                    for (int k = 0; k < billCollection.size(); ++k) {
                        if (!billCollection.getObject(i).get("id").toString().equals(desBillId)) continue;
                        desBillInfo = (CoreBillBaseInfo)billCollection.getObject(i);
                        desBillIdInfoMap.put(desBillId, desBillInfo);
                        break;
                    }
                } else {
                    desBillInfo = (CoreBillBaseInfo)desBillIdInfoMap.get(desBillId);
                }
                vrii = new SmartAccountingDetailRPTInfo();
                vrii.put("company", this.company);
                if (this.billType != null) {
                    vrii.setSubSystem(this.billType.getSubSystem());
                    vrii.setBusinessType(this.billType.getId().toString());
                    vrii.setBusinessNumber(this.billType.getBosObjectType());
                } else {
                    vrii.setSubSystem(this.businessType.getSubSystem());
                    vrii.setBusinessType(this.businessType.getId().toString());
                    vrii.setBusinessNumber(this.businessType.getNumber());
                }
                vrii.setOperatorNumber(this.desBosType);
                vrii.setBillID(srcBillInfo.get("id").toString());
                vrii.setBillNumber((String)srcBillInfo.get("number"));
                vrii.setBizDate((Date)srcBillInfo.get("bizDate"));
                vrii.setVoucherState(VoucherStateEnum.success);
                vrii.setTargetBillID(desBillInfo.getId().toString());
                if (desBillInfo.getNumber() != null) {
                    vrii.setTargetBillNumber(desBillInfo.getNumber().toString());
                } else {
                    ICoreBillBase billBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)new BOSObjectType("A70BC00F"));
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    CoreBillBaseInfo baseInfo = (CoreBillBaseInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(desBillInfo.getId()), sic);
                    if (baseInfo.getNumber() != null) {
                        desBillInfo = baseInfo;
                        desBillIdInfoMap.put(desBillId, desBillInfo);
                    }
                }
                vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
                vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                if (isAutoProcess) {
                    vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                } else {
                    vrii.setUser(userInfo);
                }
                vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                vrc.addObject((IObjectValue)vrii);
            }
        } else {
            int len = this.billCol.size();
            for (int i = 0; i < len; ++i) {
                CoreBillBaseInfo billInfo = this.billCol.get(i);
                vrii = new SmartAccountingDetailRPTInfo();
                vrii.put("company", this.company);
                if (this.billType != null) {
                    vrii.setSubSystem(this.billType.getSubSystem());
                    vrii.setBusinessType(this.billType.getId().toString());
                    vrii.setBusinessNumber(this.billType.getBosObjectType());
                } else {
                    vrii.setSubSystem(this.businessType.getSubSystem());
                    vrii.setBusinessType(this.businessType.getId().toString());
                    vrii.setBusinessNumber(this.businessType.getNumber());
                }
                vrii.setOperatorNumber(this.desBosType);
                vrii.setBillID(billInfo.get("id").toString());
                vrii.setBillNumber((String)billInfo.get("number"));
                vrii.setBizDate((Date)billInfo.get("bizDate"));
                vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                if (isAutoProcess) {
                    vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                } else {
                    vrii.setUser(userInfo);
                }
                vrii.setVoucherState(VoucherStateEnum.failForOtherCause);
                vrii.setFailureCause(this.failMsg);
                vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
                vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                vrc.addObject((IObjectValue)vrii);
            }
        }
    }

    private void recordPC() throws BOSException, EASBizException {
        CoreBaseCollection vrc = null;
        Object vri = null;
        ArrayList<String> billIds = new ArrayList<String>();
        SmartAccountingSchemaInfo schemaInfo = (SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo");
        UserInfo userInfo = (UserInfo)BOSObjectFactory.getContextFromThread().get((Object)"userInfo");
        boolean isAutoProcess = Boolean.valueOf(BOSObjectFactory.getContextFromThread().get((Object)"isAutoProcess").toString());
        HashMap<String, CoreBillBaseInfo> desBillIdInfoMap = new HashMap<String, CoreBillBaseInfo>();
        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\u6765\u8bb0\u5f55\u6210\u529f\u6216\u8005\u5931\u8d25\u660e\u7ec6\u65e5\u5fd7\uff0c\u65b0\u589e");
        vrc = new CoreBaseCollection();
        CoreBillBaseCollection billCol = VcDapUtil.getSrcCollectionByIds(this.ctx, this.srcBillPKs, new String[]{"number", "bizDate"});
        SmartAccountingDetailRPTInfo vrii = null;
        if (VOUCHER_SUCCEED.equals(this.status)) {
            BOTRelationCollection botpCol = this.dapResult.getRelationCollection();
            int len = billCol.size();
            for (int i = 0; i < len; ++i) {
                CoreBillBaseInfo srcBillInfo = billCol.get(i);
                if (this.pcVoucherCol.size() == 1) {
                    PcVoucherInfo voucher = this.pcVoucherCol.get(0);
                    billIds.add(srcBillInfo.get("id").toString());
                    vrii = new SmartAccountingDetailRPTInfo();
                    vrii.put("company", this.company);
                    if (this.billType != null) {
                        vrii.setSubSystem(this.billType.getSubSystem());
                        vrii.setBusinessType(this.billType.getId().toString());
                        vrii.setBusinessNumber(this.billType.getBosObjectType());
                    } else {
                        vrii.setSubSystem(this.businessType.getSubSystem());
                        vrii.setBusinessType(this.businessType.getId().toString());
                        vrii.setBusinessNumber(this.businessType.getNumber());
                    }
                    vrii.setOperatorNumber("scpcpz");
                    vrii.setBillID(srcBillInfo.get("id").toString());
                    vrii.setBillNumber((String)srcBillInfo.get("number"));
                    vrii.setBizDate((Date)srcBillInfo.get("bizDate"));
                    vrii.setVoucherState(VoucherStateEnum.success);
                    vrii.put("voucher", voucher);
                    vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
                    vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                    if (isAutoProcess) {
                        vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                    } else {
                        vrii.setUser(userInfo);
                    }
                    vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                    vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                    vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                    SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                    vrc.addObject((IObjectValue)vrii);
                    continue;
                }
                CoreBillBaseInfo desBillInfo = null;
                String desBillId = null;
                int bill_size = botpCol.size();
                for (int j = 0; j < bill_size; ++j) {
                    if (!botpCol.get(j).getSrcObjectID().equals(srcBillInfo.get("id").toString())) continue;
                    desBillId = botpCol.get(j).getDestObjectID();
                    break;
                }
                if (desBillIdInfoMap.get(desBillId) == null) {
                    for (int k = 0; k < this.pcVoucherCol.size(); ++k) {
                        if (!this.pcVoucherCol.getObject(i).get("id").toString().equals(desBillId)) continue;
                        desBillInfo = (CoreBillBaseInfo)this.pcVoucherCol.getObject(i);
                        desBillIdInfoMap.put(desBillId, desBillInfo);
                        break;
                    }
                } else {
                    desBillInfo = (CoreBillBaseInfo)desBillIdInfoMap.get(desBillId);
                }
                PcVoucherInfo voucher = (PcVoucherInfo)desBillInfo;
                billIds.add(srcBillInfo.get("id").toString());
                vrii = new SmartAccountingDetailRPTInfo();
                vrii.put("company", this.company);
                if (this.billType != null) {
                    vrii.setSubSystem(this.billType.getSubSystem());
                    vrii.setBusinessType(this.billType.getId().toString());
                    vrii.setBusinessNumber(this.billType.getBosObjectType());
                } else {
                    vrii.setSubSystem(this.businessType.getSubSystem());
                    vrii.setBusinessType(this.businessType.getId().toString());
                    vrii.setBusinessNumber(this.businessType.getNumber());
                }
                vrii.setOperatorNumber("scpcpz");
                vrii.setBillID(srcBillInfo.get("id").toString());
                vrii.setBillNumber((String)srcBillInfo.get("number"));
                vrii.setBizDate((Date)srcBillInfo.get("bizDate"));
                vrii.setVoucherState(VoucherStateEnum.success);
                vrii.put("voucher", voucher);
                vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
                vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                if (isAutoProcess) {
                    vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                } else {
                    vrii.setUser(userInfo);
                }
                vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                vrc.addObject((IObjectValue)vrii);
            }
        } else {
            int len = billCol.size();
            for (int i = 0; i < len; ++i) {
                CoreBillBaseInfo billInfo = billCol.get(i);
                vrii = new SmartAccountingDetailRPTInfo();
                vrii.put("company", this.company);
                if (this.billType != null) {
                    vrii.setSubSystem(this.billType.getSubSystem());
                    vrii.setBusinessType(this.billType.getId().toString());
                    vrii.setBusinessNumber(this.billType.getBosObjectType());
                } else {
                    vrii.setSubSystem(this.businessType.getSubSystem());
                    vrii.setBusinessType(this.businessType.getId().toString());
                    vrii.setBusinessNumber(this.businessType.getNumber());
                }
                vrii.setOperatorNumber("scpcpz");
                vrii.setBillID(billInfo.get("id").toString());
                vrii.setBillNumber((String)billInfo.get("number"));
                vrii.setBizDate((Date)billInfo.get("bizDate"));
                vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                if (isAutoProcess) {
                    vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                } else {
                    vrii.setUser(userInfo);
                }
                vrii.setVoucherState(VoucherStateEnum.failForOtherCause);
                vrii.setFailureCause(this.failMsg);
                vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
                vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                vrc.addObject((IObjectValue)vrii);
            }
        }
    }

    private void record() throws BOSException, EASBizException {
        CoreBaseCollection vrc = null;
        AbstractVoucherReportInfo vri = null;
        ArrayList<String> billIds = new ArrayList<String>();
        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\u6765\u8bb0\u5f55\u6210\u529f\u6216\u8005\u5931\u8d25\u660e\u7ec6\u65e5\u5fd7");
        HashMap desBillIdInfoMap = new HashMap();
        if (BOSObjectFactory.getContextFromThread() != null && BOSObjectFactory.getContextFromThread().get((Object)"isBackTask") != null && this.ctx.get((Object)"isSmartAccounting") != null) {
            SmartAccountingSchemaInfo schemaInfo = (SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo");
            UserInfo userInfo = (UserInfo)BOSObjectFactory.getContextFromThread().get((Object)"userInfo");
            boolean isAutoProcess = Boolean.valueOf(BOSObjectFactory.getContextFromThread().get((Object)"isAutoProcess").toString());
            Object operator = this.ctx.get((Object)"operator");
            if (operator != null && operator.toString().endsWith("glpz")) {
                this.billType = null;
                this.businessType = VcDapUtil.getBusinessTypeByNumber(this.ctx, VcDapUtil.getBOSTypeById(this.srcBillPKs[0].toString()).toString(), this.subSystem, operator.toString());
            }
            if (this.isUpdate) {
                logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\u6765\u8bb0\u5f55\u6210\u529f\u6216\u8005\u5931\u8d25\u660e\u7ec6\u65e5\u5fd7\uff0c\u66f4\u65b0");
                EntityViewInfo evi = this.getVoucherReportEVIByBillIds(this.srcBillPKs);
                vrc = SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).getCollection(evi);
                CoreBaseCollection vrcNew = new CoreBaseCollection();
                AbstractSmartAccountingDetailRPTInfo vrii = null;
                if (VOUCHER_SUCCEED.equals(this.status)) {
                    int len = vrc.size();
                    for (int i = 0; i < len; ++i) {
                        vrii = (SmartAccountingDetailRPTInfo)vrc.get(i);
                        int voucher_size = this.voucherCol.size();
                        for (int j = 0; j < voucher_size; ++j) {
                            SmartAccountingDetailRPTInfo vriNew = (SmartAccountingDetailRPTInfo)vrii.clone();
                            vriNew.setId(null);
                            vriNew.setVoucherState(VoucherStateEnum.success);
                            vriNew.setVoucher(this.voucherCol.get(j));
                            if (this.rulePKs[0] != null) {
                                vriNew.setDapRuleIds(this.rulePKs[0].toString());
                            }
                            vriNew.setFailureCause(null);
                            vrcNew.add((CoreBaseInfo)vriNew);
                        }
                    }
                    billIds.add(vrii.getBillID().toString());
                } else {
                    int len = vrc.size();
                    for (int i = 0; i < len; ++i) {
                        vrii = (SmartAccountingDetailRPTInfo)vrc.get(i);
                        vrii.setId(null);
                        vrii.setVoucherState(VoucherStateEnum.failForOtherCause);
                        vrii.setFailureCause(this.failMsg);
                        if (this.rulePKs[0] != null) {
                            vrii.setDapRuleIds(this.rulePKs[0].toString());
                        }
                        vrcNew.add((CoreBaseInfo)vrii);
                    }
                }
                vrc.clear();
                vrc.addCollection(vrcNew);
            } else {
                logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\u6765\u8bb0\u5f55\u6210\u529f\u6216\u8005\u5931\u8d25\u660e\u7ec6\u65e5\u5fd7\uff0c\u65b0\u589e");
                vrc = new CoreBaseCollection();
                CoreBillBaseCollection billCol = VcDapUtil.getSrcCollectionByIds(this.ctx, this.srcBillPKs, new String[]{"number", "bizDate"});
                SmartAccountingDetailRPTInfo vrii = null;
                if (VOUCHER_SUCCEED.equals(this.status)) {
                    BOTRelationCollection botpCol = null;
                    if (this.dapResult != null) {
                        botpCol = this.dapResult.getRelationCollection();
                    }
                    if (this.dapResultList != null) {
                        for (int j = 0; j < this.dapResultList.size(); ++j) {
                            DAPTransformResult result = (DAPTransformResult)this.dapResultList.get(j);
                            if (botpCol == null || botpCol.size() == 0) {
                                botpCol = result.getRelationCollection();
                                continue;
                            }
                            botpCol.addCollection(result.getRelationCollection());
                        }
                    }
                    int len = billCol.size();
                    for (int i = 0; i < len; ++i) {
                        CoreBillBaseInfo srcBillInfo = billCol.get(i);
                        if (this.voucherCol.size() == 1) {
                            VoucherInfo voucher = this.voucherCol.get(0);
                            billIds.add(srcBillInfo.get("id").toString());
                            vrii = new SmartAccountingDetailRPTInfo();
                            vrii.put("company", this.company);
                            if (this.billType != null) {
                                vrii.setSubSystem(this.billType.getSubSystem());
                                vrii.setBusinessType(this.billType.getId().toString());
                                vrii.setBusinessNumber(this.billType.getBosObjectType());
                            } else {
                                vrii.setSubSystem(this.businessType.getSubSystem());
                                vrii.setBusinessType(this.businessType.getId().toString());
                                vrii.setBusinessNumber(this.businessType.getNumber());
                            }
                            vrii.setOperatorNumber("scpz");
                            vrii.setBillID(srcBillInfo.get("id").toString());
                            vrii.setBillNumber((String)srcBillInfo.get("number"));
                            vrii.setBizDate((Date)srcBillInfo.get("bizDate"));
                            vrii.setVoucherState(VoucherStateEnum.success);
                            vrii.setVoucher(voucher);
                            vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
                            vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                            if (this.rulePKs[0] != null) {
                                vrii.setDapRuleIds(this.rulePKs[0].toString());
                            }
                            if (isAutoProcess) {
                                vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                            } else {
                                vrii.setUser(userInfo);
                            }
                            vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                            vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                            vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                            SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                            vrc.addObject((IObjectValue)vrii);
                            continue;
                        }
                        ArrayList<String> desBillIdList = new ArrayList<String>();
                        int bill_size = botpCol.size();
                        for (int j = 0; j < bill_size; ++j) {
                            if (!botpCol.get(j).getSrcObjectID().equals(srcBillInfo.get("id").toString())) continue;
                            desBillIdList.add(botpCol.get(j).getDestObjectID());
                        }
                        for (int k = 0; k < desBillIdList.size(); ++k) {
                            VoucherInfo desBillInfo = null;
                            if (desBillIdInfoMap.get(desBillIdList.get(k)) == null) {
                                desBillInfo = new VoucherInfo();
                                desBillInfo.setId(BOSUuid.read((String)((String)desBillIdList.get(k))));
                                desBillIdInfoMap.put(desBillIdList.get(k), desBillInfo);
                            } else {
                                desBillInfo = (CoreBillBaseInfo)desBillIdInfoMap.get(desBillIdList.get(k));
                            }
                            VoucherInfo voucher = desBillInfo;
                            billIds.add(srcBillInfo.get("id").toString());
                            vrii = new SmartAccountingDetailRPTInfo();
                            vrii.put("company", this.company);
                            if (this.billType != null) {
                                vrii.setSubSystem(this.billType.getSubSystem());
                                vrii.setBusinessType(this.billType.getId().toString());
                                vrii.setBusinessNumber(this.billType.getBosObjectType());
                            } else {
                                vrii.setSubSystem(this.businessType.getSubSystem());
                                vrii.setBusinessType(this.businessType.getId().toString());
                                vrii.setBusinessNumber(this.businessType.getNumber());
                            }
                            vrii.setOperatorNumber("scpz");
                            vrii.setBillID(srcBillInfo.get("id").toString());
                            vrii.setBillNumber((String)srcBillInfo.get("number"));
                            vrii.setBizDate((Date)srcBillInfo.get("bizDate"));
                            vrii.setVoucherState(VoucherStateEnum.success);
                            vrii.setVoucher(voucher);
                            vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
                            vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                            if (this.rulePKs[0] != null) {
                                vrii.setDapRuleIds(this.rulePKs[0].toString());
                            }
                            if (isAutoProcess) {
                                vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                            } else {
                                vrii.setUser(userInfo);
                            }
                            vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                            vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                            vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                            SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                            vrc.addObject((IObjectValue)vrii);
                        }
                    }
                } else {
                    int len = billCol.size();
                    for (int i = 0; i < len; ++i) {
                        CoreBillBaseInfo billInfo = billCol.get(i);
                        vrii = new SmartAccountingDetailRPTInfo();
                        vrii.put("company", this.company);
                        if (this.billType != null) {
                            vrii.setSubSystem(this.billType.getSubSystem());
                            vrii.setBusinessType(this.billType.getId().toString());
                            vrii.setBusinessNumber(this.billType.getBosObjectType());
                        } else {
                            vrii.setSubSystem(this.businessType.getSubSystem());
                            vrii.setBusinessType(this.businessType.getId().toString());
                            vrii.setBusinessNumber(this.businessType.getNumber());
                        }
                        vrii.setOperatorNumber("scpz");
                        vrii.setBillID(billInfo.get("id").toString());
                        vrii.setBillNumber((String)billInfo.get("number"));
                        vrii.setBizDate((Date)billInfo.get("bizDate"));
                        vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                        if (isAutoProcess) {
                            vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                        } else {
                            vrii.setUser(userInfo);
                        }
                        vrii.setVoucherState(VoucherStateEnum.failForOtherCause);
                        vrii.setFailureCause(this.failMsg);
                        vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
                        if (this.rulePKs[0] != null) {
                            vrii.setDapRuleIds(this.rulePKs[0].toString());
                        }
                        vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                        vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                        vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                        SmartAccountingDetailRPTFactory.getLocalInstance(this.ctx).submitReportDetailNew(vrii);
                        vrc.addObject((IObjectValue)vrii);
                    }
                }
            }
        } else {
            if (this.isUpdate) {
                EntityViewInfo evi = this.getVoucherReportEVIByBillIds(this.srcBillPKs);
                vrc = VoucherReportFactory.getLocalInstance(this.ctx).getCollection(evi);
                CoreBaseCollection vrcNew = new CoreBaseCollection();
                if (VOUCHER_SUCCEED.equals(this.status)) {
                    int len = vrc.size();
                    for (int i = 0; i < len; ++i) {
                        vri = (VoucherReportInfo)vrc.get(i);
                        int voucher_size = this.voucherCol.size();
                        for (int j = 0; j < voucher_size; ++j) {
                            VoucherReportInfo vriNew = (VoucherReportInfo)vri.clone();
                            vriNew.setId(null);
                            vriNew.setVoucherState(VoucherStateEnum.success);
                            vriNew.setVoucher(this.voucherCol.get(j));
                            vriNew.setFailureCause(null);
                            if (this.rulePKs[0] != null) {
                                vriNew.setDapRuleIds(this.rulePKs[0].toString());
                            }
                            vrcNew.add((CoreBaseInfo)vriNew);
                        }
                    }
                    billIds.add(vri.getBillID().toString());
                } else {
                    int len = vrc.size();
                    for (int i = 0; i < len; ++i) {
                        vri = (VoucherReportInfo)vrc.get(i);
                        vri.setId(null);
                        vri.setVoucherState(VoucherStateEnum.failForOtherCause);
                        vri.setFailureCause(this.failMsg);
                        if (this.rulePKs[0] != null) {
                            vri.setDapRuleIds(this.rulePKs[0].toString());
                        }
                        vrcNew.add((CoreBaseInfo)vri);
                    }
                }
                VoucherReportFactory.getLocalInstance(this.ctx).delete(evi.getFilter());
                vrc.clear();
                vrc.addCollection(vrcNew);
            } else {
                vrc = new CoreBaseCollection();
                CoreBillBaseCollection billCol = VcDapUtil.getSrcCollectionByIds(this.ctx, this.srcBillPKs, new String[]{"number", "bizDate"});
                if (VOUCHER_SUCCEED.equals(this.status)) {
                    int len = billCol.size();
                    for (int i = 0; i < len; ++i) {
                        BOTRelationCollection botpCol = null;
                        if (this.dapResult != null) {
                            botpCol = this.dapResult.getRelationCollection();
                        }
                        if (this.dapResultList != null) {
                            for (int j = 0; j < this.dapResultList.size(); ++j) {
                                DAPTransformResult result = (DAPTransformResult)this.dapResultList.get(j);
                                if (botpCol == null || botpCol.size() == 0) {
                                    botpCol = result.getRelationCollection();
                                    continue;
                                }
                                botpCol.addCollection(result.getRelationCollection());
                            }
                        }
                        CoreBillBaseInfo billInfo = billCol.get(i);
                        ArrayList<String> desBillIdList = new ArrayList<String>();
                        int bill_size = botpCol.size();
                        for (int j = 0; j < bill_size; ++j) {
                            if (!botpCol.get(j).getSrcObjectID().equals(billInfo.get("id").toString())) continue;
                            desBillIdList.add(botpCol.get(j).getDestObjectID());
                        }
                        for (int k = 0; k < desBillIdList.size(); ++k) {
                            VoucherInfo desBillInfo = null;
                            if (desBillIdInfoMap.get(desBillIdList.get(k)) == null) {
                                desBillInfo = new VoucherInfo();
                                desBillInfo.setId(BOSUuid.read((String)((String)desBillIdList.get(k))));
                                desBillIdInfoMap.put(desBillIdList.get(k), desBillInfo);
                            } else {
                                desBillInfo = (CoreBillBaseInfo)desBillIdInfoMap.get(desBillIdList.get(k));
                            }
                            VoucherInfo voucher = desBillInfo;
                            billIds.add(billInfo.get("id").toString());
                            vri = new VoucherReportInfo();
                            if (this.companyOrg == null) {
                                this.companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo("select id where id = '" + this.company.getId().toString() + "'");
                            }
                            vri.setCompany(this.companyOrg);
                            vri.setSubSystem(this.billType.getSubSystem());
                            vri.setBillType(this.billType);
                            vri.setBillID(billInfo.get("id").toString());
                            vri.setBillNumber((String)billInfo.get("number"));
                            vri.setBizDate((Date)billInfo.get("bizDate"));
                            vri.setUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                            vri.setVoucherState(VoucherStateEnum.success);
                            if (this.rulePKs[0] != null) {
                                vri.setDapRuleIds(this.rulePKs[0].toString());
                            }
                            vri.setVoucher(voucher);
                            vrc.addObject((IObjectValue)vri);
                        }
                    }
                } else {
                    int len = billCol.size();
                    for (int i = 0; i < len; ++i) {
                        CoreBillBaseInfo billInfo = billCol.get(i);
                        vri = new VoucherReportInfo();
                        if (this.companyOrg == null) {
                            this.companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo("select id where id = '" + this.company.getId().toString() + "'");
                        }
                        vri.setCompany(this.companyOrg);
                        vri.setSubSystem(this.billType.getSubSystem());
                        vri.setBillType(this.billType);
                        vri.setBillID(billInfo.get("id").toString());
                        vri.setBillNumber((String)billInfo.get("number"));
                        vri.setBizDate((Date)billInfo.get("bizDate"));
                        vri.setUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                        vri.setVoucherState(VoucherStateEnum.failForOtherCause);
                        if (this.rulePKs[0] != null) {
                            vri.setDapRuleIds(this.rulePKs[0].toString());
                        }
                        if (this.failMsg.length() > 500) {
                            this.failMsg = this.failMsg.substring(0, 500);
                        }
                        vri.setFailureCause(this.failMsg);
                        vrc.addObject((IObjectValue)vri);
                    }
                }
            }
            this.clearPreRecordForSuccessBill(billIds);
            VoucherReportFactory.getLocalInstance(this.ctx).submitBatchData(vrc);
        }
    }

    private void clearPreRecordForSuccessBill(List billIds) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        Object[] billIdArr = new String[]{};
        if (billIds != null && billIds.size() > 0) {
            billIdArr = billIds.toArray(billIdArr);
            fi.getFilterItems().add(new FilterItemInfo("billID", (Object)StringUtils.arrayToString((Object[])billIdArr, (String)","), CompareType.INCLUDE));
            evi.setFilter(fi);
            VoucherReportFactory.getLocalInstance(this.ctx).delete(evi.toString());
        }
    }

    private EntityViewInfo getVoucherReportEVIByBillIds(IObjectPK[] srcBillPKs) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String strIdLists = StringUtils.arrayToString((Object[])srcBillPKs, (String)",");
        fi.getFilterItems().add(new FilterItemInfo("billID", (Object)strIdLists, CompareType.INCLUDE));
        evi.setFilter(fi);
        return evi;
    }
}

