/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.dom.stmt.ReturnStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.bot.BOTAggregateInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BotEngineNew {
    private static Logger logger = Logger.getLogger(BotEngineNew.class);

    public Map preMerge(Context ctx, String[] billIds, String ruleId) throws EASBizException, BOSException {
        BOTMappingInfo botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(ruleId));
        BOTRuleCollection botRuleCols = botMappingInfo.getRules();
        HashSet<String> destGroupProperty = new HashSet<String>();
        int size = botRuleCols.size();
        for (int i = 0; i < size; ++i) {
            Iterator it = botRuleCols.get(i).getGroups().iterator();
            while (it.hasNext()) {
                String property = ((BOTGroupingInfo)it.next()).getGroupingProperty();
                if (property == null || property.indexOf(".") >= 0) continue;
                destGroupProperty.add(property);
            }
        }
        HashSet<String> destSumProperty = new HashSet<String>();
        Iterator it = botMappingInfo.getAggregateCollection().iterator();
        while (it.hasNext()) {
            String property = ((BOTAggregateInfo)it.next()).getPropertyName();
            if (property == null || property.indexOf(".") >= 0) continue;
            destSumProperty.add(property);
        }
        ArrayList complexExpr = new ArrayList();
        HashSet<String> srcGroupProperty = new HashSet<String>();
        HashSet srcSumProperty = new HashSet();
        this.analyzeBOTRules(botRuleCols, complexExpr, srcGroupProperty, srcSumProperty, destGroupProperty, destSumProperty);
        Iterator it2 = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String idFi = StringUtils.arrayToString((Object[])billIds, (String)",");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idFi, CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        it2 = srcSumProperty.iterator();
        while (it2.hasNext()) {
            sic.add((String)it2.next());
        }
        it2 = srcGroupProperty.iterator();
        while (it2.hasNext()) {
            sic.add((String)it2.next());
        }
        CoreBillBaseCollection srcObjCols = VcDapUtil.getSrcBizInterface(ctx, billIds[0]).getCoreBillBaseCollection(evi);
        IObjectValue baseInfo = srcObjCols.getObject(0);
        String property2 = null;
        ArrayList<String> tempList = new ArrayList<String>();
        for (String property2 : srcSumProperty) {
            if (baseInfo.get(property2) instanceof BigDecimal) continue;
            tempList.add(property2);
        }
        for (String property2 : tempList) {
            srcGroupProperty.add(property2);
            srcSumProperty.remove(property2);
        }
        Map transGroups = this.group(ctx, srcObjCols, srcGroupProperty, complexExpr, botMappingInfo);
        return transGroups;
    }

    private void analyzeBOTRules(BOTRuleCollection botRuleCols, List complexExpr, Set srcGroupProperty, Set srcSumProperty, Set destGroupProperty, Set destSumProperty) throws BOSException {
        int i;
        BOTRuleSegmentInfo segment2 = null;
        ArrayList srcIdentList = new ArrayList();
        ArrayList sumIdentList = new ArrayList();
        String srcExpr = null;
        int size = botRuleCols.size();
        for (int i2 = 0; i2 < size; ++i2) {
            for (BOTRuleSegmentInfo segment2 : botRuleCols.get(i2).getRuleSegments()) {
                if (!destGroupProperty.contains(segment2.getDestPropertyName()) && !destSumProperty.contains(segment2.getDestPropertyName())) continue;
                srcExpr = segment2.getSrcPropertyName();
                if (srcExpr == null || srcExpr.length() == 0) {
                    int exprType;
                    srcExpr = segment2.getExpression();
                    if (destGroupProperty.contains(segment2.getDestPropertyName()) && srcExpr.indexOf("__src.") != -1 && 13 == (exprType = this.analyzeExpression(srcExpr))) {
                        complexExpr.add(srcExpr);
                        continue;
                    }
                } else if (!srcExpr.startsWith("__src.")) {
                    srcExpr = "__src." + srcExpr;
                }
                if (destGroupProperty.contains(segment2.getDestPropertyName())) {
                    BotUtil.computeIdent((String)srcExpr, srcIdentList);
                    continue;
                }
                if (!destSumProperty.contains(segment2.getDestPropertyName())) continue;
                BotUtil.computeIdent((String)srcExpr, sumIdentList);
            }
        }
        String ident = null;
        int size2 = srcIdentList.size();
        for (i = 0; i < size2; ++i) {
            ident = (String)srcIdentList.get(i);
            if (!ident.startsWith("__src.") || StringUtils.isEmpty((String)(ident = ident.substring("__src.".length())))) continue;
            srcGroupProperty.add(ident);
        }
        size2 = sumIdentList.size();
        for (i = 0; i < size2; ++i) {
            ident = (String)sumIdentList.get(i);
            if (!ident.startsWith("__src.") || StringUtils.isEmpty((String)(ident = ident.substring("__src.".length())))) continue;
            srcSumProperty.add(ident);
        }
    }

    private int analyzeExpression(String expression) throws BOSException {
        KScriptParser parser = new KScriptParser(expression);
        parser.parse();
        List stmtList = parser.stmtList;
        ArrayList<CodeStmt> realStmtList = new ArrayList<CodeStmt>();
        int size = stmtList.size();
        for (int i = 0; i < size; ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            if (stmt instanceof VarDeclStmt || stmt instanceof ReturnStmt) continue;
            realStmtList.add(stmt);
        }
        if (realStmtList.size() != 1) {
            return 13;
        }
        if (realStmtList.get(0) instanceof IfStmt) {
            return 13;
        }
        if (realStmtList.get(0) instanceof ExprStmt) {
            return this.innerAnalyzeCodeExpr(((ExprStmt)realStmtList.get((int)0)).expr);
        }
        return 2;
    }

    private int innerAnalyzeCodeExpr(CodeExpr expr) {
        if (expr instanceof MethodInvokeExpr) {
            return 13;
        }
        if (expr instanceof BinaryOpExpr) {
            int val = this.innerAnalyzeCodeExpr(((BinaryOpExpr)expr).left);
            if (13 == val) {
                return 13;
            }
            return this.innerAnalyzeCodeExpr(((BinaryOpExpr)expr).right);
        }
        return 2;
    }

    private Map group(Context ctx, CoreBillBaseCollection srcObjCols, Set srcGroupProperty, List complexExpr, BOTMappingInfo botMappingInfo) throws BOSException {
        int i;
        LinkedHashMap groups = new LinkedHashMap();
        Iterator it = null;
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        Interpreter interpreter = new Interpreter(ctx);
        localCtx.put("__bosContext", ctx);
        List funcProviderList = new ArrayList();
        try {
            funcProviderList = BOTPTools.getBOTTransform((Context)ctx, (BOTMappingInfo)botMappingInfo).getFunctionProviderList();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int size = funcProviderList.size();
        for (i = 0; i < size; ++i) {
            interpreter.addFunctionProvider((IFunctionProvider)funcProviderList.get(i));
        }
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        size = srcObjCols.size();
        for (i = 0; i < size; ++i) {
            CoreBillBaseInfo info = srcObjCols.get(i);
            localCtx.put("__src", info);
            StringBuffer key = new StringBuffer();
            for (String prop : srcGroupProperty) {
                Object val = info.get(prop);
                if (val == null) {
                    key.append("null");
                } else if (val instanceof IObjectValue) {
                    key.append(((IObjectValue)val).get("id").toString());
                } else if (val instanceof BigDecimal) {
                    key.append(((BigDecimal)val).doubleValue());
                } else if (val instanceof Integer) {
                    key.append((Integer)val);
                } else {
                    key.append(val.toString());
                }
                key.append(";");
            }
            Object value = null;
            Iterator iter = complexExpr.iterator();
            while (iter.hasNext()) {
                String expr = iter.next().toString();
                value = interpreter.eval(expr, localCtx);
                if (value == null) continue;
                if (value instanceof IObjectValue) {
                    key.append(((IObjectValue)value).get("id").toString());
                    continue;
                }
                key.append(value);
            }
            List<ObjectUuidPK> aGroup = null;
            if (groups.containsKey(key.toString())) {
                aGroup = (List)groups.get(key.toString());
            } else {
                aGroup = new ArrayList();
                groups.put(key.toString(), aGroup);
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
            aGroup.add(pk);
        }
        return groups;
    }
}

