/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.app.dap.BaseRecorder;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.ICoreBillBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DAPTransmitRecorder {
    private BaseRecorder recorder = null;

    public DAPTransmitRecorder(String companyId, Context ctx) throws BOSException, EASBizException {
        this.recorder = new BaseRecorder(ctx, companyId, true);
    }

    public void generateVoucher(Context ctx, List<Map> list) throws BOSException, EASBizException {
        int i;
        HashMap groupByBillType = new HashMap();
        int size = list.size();
        BillTypeInfo billType = null;
        for (i = 0; i < size; ++i) {
            Map report = list.get(i);
            String billId = (String)report.get("billID");
            String billBosType = VcDapUtil.getBOSTypeById(billId).toString();
            int subSystem = Integer.valueOf(report.get("subSystem").toString());
            billType = VcDapUtil.getBillTypeByBOSType(ctx, billBosType, subSystem);
            report.put("billType", billType);
            List<Map> reportList = null;
            if (groupByBillType.containsKey(billBosType)) {
                reportList = (List)groupByBillType.get(billBosType);
            } else {
                reportList = new ArrayList();
                groupByBillType.put(billBosType, reportList);
            }
            reportList.add(report);
        }
        Set entrySet = groupByBillType.entrySet();
        for (Map.Entry entry : entrySet) {
            String bosType = (String)entry.getKey();
            ICoreBillBase icbb = VcDapUtil.getSrcBizInterface(ctx, BOSObjectType.create((String)bosType));
            List reportList = (List)entry.getValue();
            size = reportList.size();
            for (i = 0; i < size; ++i) {
                Map report = (Map)reportList.get(i);
                String billId = (String)report.get("billID");
                ObjectUuidPK rulePK = new ObjectUuidPK((String)report.get("botpRuleId"));
                IObjectPK[] rulePKs = new IObjectPK[]{rulePK};
                ObjectUuidPK srcPK = new ObjectUuidPK(billId);
                IObjectPK[] srcPKs = new IObjectPK[]{srcPK};
                billType = (BillTypeInfo)report.get("billType");
                this.recorder.generateVoucher(srcPKs, rulePKs, icbb, billType.getSubSystem().getValue());
            }
        }
    }
}

