/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.BusinessTypeInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTFactory;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailStateEnum;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaInfo;
import com.kingdee.eas.fi.vc.VoucherReportFactory;
import com.kingdee.eas.fi.vc.VoucherReportInfo;
import com.kingdee.eas.fi.vc.VoucherStateEnum;
import com.kingdee.eas.fi.vc.app.dap.BaseRecorder;
import com.kingdee.eas.fi.vc.app.dap.BillToRule;
import com.kingdee.eas.fi.vc.app.dap.BotEngineNew;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DAPTransmitRecorderForBillsAndRules {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.app.dap.DAPTransmitRecorderForBillsAndRules");
    private Set<BillToRule> billToRuleSet = new HashSet<BillToRule>();
    private Context ctx;
    private String[] billIds = null;
    private BillTypeInfo billType = null;
    private BusinessTypeInfo busiType = null;
    private OrgUnitInfo company = null;
    private CompanyOrgUnitInfo companyOrg = null;
    private ICoreBillBase icbb = null;
    private BOTMappingCollection botCol = null;
    private Map<String, Integer> botColMap = null;
    private BaseRecorder recorder = null;

    public DAPTransmitRecorderForBillsAndRules(String companyId, Context ctx, String[] billIds) throws BOSException, EASBizException {
        OrgUnitInfo company;
        this.company = company = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select id where id='" + companyId + "'");
        this.ctx = ctx;
        this.billIds = billIds;
        this.recorder = new BaseRecorder(ctx, companyId);
    }

    public void addBillToRule(BillToRule btr) {
        this.billToRuleSet.add(btr);
    }

    private void preprocessing(Map<String, List> rule_bills, Map<String, List> bill_rules, List<String> noRule, int subSystem, String type, boolean isSupportMultiBotp) throws EASBizException, BOSException {
        int len = this.billIds.length;
        Iterator<BillToRule> it = null;
        BillToRule btr2 = null;
        ArrayList<String> billToRuleTmp = null;
        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u4e2d\uff0c\u5c06\u5355\u636e\u8ddf\u89c4\u5219\u5206\u7ec4");
        for (int i = 0; i < len; ++i) {
            billToRuleTmp = new ArrayList<String>();
            String billId = this.billIds[i];
            for (BillToRule btr2 : this.billToRuleSet) {
                if (!billId.equals(btr2.getBillId())) continue;
                billToRuleTmp.add(btr2.getRuleId());
            }
            int size = billToRuleTmp.size();
            if (size <= 0) {
                noRule.add(billId);
                continue;
            }
            if (size == 1) {
                String ruleId = (String)billToRuleTmp.get(0);
                List<String> tmp = null;
                if (rule_bills.containsKey(ruleId)) {
                    tmp = rule_bills.get(ruleId);
                    tmp.add(billId);
                    continue;
                }
                tmp = new ArrayList();
                tmp.add(billId);
                rule_bills.put(ruleId, tmp);
                continue;
            }
            bill_rules.put(billId, billToRuleTmp);
        }
        this.processingBillRules(rule_bills, bill_rules, subSystem, type, isSupportMultiBotp);
    }

    private void processingBillRules(Map<String, List> rule_bills, Map<String, List> bill_rules, int subSystem, String type, boolean isSupportMultiBotp) throws EASBizException, BOSException {
        if (bill_rules.size() <= 0) {
            return;
        }
        String currId = bill_rules.keySet().iterator().next();
        BOSUuid uuid = BOSUuid.read((String)currId);
        BOSObjectType bosType = uuid.getType();
        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u5904\u7406\u6709\u591a\u89c4\u5219\u7684\u5355\u636e");
        LinkedHashMap<String, BOTMappingCollection> result = VcDapUtil.getRulesByCompanyAndBOSType(this.ctx, this.company.getId().toString(), bosType.toString());
        logger.error((Object)("\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u5904\u7406\u6709\u591a\u89c4\u5219\u7684\u5355\u636e\uff0c\u91cd\u65b0\u83b7\u53d6\u5230\u65b0\u7684\u89c4\u5219\uff1a" + result));
        ArrayList<Object> ruless = new ArrayList<Object>(result.size());
        for (BOTMappingCollection coll : result.values()) {
            if (coll.size() <= 0) continue;
            ArrayList rules = new ArrayList(coll.size());
            ruless.add(rules);
            for (int i = 0; i < coll.size(); ++i) {
                rules.add(coll.get(i).getId().toString());
            }
        }
        HashMap<String, List> newbill_rules = new HashMap<String, List>();
        HashSet<String> newBills = new HashSet<String>();
        for (String billId : bill_rules.keySet()) {
            List useRules = bill_rules.get(billId);
            for (Object rules : ruless) {
                int count = 0;
                String useRule = null;
                Iterator iterator = rules.iterator();
                while (iterator.hasNext()) {
                    String rule = (String)iterator.next();
                    if (!useRules.contains(rule)) continue;
                    useRule = rule;
                    ++count;
                }
                if (count == 1) {
                    ArrayList<String> tmps = rule_bills.get(useRule);
                    if (tmps == null) {
                        tmps = new ArrayList<String>();
                        rule_bills.put(useRule, tmps);
                    }
                    tmps.add(billId);
                    newBills.add(billId);
                    break;
                }
                if (count <= true) continue;
                break;
            }
            if (newBills.contains(billId)) continue;
            newbill_rules.put(billId, useRules);
        }
        HashMap newrule_bills = new HashMap();
        TreeMap rules = null;
        ArrayList minLevelRules = null;
        ArrayList<String> needDeleteBill = new ArrayList<String>();
        for (String billId : newbill_rules.keySet()) {
            List useRules = (List)newbill_rules.get(billId);
            rules = new TreeMap();
            int minLevel = 0;
            minLevelRules = new ArrayList();
            for (int i = 0; i < useRules.size(); ++i) {
                if (i == 0) {
                    minLevel = this.botColMap.get(useRules.get(i));
                }
                if (this.botColMap.get(useRules.get(i)) < minLevel) {
                    minLevel = this.botColMap.get(useRules.get(i));
                    minLevelRules.clear();
                    minLevelRules.add(useRules.get(i));
                    continue;
                }
                if (this.botColMap.get(useRules.get(i)) != minLevel) continue;
                minLevelRules.add(useRules.get(i));
            }
            if (minLevelRules.size() != 1) continue;
            ArrayList<String> oldList = rule_bills.get(minLevelRules.get(0));
            if (oldList == null || oldList.size() == 0) {
                oldList = new ArrayList<String>();
                oldList.add(billId);
                rule_bills.put(minLevelRules.get(0).toString(), oldList);
            } else {
                oldList.add(billId);
            }
            needDeleteBill.add(billId);
        }
        for (int i = 0; i < needDeleteBill.size(); ++i) {
            newbill_rules.remove(needDeleteBill.get(i));
        }
        bill_rules.clear();
        if (type != null && type.equals("GL") && isSupportMultiBotp) {
            HashMap mutiRuleMap = new HashMap();
            for (String billId : newbill_rules.keySet()) {
                List<String> idList;
                Map mutiMap;
                List useRules = (List)newbill_rules.get(billId);
                StringBuffer ruleIdSb = new StringBuffer();
                for (int i = 0; i < useRules.size(); ++i) {
                    ruleIdSb.append((String)useRules.get(i));
                }
                String mutiRuleKey = ruleIdSb.toString();
                if (mutiRuleMap.containsKey(mutiRuleKey)) {
                    mutiMap = (Map)mutiRuleMap.get(mutiRuleKey);
                    idList = (List)mutiMap.get("idList");
                    idList.add(billId);
                    continue;
                }
                mutiMap = new HashMap();
                idList = new ArrayList<String>();
                idList.add(billId);
                mutiMap.put("idList", idList);
                mutiMap.put("useRules", useRules);
                mutiRuleMap.put(mutiRuleKey, mutiMap);
            }
            for (String mutiRuleKey : mutiRuleMap.keySet()) {
                Map mutiMap = (Map)mutiRuleMap.get(mutiRuleKey);
                List idList = (List)mutiMap.get("idList");
                List useRules = (List)mutiMap.get("useRules");
                IObjectPK[] rulePKs = new IObjectPK[useRules.size()];
                for (int i = 0; i < useRules.size(); ++i) {
                    String ruleId = (String)useRules.get(i);
                    rulePKs[i] = new ObjectUuidPK(ruleId);
                }
                IObjectPK[] billIds = new IObjectPK[idList.size()];
                for (int i = 0; i < idList.size(); ++i) {
                    String billid = (String)idList.get(i);
                    billIds[i] = new ObjectUuidPK(billid);
                }
                if (type != null && type.equals("PCA")) {
                    this.recorder.generatePCVoucher(billIds, rulePKs, this.icbb, subSystem);
                    continue;
                }
                this.recorder.generateVoucher(billIds, rulePKs, this.icbb, subSystem);
            }
        } else {
            bill_rules.putAll(newbill_rules);
        }
        logger.error((Object)("\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u5904\u7406\u6709\u591a\u89c4\u5219\u7684\u5355\u636e\uff0c\u6700\u7ec8\u8fd4\u56de\u7684\u65b0\u7684\u5355\u636e\u8ddf\u89c4\u5219\u5bf9\u5e94\u5173\u7cfb\uff1a" + newbill_rules));
    }

    public void transformBill(Context ctx, String bostype, int subSystem) throws BOSException, EASBizException {
        this.icbb = VcDapUtil.getSrcBizInterface(ctx, BOSObjectType.create((String)bostype));
        SmartAccountingSchemaInfo schema = (SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo");
        SmartAccountEntryBusinessInfo busiInfo = (SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo");
        String ruleFilter = busiInfo.getRuleFilterSql();
        Map ruleParam = null;
        if (ruleFilter != null && ruleFilter.length() > 0) {
            ruleParam = VcDapUtil.getRuleFilterMap(ctx, ruleFilter);
        }
        HashMap<String, List> rule_bills = new HashMap<String, List>();
        HashMap<String, List> bill_rules = new HashMap<String, List>();
        ArrayList<String> noRule = new ArrayList<String>();
        this.preprocessing(rule_bills, bill_rules, noRule, subSystem, null, false);
        this.genReporters(ctx, bill_rules, noRule);
        BotEngineNew botEngineNew = new BotEngineNew();
        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\uff0c\u89c4\u5219\u5355\u636e\u5904\u7406\u5b8c\u6210\uff0c\u751f\u6210\u51ed\u8bc1\u5e76\u8bb0\u5f55\u65e5\u5fd7");
        Set es = rule_bills.entrySet();
        for (Map.Entry mEn : es) {
            String ruleId = (String)mEn.getKey();
            String[] billIds = new String[]{};
            billIds = ((List)mEn.getValue()).toArray(billIds);
            Map transGroups = botEngineNew.preMerge(ctx, billIds, ruleId);
            ObjectUuidPK rulePK = new ObjectUuidPK(ruleId);
            IObjectPK[] rulePKs = new IObjectPK[]{rulePK};
            Set entrySet = transGroups.entrySet();
            Iterator it = null;
            for (Map.Entry entry : entrySet) {
                IObjectPK[] srcBillPks = new IObjectPK[]{};
                srcBillPks = ((List)entry.getValue()).toArray(srcBillPks);
                List billList = (List)entry.getValue();
                String[] srcBillIds = new String[srcBillPks.length];
                for (int i = 0; i < srcBillPks.length; ++i) {
                    srcBillIds[i] = srcBillPks[i].toString();
                }
                this.recorder.transformBill(srcBillPks, srcBillIds, busiInfo.getBusinessType().getOperator(), rulePKs, subSystem);
            }
        }
    }

    public void generateVoucher(Context ctx, String bostype, int subSystem, String type) throws BOSException, EASBizException {
        this.generateVoucher(ctx, bostype, subSystem, type, false);
    }

    public void generateVoucher(Context ctx, String bostype, int subSystem, String type, boolean isSupportMultiBotp) throws BOSException, EASBizException {
        this.billType = VcDapUtil.getBillTypeByBOSType(ctx, bostype, subSystem);
        this.icbb = VcDapUtil.getSrcBizInterface(ctx, BOSObjectType.create((String)bostype));
        HashMap<String, List> rule_bills = new HashMap<String, List>();
        HashMap<String, List> bill_rules = new HashMap<String, List>();
        ArrayList<String> noRule = new ArrayList<String>();
        this.preprocessing(rule_bills, bill_rules, noRule, subSystem, type, isSupportMultiBotp);
        this.genReporters(ctx, bill_rules, noRule);
        BotEngineNew botEngineNew = new BotEngineNew();
        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\uff0c\u89c4\u5219\u5355\u636e\u5904\u7406\u5b8c\u6210\uff0c\u751f\u6210\u51ed\u8bc1\u5e76\u8bb0\u5f55\u65e5\u5fd7");
        Set es = rule_bills.entrySet();
        for (Map.Entry mEn : es) {
            String ruleId = (String)mEn.getKey();
            String[] billIds = new String[]{};
            billIds = ((List)mEn.getValue()).toArray(billIds);
            IObjectPK[] rulePKs = new IObjectPK[]{new ObjectUuidPK(ruleId)};
            ObjectUuidPK[] srcBillPks = new ObjectUuidPK[billIds.length];
            for (int i = 0; i < billIds.length; ++i) {
                ObjectUuidPK pk;
                srcBillPks[i] = pk = new ObjectUuidPK(billIds[i]);
            }
            if (type != null && type.equals("PCA")) {
                this.recorder.generatePCVoucher((IObjectPK[])srcBillPks, rulePKs, this.icbb, subSystem);
                continue;
            }
            this.recorder.generateVoucher((IObjectPK[])srcBillPks, rulePKs, this.icbb, subSystem);
        }
    }

    private void genReporters(Context ctx, Map bill_rules, List noRule) throws BOSException, EASBizException {
        CoreBaseCollection vrc = new CoreBaseCollection();
        Map.Entry me2 = null;
        Iterator it = null;
        Set s = null;
        Map billIdToInfo = this.getBillIdToInfo(bill_rules, noRule);
        String billId = null;
        CoreBillBaseInfo billInfo = null;
        if (billIdToInfo != null) {
            logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u5f00\u59cb");
            if (BOSObjectFactory.getContextFromThread() != null && BOSObjectFactory.getContextFromThread().get((Object)"isBackTask") != null && ctx.get((Object)"isSmartAccounting") != null) {
                BusinessTypeInfo busiType;
                SmartAccountEntryBusinessInfo busiInfo;
                SmartAccountingDetailRPTInfo vrii;
                logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u667a\u80fd\u6838\u7b97\u65e5\u5fd7");
                SmartAccountingSchemaInfo schemaInfo = (SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo");
                UserInfo userInfo = (UserInfo)BOSObjectFactory.getContextFromThread().get((Object)"userInfo");
                boolean isAutoProcess = Boolean.valueOf(BOSObjectFactory.getContextFromThread().get((Object)"isAutoProcess").toString());
                logger.error((Object)("\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0cisAutoProcess:" + isAutoProcess));
                if (bill_rules != null) {
                    logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u8bb0\u5f55\u591a\u89c4\u5219");
                    s = bill_rules.entrySet();
                    for (Map.Entry me2 : s) {
                        vrii = new SmartAccountingDetailRPTInfo();
                        billId = (String)me2.getKey();
                        billInfo = (CoreBillBaseInfo)billIdToInfo.get(billId);
                        vrii.put("company", this.company);
                        busiInfo = (SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo");
                        if (this.billType != null) {
                            vrii.setSubSystem(this.billType.getSubSystem());
                            vrii.setBusinessType(this.billType.getId().toString());
                            vrii.setBusinessNumber(this.billType.getBosObjectType());
                            vrii.setOperatorNumber("scpz");
                        } else {
                            busiType = busiInfo.getBusinessType();
                            vrii.setSubSystem(busiType.getSubSystem());
                            vrii.setBusinessType(busiType.getId().toString());
                            vrii.setBusinessNumber(busiType.getNumber());
                            vrii.setOperatorNumber(busiType.getOperator());
                        }
                        vrii.setBillID(billInfo.get("id").toString());
                        vrii.setBillNumber((String)billInfo.get("number"));
                        vrii.setBizDate((Date)billInfo.get("bizDate"));
                        vrii.setVoucherState(VoucherStateEnum.failForMultiDAP);
                        vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
                        vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                        if (isAutoProcess) {
                            vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                        } else {
                            vrii.setUser(userInfo);
                        }
                        vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                        vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                        vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                        vrii.setFailureCause(VoucherStateEnum.failForMultiDAP.getAlias());
                        List ruleIds = (List)me2.getValue();
                        vrii.setDapRuleIds(StringUtils.arrayToString((Object[])ruleIds.toArray(), (String)","));
                        vrc.addObject((IObjectValue)vrii);
                        logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u8bb0\u5f55\u591a\u89c4\u5219\uff0c\u5b8c\u6210");
                    }
                }
                if (noRule != null) {
                    logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219");
                    int len = noRule.size();
                    for (int i = 0; i < len; ++i) {
                        vrii = new SmartAccountingDetailRPTInfo();
                        billId = (String)noRule.get(i);
                        billInfo = (CoreBillBaseInfo)billIdToInfo.get(billId);
                        vrii.put("company", this.company);
                        busiInfo = (SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo");
                        if (this.billType != null) {
                            vrii.setSubSystem(this.billType.getSubSystem());
                            vrii.setBusinessType(this.billType.getId().toString());
                            vrii.setBusinessNumber(this.billType.getBosObjectType());
                            vrii.setOperatorNumber("scpz");
                        } else {
                            busiType = busiInfo.getBusinessType();
                            vrii.setSubSystem(busiType.getSubSystem());
                            vrii.setBusinessType(busiType.getId().toString());
                            vrii.setBusinessNumber(busiType.getNumber());
                            vrii.setOperatorNumber(busiType.getOperator());
                        }
                        vrii.setBillID(billInfo.get("id").toString());
                        vrii.setBillNumber((String)billInfo.get("number"));
                        vrii.setBizDate((Date)billInfo.get("bizDate"));
                        vrii.setVoucherState(VoucherStateEnum.failForNoDAP);
                        vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
                        vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                        if (isAutoProcess) {
                            vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                        } else {
                            vrii.setUser(userInfo);
                        }
                        vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                        vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                        vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                        vrii.setFailureCause(VoucherStateEnum.failForNoDAP.getAlias());
                        vrc.addObject((IObjectValue)vrii);
                    }
                    logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\u5b8c\u6210");
                }
                SmartAccountingDetailRPTFactory.getLocalInstance(ctx).submitBatchData(vrc);
            } else {
                VoucherReportInfo vri;
                if (bill_rules != null) {
                    s = bill_rules.entrySet();
                    for (Map.Entry me2 : s) {
                        vri = new VoucherReportInfo();
                        vrc.add((CoreBaseInfo)vri);
                        billId = (String)me2.getKey();
                        billInfo = (CoreBillBaseInfo)billIdToInfo.get(billId);
                        this.setCommonFieldInRecord(ctx, billInfo, vri);
                        vri.setVoucherState(VoucherStateEnum.failForMultiDAP);
                        List ruleIds = (List)me2.getValue();
                        vri.setFailureCause(VoucherStateEnum.failForMultiDAP.getAlias());
                        vri.setDapRuleIds(StringUtils.arrayToString((Object[])ruleIds.toArray(), (String)","));
                    }
                }
                if (noRule != null) {
                    int len = noRule.size();
                    for (int i = 0; i < len; ++i) {
                        vri = new VoucherReportInfo();
                        vrc.add((CoreBaseInfo)vri);
                        billId = (String)noRule.get(i);
                        billInfo = (CoreBillBaseInfo)billIdToInfo.get(billId);
                        this.setCommonFieldInRecord(ctx, billInfo, vri);
                        vri.setVoucherState(VoucherStateEnum.failForNoDAP);
                        vri.setFailureCause(VoucherStateEnum.failForNoDAP.getAlias());
                    }
                }
                VoucherReportFactory.getLocalInstance(ctx).submitBatchData(vrc);
            }
            logger.error((Object)"\u751f\u6210\u51ed\u8bc1\u8fc7\u7a0b\u4e2d\uff0c\u8bb0\u5f55\u65e0\u89c4\u5219\uff0c\u6216\u8005\u591a\u89c4\u5219\u7684\u65e5\u5fd7\uff0c\u8bb0\u5f55\u5b8c\u6210");
        }
    }

    private void setCommonFieldInRecord(Context ctx, CoreBillBaseInfo billInfo, VoucherReportInfo vri) throws EASBizException, BOSException {
        if (this.companyOrg == null) {
            this.companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id where id = '" + this.company.getId().toString() + "'");
        }
        vri.setCompany(this.companyOrg);
        vri.setSubSystem(this.billType.getSubSystem());
        vri.setBillType(this.billType);
        vri.setBillID(billInfo.get("id").toString());
        vri.setBillNumber((String)billInfo.get("number"));
        vri.setBizDate((Date)billInfo.get("bizDate"));
        vri.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
    }

    private Map getBillIdToInfo(Map bill_rules, List noRule) throws BOSException {
        int i = 0;
        int len = 0;
        Iterator it = null;
        StringBuffer buf = new StringBuffer();
        StringBuffer idOql = new StringBuffer();
        buf.append("select id, number, bizDate where id in (");
        Set s = null;
        if (bill_rules != null) {
            s = bill_rules.keySet();
            it = s.iterator();
            while (it.hasNext()) {
                idOql.append("'").append((String)it.next()).append("',");
            }
        }
        if (noRule != null) {
            len = noRule.size();
            for (i = 0; i < len; ++i) {
                idOql.append("'").append((String)noRule.get(i)).append("',");
            }
        }
        CoreBillBaseCollection billCol = null;
        if (idOql.length() > 0) {
            idOql.replace(idOql.length() - 1, idOql.length(), ")");
            buf.append(idOql.toString());
            billCol = this.icbb.getCoreBillBaseCollection(buf.toString());
        }
        if (billCol != null && billCol.size() > 0) {
            HashMap<String, CoreBillBaseInfo> idToInfo = new HashMap<String, CoreBillBaseInfo>();
            len = billCol.size();
            for (i = 0; i < len; ++i) {
                CoreBillBaseInfo billInfo = billCol.get(i);
                idToInfo.put(billInfo.getId().toString(), billInfo);
            }
            return idToInfo;
        }
        return null;
    }

    public BOTMappingCollection getBotCol() {
        return this.botCol;
    }

    public void setBotCol(BOTMappingCollection botCol) {
        this.botCol = botCol;
        this.botColMap = new HashMap<String, Integer>();
        for (int i = 0; i < botCol.size(); ++i) {
            this.botColMap.put(botCol.get(i).getId().toString(), (Integer)botCol.get(i).get("daplevel"));
        }
    }
}

