/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.BusinessTypeInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTFactory;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailStateEnum;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaInfo;
import com.kingdee.eas.fi.vc.VoucherReportFactory;
import com.kingdee.eas.fi.vc.VoucherReportInfo;
import com.kingdee.eas.fi.vc.VoucherStateEnum;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;

public class NoRuleRecorder {
    private String[] billIds = null;
    private CompanyOrgUnitInfo company = null;
    private BillTypeInfo billType;
    protected ICoreBillBase icbb = null;

    public NoRuleRecorder(String companyId, Context ctx, String[] billIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company;
        this.company = company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id where id = '" + companyId + "'");
        this.billIds = billIds;
    }

    public void record(Context ctx, String bostype, int subSystem) throws BOSException, EASBizException {
        if (BOSObjectFactory.getContextFromThread() != null && BOSObjectFactory.getContextFromThread().get((Object)"isBackTask") != null && ctx.get((Object)"isSmartAccounting") != null) {
            SmartAccountingSchemaInfo schemaInfo = (SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo");
            UserInfo userInfo = (UserInfo)BOSObjectFactory.getContextFromThread().get((Object)"userInfo");
            boolean isAutoProcess = Boolean.valueOf(BOSObjectFactory.getContextFromThread().get((Object)"isAutoProcess").toString());
            this.billType = VcDapUtil.getBillTypeByBOSType(ctx, bostype, subSystem);
            this.icbb = VcDapUtil.getSrcBizInterface(ctx, BOSObjectType.create((String)bostype));
            int i = 0;
            int len = 0;
            String operatorNumber = "";
            SmartAccountEntryBusinessInfo busiInfo = (SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo");
            SystemEnum subSys = null;
            String busiId = "";
            String busiNumber = "";
            if (busiInfo.getBusinessType() == null) {
                operatorNumber = "scpz";
                subSys = this.billType.getSubSystem();
                busiId = this.billType.getId().toString();
                busiNumber = this.billType.getBosObjectType();
            } else {
                BusinessTypeInfo busiType = busiInfo.getBusinessType();
                subSys = busiType.getSubSystem();
                busiId = busiType.getId().toString();
                busiNumber = busiType.getNumber();
                operatorNumber = busiInfo.getOperatorNumber();
            }
            CoreBaseCollection vrc = new CoreBaseCollection();
            StringBuffer buf = new StringBuffer();
            buf.append("select id, number, bizDate where id in (");
            len = this.billIds.length;
            for (i = 0; i < len; ++i) {
                buf.append("'").append(this.billIds[i]).append("',");
            }
            buf.replace(buf.length() - 1, buf.length(), ")");
            CoreBillBaseCollection billCol = this.icbb.getCoreBillBaseCollection(buf.toString());
            len = billCol.size();
            for (i = 0; i < len; ++i) {
                SmartAccountingDetailRPTInfo vrii = new SmartAccountingDetailRPTInfo();
                CoreBillBaseInfo billInfo = billCol.get(i);
                vrii.put("company", this.company);
                vrii.setSubSystem(subSys);
                vrii.setBusinessType(busiId);
                vrii.setBusinessNumber(busiNumber);
                vrii.setOperatorNumber(operatorNumber);
                vrii.setBillID(billInfo.get("id").toString());
                vrii.setBillNumber((String)billInfo.get("number"));
                vrii.setBizDate((Date)billInfo.get("bizDate"));
                vrii.setVoucherState(VoucherStateEnum.failForNoDAP);
                vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
                vrii.setSmartAccounting((SmartAccountingSchemaInfo)BOSObjectFactory.getContextFromThread().get((Object)"schemaInfo"));
                if (isAutoProcess) {
                    vrii.setUser(schemaInfo.getBackSchedule().getCreator());
                } else {
                    vrii.setUser(userInfo);
                }
                vrii.setSmartAccountEntryBusiness((SmartAccountEntryBusinessInfo)BOSObjectFactory.getContextFromThread().get((Object)"busiInfo"));
                vrii.setSmartAccountEntryCompany((SmartAccountEntryCompanyInfo)BOSObjectFactory.getContextFromThread().get((Object)"comInfo"));
                vrii.put("report", BOSObjectFactory.getContextFromThread().get((Object)"reportID"));
                vrii.setFailureCause(VoucherStateEnum.failForNoDAP.getAlias());
                vrc.addObject((IObjectValue)vrii);
            }
            SmartAccountingDetailRPTFactory.getLocalInstance(ctx).submitBatchData(vrc);
        } else {
            this.clearPreviousReport(ctx);
            this.billType = VcDapUtil.getBillTypeByBOSType(ctx, bostype, subSystem);
            this.icbb = VcDapUtil.getSrcBizInterface(ctx, BOSObjectType.create((String)bostype));
            int i = 0;
            int len = 0;
            CoreBaseCollection vrc = new CoreBaseCollection();
            StringBuffer buf = new StringBuffer();
            buf.append("select id, number, bizDate where id in (");
            len = this.billIds.length;
            for (i = 0; i < len; ++i) {
                buf.append("'").append(this.billIds[i]).append("',");
            }
            buf.replace(buf.length() - 1, buf.length(), ")");
            CoreBillBaseCollection billCol = this.icbb.getCoreBillBaseCollection(buf.toString());
            len = billCol.size();
            for (i = 0; i < len; ++i) {
                VoucherReportInfo vri = new VoucherReportInfo();
                vrc.add((CoreBaseInfo)vri);
                this.setCommonFieldInRecord(ctx, billCol.get(i), vri);
                vri.setVoucherState(VoucherStateEnum.failForNoDAP);
                vri.setFailureCause(VoucherStateEnum.failForNoDAP.getAlias());
            }
            VoucherReportFactory.getLocalInstance(ctx).submitBatchData(vrc);
        }
    }

    private void setCommonFieldInRecord(Context ctx, CoreBillBaseInfo billInfo, VoucherReportInfo vri) {
        vri.setCompany(this.company);
        vri.setSubSystem(this.billType.getSubSystem());
        vri.setBillType(this.billType);
        vri.setBillID(billInfo.get("id").toString());
        vri.setBillNumber((String)billInfo.get("number"));
        vri.setBizDate((Date)billInfo.get("bizDate"));
        vri.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
    }

    private void clearPreviousReport(Context ctx) throws BOSException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer buf = new StringBuffer().append("delete from T_VC_VoucherReport where ");
        buf.append("fUserID = '").append(userId).append("' ");
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }
}

