/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.app.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTReverseManager;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.BotpUtils;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.app.BOTAppTools;
import com.kingdee.eas.base.btp.app.BOTOrgUtils;
import com.kingdee.eas.base.core.IEASBillEntryInfo;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.base.dap.app.DAPAppTools;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeFactory;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.BusinessTypeFactory;
import com.kingdee.eas.fi.vc.BusinessTypeInfo;
import com.kingdee.eas.fi.vc.app.dap.BillToRule;
import com.kingdee.eas.fi.vc.app.dap.DAPTransmitRecorderForBillsAndRules;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseCollection;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class VcDapUtil {
    private static Logger logger = Logger.getLogger(VcDapUtil.class);
    protected static final String VOUCHERTYPE = "2652E01E";
    protected static final String TRANSMITCU = "TRANSMITCU";
    public static final int limitId = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreBillBaseCollection getSrcCollectionByIds(Context ctx, Object[] billIds, String[] selectFields) throws BOSException {
        logger.error((Object)("smartaccounting getSrcCollectionByIds\u83b7\u53d6\u5355\u636e\u7684\u96c6\u5408\uff0cbegin,billIds\uff1a" + billIds.length));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("id");
        if (selectFields != null) {
            SelectorItemCollection sic = entityViewInfo.getSelector();
            int len = selectFields.length;
            for (int i = 0; i < len; ++i) {
                sic.add(selectFields[i]);
            }
        }
        String tempTable = "";
        try {
            if (billIds.length <= 5000) {
                String strIdLists = StringUtils.arrayToString((Object[])billIds, (String)",");
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
                entityViewInfo.setFilter(filterInfo);
            } else {
                String createTableSql = "create table vc_temp_table (id varchar(44))";
                try {
                    tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                    String sql = "insert into " + tempTable + " values(?)";
                    ArrayList<String[]> paramsList = new ArrayList<String[]>();
                    for (Object id : billIds) {
                        paramsList.add(new String[]{id.toString()});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id in (select id from " + tempTable + ")"));
                    entityViewInfo.setFilter(filterInfo);
                }
                catch (Exception e) {
                    logger.error((Object)"create tempTable exception", (Throwable)e);
                    String strIdLists = StringUtils.arrayToString((Object[])billIds, (String)",");
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
                    entityViewInfo.setFilter(filterInfo);
                }
            }
            CoreBillBaseCollection sourceBillCollection = VcDapUtil.getSrcBizInterface(ctx, billIds[0].toString()).getCoreBillBaseCollection(entityViewInfo);
            logger.error((Object)("smartaccounting getSrcCollectionByIds\u83b7\u53d6\u5355\u636e\u7684\u96c6\u5408\uff0cend,sourceBillCollection\uff1a" + sourceBillCollection.size()));
            CoreBillBaseCollection coreBillBaseCollection = sourceBillCollection;
            return coreBillBaseCollection;
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    public static ICoreBillBase getSrcBizInterface(Context ctx, BOSObjectType srcBOSType) throws BOSException {
        ICoreBillBase bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBOSType.toString()));
        return bizCtrl;
    }

    public static BOSObjectType getBOSTypeById(String id) {
        return new ObjectUuidPK(id).getObjectType();
    }

    public static ICoreBillBase getSrcBizInterface(Context ctx, String billId) throws BOSException {
        return VcDapUtil.getSrcBizInterface(ctx, VcDapUtil.getBOSTypeById(billId));
    }

    public static Map getTransmitContext(Context ctx, String companyId) throws BOSException, EASBizException {
        OrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select id, CU.id where id='" + companyId + "'");
        logger.error((Object)("\u751f\u6210\u51ed\u8bc1\uff0c\u8c03\u7528\u83b7\u53d6dap\u89c4\u5219\u65b9\u6cd5getTransmitContext,\u83b7\u53d6cu\u7684\u516c\u53f8\u4e3a" + companyId));
        HashMap<String, CtrlUnitInfo> transCtx = new HashMap<String, CtrlUnitInfo>();
        transCtx.put(TRANSMITCU, org.getCU());
        return transCtx;
    }

    public static String getBillMainEntryName(String srcBOSType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)srcBOSType));
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return "entries";
    }

    public static List<String> getBillMainEntryNames(String srcBOSType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)srcBOSType));
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        Iterator propsIter = props.iterator();
        ArrayList<String> entryNames = new ArrayList<String>();
        while (propsIter.hasNext()) {
            RelationshipInfo relation;
            PropertyInfo propInfo = (PropertyInfo)propsIter.next();
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            entryNames.add(propInfo.getName());
        }
        if (entryNames.isEmpty()) {
            entryNames.add("entries");
        }
        return entryNames;
    }

    public static List getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    public static BOTMappingCollection getDAPRulesBySrcAndDestType(Context ctx, String srcBOSType, String targetBosType, DefineSysEnum defineSys, Map transmitContext) throws BOSException, BOTPException {
        BOTMappingCollection allBotMappingCols = new BOTMappingCollection();
        LinkedHashMap<String, BOTMappingCollection> result = VcDapUtil.doGetDAPRulesBySrcAndDestType(ctx, srcBOSType, targetBosType, defineSys, transmitContext);
        for (BOTMappingCollection coll : result.values()) {
            allBotMappingCols.addCollection(coll);
        }
        return allBotMappingCols;
    }

    public static LinkedHashMap<String, BOTMappingCollection> doGetDAPRulesBySrcAndDestType(Context ctx, String srcBOSType, String targetBosType, DefineSysEnum defineSys, Map transmitContext) throws BOSException, BOTPException {
        LinkedHashMap<String, BOTMappingCollection> result = new LinkedHashMap<String, BOTMappingCollection>();
        String orglongNumber = null;
        BOTMappingCollection newBotMappingCols = new BOTMappingCollection();
        String transmitCuId = null;
        if (transmitContext == null) {
            transmitCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        } else {
            transmitCuId = (String)transmitContext.get("TRANSMITCU_ID");
            if (StringUtils.isEmpty((String)transmitCuId)) {
                Object transmitCu = transmitContext.get(TRANSMITCU);
                transmitCuId = transmitCu != null && transmitCu instanceof CtrlUnitInfo ? ((CtrlUnitInfo)transmitCu).getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            }
        }
        String[] orgIDs = null;
        logger.error((Object)("SmartAccounting \u83b7\u53d6dap\u89c4\u5219\uff0cBOTPTools.isCtrlUintAuthor(ctx)\u4e3a+" + BOTPTools.isCtrlUintAuthor((Context)ctx)));
        if (!BOTPTools.isCtrlUintAuthor((Context)ctx)) {
            orgIDs = new String[]{transmitCuId, "00000000-0000-0000-0000-000000000000CCE7AED4"};
        } else {
            try {
                CtrlUnitInfo orgCu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo("select id,longNumber where id ='" + transmitCuId + "'");
                orglongNumber = orgCu.getLongNumber().toString();
                Object[] orgNumbers = orglongNumber.split("!");
                orgIDs = new String[orgNumbers.length];
                FilterInfo filterInfo = new FilterInfo();
                String strNumberLists = StringUtils.arrayToString((Object[])orgNumbers, (String)",");
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)strNumberLists, CompareType.INCLUDE));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                entityViewInfo.setFilter(filterInfo);
                SorterItemCollection sic = new SorterItemCollection();
                SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
                sortInfo.setSortType(SortType.DESCEND);
                sic.add(sortInfo);
                entityViewInfo.setSorter(sic);
                CtrlUnitCollection cucol = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(entityViewInfo);
                logger.error((Object)("SmartAccounting \u83b7\u53d6dap\u89c4\u5219\uff0corgIDs1\u4e3a+" + orgIDs));
                for (int i = 0; i < orgIDs.length; ++i) {
                    if (cucol.get(i) == null || cucol.get(i).getId() == null) continue;
                    orgIDs[i] = cucol.get(i).getId().toString();
                }
                logger.error((Object)("SmartAccounting \u83b7\u53d6dap\u89c4\u5219\uff0corgIDs2\u4e3a+" + orgIDs));
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
        }
        logger.error((Object)("SmartAccounting \u83b7\u53d6dap\u89c4\u5219\uff0corgIDs3\u4e3a+" + orgIDs));
        boolean hasSuperCtrlUnit = VcDapUtil.hasSuperCtrlUnit(ctx);
        logger.error((Object)("SmartAccounting \u83b7\u53d6dap\u89c4\u5219\uff0chasSuperCtrlUnit\u4e3a+" + hasSuperCtrlUnit));
        BOTMappingCollection retBotMappingCols = new BOTMappingCollection();
        for (int i = 0; i < orgIDs.length; ++i) {
            newBotMappingCols = VcDapUtil.getMappingByCUAfterCheck(ctx, srcBOSType, targetBosType, defineSys, orgIDs[i]);
            logger.error((Object)("SmartAccounting \u83b7\u53d6dap\u89c4\u5219\uff0c\u7ec4\u7ec7\uff1a" + orgIDs[i] + "\u7684\u89c4\u5219\uff0cnewBotMappingCols\u4e3a+" + newBotMappingCols));
            if (newBotMappingCols == null || newBotMappingCols.size() <= 0) continue;
            for (int j = 0; j < newBotMappingCols.size(); ++j) {
                newBotMappingCols.get(j).put("dapLevel", (Object)(i + 1));
                retBotMappingCols.add(newBotMappingCols.get(j));
            }
        }
        result.put(orgIDs[0], retBotMappingCols);
        return result;
    }

    public static boolean hasSuperCtrlUnit(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"BOTP_HAS_SUPER_CTRLUNIT");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static LinkedHashMap<String, BOTMappingCollection> getRulesByCompanyAndBOSType(Context ctx, String companyId, String bosType) throws BOSException, EASBizException {
        String badDeptBosType = null;
        if (bosType.equals("C9C8D8AF")) {
            badDeptBosType = bosType;
            bosType = "3C41FD86";
        }
        logger.error((Object)("\u751f\u6210\u51ed\u8bc1\uff0c\u8c03\u7528\u83b7\u53d6dap\u89c4\u5219\u65b9\u6cd5getRulesByCompanyAndBOSType,\u53d6\u7684\u662f\u516c\u53f8\u7684cu\u7684dap\u89c4\u5219\uff0c\u516c\u53f8\u4e3a" + companyId));
        LinkedHashMap<String, BOTMappingCollection> result = VcDapUtil.doGetDAPRulesBySrcAndDestType(ctx, bosType, VOUCHERTYPE, DefineSysEnum.DAP, VcDapUtil.getTransmitContext(ctx, companyId));
        logger.error((Object)("\u751f\u6210\u51ed\u8bc1\uff0c\u8c03\u7528\u83b7\u53d6dap\u89c4\u5219\u65b9\u6cd5getRulesByCompanyAndBOSType,\u89c4\u5219\u4e3a\uff1a" + result));
        if (badDeptBosType != null) {
            for (BOTMappingCollection col : result.values()) {
                for (int i = col.size() - 1; i >= 0; --i) {
                    String viewStr;
                    BOTMappingInfo mappingInfo = col.get(i);
                    EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping((BOTMappingInfo)mappingInfo);
                    if (view != null && ((viewStr = view.toString()).contains("verificationType = 111") || viewStr.contains("verificationType = 112"))) continue;
                    col.removeObject(i);
                }
            }
        }
        return result;
    }

    private static BOTMappingCollection getMappingByCUAfterCheck(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, String transmitID) throws BOTPException, BOSException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        try {
            botMappingCols = BOTMappingHelper.getMappingForSelectByCU((Context)ctx, (String)srcBillType, (String)targetBosType, (DefineSysEnum)defineSys, (String)transmitID);
            if (botMappingCols == null || botMappingCols.size() <= 0) {
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u53d6dap\u89c4\u5219\uff0cgetMappingByCUAfterCheck\u65b9\u6cd5\u4e2d\uff0c\u53d6cu\u7684\u89c4\u5219\u51fa\u9519\uff0c\u6ca1\u6709dap\u89c4\u5219,\u73b0\u5728\u53d6\u7684\u7ec4\u7ec7id\uff1a" + transmitID));
        }
        logger.error((Object)("\u53d6dap\u89c4\u5219\uff0cgetMappingByCUAfterCheck\u65b9\u6cd5\u4e2d\uff0c\u73b0\u5728\u53d6\u7684\u7ec4\u7ec7cuid\uff1a" + transmitID + ",\u89c4\u5219\u7cfb\u7edf" + defineSys.getAlias() + "srcBillType \u4e3a" + srcBillType + "targetBosType\u4e3a" + targetBosType + "\u89c4\u5219\u4e3a" + botMappingCols));
        return botMappingCols;
    }

    private static String getOrderSql(Context ctx) {
        return " ORDER BY MAPPING.FAlias_" + ctx.getLocale().toString() + " schinese_pinyin ASC";
    }

    private static IRowSet getMappingAllCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + VcDapUtil.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + VcDapUtil.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
        } else if (sourceBillType != null) {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + VcDapUtil.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + VcDapUtil.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        } else {
            ArrayList<Integer> paramsWithoutDefineSys = new ArrayList<Integer>();
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            sql = sql + VcDapUtil.getOrderSql(ctx);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        }
        return rs;
    }

    public static BOTMappingCollection getBOTMappingCollectionForSelectByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitID, boolean isAllCUMode) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = null;
            if (isAllCUMode) {
                rowset = VcDapUtil.getMappingAllCUForSelect(ctx, sourceBillType, targetBillType, defineSys);
            }
            if (rowset != null || rowset.size() > 0) {
                while (rowset.next()) {
                    BOTMappingInfo mappingInfo = new BOTMappingInfo();
                    mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                    mappingInfo.setName(rowset.getString("FNAME"));
                    mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
                    mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                    mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                    mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
                    mappingInfo.setDefineSys(DefineSysEnum.getEnum((int)rowset.getInt("FDEFINESYS")));
                    mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
                    mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
                    mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
                    mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
                    mappingInfo.setMappingType(MappingTypeEnum.getEnum((int)rowset.getInt("FMappingType")));
                    BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                    extRule.setFilter(rowset.getString("FFILTER"));
                    extRule.setDataFilter(rowset.getString("FDATAFILTER"));
                    extRule.setIsEffected(true);
                    String orgId = rowset.getString("FORGID");
                    if (!StringUtils.isEmpty((String)orgId)) {
                        CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                        org.setId(BOSUuid.read((String)orgId));
                        extRule.setOrg(org);
                    }
                    mappingInfo.setExtRule(extRule);
                    result.add(mappingInfo);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, (Throwable)exc);
        }
        return result;
    }

    public static DAPTransmitRecorderForBillsAndRules checkBotMapping(Context ctx, String companyId, String[] srcBillIDs, String[] entrieNames, List entriesKeys, BOTMappingCollection botMappingCols) throws BOSException, EASBizException {
        DAPTransmitRecorderForBillsAndRules recorder = new DAPTransmitRecorderForBillsAndRules(companyId, ctx, srcBillIDs);
        logger.error((Object)"smartaccounting checkBotMapping\uff0c\u62c6\u5206\u5355\u636e\u8ddf\u89c4\u5219,begin");
        BOTMappingCollection checkBotMappingCols = new BOTMappingCollection();
        for (int i = 0; i < botMappingCols.size(); ++i) {
            BOTMappingInfo mappingInfo = botMappingCols.get(i);
            if (BOTRuleFilterTools.isShowBOTPWithRuleFilter((Context)ctx) && BOTRuleFilterTools.isExistBOTRuleFilter((BOTMappingInfo)mappingInfo)) {
                checkBotMappingCols.add(mappingInfo);
                continue;
            }
            VcDapUtil.addAllBillInRecorder(recorder, srcBillIDs, mappingInfo.getId().toString());
        }
        if (checkBotMappingCols.size() > 0) {
            String currId = srcBillIDs[0];
            BOSUuid uuid = BOSUuid.read((String)currId);
            BOSObjectType bosType = uuid.getType();
            HashMap<String, Object> entriesKeysMap = new HashMap<String, Object>();
            for (int k = 0; k < entriesKeys.size(); ++k) {
                entriesKeysMap.put(entriesKeys.get(k).toString(), null);
            }
            for (int i = 0; i < checkBotMappingCols.size(); ++i) {
                BOTMappingInfo mappingInfo = checkBotMappingCols.get(i);
                VcDapUtil.checkIsErrorBotpRuleFilterByStep(ctx, bosType, srcBillIDs, entrieNames, entriesKeysMap, mappingInfo, recorder);
            }
        }
        logger.error((Object)"smartaccounting checkBotMapping\uff0c\u62c6\u5206\u5355\u636e\u8ddf\u89c4\u5219,end");
        return recorder;
    }

    private static void addAllBillInRecorder(DAPTransmitRecorderForBillsAndRules recorder, String[] billIds, String ruleId) {
        int len = billIds.length;
        for (int j = 0; j < len; ++j) {
            recorder.addBillToRule(new BillToRule(billIds[j], ruleId));
        }
    }

    private static void addAllBillInRecorder(DAPTransmitRecorderForBillsAndRules recorder, CoreBillBaseCollection realObjectCols, String ruleId) {
        int len = realObjectCols.size();
        for (int j = 0; j < len; ++j) {
            recorder.addBillToRule(new BillToRule(realObjectCols.get(j).getId().toString(), ruleId));
        }
    }

    public static BOTMappingCollection getDAPMeetAllBills(Context ctx, String bostype, String[] billIds, BOTMappingCollection dapCollection) throws BOSException {
        Object view = null;
        BOTMappingInfo mapInfo = null;
        int billNum = billIds.length;
        CoreBillBaseCollection filteredCols = null;
        for (int i = dapCollection.size() - 1; i >= 0; --i) {
            mapInfo = dapCollection.get(i);
            filteredCols = VcDapUtil.filterByRule(ctx, BOSObjectType.create((String)bostype), billIds, mapInfo);
            if (filteredCols != null && filteredCols.size() == billNum) continue;
            dapCollection.removeObject(i);
        }
        return dapCollection;
    }

    private static CoreBillBaseCollection filterByRule(Context ctx, BOSObjectType bosType, String[] srcBillIDs, BOTMappingInfo mappingInfo) throws BOSException {
        int iTotal = srcBillIDs.length;
        int iStep = 800;
        int iMax = iTotal % iStep == 0 ? iTotal / iStep : iTotal / iStep + 1;
        boolean bAllEmptyViewFilter = true;
        CoreBillBaseCollection realObjectCols = null;
        int resultSize = 0;
        logger.error((Object)"smartaccounting filterByRule,\u8fc7\u6ee4\u89c4\u5219\u8ddf\u5355\u636e,begin");
        EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping((BOTMappingInfo)mappingInfo);
        boolean hasEntryFilter = false;
        if (view.getEntryFilters() != null && view.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
        }
        for (int i = 0; i < iMax; ++i) {
            int iTempTotal = iStep;
            if (i == iMax - 1 && iMax * iStep != iTotal) {
                iTempTotal = iTotal % iStep;
            }
            int iStart = i * iStep;
            int iEnd = iStart + iTempTotal;
            String[] newIDs = new String[iTempTotal];
            for (int j = 0; j < iTempTotal; ++j) {
                newIDs[j] = srcBillIDs[iStart + j];
            }
            EntityViewInfo stepView = BOTRuleFilterTools.getRuleFilter((String[])newIDs, (BOTMappingInfo)mappingInfo);
            if (stepView == null) continue;
            bAllEmptyViewFilter = false;
            CoreBillBaseCollection filteredCols = VcDapUtil.getSrcBillCollection(ctx, bosType.toString(), stepView);
            if (filteredCols == null || filteredCols.size() <= 0) continue;
            if (realObjectCols == null) {
                realObjectCols = filteredCols;
                continue;
            }
            resultSize += filteredCols.size();
            realObjectCols.addObjectCollection((IObjectCollection)filteredCols);
        }
        if (bAllEmptyViewFilter) {
            HashSet<String> s = new HashSet<String>();
            int size = srcBillIDs.length;
            for (int i = 0; i < size; ++i) {
                s.add(srcBillIDs[i]);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", s, CompareType.INCLUDE));
            evi.setFilter(fi);
            realObjectCols = VcDapUtil.getSrcBillCollection(ctx, bosType.toString(), evi);
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return null;
        }
        if (hasEntryFilter) {
            int n = view.getEntryFilters().size();
            for (int j = 0; j < n; ++j) {
                String entryName = view.getEntryFilters().get(j).getEntryName();
                for (int i = realObjectCols.size() - 1; i >= 0; --i) {
                    IObjectValue filteredInfo = realObjectCols.getObject(i);
                    Object objColl = filteredInfo.get(entryName);
                    if (objColl != null && objColl instanceof IObjectCollection && ((IObjectCollection)objColl).size() > 0) continue;
                    realObjectCols.removeObject(i);
                }
            }
        }
        DAPAppTools.execDataFilterMultiEntry((Context)ctx, realObjectCols, (BOTMappingInfo)mappingInfo);
        logger.error((Object)"smartaccounting filterByRule,\u8fc7\u6ee4\u89c4\u5219\u8ddf\u5355\u636e,begin");
        return realObjectCols;
    }

    private static void checkIsErrorBotpRuleFilterByStep(Context ctx, BOSObjectType bosType, String[] srcBillIDs, String[] entrieNames, Map entriesKeysMap, BOTMappingInfo mappingInfo, DAPTransmitRecorderForBillsAndRules recorder) throws BOSException {
        CoreBillBaseCollection realObjectCols = VcDapUtil.filterByRule(ctx, bosType, srcBillIDs, mappingInfo);
        if (realObjectCols != null && realObjectCols.size() > 0) {
            VcDapUtil.addAllBillInRecorder(recorder, realObjectCols, mappingInfo.getId().toString());
        }
    }

    private static CoreBillBaseCollection getSrcBillCollection(Context ctx, String srcBillType, EntityViewInfo evi) throws BOSException {
        BOSObjectType bosType = BOSObjectType.create((String)srcBillType);
        ICoreBillBase bizCtrl = VcDapUtil.createInterface(ctx, bosType);
        CoreBillBaseCollection sourceBillCollection = null;
        try {
            sourceBillCollection = bizCtrl.getCoreBillBaseCollection(evi);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    public static ICoreBillBase createInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        ICoreBillBase bizCtrl = null;
        if (ctx == null) {
            Class<?> model;
            BusinessObjectInfo meta = MetaDataLoaderFactory.getRemoteMetaDataLoader().getBusinessObject(bosType);
            String interfaceClass = meta.getBusinessInterface();
            try {
                model = Class.forName(interfaceClass);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            bizCtrl = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, model);
        } else {
            bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        }
        return bizCtrl;
    }

    public static void processBizObjectInfoAfterTransform(Context ctx, BOTMappingInfo mappingInfo, BTPTransformResult btpResult) throws BOSException, EASBizException {
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection relations = btpResult.getBOTRelationCollection();
        try {
            String orgPropertyName = null;
            if (destBillCols.size() > 0) {
                orgPropertyName = BOTOrgUtils.getOrgPropertyNameByCoreBillBaseInfo((CoreBillBaseInfo)((CoreBillBaseInfo)destBillCols.getObject(0)));
            }
            HashMap contextMap = new HashMap();
            VcDapUtil.checkRebuild(ctx, relations);
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                Context bosctx;
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                int tempSaveMdoe = mappingInfo.getIsTempSave();
                if (tempSaveMdoe == 1 || mappingInfo.getIsTempSave() == 2) {
                    VcDapUtil.handleAfterTransform(ctx, "SAVE", (IObjectValue)destBillInfo, mappingInfo.getId().toString(), (IObjectCollection)relations);
                    bosctx = VcDapUtil.switchOrgIfNeed(ctx, destBillInfo, orgPropertyName, contextMap);
                    VcDapUtil.innerSaveModelAndRelations(bosctx, (IObjectValue)destBillInfo, (IObjectCollection)relations, false, false);
                    continue;
                }
                if (tempSaveMdoe != 0) continue;
                VcDapUtil.handleAfterTransform(ctx, "SUBMIT", (IObjectValue)destBillInfo, mappingInfo.getId().toString(), (IObjectCollection)relations);
                bosctx = VcDapUtil.switchOrgIfNeed(ctx, destBillInfo, orgPropertyName, contextMap);
                VcDapUtil.innerSubmitModelAndRelations(bosctx, (IObjectValue)destBillInfo, (IObjectCollection)relations, false, false);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(BTPException.CALLBACKBIZERR, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            throw e;
        }
    }

    public static IObjectPK innerSubmitModelAndRelations(Context ctx, IObjectValue model, IObjectCollection relations, boolean isclearCache, boolean ischeckPermission) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            boolean isNew;
            CoreBillBaseInfo baseinfo;
            block13: {
                baseinfo = (CoreBillBaseInfo)model;
                IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)model.getBOSType());
                ICoreBillBase iBillBase = (ICoreBillBase)obj;
                isNew = BOTAppTools.isNewObjectValue((Context)ctx, (IObjectValue)model, (ICoreBillBase)iBillBase);
                if (ischeckPermission && VcDapUtil.isCheckPermission(ctx)) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                try {
                    pk = iBillBase.submit((CoreBaseInfo)baseinfo);
                    if (relations != null && relations.size() != 0) break block13;
                    IObjectPK iObjectPK = pk;
                    return iObjectPK;
                }
                catch (Exception ee) {
                    logger.error((Object)"\u5355\u636e\u63d0\u4ea4\u5931\u8d25\u65f6\uff0c\u56de\u6536\u7f16\u53f7recycleNumber   -------------------");
                    logger.error((Object)ee.getMessage(), (Throwable)ee);
                    try {
                        if (baseinfo != null && baseinfo.getNumber() != null) {
                            iBillBase.recycleNumber(baseinfo, null, null, null, baseinfo.getNumber());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    throw ee;
                }
            }
            boolean isReverseWrite = BOTAppTools.isNeedSubmitReverseWrite((Context)ctx, (IObjectValue)model);
            VcDapUtil.innerRecalcRelationsAndReverseWrite(ctx, baseinfo, relations, isNew, isReverseWrite);
            IObjectPK iObjectPK = pk;
            return iObjectPK;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BOTObjectCache.getInstance((Context)ctx).clear();
        }
    }

    public static boolean isCheckPermission(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"CHECK_SUBMITPERMISSION");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u7279\u6b8a\u6743\u9650\u8bbe\u7f6e\u51fa\u9519   " + e.getMessage()));
            return false;
        }
        return false;
    }

    public static void innerRecalcRelationsAndReverseWrite(Context ctx, CoreBillBaseInfo destObjectInfo, IObjectCollection relations, boolean isNew, boolean isNeedReverse) throws EASBizException, BOSException {
        if (destObjectInfo.getId() == null) {
            throw new BOSException("The baseinfo'id can't be null!");
        }
        BOTRelationCollection botRelationColls = new BOTRelationCollection();
        BOTRelationCollection deleteRelationCol = new BOTRelationCollection();
        BOTRelationEntryCollection deleteRelationEntryCol = new BOTRelationEntryCollection();
        BOTRelationEntryCollection updateRelationEntryCol = new BOTRelationEntryCollection();
        boolean isDelRelationsWithoutEntries = BOTAppTools.isDelRelationsWithoutEntries((Context)ctx, (IObjectValue)destObjectInfo);
        BOTMappingInfo botMappingInfo = null;
        HashMap entryIdValueMap = new HashMap();
        CoreBillEntryBaseCollection billBaseEntries = new CoreBillEntryBaseCollection();
        boolean hasReversed = false;
        int count = relations.size();
        for (int i = 0; i < count; ++i) {
            BOTRelationInfo currRelationInfo;
            String botMappingId = ((BOTRelationInfo)relations.getObject(i)).getBOTMappingID();
            BOTRelationInfo oldRelationInfo = (BOTRelationInfo)relations.getObject(i);
            if (!oldRelationInfo.getDestObjectID().equals(destObjectInfo.getId().toString())) continue;
            hasReversed = oldRelationInfo.isIsEffected();
            if (botMappingId == null || botMappingId.length() < 1) {
                currRelationInfo = (BOTRelationInfo)oldRelationInfo.clone();
                botRelationColls.add(currRelationInfo);
                continue;
            }
            botMappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingId, ctx);
            currRelationInfo = VcDapUtil.getNewRelationInfo(ctx, botMappingInfo, deleteRelationEntryCol, oldRelationInfo, (IObjectCollection)billBaseEntries, destObjectInfo, isNew, isNeedReverse);
            if (currRelationInfo == null) {
                deleteRelationCol.add(oldRelationInfo);
                deleteRelationEntryCol.addCollection(oldRelationInfo.getRelationEntries());
                continue;
            }
            botRelationColls.add(currRelationInfo);
            VcDapUtil.addUpRelationValue(entryIdValueMap, currRelationInfo);
        }
        if (entryIdValueMap.size() > 0 && isNeedReverse) {
            VcDapUtil.prepareGetSrcBillAndEntrys(ctx, (BOTRelationCollection)relations);
        }
        if (entryIdValueMap.size() > 0) {
            VcDapUtil.resetEntryRelationValue(ctx, updateRelationEntryCol, destObjectInfo, botRelationColls, entryIdValueMap, (IObjectCollection)billBaseEntries);
        }
        CoreBillBaseCollection destObjCol = new CoreBillBaseCollection();
        destObjCol.addObject((IObjectValue)destObjectInfo);
        if (!(isNew || deleteRelationCol.size() <= 0 && deleteRelationEntryCol.size() <= 0)) {
            if (botRelationColls.size() == 0 && isDelRelationsWithoutEntries) {
                throw new BOSException("could not remove all botrelations when save or submit bills!");
            }
            VcDapUtil.updateOrDeleleBatchSql(ctx, 1, "t_bot_relation", null, null, (IObjectCollection)deleteRelationCol);
            VcDapUtil.updateOrDeleleBatchSql(ctx, 1, "t_bot_relationentry", null, null, (IObjectCollection)deleteRelationEntryCol);
            if (hasReversed) {
                BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
                botReverseManager.setOprtState(BOTBillOperStateEnum.DELETE);
                if (deleteRelationCol.size() > 0) {
                    botReverseManager.delReverseWriteBatch((IObjectCollection)deleteRelationCol, (IObjectCollection)destObjCol);
                } else {
                    botReverseManager.delReverseWriteByEntryRelation((IObjectCollection)deleteRelationEntryCol, relations, (IObjectCollection)destObjCol);
                }
            }
        }
        if (botMappingInfo != null) {
            VcDapUtil.removeEntryRelation(ctx, botRelationColls, botMappingInfo);
        }
        VcDapUtil.insertBOTRelation(ctx, botRelationColls);
        if (isNeedReverse) {
            VcDapUtil.updateOrDeleleBatchSql(ctx, 0, "t_bot_relation", "FisEffected", true, (IObjectCollection)botRelationColls);
            if (isNew) {
                VcDapUtil.reverseWriteBatch(ctx, (IObjectCollection)botRelationColls, BOTBillOperStateEnum.ADDNEW, (IObjectCollection)destObjCol, hasReversed);
            } else {
                VcDapUtil.reverseWriteBatch(ctx, (IObjectCollection)botRelationColls, BOTBillOperStateEnum.EDIT, (IObjectCollection)destObjCol, hasReversed);
            }
        }
    }

    public static void reverseWriteBatch(Context ctx, IObjectCollection botRelations, BOTBillOperStateEnum botBillOprtState, IObjectCollection destObjCol, boolean hasReversed) throws BOSException, EASBizException {
        BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
        botReverseManager.setOprtState(botBillOprtState);
        botReverseManager.reverseWriteBatch((IObjectCollection)((BOTRelationCollection)botRelations), destObjCol, hasReversed);
    }

    public static void insertBOTRelation(Context ctx, BOTRelationCollection botRelationColls) throws BOSException {
        int tmpRelationSize = 0;
        int tmpRelationEntrySize = 0;
        BOTRelationInfo botRelationInfo = null;
        BOTRelationEntryCollection relationEntryCollection = null;
        BOTRelationEntryInfo relationEntryInfo = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsEntryList = new ArrayList<Object[]>();
        String sql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (?,?,?,?,?,?,?,?,?,?)";
        String sqlEntry = "insert into t_bot_relationentry (FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID) values (?,?,?,?,?,?,?,?,?,?,?)";
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int count = botRelationColls.size();
        for (int i = 0; i < count; ++i) {
            botRelationInfo = botRelationColls.get(i);
            if (ibotRelation.exists((IObjectPK)new ObjectUuidPK(botRelationInfo.getId().toString()))) continue;
            Object[] params = new Object[]{botRelationInfo.getId().toString(), botRelationInfo.getSrcEntityID(), botRelationInfo.getDestEntityID(), botRelationInfo.getSrcObjectID(), botRelationInfo.getDestObjectID(), botRelationInfo.getDate() != null ? new Timestamp(botRelationInfo.getDate().getTime()) : new Timestamp(System.currentTimeMillis()), botRelationInfo.getOperatorID(), new Boolean(botRelationInfo.isIsEffected()), botRelationInfo.getBOTMappingID(), new Integer(botRelationInfo.getType())};
            paramList.add(params);
            tmpRelationSize = paramList.size();
            if (tmpRelationSize > 2000) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                paramList.clear();
                tmpRelationSize = 0;
            }
            relationEntryCollection = botRelationInfo.getRelationEntries();
            for (int j = 0; j < relationEntryCollection.size(); ++j) {
                relationEntryInfo = relationEntryCollection.get(j);
                String entryid = null;
                entryid = relationEntryInfo.getId() == null ? BOSUuid.create((String)"B99C354C").toString() : relationEntryInfo.getId().toString();
                Object[] paramsEntry = new Object[]{entryid, relationEntryInfo.getSrcObjectID(), relationEntryInfo.getDestObjectID(), relationEntryInfo.getSrcEntryID(), relationEntryInfo.getDestEntryID(), relationEntryInfo.getSrcEntryPropName(), relationEntryInfo.getDestEntryPropName(), relationEntryInfo.getSrcPropertyName(), relationEntryInfo.getDestPropertyName(), relationEntryInfo.getValue(), botRelationInfo.getId().toString()};
                paramsEntryList.add(paramsEntry);
                tmpRelationEntrySize = paramsEntryList.size();
                if (tmpRelationEntrySize <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sqlEntry, paramsEntryList);
                paramsEntryList.clear();
                tmpRelationEntrySize = 0;
            }
        }
        if (tmpRelationSize != 0) {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
            paramList.clear();
        }
        if (tmpRelationEntrySize != 0) {
            DbUtil.executeBatch((Context)ctx, (String)sqlEntry, paramsEntryList);
            paramsEntryList.clear();
        }
    }

    public static void removeEntryRelation(Context ctx, BOTRelationCollection botRelationCollection, BOTMappingInfo botMappingInfo) {
        for (int i = 0; i < botRelationCollection.size(); ++i) {
            BOTRelationInfo botRelationInfo = botRelationCollection.get(i);
            String botMappingId = botRelationInfo.getBOTMappingID();
            if (botMappingId == null || "".equals(botMappingId)) continue;
            boolean isNeedSaveEntries = true;
            try {
                isNeedSaveEntries = VcDapUtil.isNeedSaveEntries(ctx, botMappingInfo);
            }
            catch (EASBizException eASBizException) {
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            if (isNeedSaveEntries) continue;
            botRelationInfo.getRelationEntries().clear();
        }
    }

    public static void updateOrDeleleBatchSql(Context ctx, int type, String tableName, String fieldName, Object value, IObjectCollection col) throws BOSException {
        if (col == null || col.size() == 0 || tableName == null) {
            return;
        }
        String sql = type == 0 ? "UPDATE " + tableName + " SET " + fieldName + " = ? WHERE FID in (" : "DELETE FROM " + tableName + "  WHERE FID in (";
        int step = 200;
        int tempCount = 0;
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            if (tempCount != 0) {
                idStr.append(",");
            }
            idStr.append("'" + col.getObject(i).get("id").toString() + "'");
            if (++tempCount <= 200) continue;
            if (type == 0) {
                DbUtil.execute((Context)ctx, (String)(sql + idStr + ")"), (Object[])new Object[]{value});
            } else {
                DbUtil.execute((Context)ctx, (String)(sql + idStr + ")"));
            }
            idStr = new StringBuffer();
            tempCount = 0;
        }
        if (tempCount > 0) {
            if (type == 0) {
                DbUtil.execute((Context)ctx, (String)(sql + idStr + ")"), (Object[])new Object[]{value});
            } else {
                DbUtil.execute((Context)ctx, (String)(sql + idStr + ")"));
            }
        }
    }

    public static void resetEntryRelationValue(Context ctx, BOTRelationEntryCollection updateRelationEntryCol, CoreBillBaseInfo destObjectInfo, BOTRelationCollection botRelationColls, HashMap entryIdValueMap, IObjectCollection billBaseEntries) throws DataAccessException, BOSException, BTPException {
        String mappingId = botRelationColls.get(0).getBOTMappingID();
        if (mappingId == null) {
            return;
        }
        BOTMappingInfo botMappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(mappingId, ctx);
        String destEntriesName = BOTMappingUtil.getDestEntriesName((Context)ctx, (BOTMappingInfo)botMappingInfo);
        billBaseEntries = (IObjectCollection)destObjectInfo.get(destEntriesName);
        if (billBaseEntries == null) {
            return;
        }
        Iterator entryIter = entryIdValueMap.keySet().iterator();
        boolean idx = false;
        BigDecimal ZERO = new BigDecimal("0");
        while (entryIter.hasNext()) {
            String destEntryId = (String)entryIter.next();
            HashMap destPropertyValueMap = (HashMap)entryIdValueMap.get(destEntryId);
            CoreBillBaseInfo destBillInfo = null;
            if (destEntryId.charAt(0) != '0') continue;
            boolean isDestEntry = false;
            if ((destEntryId = destEntryId.substring(1)).equals(destObjectInfo.getId().toString())) {
                destBillInfo = destObjectInfo;
            }
            if (destBillInfo == null) continue;
            for (String destPropertyName : destPropertyValueMap.keySet()) {
                BigDecimal value = (BigDecimal)destPropertyValueMap.get(destPropertyName);
                BigDecimal destValue = null;
                if (!isDestEntry) {
                    destValue = new BigDecimal(destBillInfo.get(destPropertyName).toString());
                } else {
                    String[] destProps = StringUtil.split((String)destPropertyName, (String)".");
                    if (destProps.length == 2 && destProps[0].equals(destEntriesName)) {
                        destValue = new BigDecimal(destBillInfo.get(destProps[1]).toString());
                    }
                }
                if (destValue == null || destValue.compareTo(value) == 0) continue;
                BigDecimal diff = destValue.subtract(value);
                int zCount = botRelationColls.size();
                for (int z = 0; z < zCount; ++z) {
                    BOTRelationInfo botRelationInfo = botRelationColls.get(z);
                    String botMappingId = botRelationInfo.getBOTMappingID();
                    if (botMappingId == null || botMappingId.length() < 1) continue;
                    int reCount = botRelationInfo.getRelationEntries().size();
                    for (int k = 0; k < reCount; ++k) {
                        String sql;
                        String srcEntryId;
                        String srcEntryNameInBot;
                        BigDecimal botRelaValue;
                        String botValueStr;
                        String destEntryIdInBot;
                        BOTRelationEntryInfo botRelationEntryInfo = botRelationInfo.getRelationEntries().get(k);
                        String destPropertyNameInBot = botRelationEntryInfo.getDestPropertyName();
                        String destEntryNameInBot = botRelationEntryInfo.getDestEntryPropName();
                        if (destEntryNameInBot != null && destEntryNameInBot.startsWith("__dest.")) {
                            destEntryNameInBot = destEntryNameInBot.substring("__dest.".length());
                            destPropertyNameInBot = destEntryNameInBot + "." + destPropertyNameInBot;
                        }
                        if (destPropertyNameInBot == null || destPropertyNameInBot.length() < 1 || !(destEntryIdInBot = StringUtils.split((String)destPropertyNameInBot, (String)".").length == 1 ? botRelationEntryInfo.getDestObjectID() : botRelationEntryInfo.getDestEntryID()).equals(destEntryId) || !destPropertyNameInBot.equals(destPropertyName) || (botValueStr = botRelationEntryInfo.getValue()) == null || botValueStr.length() == 0) continue;
                        try {
                            botRelaValue = new BigDecimal(botValueStr);
                        }
                        catch (NumberFormatException ne) {
                            continue;
                        }
                        String srcPropertyNameInBot = botRelationEntryInfo.getSrcPropertyName();
                        if (srcPropertyNameInBot.startsWith("__src.")) {
                            srcPropertyNameInBot = srcPropertyNameInBot.substring(6);
                        }
                        if ((srcEntryNameInBot = botRelationEntryInfo.getSrcEntryPropName()) != null && !srcEntryNameInBot.equals("__src") && srcEntryNameInBot.startsWith("__src.")) {
                            srcEntryNameInBot = srcEntryNameInBot.substring("__src.".length());
                            srcPropertyNameInBot = srcEntryNameInBot + "." + srcPropertyNameInBot;
                        }
                        String[] srcPropertyName = StringUtils.split((String)srcPropertyNameInBot, (String)".");
                        IObjectValue srcEntryInfo = null;
                        if (srcPropertyName.length == 1) {
                            srcEntryId = botRelationEntryInfo.getSrcObjectID();
                            srcEntryInfo = BOTObjectCache.getInstance((Context)ctx).get(srcEntryId);
                        } else {
                            srcEntryId = botRelationEntryInfo.getSrcEntryID();
                            String srcObjectId = botRelationEntryInfo.getSrcObjectID();
                            IObjectValue srcObject = BOTObjectCache.getInstance((Context)ctx).get(srcObjectId);
                            IObjectCollection srcEntryCols = (IObjectCollection)srcObject.get(srcPropertyName[0]);
                            if (srcEntryCols != null) {
                                int srcBeCount = srcEntryCols.size();
                                for (int m = 0; m < srcBeCount; ++m) {
                                    IObjectValue srcEntryObject = srcEntryCols.getObject(m);
                                    if (!srcEntryObject.get("id").toString().equals(srcEntryId)) continue;
                                    srcEntryInfo = srcEntryObject;
                                    break;
                                }
                            }
                        }
                        if (srcEntryInfo == null) continue;
                        BigDecimal srcValue = new BigDecimal(srcEntryInfo.get(srcPropertyName[srcPropertyName.length - 1]).toString());
                        BigDecimal tempResultValue = botRelaValue.add(diff);
                        if (tempResultValue.compareTo(srcValue) >= 0) {
                            diff = diff.subtract(srcValue.subtract(botRelaValue));
                            if (botRelationEntryInfo.getId() != null) {
                                sql = "UPDATE t_bot_relationentry SET FValue = " + srcValue.toString() + " WHERE FID ='" + botRelationEntryInfo.getId().toString() + "'";
                                DbUtil.execute((Context)ctx, (String)sql);
                            }
                            botRelationEntryInfo.setValue(srcValue.toString());
                            continue;
                        }
                        if (tempResultValue.compareTo(ZERO) <= 0) {
                            diff = diff.subtract(ZERO.subtract(botRelaValue));
                            botRelationEntryInfo.setValue(ZERO.toString());
                            if (botRelationEntryInfo.getId() == null) continue;
                            sql = "UPDATE t_bot_relationentry SET FValue = " + ZERO.toString() + " WHERE FID ='" + botRelationEntryInfo.getId().toString() + "'";
                            DbUtil.execute((Context)ctx, (String)sql);
                            continue;
                        }
                        diff = ZERO;
                        if (botRelationEntryInfo.getId() != null) {
                            sql = "UPDATE t_bot_relationentry SET FValue = " + tempResultValue.toString() + " WHERE FID ='" + botRelationEntryInfo.getId().toString() + "'";
                            DbUtil.execute((Context)ctx, (String)sql);
                        }
                        botRelationEntryInfo.setValue(tempResultValue.toString());
                        break;
                    }
                    if (diff.compareTo(ZERO) == 0) break;
                }
                if (diff.compareTo(ZERO) != 0 && !BotpUtils.needValidateEntryValue((Context)ctx)) continue;
            }
        }
    }

    public static void prepareGetSrcBillAndEntrys(Context ctx, BOTRelationCollection relations) throws BOSException, BOTPException {
    }

    public static void addUpRelationValue(HashMap entryIdValueMap, BOTRelationInfo currRelationInfo) {
        int reCount = currRelationInfo.getRelationEntries().size();
        for (int k = 0; k < reCount; ++k) {
            HashMap destPropertyValueMap;
            String destEntryId;
            BigDecimal value;
            BOTRelationEntryInfo currRelationEntryInfo = currRelationInfo.getRelationEntries().get(k);
            String valueStr = currRelationEntryInfo.getValue();
            if (valueStr == null || valueStr.length() == 0) continue;
            try {
                value = new BigDecimal(valueStr);
            }
            catch (NumberFormatException ne) {
                continue;
            }
            String destPropertyName = currRelationEntryInfo.getDestPropertyName();
            String destEntryName = currRelationEntryInfo.getDestEntryPropName();
            if (destEntryName == null || destEntryName.equals("__dest")) {
                destEntryId = currRelationEntryInfo.getDestObjectID();
                destEntryId = "0" + destEntryId;
            } else {
                if (destEntryName.startsWith("__dest.")) {
                    destEntryName = destEntryName.substring("__dest.".length());
                    destPropertyName = destEntryName + "." + destPropertyName;
                }
                destEntryId = currRelationEntryInfo.getDestEntryID();
                destEntryId = "1" + destEntryId;
            }
            if (!entryIdValueMap.keySet().contains(destEntryId)) {
                destPropertyValueMap = new HashMap();
                entryIdValueMap.put(destEntryId, destPropertyValueMap);
            }
            if ((destPropertyValueMap = (HashMap)entryIdValueMap.get(destEntryId)).keySet().contains(destPropertyName)) {
                value = value.add((BigDecimal)destPropertyValueMap.get(destPropertyName));
            }
            destPropertyValueMap.put(destPropertyName, value);
        }
    }

    public static BOTRelationInfo getNewRelationInfo(Context ctx, BOTMappingInfo botMappingInfo, BOTRelationEntryCollection deleteRelationEntryCol, BOTRelationInfo oldRelationInfo, IObjectCollection billBaseEntries, CoreBillBaseInfo destObjectInfo, boolean isNew, boolean isNeedReverse) throws EASBizException, BOSException {
        BOTRelationInfo currRelationInfo = (BOTRelationInfo)oldRelationInfo.clone();
        boolean isDelRelationsWithoutEntries = BOTAppTools.isDelRelationsWithoutEntries((Context)ctx, (IObjectValue)destObjectInfo);
        if (isNeedReverse != currRelationInfo.isIsEffected()) {
            currRelationInfo.setIsEffected(isNeedReverse);
        }
        currRelationInfo.put("relationEntries", (Object)new BOTRelationEntryCollection());
        boolean isNeedSaveEntries = VcDapUtil.isNeedSaveEntries(ctx, botMappingInfo);
        BOTRelationEntryCollection oldRelationEntries = oldRelationInfo.getRelationEntries();
        if (!isNeedSaveEntries) {
            Set srcIDSet = VcDapUtil.getSrcBillIDByDestInfo((CoreBaseInfo)destObjectInfo);
            if (srcIDSet.contains(currRelationInfo.getSrcObjectID()) || srcIDSet.size() == 0) {
                return currRelationInfo;
            }
            return null;
        }
        int reCount = oldRelationEntries.size();
        for (int k = 0; k < reCount; ++k) {
            BOTRelationEntryInfo currOldRelaEntry = oldRelationEntries.get(k);
            String relaDestEntryId = currOldRelaEntry.getDestEntryID();
            if (currOldRelaEntry.getDestEntryPropName() != null && currOldRelaEntry.getDestEntryPropName().startsWith("__dest.")) {
                billBaseEntries = (IObjectCollection)destObjectInfo.get(currOldRelaEntry.getDestEntryPropName().substring("__dest.".length()));
            }
            if (StringUtils.isEmpty((String)relaDestEntryId) || destObjectInfo.getId() != null && relaDestEntryId.equals(destObjectInfo.getId().toString())) {
                currRelationInfo.getRelationEntries().add((BOTRelationEntryInfo)currOldRelaEntry.clone());
                continue;
            }
            if (billBaseEntries == null) {
                return currRelationInfo;
            }
            boolean exist = false;
            int beCount = billBaseEntries.size();
            for (int j = 0; j < beCount; ++j) {
                IObjectValue billEntryInfo = billBaseEntries.getObject(j);
                if ("__src".equals(currOldRelaEntry.getSrcEntryPropName()) && !isDelRelationsWithoutEntries || billEntryInfo.get("id") == null || !billEntryInfo.get("id").toString().equals(relaDestEntryId)) continue;
                currRelationInfo.getRelationEntries().add((BOTRelationEntryInfo)currOldRelaEntry.clone());
                exist = true;
                break;
            }
            if (exist) continue;
            deleteRelationEntryCol.add(currOldRelaEntry);
        }
        if (oldRelationEntries.size() > 0 && currRelationInfo.getRelationEntries().size() == 0 && isDelRelationsWithoutEntries) {
            return null;
        }
        return currRelationInfo;
    }

    public static Set getSrcBillIDByDestInfo(CoreBaseInfo destObjectInfo) {
        HashSet<String> srcIDSet = new HashSet<String>();
        if (destObjectInfo instanceof IEASBillHeadInfo && ((IEASBillHeadInfo)destObjectInfo).getEntries() != null) {
            IObjectCollection easBillEntries = ((IEASBillHeadInfo)destObjectInfo).getEntries();
            IObjectValue destObjectEntryInfo2 = null;
            for (IObjectValue destObjectEntryInfo2 : easBillEntries) {
                if (!(destObjectEntryInfo2 instanceof IEASBillEntryInfo) || ((IEASBillEntryInfo)destObjectEntryInfo2).getSourceBillId() == null) continue;
                srcIDSet.add(((IEASBillEntryInfo)destObjectEntryInfo2).getSourceBillId());
            }
        }
        return srcIDSet;
    }

    public static boolean isNeedSaveEntries(Context ctx, BOTMappingInfo mappingInfo) throws EASBizException, BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo srcEntity = loader.getEntity(BOSObjectType.create((String)mappingInfo.getSrcEntityName()));
        EntityObjectInfo destEntity = loader.getEntity(BOSObjectType.create((String)mappingInfo.getDestEntityName()));
        return BOTAppTools.IsSaveBotpEntryRelation((Context)ctx, (EntityObjectInfo)srcEntity, (EntityObjectInfo)destEntity);
    }

    public static IObjectPK innerSaveModelAndRelations(Context ctx, IObjectValue model, IObjectCollection relations, boolean isclearCache, boolean ischeckPermission) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            boolean isNew;
            CoreBillBaseInfo baseinfo;
            block14: {
                baseinfo = (CoreBillBaseInfo)model;
                IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)model.getBOSType());
                ICoreBillBase iBillBase = (ICoreBillBase)obj;
                Object destBillIdPk = model.get(model.getPKField());
                String destBillId = null;
                if (destBillIdPk != null) {
                    destBillId = destBillIdPk.toString();
                }
                isNew = destBillId == null || !iBillBase.exists((IObjectPK)new ObjectUuidPK(destBillId));
                if (ischeckPermission && VcDapUtil.isCheckPermission(ctx)) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                try {
                    pk = iBillBase.save((CoreBaseInfo)baseinfo);
                    if (relations != null && relations.size() != 0) break block14;
                    IObjectPK iObjectPK = pk;
                    return iObjectPK;
                }
                catch (Exception ee) {
                    try {
                        if (baseinfo != null && baseinfo.getNumber() != null) {
                            iBillBase.recycleNumber(baseinfo, null, null, null, baseinfo.getNumber());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    throw ee;
                }
            }
            VcDapUtil.innerRecalcRelationsAndReverseWrite(ctx, baseinfo, relations, isNew, false);
            IObjectPK iObjectPK = pk;
            return iObjectPK;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BOTObjectCache.getInstance((Context)ctx).clear();
        }
    }

    public static void handleAfterTransform(Context ctx, String action, IObjectValue model, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        CoreBillBaseInfo baseinfo = (CoreBillBaseInfo)model;
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)model.getBOSType());
        ICoreBillBase iBillBase = (ICoreBillBase)obj;
        iBillBase.handleAfterTransform(action, model);
        iBillBase.newHandleAfterTransform(action, model, mappingId, relationCol);
    }

    public static Context switchOrgIfNeed(Context ctx, CoreBillBaseInfo destBillInfo, String orgPropertyName, Map contextMap) throws BOSException {
        Context bosctx = ctx;
        IObjectPK pk = null;
        try {
            if (orgPropertyName != null) {
                pk = BOTOrgUtils.getOrgPKByCoreBillBaseInfo((CoreBillBaseInfo)destBillInfo, (String)orgPropertyName);
            }
            if (pk != null) {
                Object existContext = contextMap.get(pk.toString());
                if (existContext != null) {
                    bosctx = (Context)existContext;
                } else {
                    bosctx = BOTOrgUtils.switchOrg((Context)ctx, (String)pk.toString());
                    contextMap.put(pk.toString(), bosctx);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bosctx;
    }

    public static void checkRebuild(Context ctx, BOTRelationCollection botRelationColls) throws BOSException {
        if (botRelationColls.size() > 0) {
            BOTRelationInfo relationinfo = botRelationColls.get(0);
            String destBostype = relationinfo.getDestEntityID();
            ArrayList<String> idList = new ArrayList<String>();
            ArrayList<String> destList = new ArrayList<String>();
            for (int i = 0; i < botRelationColls.size(); ++i) {
                idList.add(botRelationColls.get(i).getSrcObjectID());
                destList.add(botRelationColls.get(i).getDestObjectID());
                if (destBostype != null) continue;
                String destObjectID = botRelationColls.get(i).getDestObjectID();
                ObjectUuidPK objectUuidPK = new ObjectUuidPK(destObjectID);
                destBostype = objectUuidPK.getObjectType().toString();
            }
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(relationinfo.getBOTMappingID(), ctx);
            String reBuildControl = "";
            String extconfig = mappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
            if (extconfig != null && !extconfig.equals("")) {
                try {
                    info = processor.marshallingExtConfig(extconfig);
                    reBuildControl = info.getReBuildControl();
                    if (reBuildControl.equals("2") && VcDapUtil.hasReBuild(ctx, idList, destList, destBostype)) {
                        BOSException e = new BOSException(EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource", (String)"notReBuild"));
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                catch (DocumentException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static boolean hasReBuild(Context ctx, List idlist, List destList, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        String destbillIds = StringUtils.arrayToString((Object[])destList.toArray(), (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterBill.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destbillIds, CompareType.NOTINCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    public static Map getRuleFilterMap(Context ctx, String filterSql) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] filStr = filterSql.split(" and ");
        for (int i = 0; i < filStr.length; ++i) {
            String name = filStr[i].split(" = ")[0];
            String value = filStr[i].split(" = ")[1];
            result.put(name, value.trim());
        }
        return result;
    }

    public static BillTypeInfo getBillTypeByBOSType(Context ctx, String bosType, int subSystem) throws BOSException, EASBizException {
        return BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo("select id, bosObjectType, subSystem where bosObjectType = '" + bosType + "' and subSystem = " + subSystem);
    }

    public static BusinessTypeInfo getBusinessTypeByNumber(Context ctx, String number, int subSystem, String operatorNumber) throws BOSException, EASBizException {
        return BusinessTypeFactory.getLocalInstance(ctx).getBusinessTypeInfo("select id, number, subSystem ,operator,isBillTransform where number = '" + number + "' and subSystem = " + subSystem + " and operator = '" + operatorNumber + "' ");
    }
}

