/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ebgateway.common.data;

import com.kingdee.bos.ebgateway.common.data.AbstractParser;
import com.kingdee.bos.ebgateway.common.data.CheckedMessageWrapper;
import com.kingdee.bos.ebgateway.common.data.DataObject;
import com.kingdee.bos.ebservice.NameValuePair;
import com.kingdee.bos.util.EASResource;
import java.text.MessageFormat;
import java.util.LinkedList;

public class DataParser
extends AbstractParser {
    private NameValuePair[] pairs = null;

    private DataParser(NameValuePair[] pairs) {
        this.pairs = pairs;
    }

    private Object get(Class clazz, String name) {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < this.pairs.length; ++i) {
            String _name;
            NameValuePair pair = this.pairs[i];
            if (pair.getName() == null || (_name = pair.getName().trim()).length() == 0 || !_name.equals(name)) continue;
            list.add(pair.getValue());
        }
        if (String.class.equals((Object)clazz)) {
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        if (list.size() > 0) {
            return list.toArray(new String[0]);
        }
        return null;
    }

    public static DataParser getInstance(NameValuePair[] pairs) {
        CheckedMessageWrapper messageWrapper;
        DataParser parser = null;
        parser = pairs == null ? new DataParser(new NameValuePair[0]) : new DataParser(pairs);
        parser.wrapper = messageWrapper = new CheckedMessageWrapper();
        return parser;
    }

    public DataObject getDataObject(String name) {
        String xmlValue = this.getProperty(name);
        if (xmlValue == null) {
            throw new NullPointerException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEBosResource", (String)"003_PROPERTY_ABSENCE"), name));
        }
        DataObject dataObject = DataObject.parse(name, xmlValue);
        dataObject.wrapper = this.wrapper;
        return dataObject;
    }

    public DataObject[] getDataObjects(String name) {
        String[] xmlValues = this.getPropertyArray(name);
        LinkedList<DataObject> dataObjects = new LinkedList<DataObject>();
        int index = 0;
        if (xmlValues == null) {
            return null;
        }
        for (int i = 0; i < xmlValues.length; ++i) {
            String xmlValue = xmlValues[i];
            if (xmlValue == null) continue;
            DataObject dataObject = DataObject.parse(name + "[" + index + "]", xmlValue);
            dataObject.wrapper = this.wrapper;
            dataObjects.add(dataObject);
            ++index;
        }
        return dataObjects.toArray(new DataObject[0]);
    }

    @Override
    public String getProperty(String name) {
        return (String)this.get(String.class, name);
    }

    @Override
    public String[] getPropertyArray(String name) {
        return (String[])this.get(String[].class, name);
    }

    @Override
    protected String getPropertyPrefix() {
        return "";
    }
}

