/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DetailIntegralityFilterParam
implements FilterParam {
    private static final long serialVersionUID = -1166079360935338801L;
    private String currencyId;
    private String[] companyId;
    private String bankInterface;
    private Set bankAcctIds;
    private Date beginDate;
    private Date endDate;
    private boolean isDataImport;
    private AccountBankInfo[] bankAccts;

    public AccountBankInfo[] getBankAccts() {
        return this.bankAccts;
    }

    public void setBankAccts(AccountBankInfo[] bankAccts) {
        this.bankAccts = bankAccts;
    }

    public boolean isIsDataImport() {
        return this.isDataImport;
    }

    public void setIsDataImport(boolean isDataImport) {
        this.isDataImport = isDataImport;
    }

    public Set getBankAcctIds() {
        return this.bankAcctIds;
    }

    public void setBankAcctIds(Set bankAcctIds) {
        this.bankAcctIds = bankAcctIds;
    }

    public String getBankInterface() {
        return this.bankInterface;
    }

    public void setBankInterface(String bankInterfaceId) {
        this.bankInterface = bankInterfaceId;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String[] getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String[] companyId) {
        this.companyId = companyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public FilterInfo getFilter() {
        FilterInfo fi = new FilterInfo();
        if (this.currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (!FMHelper.isEmpty((Object[])this.companyId)) {
            HashSet<String> list = new HashSet<String>(this.companyId.length);
            for (int i = 0; i < this.companyId.length; ++i) {
                list.add(this.companyId[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        } else {
            CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        }
        if (this.beginDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)FMConstants.FORMAT_DAY.format(this.beginDate), CompareType.GREATER_EQUALS));
        }
        if (this.endDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)FMConstants.FORMAT_DAY.format(DateUtil.getNextDay((Date)this.endDate)), CompareType.LESS));
        }
        if (!FMHelper.isEmpty((Collection)this.bankAcctIds)) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)this.bankAcctIds, CompareType.INCLUDE));
        }
        return fi;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizDate"));
        sorter.add(new SorterItemInfo("company.name"));
        sorter.add(new SorterItemInfo("bankAccount.bankAccountNumber"));
        sorter.add(new SorterItemInfo("currency.name"));
        return sorter;
    }
}

