/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class ElStatementFilterParam
implements FilterParam {
    private static final long serialVersionUID = 1L;
    private String[] companyId;
    private Date startDate;
    private Date endDate;
    private String currencyId;
    private String[] bankAcctId;
    private String bankInterface;
    private boolean isClosed;
    private boolean isImport;

    public String[] getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String[] companyId) {
        this.companyId = companyId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String[] getBankAcctId() {
        return this.bankAcctId;
    }

    public void setBankAcctId(String[] bankAcctId) {
        this.bankAcctId = bankAcctId;
    }

    public String getBankInterface() {
        return this.bankInterface;
    }

    public void setBankInterface(String bankInterface) {
        this.bankInterface = bankInterface;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public void setImport(boolean isImport) {
        this.isImport = isImport;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.companyId == null || this.companyId.length == 0) {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)FMHelper.asSet((String[])this.companyId), CompareType.INCLUDE));
        }
        if (this.bankAcctId != null) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)FMHelper.asSet((String[])this.bankAcctId), CompareType.INCLUDE));
        }
        if (this.startDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("transDate", (Object)DateTimeUtils.truncateDate((Date)this.startDate), CompareType.GREATER_EQUALS));
        }
        if (this.endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("transDate", (Object)DateTimeUtils.truncateDate((Date)this.endDate), CompareType.LESS_EQUALS));
        }
        if (!this.isImport) {
            filter.getFilterItems().add(new FilterItemInfo("isImport", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("transDate"));
        sorter.add(new SorterItemInfo("company.name"));
        sorter.add(new SorterItemInfo("bankAccount.bankAccountNumber"));
        sorter.add(new SorterItemInfo("currency.name"));
        return sorter;
    }
}

