/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.Detail;
import com.kingdee.bos.ebservice.FixedInfo;
import com.kingdee.bos.ebservice.PingDetail;
import com.kingdee.bos.ebservice.PingResponseBody;
import com.kingdee.bos.ebservice.ReconciliateDetail;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankSignEnum;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ElecBookInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BalSourceTpye;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankGovHrWageEntryInfo;
import com.kingdee.eas.fm.be.BankGovHrWageJoinInfo;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.BeServiceAddFactory;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.be.DifBankEnum;
import com.kingdee.eas.fm.be.ErrCodeHelper;
import com.kingdee.eas.fm.be.PingResult;
import com.kingdee.eas.fm.be.RegularDetailFactory;
import com.kingdee.eas.fm.be.RegularDetailInfo;
import com.kingdee.eas.fm.be.RegularDetailsEnum;
import com.kingdee.eas.fm.be.RegularFixTransInfo;
import com.kingdee.eas.fm.be.RegularRenewFlagEnum;
import com.kingdee.eas.fm.be.RegularTermUnitEnum;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransdetailSourceEnum;
import com.kingdee.eas.fm.be.app.BankBaseDataUtil;
import com.kingdee.eas.fm.be.app.BankFacadeHelper;
import com.kingdee.eas.fm.be.app.BankServiceUtil;
import com.kingdee.eas.fm.be.app.service.PingUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.be.app.util.ElecBookBizInfo;
import com.kingdee.eas.fm.be.app.util.RegularBizInfo;
import com.kingdee.eas.fm.be.util.ThreadLocalDateUtil;
import com.kingdee.eas.fm.be.util.ThreadLocalTimeUtil;
import com.kingdee.eas.fm.be.ws.AgencySalaryInfo;
import com.kingdee.eas.fm.be.ws.BankAcnt;
import com.kingdee.eas.fm.be.ws.Country;
import com.kingdee.eas.fm.be.ws.Currency;
import com.kingdee.eas.fm.be.ws.FundTransferInfo;
import com.kingdee.eas.fm.be.ws.LinkPaymentInfo;
import com.kingdee.eas.fm.be.ws.PayUnitInfo;
import com.kingdee.eas.fm.be.ws.PaymentCheckResult;
import com.kingdee.eas.fm.be.ws.PaymentInfo;
import com.kingdee.eas.fm.be.ws.PaymentState;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class FmBeHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.FmBeHelper");
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private static final String provinceCn = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"province");
    private static final String cityCn = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"city");
    private static Country[] countrys = null;
    private static Currency[] currencys = null;
    private static final DateFormat FORMAT_SHORT = new SimpleDateFormat("yyyyMMdd");
    public static final String BALANCE_ZERO_ACCOUNT = "balanceZeroAccount";

    public static boolean EBGIsON(Context ctx) {
        return true;
    }

    public static String cutString(String returnMsg) {
        if (returnMsg != null && returnMsg.length() > 75) {
            returnMsg = returnMsg.substring(0, 75);
        }
        return returnMsg;
    }

    public static String cutString(String returnMsg, int length) {
        if (returnMsg != null && returnMsg.length() > length) {
            returnMsg = returnMsg.substring(0, length);
        }
        return returnMsg;
    }

    public static BankPayingBillStateEnum transferState(PaymentState paymentState) {
        if (paymentState.equals(PaymentState.INVALIDATED)) {
            return BankPayingBillStateEnum.DE;
        }
        if (paymentState.equals(PaymentState.WILLSUBMIT)) {
            return BankPayingBillStateEnum.OP;
        }
        if (paymentState.equals(PaymentState.SUBMIT_SUCCESSE)) {
            return BankPayingBillStateEnum.OS;
        }
        if (paymentState.equals(PaymentState.SUBMIT_FAILURE)) {
            return BankPayingBillStateEnum.OF;
        }
        if (paymentState.equals(PaymentState.TRANSACTION_SUCCESS)) {
            return BankPayingBillStateEnum.TS;
        }
        if (paymentState.equals(PaymentState.TRANSACTION_FAILURE)) {
            return BankPayingBillStateEnum.TF;
        }
        return BankPayingBillStateEnum.NC;
    }

    public static StringBuffer getRstMsg(PaymentCheckResult rst) {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < rst.getAllResult().length; ++k) {
            sb.append(rst.getAllResult()[k]);
        }
        return sb;
    }

    private Country[] getBankCountry(Context ctx) throws BOSException {
        if (countrys == null) {
            try {
                BankBaseDataUtil bankBaseDataUtil = new BankBaseDataUtil(ctx);
                countrys = bankBaseDataUtil.getCountry();
            }
            catch (RemoteException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return countrys;
    }

    public PaymentInfo parsePaymentInfo(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException, RemoteException, ServiceException {
        countrys = this.getBankCountry(ctx);
        BankAcnt payBankAcnt = this.createPayBankAcnt(ctx, info, countrys);
        BankAcnt recBankAcnt = this.createRecBankAcnt(ctx, info, countrys);
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setBankAcnt(payBankAcnt);
        paymentInfo.setOppBankAcnt(recBankAcnt);
        if (EmptyUtil.isEmpty((String)info.getSerialNumber())) {
            BankServiceUtil bankServiceUtil = new BankServiceUtil(ctx);
            String[] serialNumbers = bankServiceUtil.getSerialNumber(payBankAcnt, true, 1);
            if (serialNumbers != null && serialNumbers.length == 1) {
                paymentInfo.setPackageID(serialNumbers[0]);
            }
        } else {
            paymentInfo.setPackageID(info.getSerialNumber());
        }
        String currency = FmBeHelper.getCurrency(ctx, info.getCurrency());
        paymentInfo.setCurrency(currency);
        paymentInfo.setAmount(info.getPayAmount());
        paymentInfo.setBookingDate(info.getExpectTransTime());
        int description = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        if (description > 0 && info.getDescription() != null && info.getDescription().length() > description) {
            info.setDescription(info.getDescription().substring(0, description));
        }
        paymentInfo.setExplanation(info.getDescription());
        paymentInfo.setSameCity(!info.isIsDifferPlace());
        paymentInfo.setSubmitDate(Calendar.getInstance().getTime());
        paymentInfo.setSubmiterID(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
        paymentInfo.setBusinessRefNumber(info.getSrcBillNumber());
        paymentInfo.setUrgent(info.isIsEmergency());
        paymentInfo.setState(PaymentState.WILLSUBMIT);
        paymentInfo.setBankNumber(info.getRecBankNo());
        if (info.getFRecCountry() != null) {
            // empty if block
        }
        boolean sameBank = true;
        DifBankEnum difBankEnum = info.getIsDifBank();
        if (difBankEnum != null && difBankEnum.getValue() == 1) {
            sameBank = false;
        }
        paymentInfo.setSameBank(sameBank);
        paymentInfo.setUse(info.getUsage());
        return paymentInfo;
    }

    public PaymentInfo parseTransDownPaymentInfo(Context ctx, BankTransDownBillInfo info, BankTransDownBillEntryInfo entryInfo) throws BOSException, EASBizException, RemoteException, ServiceException {
        countrys = this.getBankCountry(ctx);
        BankAcnt payBankAcnt = this.createDownMotherBankAcnt(ctx, info, countrys);
        BankAcnt recBankAcnt = this.createDownSubBankAcnt(ctx, info, entryInfo, countrys);
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setBankAcnt(payBankAcnt);
        paymentInfo.setOppBankAcnt(recBankAcnt);
        if (EmptyUtil.isEmpty((String)entryInfo.getSerialNumber())) {
            BankServiceUtil bankServiceUtil = new BankServiceUtil(ctx);
            String[] serialNumbers = bankServiceUtil.getSerialNumber(payBankAcnt, true, 1);
            if (serialNumbers != null && serialNumbers.length == 1) {
                paymentInfo.setPackageID(serialNumbers[0]);
            }
        } else {
            paymentInfo.setPackageID(entryInfo.getSerialNumber());
        }
        String currency = FmBeHelper.getCurrency(ctx, info.getCurrency());
        paymentInfo.setCurrency(currency);
        paymentInfo.setAmount(entryInfo.getAmount());
        paymentInfo.setBookingDate(info.getExpectTransTime());
        int description = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        if (description > 0 && info.getDescription() != null && info.getDescription().length() > description) {
            info.setDescription(info.getDescription().substring(0, description));
        }
        paymentInfo.setExplanation(info.getDescription());
        paymentInfo.setSameCity(entryInfo.getIsDifferPlace().getValue() == 0);
        paymentInfo.setSubmitDate(Calendar.getInstance().getTime());
        paymentInfo.setSubmiterID(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
        paymentInfo.setBusinessRefNumber(info.getSrcBillNumber());
        paymentInfo.setState(PaymentState.WILLSUBMIT);
        String recBank = entryInfo.getRecBank();
        String item = BEBankFactory.getLocalInstance((Context)ctx).getBankNo(recBank);
        paymentInfo.setBankNumber(item);
        boolean sameBank = true;
        DifBankEnum difBankEnum = DifBankEnum.getEnum(entryInfo.getIsDifBank().getValue());
        if (difBankEnum != null && difBankEnum.getValue() == 1) {
            sameBank = false;
        }
        paymentInfo.setSameBank(sameBank);
        return paymentInfo;
    }

    public LinkPaymentInfo parseLinkPaymentInfo(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException, RemoteException, ServiceException {
        countrys = this.getBankCountry(ctx);
        BankAcnt pbankAcnt = this.createPBankAcnt(ctx, info, countrys);
        BankAcnt payBankAcnt = this.createPayBankAcnt(ctx, info, countrys);
        BankAcnt recBankAcnt = this.createRecBankAcnt(ctx, info, countrys);
        LinkPaymentInfo linkPaymentInfo = new LinkPaymentInfo();
        linkPaymentInfo.setApbankAcnt(pbankAcnt);
        linkPaymentInfo.setBankAcnt(payBankAcnt);
        linkPaymentInfo.setOppBankAcnt(recBankAcnt);
        if (EmptyUtil.isEmpty((String)info.getSerialNumber())) {
            BankServiceUtil bankServiceUtil = new BankServiceUtil(ctx);
            String[] serialNumbers = bankServiceUtil.getSerialNumber(payBankAcnt, true, 1);
            if (serialNumbers != null && serialNumbers.length == 1) {
                linkPaymentInfo.setPackageID(serialNumbers[0]);
            }
        } else {
            linkPaymentInfo.setPackageID(info.getSerialNumber());
        }
        String currency = FmBeHelper.getCurrency(ctx, info.getCurrency());
        linkPaymentInfo.setCurrency(currency);
        linkPaymentInfo.setAmount(info.getPayAmount());
        linkPaymentInfo.setBookingDate(info.getExpectTransTime());
        int description = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        if (description > 0 && info.getDescription() != null && info.getDescription().length() > description) {
            info.setDescription(info.getDescription().substring(0, description));
        }
        linkPaymentInfo.setExplanation(info.getDescription());
        linkPaymentInfo.setSameCity(!info.isIsDifferPlace());
        linkPaymentInfo.setSubmitDate(Calendar.getInstance().getTime());
        linkPaymentInfo.setSubmiterID(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
        linkPaymentInfo.setBusinessRefNumber(info.getSrcBillNumber());
        linkPaymentInfo.setUrgent(info.isIsEmergency());
        linkPaymentInfo.setState(PaymentState.WILLSUBMIT);
        linkPaymentInfo.setBankNumber(info.getRecBankNo());
        if (info.getFRecCountry() != null) {
            // empty if block
        }
        boolean sameBank = true;
        DifBankEnum difBankEnum = info.getIsDifBank();
        if (difBankEnum != null && difBankEnum.getValue() == 1) {
            sameBank = false;
        }
        linkPaymentInfo.setSameBank(sameBank);
        linkPaymentInfo.setPersonFlag(info.isIsPersonPay() || info.isIsAgencyPersonPay());
        return linkPaymentInfo;
    }

    public BankAcnt createPayBankAcnt(Context ctx, BankPayingBillInfo info, Country[] countrys) throws EASBizException, BOSException {
        AccountBankInfo payAccountBank = info.getPayAccountBank();
        ObjectUuidPK pk = new ObjectUuidPK(payAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("openArea.name");
        selector.add("openArea.province");
        selector.add("openArea.number");
        selector.add("openArea.deptID");
        payAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setBank(info.getBankInterfaceType().getAlias());
        bankAcnt.setAcntNumber(payAccountBank.getBankAccountNumber());
        bankAcnt.setAcntName(payAccountBank.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, payAccountBank, bankAcnt);
        bankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        FmBeHelper.setPayerProviceAndCity(payAccountBank, bankAcnt);
        if (payAccountBank != null) {
            bankAcnt.setBranchID(payAccountBank.getOpenArea().getNumber());
            bankAcnt.setDeptID(payAccountBank.getOpenArea().getDeptID());
            bankAcnt.setAcntName(payAccountBank.getAcctName());
        }
        return bankAcnt;
    }

    private BankAcnt createPBankAcnt(Context ctx, BankPayingBillInfo info, Country[] countrys) throws EASBizException, BOSException {
        AccountBankCollection banks = null;
        AccountBankInfo payAccountBank = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)info.getParentAccount().trim()));
        try {
            banks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ev);
            payAccountBank = banks.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ObjectUuidPK pk = new ObjectUuidPK(payAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("openArea.name");
        selector.add("openArea.province");
        selector.add("openArea.number");
        selector.add("openArea.deptID");
        payAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setBank(info.getBankInterfaceType().getAlias());
        bankAcnt.setAcntNumber(payAccountBank.getBankAccountNumber());
        bankAcnt.setAcntName(payAccountBank.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, payAccountBank, bankAcnt);
        bankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        FmBeHelper.setPayerProviceAndCity(payAccountBank, bankAcnt);
        if (payAccountBank != null) {
            bankAcnt.setBranchID(payAccountBank.getOpenArea().getNumber());
            bankAcnt.setDeptID(payAccountBank.getOpenArea().getDeptID());
            bankAcnt.setAcntName(payAccountBank.getAcctName());
        }
        return bankAcnt;
    }

    private BankAcnt createRecBankAcnt(Context ctx, BankPayingBillInfo info, Country[] countrys) throws BEException {
        BankAcnt bankAcnt = new BankAcnt();
        if (info.getRecOpenArea() != null) {
            bankAcnt.setBranchID(info.getRecOpenArea().getNumber());
            bankAcnt.setDeptID(info.getRecOpenArea().getDeptID());
        }
        bankAcnt.setBank(info.getRecBank());
        bankAcnt.setAcntNumber(info.getRecAccountBank());
        AccountBankCollection banks = null;
        AccountBankInfo recAccountBank = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)info.getRecAccountBank()));
        try {
            banks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ev);
            recAccountBank = banks.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)recAccountBank) && !EmptyUtil.isEmpty((String)recAccountBank.getAcctName())) {
            bankAcnt.setAcntName(recAccountBank.getAcctName());
        } else {
            bankAcnt.setAcntName(info.getRecCompany());
        }
        bankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        this.setRecProvinceAndCity(ctx, info.getRecProvinceStr(), info.getRecCityStr(), bankAcnt);
        return bankAcnt;
    }

    public static TransDetailInfo parseTransDetailInfo(Context ctx, AccountBankInfo acctBank, AccountBankInfo oppBankAcct, Detail info) throws Exception {
        TransDetailInfo transDetailInfo = new TransDetailInfo();
        transDetailInfo.setBankAccount(acctBank);
        if (info.getCreditAmount() == null) {
            info.setCreditAmount("0");
        }
        if (info.getDebitAmount() == null) {
            info.setDebitAmount("0");
        }
        if (!EmptyUtil.isEmpty((String)info.getCreditAmount())) {
            transDetailInfo.setCreditAmount(new BigDecimal(info.getCreditAmount()));
        }
        if (!EmptyUtil.isEmpty((String)info.getDebitAmount())) {
            transDetailInfo.setDebitAmount(new BigDecimal(info.getDebitAmount()));
        }
        if (transDetailInfo.getDebitAmount().compareTo(Constants.ZERO) != 0) {
            transDetailInfo.setIsDebit(true);
            transDetailInfo.setCreditAmount(Constants.ZERO);
        } else {
            transDetailInfo.setIsDebit(false);
            transDetailInfo.setDebitAmount(Constants.ZERO);
        }
        if (!EmptyUtil.isEmpty((String)info.getBalance())) {
            transDetailInfo.setTransBalance(new BigDecimal(info.getBalance()));
        }
        transDetailInfo.setDescription(FmBeHelper.trim(info.getExplanation()));
        Date detailDateTime = ThreadLocalTimeUtil.parse(info.getDetailDateTime());
        if (detailDateTime.getTime() < 0L) {
            logger.error((Object)("\u83b7\u53d6\u5230\u7684\u65f6\u95f4\u4e3a\u516c\u5143\u524d -----" + detailDateTime.getTime() + "-----------"));
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(detailDateTime);
        cal.set(0, 1);
        cal.set(14, 0);
        Timestamp bizDate = new Timestamp(cal.getTimeInMillis());
        if (detailDateTime.getTime() < 0L) {
            logger.error((Object)("\u6309\u516c\u5143\u540e\u65f6\u95f4\u83b7\u53d6\u4e3a -----" + bizDate.getTime() + "-----------"));
        }
        transDetailInfo.setBizTime(bizDate);
        transDetailInfo.setOppBankNumber(info.getOppAccNo());
        transDetailInfo.setOppUnit(info.getOppAccName());
        if (!EmptyUtil.isEmpty((String)transDetailInfo.getOppUnit()) && transDetailInfo.getOppUnit().trim().length() > 80) {
            transDetailInfo.setOppUnit(transDetailInfo.getOppUnit().trim().substring(0, 80));
        }
        transDetailInfo.setOppBank(info.getOppAccBank());
        if (!EmptyUtil.isEmpty((String)info.getTransType())) {
            transDetailInfo.setIsTransDown(info.getTransType().equalsIgnoreCase("autotransdown"));
            transDetailInfo.setIsTransUp(info.getTransType().equalsIgnoreCase("autotransup"));
        }
        BizTypeEnum bizType = FmBeHelper.getTransType(ctx, acctBank, oppBankAcct, new BigDecimal(info.getDebitAmount()), new BigDecimal(info.getCreditAmount()));
        transDetailInfo.setBizType(bizType);
        if (oppBankAcct != null) {
            transDetailInfo.setOppCompany(oppBankAcct.getCompany());
        } else {
            logger.info((Object)"detail oppBankAcnt is null");
        }
        if (info.getTransType().equals(BizTypeEnum.refund.getName())) {
            transDetailInfo.setBizType(BizTypeEnum.refund);
            transDetailInfo.setIsRefund(true);
        }
        Object[] reserveds = info.getReserveds();
        transDetailInfo.setIsKDRetFlag(false);
        if (!EmptyUtil.isEmpty((Object[])reserveds)) {
            String reservedField = Arrays.toString(reserveds).trim();
            int endIndex = reservedField.length() > 2000 ? 2000 : reservedField.length() - 1;
            reservedField = reservedField.substring(1, endIndex);
            transDetailInfo.setReservedField(reservedField);
            for (int i = 0; i < reserveds.length; ++i) {
                String returnValue = ((String)reserveds[i]).trim();
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("bizRefNo=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setNumber(returnValue.substring("bizRefNo=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("VouhNo=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setName(returnValue.substring("VouhNo=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("agentAccNo=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setAgentAccNo(returnValue.substring("agentAccNo=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("agentAccName=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setAgentAccName(returnValue.substring("agentAccNo=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("agentAccBkName=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setAgentAccBkName(returnValue.substring("agentAccBkName=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("receiptNo=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setReceiptNo(returnValue.substring("receiptNo=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("KDRetFlag=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setIsKDRetFlag(true);
                    transDetailInfo.setBankCheckFlag(returnValue.substring("KDRetFlag=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("refundNo=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setRefundNo(returnValue.substring("refundNo=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("businessName=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setBizName(returnValue.substring("businessName=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("businessType=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setBusinessType(returnValue.substring("businessType=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("busType=".toUpperCase(Locale.ENGLISH)) && EmptyUtil.isEmpty((String)transDetailInfo.getBusinessType())) {
                    transDetailInfo.setBusinessType(returnValue.substring("busType=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("goodsName=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setGoodsName(returnValue.substring("goodsName=".length()));
                }
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("businessOrderNo=".toUpperCase(Locale.ENGLISH))) {
                    transDetailInfo.setBusinessOrderNo(returnValue.substring("businessOrderNo=".length()));
                }
                if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("virtual_number=".toUpperCase())) continue;
                transDetailInfo.setVirtualAcctNo(returnValue.substring("virtual_number=".length()));
            }
        }
        if (EmptyUtil.isEmpty((String)transDetailInfo.getBankCheckFlag())) {
            transDetailInfo.setBankCheckFlag(info.getDetailID());
        }
        if ("autotransup".equalsIgnoreCase(info.getTransType())) {
            transDetailInfo.setIsTransUp(true);
        } else if ("antotransdown".equalsIgnoreCase(info.getTransType())) {
            transDetailInfo.setIsTransDown(true);
        } else if ("bankcharge".equalsIgnoreCase(info.getTransType())) {
            transDetailInfo.setIsBankWithHolding(true);
        }
        transDetailInfo.setIsDownToBankState(false);
        transDetailInfo.setTranPackageID(info.getDetailID());
        transDetailInfo.setTranPackageUQID(info.getDetailID());
        transDetailInfo.setIsDataImport(TransdetailSourceEnum.BE);
        if (!EmptyUtil.isEmpty((String)info.getRqstSerialNo())) {
            transDetailInfo.setSortedID(info.getFlowSerialNo());
            transDetailInfo.setBizDate(ThreadLocalDateUtil.parse(info.getRqstSerialNo()));
        } else {
            transDetailInfo.setBizDate(DateUtil.getDayBegin((Date)new Date(transDetailInfo.getBizTime().getTime())));
        }
        return transDetailInfo;
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static AccountBankInfo getAccountBankByNumber(Context ctx, String oppAcctNumber) throws BOSException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)oppAcctNumber));
        entityView.setFilter(filter);
        AccountBankCollection oppAccountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(entityView);
        AccountBankInfo oppAccountBankInfo = null;
        if (oppAccountBankCol != null && oppAccountBankCol.size() != 0) {
            oppAccountBankInfo = oppAccountBankCol.get(0);
        }
        return oppAccountBankInfo;
    }

    public static BizTypeEnum getTransType(Context ctx, AccountBankInfo accountBankInfo, AccountBankInfo oppAccountBankInfo, BigDecimal debitAmount, BigDecimal creditAmount) throws BOSException {
        if (oppAccountBankInfo == null) {
            return BizTypeEnum.normal;
        }
        if (accountBankInfo.isIsMotherAccount() && oppAccountBankInfo.getReleMotherAcct() != null && oppAccountBankInfo.getReleMotherAcct().getId().equals((Object)accountBankInfo.getId())) {
            if (debitAmount.compareTo(creditAmount) > 0) {
                return BizTypeEnum.transDown;
            }
            return BizTypeEnum.transUp;
        }
        if (oppAccountBankInfo.isIsMotherAccount() && accountBankInfo.getReleMotherAcct() != null && accountBankInfo.getReleMotherAcct().getId().equals((Object)oppAccountBankInfo.getId())) {
            if (debitAmount.compareTo(creditAmount) > 0) {
                return BizTypeEnum.transUp;
            }
            return BizTypeEnum.transDown;
        }
        return BizTypeEnum.normal;
    }

    public static boolean isExistsTransDetail(Context ctx, TransDetailInfo info) throws EASBizException, BOSException {
        boolean isExists = false;
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)info.getBankAccount().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("bizTime", (Object)info.getBizTime()));
        fi.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)info.getDebitAmount()));
        fi.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)info.getCreditAmount()));
        if (!EmptyUtil.isEmpty((Object)info.getTransBalance())) {
            fi.getFilterItems().add(new FilterItemInfo("transBalance", (Object)info.getTransBalance()));
        }
        if (!EmptyUtil.isEmpty((String)info.getOppBankNumber())) {
            fi.getFilterItems().add(new FilterItemInfo("oppBankNumber", (Object)info.getOppBankNumber()));
        }
        if (!EmptyUtil.isEmpty((String)info.getName())) {
            fi.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        }
        if (!EmptyUtil.isEmpty((String)info.getRawTransTime())) {
            fi.getFilterItems().add(new FilterItemInfo("rawTransTime", (Object)info.getRawTransTime()));
        }
        if (!EmptyUtil.isEmpty((String)info.getDescription())) {
            fi.getFilterItems().add(new FilterItemInfo("description", (Object)info.getDescription()));
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        }
        if (!EmptyUtil.isEmpty((String)info.getTranPackageID())) {
            fi.getFilterItems().add(new FilterItemInfo("tranPackageID", (Object)info.getTranPackageID()));
        }
        logger.info((Object)("bankface filter:" + fi));
        isExists = TransDetailFactory.getLocalInstance(ctx).exists(fi);
        logger.info((Object)(" isists :" + isExists));
        return isExists;
    }

    public static void addnewOrUpdateBalance(Context ctx, AccountBankBalanceInfo info, boolean isTodayBal) throws EASBizException, BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)info.getAccountBank().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
        evi.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("lstBalance");
        sic.add("balance");
        sic.add("valiBalance");
        sic.add("frozenAmount");
        sic.add("depositBalance");
        sic.add("reservedField");
        sic.add("accurateBizDate");
        sic.add("lastUpdateUser");
        sic.add("lastUpdateTime");
        evi.setSelector(sic);
        AccountBankBalanceCollection coll = AccountBankBalanceFactory.getLocalInstance(ctx).getAccountBankBalanceCollection(evi);
        AccountBankBalanceInfo balanceInfo = null;
        if (coll != null && coll.size() > 0) {
            BigDecimal newDepositBalance;
            balanceInfo = coll.get(0);
            Date oldDate = balanceInfo.getAccurateBizDate();
            Date newDate = info.getAccurateBizDate();
            BigDecimal oldBalance1 = balanceInfo.getBalance() == null ? new BigDecimal("0") : balanceInfo.getBalance();
            BigDecimal newBalance1 = info.getBalance() == null ? new BigDecimal("0") : info.getBalance();
            BigDecimal oldLstBalance = balanceInfo.getLstBalance() == null ? new BigDecimal("0") : balanceInfo.getLstBalance();
            BigDecimal newLstBalance = info.getLstBalance() == null ? new BigDecimal("0") : info.getLstBalance();
            BigDecimal oldValiBalance = balanceInfo.getValiBalance() == null ? new BigDecimal("0") : balanceInfo.getValiBalance();
            BigDecimal newValiBalance = info.getValiBalance() == null ? new BigDecimal("0") : info.getValiBalance();
            BigDecimal oldFrozenAmount = balanceInfo.getFrozenAmount() == null ? new BigDecimal("0") : balanceInfo.getFrozenAmount();
            BigDecimal newFrozenAmount = info.getFrozenAmount() == null ? new BigDecimal("0") : info.getFrozenAmount();
            BigDecimal oldDepositBalance = balanceInfo.getDepositBalance() == null ? new BigDecimal("0") : balanceInfo.getDepositBalance();
            BigDecimal bigDecimal = newDepositBalance = info.getDepositBalance() == null ? new BigDecimal("0") : info.getDepositBalance();
            if ((oldBalance1.compareTo(newBalance1) != 0 || oldLstBalance.compareTo(newLstBalance) != 0 || oldValiBalance.compareTo(newValiBalance) != 0) && oldFrozenAmount.compareTo(newFrozenAmount) != 0 && oldDepositBalance.compareTo(newDepositBalance) != 0 || !oldDate.equals(newDate)) {
                balanceInfo.setBalance(info.getBalance());
                if (isTodayBal) {
                    balanceInfo.setLstBalance(info.getLstBalance());
                    balanceInfo.setValiBalance(info.getValiBalance());
                    balanceInfo.setFrozenAmount(info.getFrozenAmount());
                    balanceInfo.setDepositBalance(info.getDepositBalance());
                    balanceInfo.setReservedField(info.getReservedField());
                }
                balanceInfo.setAccurateBizDate(info.getAccurateBizDate());
                balanceInfo.setLastUpdateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                balanceInfo.setLastUpdateUser(userInfo);
                AccountBankBalanceFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)balanceInfo, sic);
            }
        } else {
            info.setBalSourceType(BalSourceTpye.BE);
            AccountBankBalanceFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        }
    }

    public static void deleteNoExistDetail(Context ctx, String currency, String accountBanks, Date beginDate, Date endDate, BigDecimal miniAmount, BigDecimal maxAmount, Map deleteMap) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)accountBanks)) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)accountBanks, CompareType.EQUALS));
        }
        Set key = deleteMap.keySet();
        fi.getFilterItems().add(new FilterItemInfo("id", key, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency));
        fi.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)new Boolean(true), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)new Boolean(true), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("isCreatedTransUp", (Object)new Boolean(true), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)0, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getNextDay((Date)endDate), CompareType.LESS));
        fi.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("isReced", (Object)new Boolean(false)));
        fi.getFilterItems().add(new FilterItemInfo("isDownToBankState", (Object)new Boolean(false)));
        FilterInfo fi1 = new FilterInfo();
        fi1.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(1)));
        if (maxAmount != null) {
            fi1.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)maxAmount, CompareType.LESS_EQUALS));
        }
        if (miniAmount != null) {
            fi1.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)miniAmount, CompareType.GREATER_EQUALS));
        }
        FilterInfo fi2 = new FilterInfo();
        fi2.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(0)));
        if (maxAmount != null) {
            fi2.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)maxAmount, CompareType.LESS_EQUALS));
        }
        if (miniAmount != null) {
            fi2.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)miniAmount, CompareType.GREATER_EQUALS));
        }
        fi1.mergeFilter(fi2, "or");
        fi.mergeFilter(fi1, "and");
        TransDetailFactory.getLocalInstance(ctx).delete(fi);
    }

    public static void updateLstBalance(Context ctx, AccountBankBalanceInfo acctBankBalanceInfo, boolean isTodayBal, String BE019) throws BOSException {
        BigDecimal lstBa = acctBankBalanceInfo.getLstBalance();
        if (isTodayBal && lstBa != null && lstBa.compareTo(Constants.ZERO) != 0) {
            Date lstBizDate = DateUtil.getBeforeDay((Date)acctBankBalanceInfo.getBizDate());
            java.sql.Date sqllstBizDate = DateUtil.getSQLBegin((Date)lstBizDate);
            String accountBankid = acctBankBalanceInfo.getAccountBank().getId().toString();
            String currencyId = acctBankBalanceInfo.getCurrency().getId().toString();
            String userId = ctx.getCaller() == null ? null : ctx.getCaller().toString();
            Timestamp updateTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            if (null != BE019) {
                if (BE019.equals("0")) {
                    String sql = "update t_be_AccountBankBalance set fbalance=? , fvalibalance=?, FLastUpdateUserID=? , FLastUpdateTime=?  where fbizdate=? and faccountbankid=? and fcurrencyid=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{lstBa, lstBa, userId, updateTime, sqllstBizDate, accountBankid, currencyId});
                } else if (BE019.equals("1")) {
                    String sql = "update t_be_AccountBankBalance set fbalance=?, FLastUpdateUserID=? , FLastUpdateTime=?  where fbizdate=? and faccountbankid=? and fcurrencyid=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{lstBa, userId, updateTime, sqllstBizDate, accountBankid, currencyId});
                } else if (BE019.equals("2")) {
                    String sql = "update t_be_AccountBankBalance set fvalibalance=?, FLastUpdateUserID=? , FLastUpdateTime=?  where fbizdate=? and faccountbankid=? and fcurrencyid=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{lstBa, userId, updateTime, sqllstBizDate, accountBankid, currencyId});
                }
            }
        }
    }

    public static boolean isSupportLstBalance(Context ctx, String Banktype) {
        if (EmptyUtil.isEmpty((String)Banktype)) {
            return false;
        }
        return Banktype.startsWith("ICBC");
    }

    public FundTransferInfo parseTransUpBillInfo(Context ctx, BankTransUpBillInfo info, BankTransUpBillEntryInfo entryInfo) throws BOSException, EASBizException, RemoteException, ServiceException {
        countrys = this.getBankCountry(ctx);
        logger.info((Object)"begin to parse PaymentInfo!");
        BankAcnt motherBankAcnt = this.createUpMotherBankAcnt(ctx, info, countrys);
        BankAcnt subBankAcnt = this.createUpSubBankAcnt(ctx, info, entryInfo, countrys);
        FundTransferInfo fundTransferInfo = new FundTransferInfo();
        fundTransferInfo.setUpperBankAcnt(motherBankAcnt);
        fundTransferInfo.setLowerBankAcnt(subBankAcnt);
        String currency = FmBeHelper.getCurrency(ctx, info.getCurrency());
        fundTransferInfo.setCurrency(currency);
        if (EmptyUtil.isEmpty((String)entryInfo.getSerialNumber())) {
            BankServiceUtil bankServiceUtil = new BankServiceUtil(ctx);
            String[] serialNumbers = bankServiceUtil.getSerialNumber(motherBankAcnt, false, 1);
            if (serialNumbers != null && serialNumbers.length == 1) {
                fundTransferInfo.setPackageID(serialNumbers[0]);
            }
        } else {
            fundTransferInfo.setPackageID(entryInfo.getSerialNumber());
        }
        fundTransferInfo.setAmount(entryInfo.getAmount());
        int description = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        if (description > 0 && info.getDescription() != null && info.getDescription().length() > description) {
            info.setDescription(info.getDescription().substring(0, description));
        }
        fundTransferInfo.setExplanation(info.getDescription());
        fundTransferInfo.setSubmitDate(Calendar.getInstance().getTime());
        fundTransferInfo.setBusinessRefNumber(entryInfo.getSrcBillNumber());
        fundTransferInfo.setSubmiterID(info.getCreator().getId().toString());
        fundTransferInfo.setTransferUp(true);
        return fundTransferInfo;
    }

    public FundTransferInfo parseTransDownBillInfo(Context ctx, BankTransDownBillInfo info, BankTransDownBillEntryInfo entryInfo) throws BOSException, EASBizException, RemoteException, ServiceException {
        countrys = this.getBankCountry(ctx);
        logger.info((Object)"begin to parse PaymentInfo!");
        BankAcnt motherBankAcnt = this.createDownMotherBankAcnt(ctx, info, countrys);
        BankAcnt subBankAcnt = this.createDownSubBankAcnt(ctx, info, entryInfo, countrys);
        FundTransferInfo fundTransferInfo = new FundTransferInfo();
        fundTransferInfo.setUpperBankAcnt(motherBankAcnt);
        fundTransferInfo.setLowerBankAcnt(subBankAcnt);
        String currency = FmBeHelper.getCurrency(ctx, info.getCurrency());
        fundTransferInfo.setCurrency(currency);
        if (EmptyUtil.isEmpty((String)entryInfo.getSerialNumber())) {
            BankServiceUtil bankServiceUtil = new BankServiceUtil(ctx);
            String[] serialNumbers = bankServiceUtil.getSerialNumber(motherBankAcnt, false, 1);
            if (serialNumbers != null && serialNumbers.length == 1) {
                fundTransferInfo.setPackageID(serialNumbers[0]);
            }
        } else {
            fundTransferInfo.setPackageID(entryInfo.getSerialNumber());
        }
        fundTransferInfo.setAmount(entryInfo.getAmount());
        int description = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId()));
        if (description > 0 && info.getDescription() != null && info.getDescription().length() > description) {
            info.setDescription(info.getDescription().substring(0, description));
        }
        fundTransferInfo.setExplanation(info.getDescription());
        fundTransferInfo.setSubmitDate(Calendar.getInstance().getTime());
        fundTransferInfo.setBusinessRefNumber(entryInfo.getSrcBillNumber());
        fundTransferInfo.setSubmiterID(info.getCreator().getId().toString());
        fundTransferInfo.setTransferUp(false);
        return fundTransferInfo;
    }

    public BankAcnt createUpMotherBankAcnt(Context ctx, BankTransUpBillInfo info, Country[] countrys) throws EASBizException, BOSException {
        AccountBankInfo motherAccountBank = info.getMotherAcctBank();
        ObjectUuidPK pk = new ObjectUuidPK(motherAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        selector.add("openArea.*");
        motherAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt motherBankAcnt = new BankAcnt();
        if (!EmptyUtil.isEmpty((Object)motherAccountBank.getBankInterfaceType())) {
            motherBankAcnt.setBank(motherAccountBank.getBankInterfaceType().getAlias());
        }
        motherBankAcnt.setAcntNumber(motherAccountBank.getBankAccountNumber());
        motherBankAcnt.setAcntName(motherAccountBank.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, motherAccountBank, motherBankAcnt);
        motherBankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        this.setRecProvinceAndCity(ctx, info.getRecProvince(), info.getRecCity(), motherBankAcnt);
        return motherBankAcnt;
    }

    private BankAcnt createUpSubBankAcnt(Context ctx, BankTransUpBillInfo info, BankTransUpBillEntryInfo entryInfo, Country[] countrys) throws EASBizException, BOSException {
        AccountBankInfo subAccountBank = entryInfo.getUnitAcctBank();
        ObjectUuidPK pk = new ObjectUuidPK(subAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        selector.add("openArea.*");
        subAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt subBankAcnt = new BankAcnt();
        if (!EmptyUtil.isEmpty((Object)subAccountBank.getBankInterfaceType())) {
            subBankAcnt.setBank(subAccountBank.getBankInterfaceType().getAlias());
        }
        subBankAcnt.setAcntNumber(subAccountBank.getBankAccountNumber());
        subBankAcnt.setAcntName(subAccountBank.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, subAccountBank, subBankAcnt);
        subBankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        FmBeHelper.setPayerProviceAndCity(subAccountBank, subBankAcnt);
        return subBankAcnt;
    }

    public BankAcnt createDownMotherBankAcnt(Context ctx, BankTransDownBillInfo info, Country[] countrys) throws EASBizException, BOSException {
        AccountBankInfo motherAccountBank = info.getMotherAcctBank();
        ObjectUuidPK pk = new ObjectUuidPK(motherAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        selector.add("openArea.*");
        motherAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt motherBankAcnt = new BankAcnt();
        if (!EmptyUtil.isEmpty((Object)motherAccountBank.getBankInterfaceType())) {
            motherBankAcnt.setBank(motherAccountBank.getBankInterfaceType().getAlias());
        }
        motherBankAcnt.setAcntNumber(motherAccountBank.getBankAccountNumber());
        motherBankAcnt.setAcntName(motherAccountBank.getAcctName());
        FmBeHelper.setPayerProviceAndCity(motherAccountBank, motherBankAcnt);
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, motherAccountBank, motherBankAcnt);
        if (motherAccountBank != null) {
            motherBankAcnt.setBranchID(motherAccountBank.getOpenArea().getNumber());
            motherBankAcnt.setDeptID(motherAccountBank.getOpenArea().getDeptID());
        }
        return motherBankAcnt;
    }

    private BankAcnt createDownSubBankAcnt(Context ctx, BankTransDownBillInfo info, BankTransDownBillEntryInfo entryInfo, Country[] countrys) throws EASBizException, BOSException {
        AccountBankInfo subAccountBank = entryInfo.getUnitAcctBank();
        ObjectUuidPK pk = new ObjectUuidPK(subAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        selector.add("openArea.*");
        subAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt subBankAcnt = new BankAcnt();
        if (!EmptyUtil.isEmpty((String)entryInfo.getRecBank())) {
            subBankAcnt.setBank(entryInfo.getRecBank());
        }
        subBankAcnt.setAcntNumber(subAccountBank.getBankAccountNumber());
        subBankAcnt.setAcntName(subAccountBank.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, subAccountBank, subBankAcnt);
        this.setRecProvinceAndCity(ctx, entryInfo.getRecProvince(), entryInfo.getRecCity(), subBankAcnt);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getPayeeArea())) {
            subBankAcnt.setBranchID(entryInfo.getPayeeArea().getNumber());
            subBankAcnt.setDeptID(entryInfo.getPayeeArea().getDeptID());
        }
        return subBankAcnt;
    }

    public static String getErrMsg(Exception err) {
        String returnMsg = "";
        if (err != null) {
            returnMsg = err.getMessage();
        }
        return returnMsg;
    }

    public AgencySalaryInfo parseBankGovHrWageJoinInfo(Context ctx, BankGovHrWageJoinInfo info) throws BOSException, EASBizException {
        logger.info((Object)"begin to parse PaymentInfo!");
        BankAcnt bankAcnt = this.createBankAcnt(ctx, info);
        PayUnitInfo[] payUnitSet = new PayUnitInfo[]{};
        AgencySalaryInfo agencySalaryInfo = new AgencySalaryInfo(bankAcnt, payUnitSet);
        agencySalaryInfo.setSubmitDate(Calendar.getInstance().getTime());
        String currency = "";
        agencySalaryInfo.setCurrency(currency);
        agencySalaryInfo.setBusinessRefNumber(info.getSrcBillNumber());
        agencySalaryInfo.setPackageID(info.getSrcBillNumber());
        agencySalaryInfo.setSubmiterID(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
        agencySalaryInfo.setExplanation(info.getDescription());
        PayUnitInfo[] detail = new PayUnitInfo[info.getEntry().size()];
        for (int i = 0; i < info.getEntry().size(); ++i) {
            BankGovHrWageEntryInfo bankGovHrWageEntryInfo = info.getEntry().get(i);
            BankAcnt subBankAcnt = this.createGovSubBankAcnt(ctx, info, bankGovHrWageEntryInfo);
            PayUnitInfo payUnitInfo = new PayUnitInfo(subBankAcnt);
            payUnitInfo.setCurrency(currency);
            payUnitInfo.setExplanation(bankGovHrWageEntryInfo.getId().toString());
            payUnitInfo.setAmount(bankGovHrWageEntryInfo.getMonery());
            detail[i] = payUnitInfo;
        }
        agencySalaryInfo.setPayUnitSet(detail);
        return agencySalaryInfo;
    }

    private BankAcnt createBankAcnt(Context ctx, BankGovHrWageJoinInfo info) throws EASBizException, BOSException {
        AccountBankInfo bankAccount = info.getBankAccount();
        ObjectUuidPK pk = new ObjectUuidPK(bankAccount.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        selector.add("openArea.*");
        bankAccount = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setBank(info.getBankInterfaceType().getAlias());
        bankAcnt.setAcntNumber(bankAccount.getBankAccountNumber());
        bankAcnt.setAcntName(bankAccount.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, bankAccount, bankAcnt);
        return bankAcnt;
    }

    private BankAcnt createGovSubBankAcnt(Context ctx, BankGovHrWageJoinInfo info, BankGovHrWageEntryInfo entryInfo) throws EASBizException, BOSException {
        AccountBankInfo bankAcct = info.getBankAccount();
        ObjectUuidPK pk = new ObjectUuidPK(bankAcct.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        selector.add("openArea.*");
        bankAcct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt subBankAcnt = new BankAcnt();
        subBankAcnt.setBank(info.getBankInterfaceType().getAlias());
        subBankAcnt.setAcntNumber(entryInfo.getPersonAccount());
        subBankAcnt.setAcntName(bankAcct.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, bankAcct, subBankAcnt);
        return subBankAcnt;
    }

    public static void setPayerProviceAndCity(AccountBankInfo payAccountBank, BankAcnt payBankAcnt) throws BEException {
        if (payAccountBank.getOpenArea() == null) {
            throw new BEException(BEException.PAYERAREAISNULL);
        }
        String provice = payAccountBank.getOpenArea().getProvince();
        payBankAcnt.setProvince(provice);
        String city = payAccountBank.getOpenArea().getName();
        payBankAcnt.setCity(city);
    }

    private void setRecProvinceAndCity(Context ctx, String recProvince, String recCity, BankAcnt recBankAcnt) throws BEException {
        recBankAcnt.setProvince(recProvince);
        recBankAcnt.setCity(recCity);
    }

    public static String getCurrencyBak(Context ctx, String oldCurrency) throws BEException, RemoteException, ServiceException {
        if (currencys == null) {
            BankBaseDataUtil bankBaseDataUtil = new BankBaseDataUtil(ctx);
            currencys = bankBaseDataUtil.getCurrency();
        }
        String newCurrency = null;
        for (int i = 0; i < currencys.length; ++i) {
            if (currencys[i] == null || !currencys[i].getName().equals(oldCurrency)) continue;
            newCurrency = currencys[i].getCode();
            break;
        }
        if (newCurrency == null) {
            throw new BEException(BEException.CURRENCYISERROR, new Object[]{oldCurrency});
        }
        return newCurrency;
    }

    public static String getCurrency(Context ctx, CurrencyInfo currency) throws EASBizException, BOSException {
        if (currency == null) {
            throw new BEException(BEException.CURRENCYISERROR, new Object[]{" "});
        }
        if (EmptyUtil.isEmpty((String)currency.getIsoCode())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isoCode"));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), sic);
        }
        if (currency.getIsoCode() == null) {
            throw new BEException(BEException.CURRENCYISOERROR, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"162_FmBeHelper")});
        }
        String currencyCode = " ";
        currencyCode = "RMB".equalsIgnoreCase(currency.getIsoCode()) ? "CNY" : currency.getIsoCode().toUpperCase(Locale.ENGLISH);
        return currencyCode;
    }

    public static String getCurrencyISO(Context ctx, CurrencyInfo currency) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), sic);
        if (currency != null && currency.getIsoCode() != null) {
            if ("RMB".equalsIgnoreCase(currency.getIsoCode())) {
                return "CNY";
            }
            return currency.getIsoCode().toUpperCase(Locale.ENGLISH);
        }
        return "CNY";
    }

    public PaymentInfo parseAgentPayInfo(Context ctx, BankAgentPayBillInfo info, BankAgentPayBillEntryInfo entryInfo) throws BOSException, EASBizException, RemoteException, ServiceException {
        countrys = this.getBankCountry(ctx);
        BankAcnt payBankAcnt = FmBeHelper.createAgentPayBankAcnt(ctx, info.getPayAccountBank());
        BankAcnt recBankAcnt = this.createAgentRecBankAcnt(ctx, entryInfo, info);
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setBankAcnt(payBankAcnt);
        paymentInfo.setOppBankAcnt(recBankAcnt);
        String currency = FmBeHelper.getCurrency(ctx, info.getCurrency());
        paymentInfo.setCurrency(currency);
        paymentInfo.setAmount(entryInfo.getAmount());
        if (!EmptyUtil.isEmpty((String)info.getUsage())) {
            paymentInfo.setUse(info.getUsage());
        } else if (!EmptyUtil.isEmpty((CoreBaseInfo)entryInfo.getExpenseType())) {
            paymentInfo.setUse(entryInfo.getExpenseType().getName());
        }
        paymentInfo.setSameCity(entryInfo.getDifferPlace().getValue() == 0);
        paymentInfo.setExplanation(info.getUsage());
        paymentInfo.setBusinessRefNumber(info.getAgentNumber());
        paymentInfo.setSubmitDate(Calendar.getInstance().getTime());
        paymentInfo.setSubmiterID(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString());
        paymentInfo.setState(PaymentState.WILLSUBMIT);
        return paymentInfo;
    }

    public static BankAcnt createAgentPayBankAcnt(Context ctx, AccountBankInfo accountBank) throws EASBizException, BOSException {
        AccountBankInfo payAccountBank = accountBank;
        ObjectUuidPK pk = new ObjectUuidPK(payAccountBank.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("openArea.name");
        selector.add("openArea.province");
        selector.add("openArea.number");
        selector.add("openArea.deptID");
        payAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)pk, selector);
        BankAcnt bankAcnt = new BankAcnt();
        if (payAccountBank.getBankInterfaceType() == null) {
            throw new BEException(BEException.BANKINTERFACE);
        }
        bankAcnt.setBank(payAccountBank.getBankInterfaceType().getAlias());
        bankAcnt.setAcntNumber(payAccountBank.getBankAccountNumber());
        bankAcnt.setAcntName(payAccountBank.getAcctName());
        BankFacadeHelper.setBankAccountVersionAndCert(ctx, payAccountBank, bankAcnt);
        bankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        FmBeHelper.setPayerProviceAndCity(payAccountBank, bankAcnt);
        if (payAccountBank != null) {
            bankAcnt.setBranchID(payAccountBank.getOpenArea().getNumber());
            bankAcnt.setDeptID(payAccountBank.getOpenArea().getDeptID());
            bankAcnt.setAcntName(payAccountBank.getAcctName());
        }
        return bankAcnt;
    }

    private BankAcnt createAgentRecBankAcnt(Context ctx, BankAgentPayBillEntryInfo entryInfo, BankAgentPayBillInfo info) throws BEException {
        BankAcnt bankAcnt = new BankAcnt();
        String recAccountBank = entryInfo.getRecBankAccount();
        bankAcnt.setBank(entryInfo.getRecBankName());
        bankAcnt.setAcntNumber(recAccountBank);
        bankAcnt.setAcntName(entryInfo.getRecName());
        bankAcnt.setCountry(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"7_BankFacadeControllerBean"));
        this.setRecProvinceAndCity(ctx, entryInfo.getRecProvince(), entryInfo.getRecCity(), bankAcnt);
        return bankAcnt;
    }

    public static ElecBookInfo parseElecBookInfo(Context ctx, ReconciliateDetail reconDetail, ElecBookBizInfo bizInfo) throws BOSException, EASBizException, ParseException {
        ElecBookInfo info = new ElecBookInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)reconDetail.getAccount()));
        view.getSelector().add("id");
        view.getSelector().add("bankInterfaceType");
        view.getSelector().add("bankAccountNumber");
        view.getSelector().add("acctName");
        view.getSelector().add("company");
        view.getSelector().add("company.*");
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        AccountBankInfo accountBankInfo = coll.get(0);
        info.setBankAccount(accountBankInfo);
        info.setBankInterfType(accountBankInfo.getBankInterfaceType());
        info.setCompany(accountBankInfo.getCompany());
        EntityViewInfo Curview = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        Curview.setFilter(fi);
        if (reconDetail.getCurrency().equals("CNY") || reconDetail.getCurrency().equals("RMB")) {
            FilterInfo fi1 = new FilterInfo();
            fi1.getFilterItems().add(new FilterItemInfo("isoCode", (Object)"CNY"));
            fi1.getFilterItems().add(new FilterItemInfo("isoCode", (Object)"RMB"));
            fi1.setMaskString("#0 or #1");
            fi.mergeFilter(fi1, "and");
        } else {
            fi.getFilterItems().add(new FilterItemInfo("isoCode", (Object)reconDetail.getCurrency()));
        }
        CurrencyCollection currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(Curview);
        if (currency.size() > 0) {
            info.setCurrency(currency.get(0));
        }
        Date createDate = new SimpleDateFormat("yyyyMM").parse(reconDetail.getRecDate());
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)info.getCompany());
        info.setPeriod(periodInfo);
        if (!EmptyUtil.isEmpty((String)reconDetail.getBalance())) {
            info.setBalance(new BigDecimal(reconDetail.getBalance()));
        }
        info.setAcntDrct(reconDetail.getAcntDrct().equalsIgnoreCase("C") ? DirectionEnum.Credit : DirectionEnum.Debit);
        info.setRecRef(reconDetail.getRecRef());
        info.setBatchNumber(bizInfo.getBatchSeqId());
        info.setDetailSeqId(beServiceHelper.getSerialNumber(1)[0]);
        info.setSignStatus(BankSignEnum.NoSign);
        return info;
    }

    public static void setABCSwiftCode(Context ctx, AccountBankInfo accountBankInfo, BankAcnt bankAcnt) throws EASBizException, BOSException {
        if (accountBankInfo.getBankInterfaceType() != BankInterfaceTypeEnum.ABC || accountBankInfo.getReleMotherAcct() == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        AccountBankInfo motherAcctInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getReleMotherAcct().getId().toString()), sic);
        String motherAcctCity = "";
        if (motherAcctInfo.getOpenArea().getUnionCode() != null) {
            motherAcctCity = motherAcctInfo.getOpenArea().getUnionCode();
        }
        String motherAcctNum = motherAcctInfo.getBankAccountNumber();
        String motherAcctCur = "";
        if (motherAcctInfo.isIsByCurrency()) {
            motherAcctCur = motherAcctInfo.getCurrency().getIsoCode();
        }
        String swiftCode = motherAcctCity + "|" + motherAcctNum + "|" + motherAcctCur;
        bankAcnt.setSwiftCode(swiftCode);
    }

    public static RegularDetailInfo parseRegularDetailInfo(Context ctx, FixedInfo info) {
        RegularDetailInfo regularDetailInfo = new RegularDetailInfo();
        if (info.getBalance() == null) {
            info.setBalance("0");
        }
        regularDetailInfo.setVouhNo(" ");
        regularDetailInfo.setStatus(RegularDetailsEnum.getEnum(info.getStatus()));
        regularDetailInfo.setAdvisef(" ");
        regularDetailInfo.setAmount(new BigDecimal(info.getBalance()));
        if (!EmptyUtil.isEmpty((String)info.getRate())) {
            regularDetailInfo.setRate(new BigDecimal(info.getRate()));
        }
        if (EmptyUtil.isEmpty((String)info.getDepositTermValue())) {
            regularDetailInfo.setSaveTerm(null);
        } else {
            regularDetailInfo.setSaveTerm(new BigDecimal(info.getDepositTermValue()));
        }
        if (EmptyUtil.isEmpty((String)info.getDepositTermUnit())) {
            regularDetailInfo.setTermUnit(null);
        } else {
            regularDetailInfo.setTermUnit(RegularTermUnitEnum.getEnum(info.getDepositTermUnit()));
        }
        if (!EmptyUtil.isEmpty((String)info.getNextDepositType())) {
            regularDetailInfo.setRenewFlag(RegularRenewFlagEnum.getEnum(info.getNextDepositType()));
        }
        if (EmptyUtil.isEmpty((String)info.getNextDepositTermValue())) {
            regularDetailInfo.setNextTerm(null);
        } else {
            regularDetailInfo.setNextTerm(new BigDecimal(info.getNextDepositTermValue()));
        }
        if (EmptyUtil.isEmpty((String)info.getNextDepositTermUnit())) {
            regularDetailInfo.setNextTermUnit(null);
        } else {
            regularDetailInfo.setNextTermUnit(RegularTermUnitEnum.getEnum(info.getNextDepositTermUnit()));
        }
        if (!EmptyUtil.isEmpty((String)info.getTotalInterest())) {
            regularDetailInfo.setTotalInt(new BigDecimal(info.getTotalInterest()));
        }
        if (!EmptyUtil.isEmpty((String)info.getCloseInterest())) {
            regularDetailInfo.setCloseInt(new BigDecimal(info.getCloseInterest()));
        }
        if (info.getAccNo() != null) {
            AccountBankInfo actbankinfo = null;
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)info.getAccNo()));
                view.getSelector().add("id");
                view.getSelector().add("bankInterfaceType");
                view.getSelector().add("bankAccountNumber");
                view.getSelector().add("acctName");
                view.getSelector().add("acctName");
                view.getSelector().add("company.*");
                view.getSelector().add("currency.*");
                AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                actbankinfo = coll.get(0);
                if (actbankinfo == null) {
                    regularDetailInfo.setBankAccount(null);
                } else {
                    regularDetailInfo.setBankAccount(actbankinfo);
                    regularDetailInfo.setBankInterface(actbankinfo.getBankInterfaceType());
                    regularDetailInfo.setCurrency(actbankinfo.getCurrency());
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return regularDetailInfo;
    }

    public static boolean isExistsRegularDetail(Context ctx, RegularDetailInfo info) throws EASBizException, BOSException {
        boolean isExists = false;
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)info.getBankAccount().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("vouhNo", (Object)info.getVouhNo()));
        logger.info((Object)("bankface filter:" + fi));
        isExists = RegularDetailFactory.getLocalInstance(ctx).exists(fi);
        logger.info((Object)(" isists :" + isExists));
        return isExists;
    }

    public static RegularBizInfo parseRegularBizInfo(RegularFixTransInfo regularTransInfo) {
        RegularBizInfo regularBizInfo = new RegularBizInfo();
        regularBizInfo.setAmount(regularTransInfo.getAmount());
        regularBizInfo.setBillType(regularTransInfo.getBillType());
        regularBizInfo.setCurrency(regularTransInfo.getCurrency());
        regularBizInfo.setCurrentAccNo(regularTransInfo.getCurrentAccNo());
        regularBizInfo.setDepositTermUnit(regularTransInfo.getDepositTermUnit());
        regularBizInfo.setDepositTermValue(regularTransInfo.getDepositTermValue());
        regularBizInfo.setFixedAccNo(regularTransInfo.getFixedAccNo());
        regularBizInfo.setNextDepositTermUnit(regularTransInfo.getNextDepositTermUnit());
        regularBizInfo.setNextDepositTermValue(regularTransInfo.getNextDepositTermValue());
        regularBizInfo.setNextDepositType(regularTransInfo.getNextDepositType());
        regularBizInfo.setStatus(regularTransInfo.getStatus());
        regularBizInfo.setStatusMsg(regularTransInfo.getStatusMsg());
        return regularBizInfo;
    }

    public static void sendAccountBalanceMessage(Context ctx, Map rstMap) {
        ArrayList balanceAccountList = (ArrayList)rstMap.get(BALANCE_ZERO_ACCOUNT);
        if (balanceAccountList != null && balanceAccountList.size() > 0) {
            String receiveMessager = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String msgTitle = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"163_FmBeHelper");
            StringBuffer msgBody = new StringBuffer("");
            String accountFormat = "{0}----{1}";
            for (AccountBankInfo info : balanceAccountList) {
                String msg;
                String accountName;
                String accountNumber = info.getBankAccountNumber();
                if (accountNumber == null) {
                    accountNumber = "";
                }
                if ((accountName = info.getName()) == null) {
                    accountName = "";
                }
                if ((msg = MessageFormat.format(accountFormat, accountNumber, accountName)) == null) continue;
                msgBody.append(msg).append("\n");
            }
            FmBeHelper.sendByMessage(ctx, msgTitle, EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"148_ScheduleJobControllerBean"), msgBody.toString(), receiveMessager);
        }
    }

    public static void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = FmBeHelper.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.start();
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public String[] getPayAccountSerialNumber(Context ctx, BankPayingBillInfo info, int count) throws EASBizException, BOSException {
        BankServiceUtil bankServiceUtil = new BankServiceUtil(ctx);
        try {
            BankAcnt payBankAcnt = this.createPayBankAcnt(ctx, info, this.getBankCountry(ctx));
            return bankServiceUtil.getSerialNumber(payBankAcnt, true, count);
        }
        catch (RemoteException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkBEIsAliveByPay(String companyid) throws FMException {
        String strValue = ContextHelperFactory.getRemoteInstance().getStringParam("TM018", (IObjectPK)new ObjectUuidPK(companyid));
        if (strValue == null || "1".equals(strValue)) {
            return;
        }
        try {
            BankFacadeFactory.getRemoteInstance().getVersion();
        }
        catch (Exception e1) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ErrCodeHelper.getResourceByErrCode("BE1002", e1.getMessage())});
        }
    }

    public static void checkBEIsAliveByPayTM018(String companyid, String tm018) throws FMException {
        if (tm018 == null || "1".equals(tm018)) {
            return;
        }
        try {
            BankFacadeFactory.getRemoteInstance().getVersion();
        }
        catch (Exception e1) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ErrCodeHelper.getResourceByErrCode("BE1002", e1.getMessage())});
        }
    }

    public static void lockedTransDetailIds(Context ctx, Set ids) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "update T_Be_TransDetail set FLastUpdateUserID = ? where fid in " + FMHelper.setTran2String((Set)ids);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{user.getId().toString()});
    }

    public static boolean isNotExistsMulBeService(Context ctx) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isMultiple", (Object)0, CompareType.EQUALS));
        boolean isExist = BeServiceAddFactory.getLocalInstance(ctx).exists(filter);
        return isExist;
    }

    public static Set<String> getPing(Context ctx, Set<String> bizBillIdSet, Map<String, BankPayResult> bankPayResultMap) throws BOSException, EASBizException {
        String strValue;
        boolean isNeedCommitToBank;
        Iterator<String> key;
        Object idSet = null;
        Map<String, IObjectCollection> paymentBillMap = FmBeHelper.getPaymentBillsByPayAccount(ctx, bizBillIdSet);
        BOSObjectType bosType = BOSUuid.read((String)bizBillIdSet.iterator().next()).getType();
        if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
            key = paymentBillMap.keySet().iterator();
            PaymentBillCollection payColl = (PaymentBillCollection)paymentBillMap.get(key.next());
            isNeedCommitToBank = false;
            strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(payColl.get(0).getCompany().getId()));
            boolean bl = isNeedCommitToBank = strValue == null || "0".equals(strValue);
            if (!isNeedCommitToBank) {
                return bizBillIdSet;
            }
        } else if (bosType.equals((Object)new SettlementBillInfo().getBOSType())) {
            key = paymentBillMap.keySet().iterator();
            SettlementBillCollection SettleColl = (SettlementBillCollection)paymentBillMap.get(key.next());
            isNeedCommitToBank = false;
            strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(SettleColl.get(0).getCompany().getId()));
            boolean bl = isNeedCommitToBank = strValue == null || "0".equals(strValue);
            if (!isNeedCommitToBank) {
                return bizBillIdSet;
            }
        }
        Iterator<String> iterator = paymentBillMap.keySet().iterator();
        BankBizInfo[] bizInfos = new BankBizInfo[paymentBillMap.keySet().size()];
        int n = 0;
        while (iterator.hasNext()) {
            String BankAccountNumber = iterator.next();
            BankBizInfo biz = new BankBizInfo();
            biz.setBankAcct(BankAccountNumber);
            bizInfos[n] = biz;
            ++n;
        }
        PingUtil pingUtil = new PingUtil();
        PingResponseBody body = pingUtil.getPing(ctx, bizInfos);
        ArrayList<PingResult> pingResults = new ArrayList<PingResult>();
        if (!EmptyUtil.isEmpty((Object)body)) {
            int i;
            PingDetail[] detail = body.getDetails();
            for (i = 0; i < detail.length; ++i) {
                if (detail[i].isSuccess()) continue;
                pingResults.add(new PingResult(detail[i].getAccNo().toString(), detail[i].getMessage().toString()));
            }
            if (!EmptyUtil.isEmpty(pingResults)) {
                for (i = 0; i < pingResults.size(); ++i) {
                    IObjectCollection payColl = paymentBillMap.get(((PingResult)pingResults.get(i)).getAccountBankNumber());
                    for (int fail = 0; fail < payColl.size(); ++fail) {
                        String ids = null;
                        String number = null;
                        if (payColl.getObject(fail).getBOSType().equals((Object)new PaymentBillInfo().getBOSType())) {
                            ids = ((PaymentBillInfo)payColl.getObject(fail)).getId().toString();
                            number = ((PaymentBillInfo)payColl.getObject(fail)).getNumber().toString();
                        } else if (payColl.getObject(fail).getBOSType().equals((Object)new BankPayingBillInfo().getBOSType())) {
                            ids = ((BankPayingBillInfo)payColl.getObject(fail)).getId().toString();
                            number = ((BankPayingBillInfo)payColl.getObject(fail)).getNumber().toString();
                        } else if (payColl.getObject(fail).getBOSType().equals((Object)new SettlementBillInfo().getBOSType())) {
                            ids = ((SettlementBillInfo)payColl.getObject(fail)).getId().toString();
                            number = ((SettlementBillInfo)payColl.getObject(fail)).getNumber().toString();
                        }
                        String returnMsg = "\u4ed8\u6b3e\u8d26\u6237\u4e3a\uff1a" + ((PingResult)pingResults.get(i)).getAccountBankNumber() + ", \u4ed8\u6b3e\u5931\u8d25\u539f\u56e0\u4e3a\uff1a\u94f6\u4f01\u5e73\u53f0\u8fd4\u56de" + ((PingResult)pingResults.get(i)).getReturnMsg();
                        BankPayResult payResult = new BankPayResult(ids, number, null, returnMsg);
                        payResult.setSrcId(ids);
                        payResult.setErrorDetail(returnMsg);
                        payResult.setSubmitToBe(false);
                        bankPayResultMap.put(ids, payResult);
                        bizBillIdSet.remove(ids);
                    }
                    paymentBillMap.remove(((PingResult)pingResults.get(i)).getAccountBankNumber());
                }
            }
        }
        return bizBillIdSet;
    }

    private static Map<String, IObjectCollection> getPaymentBillsByPayAccount(Context ctx, Set<String> bizBillIdSet) throws BOSException, EASBizException {
        HashMap<String, IObjectCollection> resultMap;
        block7: {
            BOSObjectType bosType;
            BankPayingBillCollection collection;
            block8: {
                block6: {
                    collection = null;
                    resultMap = new HashMap<String, IObjectCollection>();
                    bosType = BOSUuid.read((String)bizBillIdSet.iterator().next()).getType();
                    if (!bosType.equals((Object)new PaymentBillInfo().getBOSType())) break block6;
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("number"));
                    selector.add(new SelectorItemInfo("Company"));
                    selector.add(new SelectorItemInfo("payerAccountBank.id"));
                    selector.add(new SelectorItemInfo("payerAccountBank.*"));
                    view.setSelector(selector);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", bizBillIdSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SorterItemCollection sorters = new SorterItemCollection();
                    SorterItemInfo sorterItem = new SorterItemInfo("payerAccountBank.id");
                    sorters.add(sorterItem);
                    view.setSorter(sorters);
                    collection = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
                    int size = collection.size();
                    for (int i = 0; i < size; ++i) {
                        String bankAccountNumber = null;
                        PaymentBillCollection paymentBills = null;
                        PaymentBillInfo info = (PaymentBillInfo)collection.getObject(i);
                        bankAccountNumber = !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank()) ? info.getPayerAccountBank().getBankAccountNumber() : "";
                        paymentBills = (PaymentBillCollection)resultMap.get(bankAccountNumber);
                        if (EmptyUtil.isEmpty((AbstractObjectCollection)paymentBills)) {
                            paymentBills = new PaymentBillCollection();
                            resultMap.put(bankAccountNumber, (IObjectCollection)paymentBills);
                        }
                        paymentBills.add(info);
                    }
                    break block7;
                }
                if (!bosType.equals((Object)new BankPayingBillInfo().getBOSType())) break block8;
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("payAccountBank.id");
                selector.add("payAccountBank.*");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", bizBillIdSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorters = new SorterItemCollection();
                SorterItemInfo sorterItem = new SorterItemInfo("payAccountBank.id");
                sorters.add(sorterItem);
                view.setSorter(sorters);
                collection = BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(view);
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    String bankAccountNumber = null;
                    BankPayingBillCollection paymentBills = null;
                    BankPayingBillInfo info = (BankPayingBillInfo)collection.getObject(i);
                    bankAccountNumber = !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayAccountBank()) ? info.getPayAccountBank().getBankAccountNumber() : "";
                    paymentBills = (BankPayingBillCollection)((Object)resultMap.get(bankAccountNumber));
                    if (EmptyUtil.isEmpty((AbstractObjectCollection)paymentBills)) {
                        paymentBills = new BankPayingBillCollection();
                        resultMap.put(bankAccountNumber, (IObjectCollection)paymentBills);
                    }
                    paymentBills.add(info);
                }
                break block7;
            }
            if (!bosType.equals((Object)new SettlementBillInfo().getBOSType())) break block7;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("Company");
            selector.add("PayerBankAcct");
            selector.add("PayerBankAcct.*");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", bizBillIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SorterItemCollection sorters = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("payerBankAcct.id");
            sorters.add(sorterItem);
            view.setSorter(sorters);
            collection = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(view);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                String bankAccountNumber = null;
                SettlementBillCollection paymentBills = null;
                SettlementBillInfo info = (SettlementBillInfo)collection.getObject(i);
                bankAccountNumber = !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBankAcct()) ? info.getPayerBankAcct().getBankAccountNumber() : "";
                paymentBills = (SettlementBillCollection)resultMap.get(bankAccountNumber);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)paymentBills)) {
                    paymentBills = new SettlementBillCollection();
                    resultMap.put(bankAccountNumber, (IObjectCollection)paymentBills);
                }
                paymentBills.add(info);
            }
        }
        return resultMap;
    }
}

