/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.app.IBankPayingBillCnt;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractBankPayingBillCnt
implements IBankPayingBillCnt {
    private static Logger logger = Logger.getLogger(AbstractBankPayingBillCnt.class);
    public static final int PERSON_VALUE = 1;
    public static final int PUBLIC_VALUE = 0;
    private int status;
    private int isPersonPay;

    public AbstractBankPayingBillCnt(int status, int isPersonPay) {
        this.status = status;
        this.isPersonPay = isPersonPay;
    }

    @Override
    public int getBankPayingBillCnt(Context ctx, Set<String> companyIds, Date startDate, Date endDate) throws BOSException, EASBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("SELECT count(fid) from T_BE_BankPayingBill WHERE ");
        sql.append("FCompanyID in (");
        Object[] companyIdArray = companyIds.toArray();
        for (int idx = 0; idx < companyIdArray.length; ++idx) {
            if (idx > 0) {
                sql.append(",");
            }
            sql.append("?");
            params.add(companyIdArray[idx].toString());
        }
        sql.append(") ");
        sql.append("AND FCreateTime >= ");
        sql.append("{ts'" + TypeConversionUtils.objToDate((Object)startDate).toString() + " 00:00:00'} ");
        sql.append("AND FCreateTime <= ");
        sql.append("{ts'" + TypeConversionUtils.objToDate((Object)endDate).toString() + " 23:59:59'} ");
        sql.append("AND FState = ? ");
        sql.append("AND (fiscbpay = 0 or fiscbpay is null) ");
        params.add(this.status);
        if (this.status == 1) {
            sql.append("AND FIsBitBack <> 1 ");
        }
        sql.append("AND FisPersonPay = ? ");
        params.add(this.isPersonPay);
        logger.debug((Object)sql.toString());
        int count = 0;
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt(1);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return count;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getIsPersonPay() {
        return this.isPersonPay;
    }

    public void setIsPersonPay(int isPersonPay) {
        this.isPersonPay = isPersonPay;
    }
}

