/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.BalSourceTpye;
import com.kingdee.eas.fm.be.IAccountBankBalance;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctBankBalanceDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)AcctBankBalanceDataImport.class.getName());
    private Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, AccountBankInfo> bankMap = new HashMap<String, AccountBankInfo>();
    private Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    CurrencyInfo currency = new CurrencyInfo();

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AccountBankBalanceInfo info = new AccountBankBalanceInfo();
        this.parseData(hsData, info, ctx);
        return info;
    }

    private CoreBaseInfo parseData(Hashtable hsData, AccountBankBalanceInfo info, Context ctx) throws TaskExternalException {
        Timestamp accurateBizDate;
        FilterInfo filter;
        EntityViewInfo view;
        Object data = null;
        String companyid = null;
        data = this.getData(hsData, "FCompany_number");
        if (data != null && data.toString().trim().length() > 0) {
            if (this.companyMap.containsKey(data.toString().trim())) {
                info.setCompany(this.companyMap.get(data.toString().trim()));
                companyid = this.companyMap.get(data.toString().trim()).getId().toString();
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyCol = null;
                try {
                    companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (companyCol == null || companyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"342_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                this.companyMap.put(data.toString().trim(), companyCol.get(0));
                info.setCompany(companyCol.get(0));
                companyid = companyCol.get(0).getId().toString();
            }
        }
        if ((data = this.getData(hsData, "FAccountBank_bankAccountNumber")) != null && data.toString().trim().length() > 0) {
            if (this.bankMap.containsKey(data.toString().trim())) {
                AccountBankInfo accountBankInfo = this.bankMap.get(data.toString().trim());
                info.setAccountBank(accountBankInfo);
                if (companyid == null) {
                    companyid = accountBankInfo.getCompany().getId().toString();
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCurrency())) {
                        this.currency = accountBankInfo.getCurrency();
                        info.setCurrency(accountBankInfo.getCurrency());
                    }
                } else if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getCurrency())) {
                    this.currency = accountBankInfo.getCurrency();
                    info.setCurrency(accountBankInfo.getCurrency());
                }
                info.setCompany(accountBankInfo.getCompany());
            } else {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("company.name"));
                view.setSelector(sic);
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)data.toString().trim()));
                if (companyid != null) {
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
                }
                view.setFilter(filter);
                AccountBankCollection AccountBankCol = new AccountBankCollection();
                try {
                    AccountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (AccountBankCol == null || AccountBankCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"345_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                if (AccountBankCol.get(0).isIsSetBankInterface()) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"346_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                AccountBankInfo accountBankInfo = AccountBankCol.get(0);
                if (companyid != null && accountBankInfo.getShareType() != null && accountBankInfo.getShareType().getValue() == 2) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"347_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"348_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"349_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                this.bankMap.put(data.toString().trim(), AccountBankCol.get(0));
                info.setAccountBank(AccountBankCol.get(0));
                if (companyid == null) {
                    companyid = accountBankInfo.getCompany().getId().toString();
                    if (EmptyUtil.isEmpty((CoreBaseInfo)AccountBankCol.get(0).getCurrency())) {
                        Object currencyNumber = this.getData(hsData, "FCurrency_number");
                        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.currency)) {
                            info.setCurrency(this.currency);
                        } else if (currencyNumber == null || currencyNumber.toString().trim().length() <= 0) {
                            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"344_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"350_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                        }
                    } else {
                        this.currency = accountBankInfo.getCurrency();
                        info.setCurrency(this.currency);
                    }
                } else if (!EmptyUtil.isEmpty((CoreBaseInfo)AccountBankCol.get(0).getCurrency())) {
                    this.currency = accountBankInfo.getCurrency();
                    info.setCurrency(this.currency);
                }
                info.setCompany(accountBankInfo.getCompany());
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"351_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        if (companyid == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"352_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)"acctBankBalance_05import");
            if (!isPermission) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"353_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"354_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"355_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"356_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"356_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCurrency_number");
        if (data != null && data.toString().trim().length() > 0 && EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            if (this.currencyMap.containsKey(data.toString().trim())) {
                this.currency = this.currencyMap.get(data.toString().trim());
                info.setCurrency(this.currency);
            } else {
                EntityViewInfo view2 = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                view2.setFilter(filter);
                CurrencyCollection currencyCol = null;
                try {
                    currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view2);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (currencyCol == null || currencyCol.size() < 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"357_AcctBankBalanceDataImport", (Locale)ctx.getLocale()) + data + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"343_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
                }
                this.currency = currencyCol.get(0);
                this.currencyMap.put(data.toString().trim(), this.currency);
                info.setCurrency(this.currency);
            }
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"358_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FAccurateBizDate");
        if (data != null && data.toString().trim().length() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
            try {
                sdf.parse(data.toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            accurateBizDate = TypeConversionUtils.objToTimestamp((Object)data);
            Date now = DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)new Date()));
            if (accurateBizDate.compareTo(now) >= 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"359_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"360_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        info.setAccurateBizDate(accurateBizDate);
        info.setBizDate(DateTimeUtils.truncateDate((Date)accurateBizDate));
        data = this.getData(hsData, "FLstBalance");
        if (data != null && data.toString().trim().length() > 0) {
            info.setLstBalance(TypeConversionUtils.objToBigDecimal((Object)data));
        } else {
            info.setLstBalance(null);
        }
        data = this.getData(hsData, "FBalance");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"361_AcctBankBalanceDataImport", (Locale)ctx.getLocale()));
        }
        info.setBalance(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FValiBalance");
        if (data != null && data.toString().trim().length() > 0) {
            info.setValiBalance(TypeConversionUtils.objToBigDecimal((Object)data));
        } else {
            info.setValiBalance(null);
        }
        info.setIsImport(true);
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountBankBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AccountBankBalanceInfo info = (AccountBankBalanceInfo)coreBaseInfo;
        info.setBalSourceType(BalSourceTpye.IMPORT);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountBank", (Object)info.getAccountBank().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)info.getCurrency().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IAccountBankBalance iAccountBankBalance = (IAccountBankBalance)this.getController(ctx);
        try {
            AccountBankBalanceCollection coll = iAccountBankBalance.getAccountBankBalanceCollection(view);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                info.setIsImport(true);
                iAccountBankBalance.addnew((CoreBaseInfo)info);
            } else {
                AccountBankBalanceInfo acctInfo = coll.get(0);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("lstBalance");
                sic.add("balance");
                sic.add("valiBalance");
                sic.add("accurateBizDate");
                sic.add("isImport");
                sic.add("balSourceType");
                sic.add("lastUpdateTime");
                acctInfo.setLstBalance(info.getLstBalance());
                acctInfo.setBalance(info.getBalance());
                acctInfo.setValiBalance(info.getValiBalance());
                acctInfo.setAccurateBizDate(info.getAccurateBizDate());
                acctInfo.setBalSourceType(BalSourceTpye.IMPORT);
                acctInfo.setLastUpdateTime(this.getTime());
                acctInfo.setIsImport(true);
                iAccountBankBalance.updatePartial((CoreBaseInfo)acctInfo, sic);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp current = new Timestamp(d.getTime().getTime());
        return current;
    }
}

