/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.AccountBankBalanceCollection;
import com.kingdee.eas.fm.be.AccountBankBalanceFactory;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.app.AbstractAcctBankBalanceHistoryWebFacedeControllerBean;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctBankBalanceHistoryWebFacedeControllerBean
extends AbstractAcctBankBalanceHistoryWebFacedeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.AcctBankBalanceHistoryWebFacedeControllerBean");
    private static SimpleDateFormat DATEFORMAT_SHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat DATEFORMAT_FOR_QUERY = new SimpleDateFormat("yyyyMMdd");

    @Override
    protected List _getResultList(Context ctx, String beginDateStr, String endDateStr, String currencyId, String[] accountBankId) throws BOSException, EASBizException {
        List resultList = new ArrayList();
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        for (int i = 0; i < accountBankId.length; ++i) {
            AccountBankBalanceCollection coll = this.getAcctBankColl(ctx, beginDateStr, endDateStr, currencyId, accountBankId[i]);
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            AccountBankInfo accountBankInfo = null;
            CompanyOrgUnitInfo companyInfo = null;
            if (coll.size() > 0) {
                accountBankInfo = (AccountBankInfo)coll.get(0).get("accountBank");
                companyInfo = (CompanyOrgUnitInfo)coll.get(0).get("company");
                rowMap.put("company_name", companyInfo.getName());
                for (int j = 0; j < coll.size(); ++j) {
                    int columnNumber;
                    AccountBankBalanceInfo info = coll.get(j);
                    try {
                        columnNumber = this.judgeDateGreater(info.getAccurateBizDate(), DATEFORMAT_SHORT.parse(beginDateStr)) + 1;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        throw new BOSException((Throwable)e);
                    }
                    rowMap.put("column" + columnNumber, info.getBalance());
                }
            } else {
                accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId[i]));
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getCompany().getId()));
                rowMap.put("company_name", companyInfo.getName());
            }
            rowMap.put("accountBank_id", accountBankInfo.getId().toString());
            rowMap.put("accountBank_info", accountBankInfo.getName() + "\n" + accountBankInfo.getBankAccountNumber());
            rowMap.put("accountBank_currency", currencyInfo.getName());
            rowMap.put("precision", currencyInfo.getPrecision());
            resultList.add(rowMap);
        }
        resultList = this.dealWithResult(ctx, resultList);
        return resultList;
    }

    public AccountBankBalanceCollection getAcctBankColl(Context ctx, String beginDateStr, String endDateStr, String currencyId, String accountBankId) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("company.name");
        ev.getSelector().add("accountBank.name");
        ev.getSelector().add("accountBank.bankAccountNumber");
        ev.getSelector().add("balance");
        ev.getSelector().add("accurateBizDate");
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        Date begin = null;
        Date end = null;
        try {
            begin = DateTimeUtils.parseDate((String)beginDateStr, (String)"yyyy-MM-dd");
            end = DateTimeUtils.parseDate((String)endDateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBankId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", begin == null ? beginDateStr : begin, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", end == null ? endDateStr : end, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS));
        AccountBankBalanceCollection coll = AccountBankBalanceFactory.getLocalInstance(ctx).getAccountBankBalanceCollection(ev);
        return coll;
    }

    private List dealWithResult(Context ctx, List resultList) {
        Collections.sort((List)resultList, (Comparator)new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                return ((String)o1.get("company_name")).compareTo((String)o2.get("company_name"));
            }
        });
        ArrayList<Map> tempList = new ArrayList<Map>();
        ArrayList<Map> result = new ArrayList<Map>();
        Map tatalSum = this.getSumRow(ctx, resultList);
        tatalSum.remove("company_name");
        tatalSum.put("company_name", CASWebUtil.getResource((Context)ctx, (String)"535_TOTALSUM"));
        String lastCompany = "";
        for (int i = 0; i < resultList.size(); ++i) {
            Map sumRow;
            Map rowData = (Map)resultList.get(i);
            rowData.put("querySeq_No", i + 1);
            if (i == 0 && i == resultList.size() - 1) {
                tempList.add(rowData);
                result.add(rowData);
                sumRow = this.getSumRow(ctx, tempList);
                tempList.clear();
                result.add(sumRow);
            } else if (i == 0 && i != resultList.size() - 1) {
                tempList.add(rowData);
                result.add(rowData);
            } else if (i != 0 && i == resultList.size() - 1 && !lastCompany.equals(rowData.get("company_name").toString())) {
                sumRow = this.getSumRow(ctx, tempList);
                tempList.clear();
                result.add(sumRow);
                tempList.add(rowData);
                result.add(rowData);
                sumRow = this.getSumRow(ctx, tempList);
                result.add(sumRow);
            } else if (i != 0 && i == resultList.size() - 1 && lastCompany.equals(rowData.get("company_name").toString())) {
                tempList.add(rowData);
                result.add(rowData);
                sumRow = this.getSumRow(ctx, tempList);
                tempList.clear();
                result.add(sumRow);
            } else if (i != 0 && i != resultList.size() - 1 && !lastCompany.equals(rowData.get("company_name").toString())) {
                sumRow = this.getSumRow(ctx, tempList);
                tempList.clear();
                result.add(sumRow);
                tempList.add(rowData);
                result.add(rowData);
            } else {
                tempList.add(rowData);
                result.add(rowData);
            }
            lastCompany = rowData.get("company_name").toString();
        }
        result.add(tatalSum);
        return result;
    }

    private Map getSumRow(Context ctx, List tempList) {
        HashMap<String, Object> sumRow = new HashMap<String, Object>();
        Map rowData = (Map)tempList.get(0);
        sumRow.put("company_name", CASWebUtil.getResource((Context)ctx, (String)"531_SUM", (String[])new String[]{rowData.get("company_name").toString()}));
        sumRow.put("querySeq_No", "");
        for (int i = 1; i <= 30; ++i) {
            BigDecimal sum = new BigDecimal(0);
            BigDecimal temp = new BigDecimal(0);
            for (int j = 0; j < tempList.size(); ++j) {
                temp = (BigDecimal)((Map)tempList.get(j)).get("column" + i);
                if (temp == null || temp.equals(BigDecimal.ZERO)) continue;
                sum = sum.add(temp);
            }
            if (sum.equals(BigDecimal.ZERO)) continue;
            sumRow.put("column" + i, sum);
        }
        return sumRow;
    }

    public int judgeDateGreater(Date date, Date beginDate) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.set(beginDate.getYear(), beginDate.getMonth(), beginDate.getDate());
        calendar2.set(date.getYear(), date.getMonth(), date.getDate());
        long milliseconds1 = calendar1.getTimeInMillis();
        long milliseconds2 = calendar2.getTimeInMillis();
        long diff = milliseconds2 - milliseconds1;
        int diffDays = (int)(diff / 86400000L);
        return diffDays;
    }
}

