/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BECnapsDataWeb;
import com.kingdee.eas.fm.be.BeBankAbandonedStateEnum;
import com.kingdee.eas.fm.be.IBEBank;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class BEBankCallable
implements Callable {
    private static final Logger logger = Logger.getLogger(BEBankCallable.class);
    private Context ctx;
    private Map dataMap;
    private Set idSet;

    public BEBankCallable(Context ctx, Map dataMap, Set idSet) {
        this.ctx = ctx;
        this.dataMap = dataMap;
        this.idSet = idSet;
    }

    public Object call() throws Exception {
        logger.error((Object)">>> \u4efb\u52a1\u542f\u52a8");
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        HashSet updateData = new HashSet();
        HashSet addData = new HashSet();
        this.updateOrAddnewBEBankBatch(this.ctx, this.dataMap, this.idSet, updateData, addData);
        result.put("updateData", updateData);
        result.put("addData", addData);
        result.put("updateDataSize", Integer.valueOf(updateData.size()));
        result.put("addDataSize", Integer.valueOf(addData.size()));
        logger.error((Object)">>> \u4efb\u52a1\u7ed3\u675f");
        return result;
    }

    protected void updateOrAddnewBEBankBatch(Context ctx, Map dataMap, Set idSet, Set updateData, Set addData) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("BeProvince");
        selector.add("BeCity");
        selector.add("isAbandoned");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IBEBank ibeBank = BEBankFactory.getLocalInstance((Context)ctx);
        BEBankCollection coll = ibeBank.getBEBankCollection(view);
        HashMap<String, BEBankInfo> dbDataMap = new HashMap<String, BEBankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            dbDataMap.put(coll.get(i).getNumber(), coll.get(i));
        }
        CoreBaseCollection updateColl = new CoreBaseCollection();
        CoreBaseCollection addColl = new CoreBaseCollection();
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String flag = "";
        String dbKey = "";
        for (int i = 0; i < idSet.size(); ++i) {
            String bankCnaps = idSet.toArray()[i].toString();
            BECnapsDataWeb data = (BECnapsDataWeb)dataMap.get(bankCnaps);
            if (dbDataMap.containsKey(bankCnaps)) {
                BEBankInfo tmp = (BEBankInfo)dbDataMap.get(bankCnaps);
                String oldBankName = tmp.getName();
                flag = data.getBankName() + '_' + data.getProvinceName() + '_' + data.getCityName() + "_" + (EmptyUtil.isEmpty((String)data.getIsovertime()) ? "" : data.getIsovertime());
                if (flag.equals(dbKey = tmp.getName() + '_' + tmp.getBeProvince() + '_' + tmp.getBeCity() + "_" + (EmptyUtil.isEmpty((Object)((Object)tmp.getIsAbandoned())) ? "" : tmp.getIsAbandoned().getValue()))) continue;
                if (EmptyUtil.isEmpty((String)tmp.getName(LocaleUtils.locale_l1))) {
                    tmp.setName(data.getBankName(), LocaleUtils.locale_l1);
                }
                if (EmptyUtil.isEmpty((String)tmp.getName(LocaleUtils.locale_l2))) {
                    tmp.setName(data.getBankName(), LocaleUtils.locale_l2);
                }
                if (EmptyUtil.isEmpty((String)tmp.getName(LocaleUtils.locale_l3))) {
                    tmp.setName(data.getBankName(), LocaleUtils.locale_l3);
                }
                tmp.setName(data.getBankName());
                tmp.setBeProvince(data.getProvinceName());
                tmp.setBeCity(data.getCityName());
                tmp.setLastUpdateTime(this.getTime());
                if ("Y".equals(data.getIsovertime())) {
                    tmp.setIsAbandoned(BeBankAbandonedStateEnum.YES);
                } else if ("N".equals(data.getIsovertime())) {
                    tmp.setIsAbandoned(BeBankAbandonedStateEnum.NO);
                }
                if (!StringUtils.equals((String)oldBankName, (String)tmp.getName())) {
                    String updateSql = " update T_BD_CustomerCompanyBank set fbank = ? where fbank = ? ";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{tmp.getName(), oldBankName});
                    String updateSql2 = " update T_BD_SupplierCompanyBank set fbank = ? where fbank = ? ";
                    DbUtil.execute((Context)ctx, (String)updateSql2, (Object[])new Object[]{tmp.getName(), oldBankName});
                }
                updateData.add(tmp);
                updateColl.add((CoreBaseInfo)tmp);
                continue;
            }
            BEBankInfo info = new BEBankInfo();
            if (EmptyUtil.isEmpty((String)data.getBankCnaps()) || EmptyUtil.isEmpty((String)data.getBankName()) || "Y".equals(data.getIsovertime())) continue;
            info.setNumber(data.getBankCnaps());
            info.setName(data.getBankName(), LocaleUtils.locale_l1);
            info.setName(data.getBankName(), LocaleUtils.locale_l2);
            info.setName(data.getBankName(), LocaleUtils.locale_l3);
            info.setBeCity(data.getCityName().trim());
            info.setBeProvince(data.getProvinceName().trim());
            if ("N".equals(data.getIsovertime())) {
                info.setIsAbandoned(BeBankAbandonedStateEnum.NO);
            }
            info.setCreator(user);
            info.setLastUpdateUser(user);
            Timestamp createtime = this.getTime();
            info.setCreateTime(createtime);
            info.setLastUpdateTime(createtime);
            info.setCU(cu);
            addData.add(info);
            addColl.add((CoreBaseInfo)info);
        }
        ibeBank.addnewBatchData(addColl);
        ibeBank.updateBatchData(updateColl);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

