/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.app.IDataUpdateHandler;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BEBankUpdateTimeCollection;
import com.kingdee.eas.fm.be.BEBankUpdateTimeFactory;
import com.kingdee.eas.fm.be.BEBankUpdateTimeInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.StateEnum;
import com.kingdee.eas.fm.be.app.AbstractBEBankControllerBean;
import com.kingdee.eas.fm.be.app.BEBankCallable;
import com.kingdee.eas.fm.be.app.service.BankCnapsService;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class BEBankControllerBean
extends AbstractBEBankControllerBean {
    private static final Logger logger = Logger.getLogger(BEBankControllerBean.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BEBankInfo dataBaseInfo = (BEBankInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"name");
        BEBankInfo newValue = (BEBankInfo)model;
        newValue.setName(newValue.getName(), LocaleUtils.locale_l2);
        newValue.setName(newValue.getName(), LocaleUtils.locale_l1);
        newValue.setName(newValue.getName(), LocaleUtils.locale_l3);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        BEBankInfo newValue = (BEBankInfo)model;
        BEBankInfo oldValue = this.getBEBankInfo(ctx, pk);
        if (EmptyUtil.isEmpty((String)newValue.getName(LocaleUtils.locale_l1))) {
            if (!EmptyUtil.isEmpty((String)oldValue.getName(LocaleUtils.locale_l1))) {
                newValue.setName(oldValue.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            } else {
                newValue.setName(newValue.getName(), LocaleUtils.locale_l1);
            }
        }
        if (EmptyUtil.isEmpty((String)newValue.getName(LocaleUtils.locale_l2))) {
            if (!EmptyUtil.isEmpty((String)oldValue.getName(LocaleUtils.locale_l2))) {
                newValue.setName(oldValue.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            } else {
                newValue.setName(newValue.getName(), LocaleUtils.locale_l2);
            }
        }
        if (EmptyUtil.isEmpty((String)newValue.getName(LocaleUtils.locale_l3))) {
            if (!EmptyUtil.isEmpty((String)oldValue.getName(LocaleUtils.locale_l3))) {
                newValue.setName(oldValue.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            } else {
                newValue.setName(newValue.getName(), LocaleUtils.locale_l3);
            }
        }
        super._update(ctx, pk, (IObjectValue)newValue);
        this.dataUpdateHandler(ctx, oldValue, newValue);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BEBankInfo dataBaseInfo = (BEBankInfo)this._getValue(ctx, pk);
        if (dataBaseInfo.getState().equals((Object)StateEnum.EFFECTIVE)) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"510_BEBankControllerBean", (Locale)ctx.getLocale())});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected String _getBankNo(Context ctx, String recBank) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)recBank)) {
            return null;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql("select fnumber from T_BE_BEBank where FName_" + ctx.getLocale().toString() + " = ?");
        sb.addParams(new Object[]{recBank.trim()});
        ResultSet rs = sb.exeQuery(ctx);
        String item = null;
        try {
            if (rs.next()) {
                item = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return item;
    }

    private void dataUpdateHandler(Context ctx, BEBankInfo oldValue, BEBankInfo newValue) throws BOSException {
        if (oldValue == null || newValue == null) {
            return;
        }
        String[] handlers = null;
        String bosTye = oldValue.getId().getType().toString();
        try {
            handlers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosTye, IDataUpdateHandler.class);
        }
        catch (EASDBException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (handlers == null || handlers.length == 0) {
            return;
        }
        for (int i = 0; i < handlers.length; ++i) {
            try {
                Class<?> handlerClass = Class.forName(handlers[i]);
                Object handler = handlerClass.newInstance();
                if (handler == null || !(handler instanceof IDataUpdateHandler)) continue;
                ((IDataUpdateHandler)handler).dataUpdate(ctx, (IObjectValue)oldValue, (IObjectValue)newValue);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected Map _batchImport(Context ctx, Set set) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        HashSet<BEBankInfo> unChangeData = new HashSet<BEBankInfo>();
        HashSet<BEBankInfo> updateData = new HashSet<BEBankInfo>();
        HashSet<BEBankInfo> addData = new HashSet<BEBankInfo>();
        HashSet<String> idSet = new HashSet<String>();
        for (BEBankInfo info : set) {
            idSet.add(info.getNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        HashMap<String, BEBankInfo> dbDataMap = new HashMap<String, BEBankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            dbDataMap.put(coll.get(i).getNumber(), coll.get(i));
        }
        BEBankCollection updateColl = new BEBankCollection();
        BEBankCollection addColl = new BEBankCollection();
        for (BEBankInfo info : set) {
            if (info.getBeProvince().endsWith(CASWebUtil.getResource((Context)ctx, (String)"308_CITY"))) {
                String beProvince = info.getBeProvince().replaceAll(CASWebUtil.getResource((Context)ctx, (String)"308_CITY"), "");
                info.setBeProvince(beProvince);
            }
            if (dbDataMap.containsKey(info.getNumber())) {
                BEBankInfo tmp = (BEBankInfo)dbDataMap.get(info.getNumber());
                if (tmp.getName().equals(info.getName()) && info.getBeProvince().equals(tmp.getBeProvince()) && info.getBeCity().equals(tmp.getBeCity()) && !EmptyUtil.isEmpty((String)info.getAdress()) && info.getAdress().equals(tmp.getAdress())) {
                    unChangeData.add(info);
                    continue;
                }
                this.dataUpdateHandler(ctx, tmp, info);
                tmp.setName(info.getName());
                tmp.setBeProvince(info.getBeProvince());
                tmp.setBeCity(info.getBeCity());
                tmp.setAdress(info.getAdress());
                updateData.add(info);
                updateColl.add(tmp);
                continue;
            }
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            Timestamp createtime = this.getTime();
            if (info.getCreateTime() == null) {
                info.setCreateTime(createtime);
            }
            info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setLastUpdateTime(createtime);
            info.setCU(this.getCU(ctx, (ObjectBaseInfo)info));
            addData.add(info);
            addColl.add(info);
        }
        map.put("unChangeData", unChangeData);
        map.put("updateData", updateData);
        map.put("addData", addData);
        this._addnewBatchData(ctx, (IObjectCollection)addColl);
        this._updateBatchData(ctx, (IObjectCollection)updateColl);
        return map;
    }

    @Override
    protected Map _onlineImport(Context ctx, boolean fullUpdate) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection bankSortColl = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("createTime");
        sort.setSortType(SortType.ASCEND);
        bankSortColl.add(sort);
        evi.setSorter(bankSortColl);
        BEBankUpdateTimeCollection updateTimeColl = BEBankUpdateTimeFactory.getLocalInstance(ctx).getBEBankUpdateTimeCollection(evi);
        String date = "";
        if (updateTimeColl != null && updateTimeColl.size() > 0 && updateTimeColl.get(0) != null && updateTimeColl.get(0).getCnapsUpdateDate() != null) {
            date = this.sdf.format(updateTimeColl.get(0).getCnapsUpdateDate());
        }
        if (fullUpdate) {
            date = "19700101";
        }
        Map dataMap = new HashMap();
        try {
            dataMap = BankCnapsService.getCnapsWeb(ctx, date);
        }
        catch (Exception e) {
            throw new BEException(BEException.BEBANK_ONLINEIMPORT, e.getCause());
        }
        logger.info((Object)("--------------------\u4e00\u5171\u83b7\u53d6\u5230\u7684\u884c\u540d\u884c\u53f7\u6570\u636e\u4e3a: " + dataMap.keySet().toString() + "-----------------------------"));
        Iterator iter = dataMap.keySet().iterator();
        ArrayList beBankNumberGroup = new ArrayList();
        HashSet<String> idSet = new HashSet<String>();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            idSet.add(key);
            if (idSet.size() < 5000) continue;
            beBankNumberGroup.add(idSet);
            idSet = new HashSet();
        }
        if (idSet.size() > 0) {
            beBankNumberGroup.add(idSet);
        }
        logger.error((Object)("\u4e91\u7aef\u4e0b\u8f7d\u884c\u540d\u884c\u53f7\u6570\u636e\u6574\u7406\u7ed3\u675f\uff0c\u5171\u6709" + beBankNumberGroup.size() + "\u7ec4\u6570\u636e\u9700\u8981\u6267\u884c"));
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(3);
        ArrayList<Future> futureList = new ArrayList<Future>();
        for (int i = 0; i < beBankNumberGroup.size(); ++i) {
            logger.error((Object)("\u7b2c" + i + "\u7ec4\u6570\u636e\u5f00\u59cb\u6267\u884c"));
            this.updateOrAddBeBank(ctx, dataMap, (Set)beBankNumberGroup.get(i), fixedThreadPool, futureList);
            logger.error((Object)("\u7b2c" + i + "\u7ec4\u6570\u636e\u6267\u884c\u7ed3\u675f"));
            logger.error((Object)("\u4e91\u7aef\u4e0b\u8f7d\u884c\u540d\u884c\u53f7\u6570\u636e\u5e93\u65b0\u589e\u6216\u8005\u66f4\u65b0\u6b21\u6570: " + i));
        }
        fixedThreadPool.shutdown();
        Map map = this.getBeBankResult(futureList);
        if (null != map.get("isUpdateTime") && ((Boolean)map.get("isUpdateTime")).booleanValue()) {
            BEBankUpdateTimeInfo model = new BEBankUpdateTimeInfo();
            if (updateTimeColl != null && updateTimeColl.size() > 0) {
                model = updateTimeColl.get(0);
            }
            model.setCnapsUpdateDate(this.getTime());
            if (dataMap.keySet().size() > 0) {
                BEBankUpdateTimeFactory.getLocalInstance(ctx).save((CoreBaseInfo)model);
            }
        }
        String logItem = fullUpdate ? "bebank_online_fullUpdate" : "bebank_online_import";
        String logDescription = fullUpdate ? "\u4e91\u7aef\u4e0b\u8f7d\u5168\u91cf\u66f4\u65b0\u884c\u540d\u884c\u53f7" : "\u4e91\u7aef\u4e0b\u8f7d\u884c\u540d\u884c\u53f7";
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BEBankInfo().getBOSType(), null, null, (String)logItem, (String)companyOrgUnitInfo.getId().toString(), (String)logDescription);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return map;
    }

    private Map getBeBankResult(List<Future> futureList) {
        logger.error((Object)"\u5f00\u59cb\u83b7\u53d6\u6267\u884c\u7ed3\u679c");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isUpdateTime", true);
        Map result = null;
        HashSet updateData = new HashSet();
        HashSet addData = new HashSet();
        int updateDataSize = 0;
        int addDataSize = 0;
        int totalCount = 0;
        for (Future future : futureList) {
            try {
                result = (Map)future.get();
            }
            catch (Exception e) {
                logger.error((Object)("updateOrAddBeBank error: " + e));
                map.put("isUpdateTime", false);
                continue;
            }
            if (result == null || (totalCount = (updateDataSize += ((Integer)result.get("updateDataSize")).intValue()) + (addDataSize += ((Integer)result.get("addDataSize")).intValue())) >= 500) continue;
            updateData.addAll((Collection)result.get("updateData"));
            addData.addAll((Collection)result.get("addData"));
        }
        logger.error((Object)"\u6267\u884c\u7ed3\u679c\u83b7\u53d6\u5b8c\u6bd5");
        if (totalCount >= 500) {
            map.put("totalCount", totalCount);
            map.put("updateDataSize", updateDataSize);
            map.put("addDataSize", addDataSize);
        } else {
            map.put("totalCount", totalCount);
            map.put("updateDataSize", updateDataSize);
            map.put("updateData", updateData);
            map.put("addDataSize", addDataSize);
            map.put("addData", addData);
        }
        return map;
    }

    private void updateOrAddBeBank(Context ctx, Map dataMap, Set idSet, ExecutorService fixedThreadPool, List<Future> futureList) {
        BEBankCallable call = new BEBankCallable(ctx, dataMap, idSet);
        Future future = fixedThreadPool.submit(call);
        futureList.add(future);
    }

    @Override
    protected void _disableCnapsWeb(Context ctx, Set ids) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Collection)ids)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        BEBankCollection updateColl = new BEBankCollection();
        for (int i = 0; i < coll.size(); ++i) {
            BEBankInfo info = coll.get(i);
            if (info.getState().equals((Object)StateEnum.OFF)) continue;
            info.setState(StateEnum.OFF);
            updateColl.add(info);
        }
        this._updateBatchData(ctx, (IObjectCollection)updateColl);
    }

    @Override
    protected void _enableCnapsWeb(Context ctx, Set ids) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Collection)ids)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        BEBankCollection updateColl = new BEBankCollection();
        for (int i = 0; i < coll.size(); ++i) {
            BEBankInfo info = coll.get(i);
            if (info.getState().equals((Object)StateEnum.EFFECTIVE)) continue;
            info.setState(StateEnum.EFFECTIVE);
            updateColl.add(info);
        }
        this._updateBatchData(ctx, (IObjectCollection)updateColl);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected Map _batchImportWeb(Context ctx, Set set) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        HashSet<BEBankInfo> unChangeData = new HashSet<BEBankInfo>();
        HashSet<BEBankInfo> updateData = new HashSet<BEBankInfo>();
        HashSet<BEBankInfo> addData = new HashSet<BEBankInfo>();
        HashSet<String> idSet = new HashSet<String>();
        for (BEBankInfo info : set) {
            idSet.add(info.getNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        HashMap<String, BEBankInfo> dbDataMap = new HashMap<String, BEBankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            dbDataMap.put(coll.get(i).getNumber(), coll.get(i));
        }
        BEBankCollection updateColl = new BEBankCollection();
        BEBankCollection addColl = new BEBankCollection();
        for (BEBankInfo info : set) {
            if (info.getBeProvince().endsWith(CASWebUtil.getResource((Context)ctx, (String)"308_CITY"))) {
                info.getBeProvince().replaceAll(CASWebUtil.getResource((Context)ctx, (String)"308_CITY"), "");
            }
            if (dbDataMap.containsKey(info.getNumber())) {
                BEBankInfo tmp = (BEBankInfo)dbDataMap.get(info.getId());
                if (tmp.getName().equals(info.getName()) && info.getBeProvince().equals(tmp.getBeProvince()) && info.getBeCity().equals(tmp.getBeCity()) && !EmptyUtil.isEmpty((String)info.getAdress()) && info.getAdress().equals(tmp.getAdress())) {
                    unChangeData.add(info);
                    continue;
                }
                tmp.setName(info.getName());
                tmp.setBeProvince(info.getBeProvince());
                tmp.setBeCity(info.getBeCity());
                tmp.setAdress(info.getAdress());
                updateData.add(info);
                updateColl.add(tmp);
                continue;
            }
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            Timestamp createtime = this.getTime();
            if (info.getCreateTime() == null) {
                info.setCreateTime(createtime);
            }
            info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setLastUpdateTime(createtime);
            info.setCU(this.getCU(ctx, (ObjectBaseInfo)info));
            addData.add(info);
            addColl.add(info);
        }
        map.put("unChangeData", unChangeData);
        map.put("updateData", updateData);
        map.put("addData", addData);
        this._addnewBatchData(ctx, (IObjectCollection)addColl);
        this._updateBatchData(ctx, (IObjectCollection)updateColl);
        return map;
    }
}

