/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.BeBankAbandonedStateEnum;
import com.kingdee.eas.fm.be.IBEBank;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.util.Hashtable;
import java.util.List;

public class BEBankDataImport
extends AbstractFMDataImport {
    protected ICoreBase _getController(Context ctx) throws BOSException, EASBizException {
        return BEBankFactory.getLocalInstance((Context)ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        Integer datataskMode;
        int mode;
        BEBankInfo openArea = new BEBankInfo();
        this.prepareImport(ctx, (IObjectValue)openArea, hsData);
        Object data = this.getData(hsData, "FisAbandoned");
        if (data != null && data.toString().trim().length() > 0) {
            if (BeBankAbandonedStateEnum.YES.getAlias().equals(data.toString().trim())) {
                openArea.setIsAbandoned(BeBankAbandonedStateEnum.YES);
            } else if (BeBankAbandonedStateEnum.NO.getAlias().equals(data.toString().trim())) {
                openArea.setIsAbandoned(BeBankAbandonedStateEnum.NO);
            }
        }
        if ((mode = (datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE")).intValue()) == 16) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)openArea.getNumber()));
            view.setFilter(fi);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
            if (coll.size() > 0) {
                openArea.setId(coll.get(0).getId());
                openArea.setName(openArea.getName(), ctx.getLocale());
                openArea.setDescription(openArea.getDescription(), ctx.getLocale());
            }
        }
        return openArea;
    }

    private BankInterfaceTypeEnum getBankInterfaceValue(String name) {
        List a = BankInterfaceTypeEnum.getEnumList();
        for (int i = 0; i < a.size(); ++i) {
            BankInterfaceTypeEnum temp = (BankInterfaceTypeEnum)a.get(i);
            if (!name.equals(temp.getAlias())) continue;
            return temp;
        }
        return null;
    }

    protected void _submit(CoreBaseInfo info, Context ctx) throws BOSException, EASBizException {
        IBEBank j = (IBEBank)this._getController(ctx);
        BEBankInfo beInfo = (BEBankInfo)info;
        if (BeBankAbandonedStateEnum.YES.getAlias().equals(beInfo.get("isAbandoned"))) {
            beInfo.setIsAbandoned(BeBankAbandonedStateEnum.YES);
        } else if (BeBankAbandonedStateEnum.NO.getAlias().equals(beInfo.get("isAbandoned"))) {
            beInfo.setIsAbandoned(BeBankAbandonedStateEnum.NO);
        }
        if (beInfo.getId() == null || !j.exists((IObjectPK)new ObjectUuidPK(beInfo.getId()))) {
            j.addnew((CoreBaseInfo)beInfo);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId()));
            view.setFilter(fi);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
            if (coll.size() > 0 && coll != null) {
                if (EmptyUtil.isEmpty((String)beInfo.getEnglishNames()) && !EmptyUtil.isEmpty((String)coll.get(0).getEnglishNames())) {
                    beInfo.setEnglishNames(coll.get(0).getEnglishNames());
                }
                if (beInfo.getIsAbandoned() == null && coll.get(0).getIsAbandoned() != null) {
                    beInfo.setIsAbandoned(coll.get(0).getIsAbandoned());
                }
            }
            j.update((IObjectPK)new ObjectUuidPK(beInfo.getId()), (CoreBaseInfo)beInfo);
        }
    }
}

