/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankAgentPayBillBuilderFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillCollection;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryCollection;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BankLogTypeEnum;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankAgentPayBillBuilder;
import com.kingdee.eas.fm.be.app.AbstractBankAgentPayBillControllerBean;
import com.kingdee.eas.fm.be.app.service.BankPayUtil;
import com.kingdee.eas.fm.be.app.service.BusinessTollUtil;
import com.kingdee.eas.fm.be.app.service.CBBankAgentPayUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.be.bean.BankLogBuildInfo;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BankAgentPayBillControllerBean
extends AbstractBankAgentPayBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankAgentPayBillControllerBean");
    private static boolean debug = false;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankAgentPayBillInfo info = (BankAgentPayBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            } else {
                throw new BEException(BEException.BANKAGENTPAYHASNOTCODERULE);
            }
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankAgentPayBillInfo info = (BankAgentPayBillInfo)this._getValue(ctx, pk);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getState() == BankPayingBillStateEnum.TF) continue;
            throw new BEException(BEException.BANKAGENTPAYDELERROR);
        }
        if (!info.isIsBitBack()) {
            throw new BEException(BEException.BANKAGENTPAYDELERROR);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _bitBack(Context ctx, List ids) throws BOSException, EASBizException {
        BankAgentPayBillCollection coll = this.BankAgentPayBillColl(ctx, ids);
        if (FMHelper.isEmpty((AbstractObjectCollection)coll)) {
            throw new BEException(BEException.NOSUITRECORD);
        }
        for (int i = 0; i < coll.size(); ++i) {
            BankAgentPayBillInfo info = coll.get(i);
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                if (info.getEntrys().get(j).getState() == BankPayingBillStateEnum.TF || info.getEntrys().get(j).getState() == BankPayingBillStateEnum.OP) continue;
                throw new BEException(BEException.BANKAGENTPAYBILLCANNOTDEL, new Object[]{info.getNumber()});
            }
            if (info.isIsBitBack()) {
                throw new BEException(BEException.BANKPAYINGBILLHASBITBACK, new Object[]{info.getNumber()});
            }
            if (!FMHelper.isEmpty((String)info.getSourceBillId())) {
                String sql = "Select Fid from T_CAS_AgentPayBill where fid  = ? and FIsCommitToBE = 1 and FIsGenerateBill = 1";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
                try {
                    if (rs.next()) {
                        throw new BEException(BEException.FORBIDBITBACK);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                sql = "Update T_CAS_AgentPayBill set FIsCommitToBE = 0 where fid  = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
            }
            Set srcBillSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)info.getId().toString());
            if (FMHelper.isEmpty((String)info.getSourceBillId()) || FMHelper.isEmpty((Collection)srcBillSet)) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"348_BitBack_Fail", (Locale)ctx.getLocale())});
            }
            if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && !AgentPayBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"348_BitBack_Fail", (Locale)ctx.getLocale())});
            }
            info.setIsBitBack(true);
            info.setSourceBillId(null);
            super.save(ctx, (CoreBaseInfo)info);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"bankAgent_bitBank");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId((String)srcBillSet.iterator().next(), info.getBOSType().toString());
            AgentPayBillFactory.getLocalInstance((Context)ctx).cancelPay(srcBillSet);
        }
    }

    @Override
    protected IObjectPK _commitBankAgentPayBill(Context ctx, String billId, String builderName) throws BOSException, EASBizException {
        IBankAgentPayBillBuilder builder = BankAgentPayBillBuilderFactory.getInstance(builderName);
        BankAgentPayBillInfo info = builder.getBankAgentPayBillInfo(ctx, billId);
        IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(billId, pk.toString());
        BOTPUtil.saveBOTRelation((Context)ctx, map);
        SelectorItemCollection sele = this.getSelectorForBe();
        info = this.getBankAgentPayBillInfo(ctx, pk, sele);
        this.update(ctx, pk, (CoreBaseInfo)info);
        return pk;
    }

    @Override
    protected void _commitToBeAll(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        SelectorItemCollection sele = this.getSelectorForBe();
        BankAgentPayBillInfo info = this.getBankAgentPayBillInfo(ctx, billId, sele);
        IObjectPK logpk = null;
        int type = 0;
        try {
            if (!info.isIsCBPay()) {
                BankPayUtil bankPayUtil = new BankPayUtil();
                PayBody body = beServiceHelper.parseAgencySalaryBody(ctx, info);
                BankBizInfo bizInfo = new BankBizInfo();
                bizInfo.setBankAcct(info.getPayAccountBank().getBankAccountNumber());
                bizInfo.setBillType(BillTypeEnum.AgencySalary);
                bizInfo.setCurrency(FmBeHelper.getCurrencyISO(ctx, info.getCurrency()));
                type = 0;
                String[] payAcnt = new String[]{info.getPayAccountBank().getName()};
                String[] payeeAcnt = this.getPayeeAcnt(info);
                BankLogBuildInfo build = new BankLogBuildInfo();
                build.setPayAcnt(payAcnt);
                build.setPayeeAcnt(payeeAcnt);
                build.setLogType(BankLogTypeEnum.agentPayBill);
                build.setCompany(info.getCompany());
                build.setBankInterFaceID(info.getPayAccountBank().getBankInterFaceID());
                build.setBankInterFace(info.getPayAccountBank().getBankInterFace());
                build.setSourceBillId(ConvertUtils.IDSTR((Object)info));
                build.setPayBillId(ConvertUtils.IDSTR((Object)info));
                logpk = BankLogFacadeFactory.getLocalInstance(ctx).buildBaseMessage(build);
                bankPayUtil.setPk(logpk);
                bankPayUtil.pay(ctx, bizInfo, body);
            } else {
                CBBankAgentPayUtil payUtil = new CBBankAgentPayUtil();
                payUtil.pay(ctx, billId);
            }
        }
        catch (BEException e) {
            BankLogFacadeFactory.getLocalInstance(ctx).buildException(logpk, (Exception)((Object)e), type);
            String sql = "delete from t_be_bankagentpaybill where fid ='" + billId.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"0_BankAgentPayBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage()});
        }
        catch (ServiceException e) {
            BankLogFacadeFactory.getLocalInstance(ctx).buildException(logpk, (Exception)((Object)e), type);
            String sql = "delete from t_be_bankagentpaybill where fid ='" + billId.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"0_BankAgentPayBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage()});
        }
        catch (Exception e) {
            BankLogFacadeFactory.getLocalInstance(ctx).buildException(logpk, e, type);
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof ConnectException) {
                String sql = "delete from t_be_bankagentpaybill where fid ='" + billId.toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            BankPayingBillStateEnum state = BankPayingBillStateEnum.NC;
            String returnMsg = null;
            returnMsg = !EmptyUtil.isEmpty((String)e.getMessage()) && e.getMessage().length() > 80 ? e.getMessage().substring(0, 80) : e.getMessage();
            String sql = "Update T_BE_BankAgentPayBillEntry set FState = ?,FBankReturnInfo = ? where FParentId  = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{state.getValue(), returnMsg, info.getId().toString()});
        }
    }

    private String[] getPayeeAcnt(BankAgentPayBillInfo info) {
        String[] result = new String[info.getEntrys().size()];
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            result[i] = info.getEntrys().get(i).getRecBankAccount();
        }
        return result;
    }

    private BankAgentPayBillEntryCollection getNeedUpdteAgentPayEntryBillCol(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add("parent.number");
        evi.getSelector().add("parent.id");
        evi.getSelector().add("parent.sourceBillId");
        evi.getSelector().add("*");
        return BankAgentPayBillEntryFactory.getLocalInstance(ctx).getBankAgentPayBillEntryCollection(evi);
    }

    @Override
    protected Map _updateState(Context ctx, IObjectPK[] pks, BankPayingBillStateEnum state) throws BOSException, EASBizException {
        Map resultMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        if (pks == null || pks.length == 0) {
            return resultMap;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        if (state.getValue() != 6 && state.getValue() != 5) {
            throw new BEException(BEException.UPDATEBANKAGENTERROR1);
        }
        HashSet<String> bankAgentPayBillIds = new HashSet<String>();
        BankAgentPayBillEntryCollection col = this.getNeedUpdteAgentPayEntryBillCol(ctx, idSet);
        HashMap<String, BankAgentPayBillEntryCollection> updateMap = new HashMap<String, BankAgentPayBillEntryCollection>();
        for (int i = 0; i < col.size(); ++i) {
            BankPayResult result = new BankPayResult();
            BankAgentPayBillEntryInfo entryInfo = col.get(i);
            if (!entryInfo.getState().equals((Object)BankPayingBillStateEnum.NC)) {
                result.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"193_STATE_UNCONFIRMED", (Locale)ctx.getLocale()));
            } else {
                BankAgentPayBillEntryCollection needUpdate2EBGCol;
                String bankAgentPayBillId = entryInfo.getParent().getId().toString();
                bankAgentPayBillIds.add(bankAgentPayBillId);
                if (updateMap.containsKey(bankAgentPayBillId)) {
                    needUpdate2EBGCol = (BankAgentPayBillEntryCollection)((Object)updateMap.get(bankAgentPayBillId));
                    needUpdate2EBGCol.add(entryInfo);
                } else {
                    needUpdate2EBGCol = new BankAgentPayBillEntryCollection();
                    needUpdate2EBGCol.add(entryInfo);
                    updateMap.put(bankAgentPayBillId, needUpdate2EBGCol);
                }
            }
            result.setId(entryInfo.getId().toString());
            result.setState(entryInfo.getState());
            result.setSubmitToBe(false);
            resultMap.put(entryInfo.getId().toString(), result);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bankAgentPayBillIds, CompareType.INCLUDE));
        evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("company.name");
        evi.getSelector().add("*");
        BankAgentPayBillCollection billColl = BankAgentPayBillFactory.getLocalInstance(ctx).getBankAgentPayBillCollection(evi);
        HashMap<String, BigDecimal> agentPayBillIdAndAmount = new HashMap<String, BigDecimal>();
        String agentPayBillId = null;
        BusinessTollUtil util = new BusinessTollUtil();
        for (int i = 0; i < billColl.size(); ++i) {
            HashSet<String> bankAgentPayEntryIds = new HashSet<String>();
            HashSet<String> agentPayBillEntryIds = new HashSet<String>();
            BigDecimal failAmount = null;
            BigDecimal allAmount = null;
            BigDecimal journalAmount = Constants.ZERO;
            BankAgentPayBillInfo info = billColl.get(i);
            BankAgentPayBillEntryCollection updateEntry = (BankAgentPayBillEntryCollection)((Object)updateMap.get(info.getId().toString()));
            agentPayBillId = info.getSourceBillId();
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                if (!BankPayingBillStateEnum.TF.equals((Object)info.getEntrys().get(j).getState())) continue;
                journalAmount = journalAmount.add(info.getEntrys().get(j).getAmount());
            }
            Map ret = util.UpdateAgnetPayState2EBS(ctx, info, updateEntry, state);
            for (int t = 0; t < updateEntry.size(); ++t) {
                BigDecimal journalFailAmount = Constants.ZERO;
                BankAgentPayBillEntryInfo entryInfo = updateEntry.get(t);
                Map entry = (Map)ret.get(ConvertUtils.IDSTR((Object)entryInfo));
                BankPayResult result = (BankPayResult)resultMap.get(ConvertUtils.IDSTR((Object)entryInfo));
                result.setSubmitToBe(ConvertUtils.BOOL(entry.get("submit2EBS")));
                result.setErrorDetail(ConvertUtils.STR(entry.get("errorMsg")));
                result.setNumber(info.getNumber());
                if (!CheckUtils.same((Object)"SUCCESS", entry.get("result"))) continue;
                bankAgentPayEntryIds.add(entryInfo.getId().toString());
                agentPayBillEntryIds.add(entryInfo.getSrcBillID());
                if (BankPayingBillStateEnum.TF.equals((Object)state)) {
                    journalFailAmount = (BigDecimal)agentPayBillIdAndAmount.get(agentPayBillId);
                    if (null == journalFailAmount) {
                        journalFailAmount = Constants.ZERO;
                    }
                    journalFailAmount = journalFailAmount.add(entryInfo.getAmount());
                } else {
                    journalFailAmount = Constants.ZERO;
                }
                agentPayBillIdAndAmount.put(agentPayBillId, journalFailAmount);
            }
            agentPayBillId = info.getSourceBillId();
            allAmount = info.getAmount();
            failAmount = (BigDecimal)agentPayBillIdAndAmount.get(agentPayBillId);
            journalAmount = null == failAmount ? allAmount.subtract(journalAmount) : allAmount.subtract(journalAmount.add(failAmount));
            if (BankPayingBillStateEnum.TF.equals((Object)state)) {
                if (Constants.ZERO.equals(journalAmount)) {
                    String sqlJournal = "delete from T_CAS_JOURNAL where fbillid = ? and FVERIFYSTATUS = 0";
                    DbUtil.execute((Context)ctx, (String)sqlJournal, (Object[])new Object[]{agentPayBillId});
                } else {
                    String sqlFail = "update T_CAS_JOURNAL set FCREDITAMOUNT = ? where fbillid= ? and  FVERIFYSTATUS = 0";
                    DbUtil.execute((Context)ctx, (String)sqlFail, (Object[])new Object[]{journalAmount.abs(), agentPayBillId});
                }
            }
            String sql = "Update T_BE_BankAgentPayBillEntry set FState = ? where FId in " + FMHelper.setTran2String(bankAgentPayEntryIds);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{state.getValue()});
            String sqlRev = "Update T_CAS_AgentPayBillEntry set fissuccess = ?, fstate = ? where FId in " + FMHelper.setTran2String(agentPayBillEntryIds);
            String agentState = state.getValue() == 6 ? "1" : "0";
            DbUtil.execute((Context)ctx, (String)sqlRev, (Object[])new Object[]{agentState, state.getValue()});
            String sqlAgent = "update T_CAS_AGENTPAYBILL set FACTUALAMOUNT = ( select sum(famount) from T_CAS_AGENTPAYBILLENTRY where FPARENTID = ? and FISSUCCESS =1) ,factualcount=( select count(famount) from T_CAS_AGENTPAYBILLENTRY where FPARENTID = ? and FISSUCCESS =1) where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sqlAgent, (Object[])new Object[]{agentPayBillId, agentPayBillId, agentPayBillId});
            Iterator iter = bankAgentPayEntryIds.iterator();
            while (iter.hasNext()) {
                String number = info.getNumber() + "_" + (String)iter.next();
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)number, (String)"bankAgent_updateState");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
        }
        return ConvertUtils.JSMAP((Object[])new Object[]{"resultList", ConvertUtils.LIST((Object)resultMap)});
    }

    private BankAgentPayBillCollection BankAgentPayBillColl(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        BankAgentPayBillCollection coll = this.getBankAgentPayBillCollection(ctx, ev);
        return coll;
    }

    private SelectorItemCollection getSelectorForBe() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.recBank.*"));
        sic.add(new SelectorItemInfo("entrys.RecBankAccount.*"));
        sic.add(new SelectorItemInfo("PayAccountBank.*"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        return sic;
    }

    protected String _getAppSolutionID(Context ctx, IObjectPK id, IObjectValue model, String type) throws BOSException, EASBizException {
        String appSolutionID = null;
        BankAgentPayBillInfo info = null;
        if (model != null) {
            info = (BankAgentPayBillInfo)model;
        } else if (id != null) {
            info = (BankAgentPayBillInfo)this.getValue(ctx, id);
        }
        if (info != null) {
            appSolutionID = info.isIsCBPay() ? "c6oAAAB/cRQ7dcWQ" : "e74AAAAbSGE7dcWQ";
        }
        return appSolutionID;
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        BankAgentPayBillInfo info = (BankAgentPayBillInfo)model;
        if (info != null) {
            if (info.isIsCBPay()) {
                if ("list".equals(viewType)) {
                    return "com.kingdee.eas.fm.cbs.fm_cbs_cbBankAgentPayBill_list";
                }
            } else if ("list".equals(viewType)) {
                return "com.kingdee.eas.fm.be.bankAgentPayBillList";
            }
        }
        return null;
    }
}

