/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryCollection;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillEntryInfo;
import com.kingdee.eas.fm.be.BankAgentPayBillFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankAgentPayBill;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.app.AbstractBankAgentPayWebFacadeControllerBean;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.model.BatchListResult;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankAgentPayWebFacadeControllerBean
extends AbstractBankAgentPayWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankAgentPayWebFacadeControllerBean");
    public static final String BITBACK_PERMITEM = "bankAgentPayBill_BitBack";
    public static final String DELETE_PERMITEM = "bankAgentPayBill_delete";
    public static final String SYNSTATE_PERMITEM = "bankAgentPayBill_Sync";
    public static final String EDITSTATE_PERMITEM = "bankAgentPayBill_editState";

    @Override
    protected Map _batchEditState(Context ctx, String[] ids, String state) throws BOSException, EASBizException {
        BatchListResult result = new BatchListResult();
        String summary = null;
        IBankAgentPayBill bankAgent = BankAgentPayBillFactory.getLocalInstance(ctx);
        try {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < ids.length; ++i) {
                idSet.add(ids[i]);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSelector().add("*");
            evi.getSelector().add("parent.number");
            evi.getSelector().add("parent.id");
            evi.getSelector().add("parent.company.*");
            BankAgentPayBillEntryCollection coll = BankAgentPayBillEntryFactory.getLocalInstance(ctx).getBankAgentPayBillEntryCollection(evi);
            ArrayList<String> idList = new ArrayList<String>();
            HashSet<String> bankAgentPayBillIds = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                BankAgentPayBillEntryInfo info = coll.get(i);
                if (!bankAgentPayBillIds.contains(info.getParent().getId().toString())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getParent().getCompany().getId().toString()), (String)EDITSTATE_PERMITEM);
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_EDITSTATE_AUTHRIZED);
                    }
                    bankAgentPayBillIds.add(info.getParent().getId().toString());
                }
                if (!info.getState().equals((Object)BankPayingBillStateEnum.NC) || EmptyUtil.isEmpty((Object)info.getId())) continue;
                idList.add(info.getId().toString());
            }
            IObjectPK[] pks = new IObjectPK[idList.size()];
            for (int j = 0; j < idList.size(); ++j) {
                pks[j] = new ObjectUuidPK(((String)idList.get(j)).toString());
            }
            BankPayingBillStateEnum stateEnum = BankPayingBillStateEnum.getEnum(Integer.valueOf(state));
            Map rets = bankAgent.updateState(pks, stateEnum);
            List resultList = (List)rets.get("resultList");
            if (!EmptyUtil.isEmpty((Collection)resultList)) {
                result.setError(0);
                int success = pks.length;
                for (int i = 0; i < resultList.size(); ++i) {
                    BankPayResult resultInfo = (BankPayResult)resultList.get(i);
                    if (EmptyUtil.isEmpty((String)resultInfo.getErrorDetail())) continue;
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"411_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + resultInfo.getNumber() + "\uff1a\u3010" + resultInfo.getErrorDetail() + "\u3011");
                    --success;
                }
                if (pks.length != success) {
                    result.setError(1);
                } else {
                    result.setError(0);
                }
                summary = ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"412_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(success) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"413_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(pks.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"414_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale());
                result.setSummaryMsg(summary);
            } else {
                result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"415_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()));
            }
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(FmBeWebUtils.getResource(ctx, "117_UPDATESTATE_FAILED", new String[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    protected Map _bitBack(Context ctx, Map dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        IBankAgentPayBill bankAgent = BankAgentPayBillFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object v : dataMap.values()) {
            if (idList.contains(v.toString())) continue;
            idList.add(v.toString());
        }
        String summary = null;
        try {
            for (String id : idList) {
                BankAgentPayBillInfo info = bankAgent.getBankAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id));
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)BITBACK_PERMITEM);
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_BITBACK_AUTHRIZED);
                }
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    if (info.getEntrys().get(j).getState() != BankPayingBillStateEnum.TF && info.getEntrys().get(j).getState() != BankPayingBillStateEnum.OP) {
                        summary = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"38_BankAgentPayBillListUI", (Locale)ctx.getLocale());
                        result.setError(1);
                        result.setSummaryMsg(summary);
                        return result;
                    }
                    if (!info.isIsBitBack()) continue;
                    throw new BEException(BEException.BANKPAYINGBILLHASBITBACK, new Object[]{info.getNumber()});
                }
            }
            bankAgent.bitBack(idList);
            summary = FmBeWebUtils.getResource(ctx, "130_BITBACK_SUCCESS");
            result.setError(0);
        }
        catch (Exception e) {
            summary = FmBeWebUtils.getResource(ctx, "131_BITBACK_FAILED");
            result.setError(1);
            result.getDetailMsgList().add(e.getMessage());
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchDelete(Context ctx, Map dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        IBankAgentPayBill bankAgent = BankAgentPayBillFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object v : dataMap.values()) {
            if (idList.contains(v.toString())) continue;
            idList.add(v.toString());
        }
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{idList.size() + ""});
        int success = 0;
        for (int i = 0; i < idList.size(); ++i) {
            BankAgentPayBillInfo info = bankAgent.getBankAgentPayBillInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)));
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)DELETE_PERMITEM);
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                bankAgent.delete((IObjectPK)new ObjectUuidPK((String)idList.get(i)));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "135_BANKAGENTPAYBILL_DELETE_FAILED", new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idList.size() ? summary + FmBeWebUtils.getResource(ctx, "114_ALL_DELETE_SUCCESS") : summary + FmBeWebUtils.getResource(ctx, "115_DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchSyncState(Context ctx, Map dataMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        IBankAgentPayBill bankAgent = BankAgentPayBillFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (Object v : dataMap.values()) {
            if (idList.contains(v.toString())) continue;
            idList.add(v.toString());
        }
        String summary = null;
        try {
            for (String id : idList) {
                BankAgentPayBillInfo info = bankAgent.getBankAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id));
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)SYNSTATE_PERMITEM);
                if (isPermission) continue;
                throw new CasWebException(CasWebException.NO_SYNC_AUTHRIZED);
            }
            IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
            Map ret = bankFacade.syncBankAgentPayStateByBill(idList);
            if (ret != null) {
                int success = H.INT(ret.get("success"));
                int error = H.INT(ret.get("error"));
                String errMsg = (String)ret.get("errMsg");
                summary = error > 0 ? ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"416_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + success + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"417_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + error + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"418_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + errMsg : FmBeWebUtils.getResource(ctx, "127_SYNC_SUCCESS");
            } else {
                summary = FmBeWebUtils.getResource(ctx, "127_SYNC_SUCCESS");
            }
        }
        catch (Exception e) {
            summary = FmBeWebUtils.getResource(ctx, "128_SYNC_FAILED");
            result.getDetailMsgList().add(e.getMessage());
        }
        result.setSummaryMsg(summary);
        return result;
    }
}

