/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.BankInfo;
import com.kingdee.eas.base.core.fm.BankVersionInfo;
import com.kingdee.eas.base.core.fm.CertUser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.app.AbstractBankConfigFacdeControllerBean;
import com.kingdee.eas.fm.be.app.BankConfigUtil;
import com.kingdee.eas.fm.be.app.BankVersionUtil;
import com.kingdee.eas.fm.be.app.MultiCertConfigUtil;
import com.kingdee.eas.fm.be.ws.ConfigKey;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class BankConfigFacdeControllerBean
extends AbstractBankConfigFacdeControllerBean {
    @Override
    protected Map _getBankServiceConfig(Context ctx, String bankName, String bankVersion, String certuserID) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String curentVersion = null;
        if (bankVersion == null) {
            BankVersionInfo bankVersionInfo = null;
            BankVersionUtil bankVersionUtil = new BankVersionUtil(ctx);
            bankVersionInfo = bankVersionUtil.getDefaultVersion(bankName);
            if (bankVersionInfo != null) {
                curentVersion = bankVersionInfo.getShortName();
            }
        } else {
            curentVersion = bankVersion;
        }
        map.put("version", curentVersion);
        BankConfigUtil bankConfigUtil = new BankConfigUtil(ctx);
        ConfigKey[] requireKey = bankConfigUtil.getRequireConfigKey(curentVersion);
        ConfigKey key2 = null;
        if (requireKey != null) {
            for (ConfigKey key2 : requireKey) {
                if (key2 == null) continue;
                try {
                    MultiCertConfigUtil multiCertConfigUtil = new MultiCertConfigUtil(ctx);
                    map.put(key2.getKey(), multiCertConfigUtil.getUserConfigValue(certuserID, curentVersion, key2));
                }
                catch (Exception e) {
                    throw new BEException(BEException.GETCONFIGFAILURE);
                }
            }
        }
        return map;
    }

    @Override
    protected void _setBankServiceConfig(Context ctx, String bankName, Map keyMap, String bankVersion, String certuserID) throws BOSException, EASBizException {
        BankConfigUtil bankConfigUtil = new BankConfigUtil(ctx);
        MultiCertConfigUtil multiCertConfigUtil = new MultiCertConfigUtil(ctx);
        BankVersionUtil bankVersionUtil = new BankVersionUtil(ctx);
        bankVersionUtil.setDefaultVersion(bankName, bankVersion);
        ConfigKey[] requireKey = bankConfigUtil.getRequireConfigKey(bankVersion);
        ConfigKey key2 = null;
        String keyValue = null;
        for (ConfigKey key2 : requireKey) {
            if (key2 == null) continue;
            try {
                keyValue = (String)keyMap.get(key2.getKey());
                if (keyValue == null) continue;
                multiCertConfigUtil.setUserConfigValue(certuserID, bankVersion, key2, keyValue);
            }
            catch (Exception e) {
                throw new BEException(BEException.SETCONFIGFAILURE);
            }
        }
    }

    @Override
    protected String _getBankIdByIntfType(Context ctx, BankInterfaceTypeEnum intfType) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FBankId from T_BE_BankIntfBankRel where FBankName =?", (Object[])new Object[]{intfType.getName()});
        try {
            if (rs.size() <= 0) {
                return null;
            }
            if (rs.size() > 1) {
                throw new BEException(BEException.BANKINFTFCORREBANKNOTUNIQUE);
            }
            rs.next();
            return rs.getString("FBankId");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected BankInterfaceTypeEnum _getIntfTypeByBankId(Context ctx, String bankId) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FBankName from T_BE_BankIntfBankRel where FBankId =?", (Object[])new Object[]{bankId});
        try {
            if (rs.size() <= 0) {
                return null;
            }
            if (rs.size() > 1) {
                throw new BEException(BEException.BANKIDCORREBANKINTFNOTUNIQUE);
            }
            rs.next();
            String name = rs.getString("FBankName");
            return BankInterfaceTypeEnum.getEnum((String)name);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String[] _getVersionsByBank(Context ctx, String bank) throws BOSException, EASBizException {
        BankInfo[] objs = null;
        try {
            BankVersionUtil bankVersionUtil = new BankVersionUtil(ctx);
            objs = bankVersionUtil.getAvaliableBanks();
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
        for (int i = 0; i < objs.length; ++i) {
            BankInfo bankInfo = objs[i];
            if (!bank.equals(bankInfo.getShortName())) continue;
            String[] versions = new String[bankInfo.getVersions().length];
            for (int j = 0; j < bankInfo.getVersions().length; ++j) {
                versions[j] = bankInfo.getVersions()[j].getShortName();
            }
            return versions;
        }
        return null;
    }

    @Override
    protected void _addCertUser(Context ctx, CertUser certUser) throws BOSException, EASBizException {
        try {
            MultiCertConfigUtil multiCertConfigUtil = new MultiCertConfigUtil(ctx);
            multiCertConfigUtil.addCertUser(certUser);
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void _delCertUser(Context ctx, CertUser certUser) throws BOSException, EASBizException {
        try {
            MultiCertConfigUtil multiCertConfigUtil = new MultiCertConfigUtil(ctx);
            multiCertConfigUtil.delCertUser(certUser);
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void _updateCertUserName(Context ctx, CertUser certUser) throws BOSException, EASBizException {
        try {
            MultiCertConfigUtil multiCertConfigUtil = new MultiCertConfigUtil(ctx);
            multiCertConfigUtil.updateCertUserName(certUser);
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected BankInfo[] _getAvaliableBanks(Context ctx) throws BOSException, EASBizException {
        try {
            BankVersionUtil bankVersionUtil = new BankVersionUtil(ctx);
            return bankVersionUtil.getAvaliableBanks();
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected CertUser[] _getCertUsersByVersion(Context ctx, String version) throws BOSException, EASBizException {
        try {
            MultiCertConfigUtil multiCertConfigUtil = new MultiCertConfigUtil(ctx);
            return multiCertConfigUtil.getCertUsers(version);
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected BankVersionInfo[] _getAvaliableVersions(Context ctx) throws BOSException, EASBizException {
        try {
            BankVersionUtil bankVersionUtil = new BankVersionUtil(ctx);
            return bankVersionUtil.getAvaliableVersions();
        }
        catch (Exception e) {
            throw new BEException(BEException.GETBESERVICEFAIL, new Object[]{e.getMessage()});
        }
    }

    protected CertUser[] _getAllCertUsers(Context ctx) throws BOSException, EASBizException {
        return null;
    }
}

