/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankDynamicNoticeCollection;
import com.kingdee.eas.fm.be.BankDynamicNoticeFactory;
import com.kingdee.eas.fm.be.BankDynamicNoticeInfo;
import com.kingdee.eas.fm.be.app.AbstractBankDynamicNoticeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankDynamicNoticeControllerBean
extends AbstractBankDynamicNoticeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankDynamicNoticeControllerBean");

    @Override
    protected Map _detailCheck(Context ctx, String acctId, String currencyId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> resultMap = new HashMap<String, StringBuffer>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)acctId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        if (beginDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getSQLBegin((Date)beginDate), CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)DateUtil.getSQLEnd((Date)endDate), CompareType.LESS_EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemInfo sortItem1 = new SorterItemInfo("bizTime");
        sortItem1.setSortType(SortType.ASCEND);
        evi.getSorter().add(sortItem1);
        BankDynamicNoticeCollection detailColl = BankDynamicNoticeFactory.getLocalInstance(ctx).getBankDynamicNoticeCollection(evi);
        for (int i = 0; i < detailColl.size(); ++i) {
            if (i == 0) continue;
            BankDynamicNoticeInfo beforeInfo = detailColl.get(i - 1);
            BankDynamicNoticeInfo info = detailColl.get(i);
            StringBuffer result = new StringBuffer();
            if (beforeInfo.getTransBalance() == null) {
                throw new BEException(BEException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"309_TransDetailCheck", (Locale)ctx.getLocale())});
            }
            if (info.getTransBalance() == null || info.getTransBalance().compareTo(beforeInfo.getTransBalance().add(info.getCreditAmount().subtract(info.getDebitAmount()))) == 0) continue;
            result = this.getResult(beforeInfo, info, ctx);
            resultMap.put(String.valueOf(i), result);
        }
        return resultMap;
    }

    private StringBuffer getResult(BankDynamicNoticeInfo beforeInfo, BankDynamicNoticeInfo info, Context ctx) {
        StringBuffer result = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(true);
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"23_TransDetailControllerBean", (Locale)ctx.getLocale())).append(beforeInfo.getDescription());
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"24_TransDetailControllerBean", (Locale)ctx.getLocale())).append(beforeInfo.getBizTime());
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"27_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(beforeInfo.getTransBalance()));
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"28_TransDetailControllerBean", (Locale)ctx.getLocale())).append(info.getDescription());
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"24_TransDetailControllerBean", (Locale)ctx.getLocale())).append(info.getBizTime());
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"27_TransDetailControllerBean", (Locale)ctx.getLocale())).append(fm.format(info.getTransBalance()));
        result.append(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"29_TransDetailControllerBean", (Locale)ctx.getLocale()));
        return result;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankDynamicNoticeInfo info = (BankDynamicNoticeInfo)this._getValue(ctx, pk);
        super._delete(ctx, pk);
    }
}

