/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankInterfaceCurrencyCollection;
import com.kingdee.eas.fm.be.BankInterfaceCurrencyFactory;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.ws.BankAcnt;
import com.kingdee.eas.fm.common.FMHelper;
import java.util.HashSet;

public class BankFacadeHelper {
    public static AccountBankCollection getAccountBankColl(Context ctx, String[] companyId, BankInterfaceTypeEnum bankInterface) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<String> list = new HashSet<String>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        }
        if (bankInterface != null) {
            fi.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(bankInterface.getValue())));
        }
        fi.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("relatedBankNumber"));
        sic.add(new SelectorItemInfo("bankOrgNumber"));
        sic.add(new SelectorItemInfo("customerNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("openArea.*"));
        view.setFilter(fi);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return coll;
    }

    public static String covertToBECurrency(Context ctx, String currency, BankInterfaceTypeEnum bankInterface) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency));
        fi.getFilterItems().add(new FilterItemInfo("bankInterfaceType", (Object)new Integer(bankInterface.getValue())));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        view.setFilter(fi);
        BankInterfaceCurrencyCollection coll = BankInterfaceCurrencyFactory.getLocalInstance(ctx).getBankInterfaceCurrencyCollection(view);
        if (coll != null && coll.get(0) != null) {
            return coll.get(0).getCurrencyCode();
        }
        throw new BEException(BEException.NOSETINTERFACECURRENCY);
    }

    public static AccountBankCollection getAccountBankCollById(Context ctx, String[] ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (!FMHelper.isEmpty((Object[])ids)) {
            HashSet<String> list = new HashSet<String>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                list.add(ids[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("id", list, CompareType.INCLUDE));
        }
        fi.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("isonlyread"));
        sic.add(new SelectorItemInfo("relatedBankNumber"));
        sic.add(new SelectorItemInfo("bankOrgNumber"));
        sic.add(new SelectorItemInfo("customerNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("openArea.id"));
        sic.add(new SelectorItemInfo("openArea.number"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        view.setFilter(fi);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return coll;
    }

    public static AccountBankCollection getAccountBankCollNotIncludeUsedById(Context ctx, String[] ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (!FMHelper.isEmpty((Object[])ids)) {
            HashSet<String> list = new HashSet<String>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                list.add(ids[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("id", list, CompareType.INCLUDE));
        }
        fi.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("isonlyread"));
        sic.add(new SelectorItemInfo("relatedBankNumber"));
        sic.add(new SelectorItemInfo("bankOrgNumber"));
        sic.add(new SelectorItemInfo("customerNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("openArea.id"));
        sic.add(new SelectorItemInfo("openArea.number"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        view.setFilter(fi);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        return coll;
    }

    public static CompanyOrgUnitInfo getCompanyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strId));
        return company;
    }

    public static CurrencyInfo getCurrencyById(Context ctx, String strId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("isoCode"));
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(strId), sic);
        return currency;
    }

    public static void setBankAccountVersionAndCert(Context ctx, AccountBankInfo bankInfo, BankAcnt bankAcnt) {
        if (BankFacadeHelper.getIsMulCert(ctx)) {
            bankAcnt.setBankVersion(bankInfo.getBankVersion());
            bankAcnt.setCertuserID(bankInfo.getBankCert());
        }
    }

    public static boolean getIsMulCert(Context ctx) {
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        return contextHelper.getBooleanParam("BE005", (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId()));
    }
}

