/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankGovHrWageBillBuilderFactory;
import com.kingdee.eas.fm.be.BankGovHrWageJoinCollection;
import com.kingdee.eas.fm.be.BankGovHrWageJoinInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankGovHrWageBillBuilder;
import com.kingdee.eas.fm.be.app.AbstractBankGovHrWageJoinControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BankGovHrWageJoinControllerBean
extends AbstractBankGovHrWageJoinControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankGovHrWageJoinControllerBean");

    @Override
    protected void _commit2BankTransUpBill(Context ctx, String billId, String builderName) throws BOSException, EASBizException {
        IBankGovHrWageBillBuilder builder = BankGovHrWageBillBuilderFactory.getInstance(builderName);
        BankGovHrWageJoinInfo info = builder.getBankGovHrWageJoinInfo(ctx, billId);
        IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(billId, pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, map);
        BankGovHrWageJoinCollection coll = new BankGovHrWageJoinCollection();
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("bankAccount.*");
        sele.add("entrys.*");
        info = this.getBankGovHrWageJoinInfo(ctx, pk, sele);
        coll.add(info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankGovHrWageJoinInfo info = (BankGovHrWageJoinInfo)model;
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankGovHrWageJoinInfo info = (BankGovHrWageJoinInfo)this._getValue(ctx, pk);
        if (info.getState() != BankPayingBillStateEnum.TF) {
            throw new BEException(BEException.BANKTRANSDOWNDELETEERR);
        }
        if (!info.isIsBitBack()) {
            throw new BEException(BEException.BANKTRANSDOWNDELETEERR);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _bitBack(Context ctx, List ids) throws BOSException, EASBizException {
        BankGovHrWageJoinCollection coll = this.getColl4BitBack(ctx, ids);
        if (FMHelper.isEmpty((AbstractObjectCollection)coll)) {
            throw new BEException(BEException.NOSUITRECORD);
        }
        for (int i = 0; i < coll.size(); ++i) {
            BankGovHrWageJoinInfo info = coll.get(i);
            if (info.getState() != BankPayingBillStateEnum.TF) {
                throw new BEException(BEException.BANKTRANSDOWNBILLCANNOTDELETE, new Object[]{info.getNumber()});
            }
            if (info.isIsBitBack()) {
                throw new BEException(BEException.BANKTRANSDOWNBILLHASBITBACK, new Object[]{info.getNumber()});
            }
            String sbillId = info.getSourceBillId();
            if (!FMHelper.isEmpty((String)sbillId)) {
                this.rever4Remove(ctx, info, sbillId);
            }
            super._delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            info.setId(null);
            info.setSourceBillId(null);
            info.setIsBitBack(true);
            for (int j = 0; j < info.getEntry().size(); ++j) {
                info.getEntry().get(j).setIsBitBack(true);
            }
            super.addnew(ctx, (CoreBaseInfo)info);
        }
    }

    private void rever4Remove(Context ctx, BankGovHrWageJoinInfo info, String sbillId) throws BOSException, EASBizException {
        this.cancelCommitToBE(ctx, sbillId);
    }

    private BankGovHrWageJoinCollection getColl4BitBack(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        BankGovHrWageJoinCollection coll = this.getBankGovHrWageJoinCollection(ctx, ev);
        return coll;
    }

    private void cancelCommitToBE(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "UPDATE T_GOV_GovHrWageBankJoin set FIsCommittoBe=0 WHERE FID ='" + id + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

