/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.BalanceRequest;
import com.kingdee.bos.ebservice.BalanceResponse;
import com.kingdee.bos.ebservice.BatchBalanceRequest;
import com.kingdee.bos.ebservice.BatchQueryPayRequest;
import com.kingdee.bos.ebservice.BatchQueryPayResponse;
import com.kingdee.bos.ebservice.BusinessRequest;
import com.kingdee.bos.ebservice.BusinessResponse;
import com.kingdee.bos.ebservice.DetailRequest;
import com.kingdee.bos.ebservice.DetailResponse;
import com.kingdee.bos.ebservice.EBHelper;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.LinkPayDetail;
import com.kingdee.bos.ebservice.LinkPayRequest;
import com.kingdee.bos.ebservice.LinkPayResponse;
import com.kingdee.bos.ebservice.OverseaPayDetail;
import com.kingdee.bos.ebservice.OverseaPayRequest;
import com.kingdee.bos.ebservice.OverseaPayResponse;
import com.kingdee.bos.ebservice.PayRequest;
import com.kingdee.bos.ebservice.PayResponse;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.ebservice.PositionRequest;
import com.kingdee.bos.ebservice.PositionResponse;
import com.kingdee.bos.ebservice.QueryLinkPayRequest;
import com.kingdee.bos.ebservice.QueryLinkPayResponse;
import com.kingdee.bos.ebservice.QueryOverseaPayRequest;
import com.kingdee.bos.ebservice.QueryOverseaPayResponse;
import com.kingdee.bos.ebservice.QueryPayRequest;
import com.kingdee.bos.ebservice.QueryPayResponse;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogCollection;
import com.kingdee.eas.fm.be.BankLogFactory;
import com.kingdee.eas.fm.be.BankLogInfo;
import com.kingdee.eas.fm.be.BankLogTranTypeEnum;
import com.kingdee.eas.fm.be.BankLogTypeEnum;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.app.AbstractBankLogFacadeControllerBean;
import com.kingdee.eas.fm.be.bankLog.BankLogAbstractInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBalanceRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBalanceResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBatchBalanceRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBatchQueryPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBatchQueryPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBusinessRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogBusinessResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogDetailRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogDetailResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogException;
import com.kingdee.eas.fm.be.bankLog.BankLogLinkPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogLinkPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogOverseaPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogOverseaPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogQueryLinkPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogQueryLinkPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogQueryOverseaPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogQueryOverseaPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogQueryPayRequestInfo;
import com.kingdee.eas.fm.be.bankLog.BankLogQueryPayResponseInfo;
import com.kingdee.eas.fm.be.bankLog.VirtualDetailRequestInfo;
import com.kingdee.eas.fm.be.bankLog.VirtualDetailResponseInfo;
import com.kingdee.eas.fm.be.bean.BankLogBuildInfo;
import com.kingdee.eas.fm.be.bean.BankLogExpParam;
import com.kingdee.eas.fm.be.bean.BankLogRowParam;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankLogFacadeControllerBean
extends AbstractBankLogFacadeControllerBean {
    public static final String FORMAT_PATTERN = "#,###,###,###,###,###,##0.0000";
    public static final String resource = "com.kingdee.eas.fm.be.BEAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankLogFacadeControllerBean");
    private static int addLogCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSerialValue(Object info) {
        SectionByteOutputStream bytes = new SectionByteOutputStream();
        byte[] data = null;
        try {
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)bytes);
            out.writeObject(info);
            out.close();
            data = ZipUtil.pack((SectionByteOutputStream)bytes);
        }
        catch (IOException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)e.getMessage());
            }
        }
        finally {
            block13: {
                try {
                    bytes.close();
                }
                catch (IOException e) {
                    if (!logger.isInfoEnabled()) break block13;
                    logger.info((Object)e.getMessage());
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getUnSerialValue(byte[] bytes) throws IOException {
        Object obj = null;
        try (ObjectInputStream in = null;){
            InputStream stream = ZipUtil.unpack((byte[])bytes);
            in = new ObjectInputStream(stream);
            obj = in.readObject();
        }
        return obj;
    }

    @Override
    protected IObjectPK _buildException(Context ctx, IObjectPK Fid, Exception exeception, int type) throws BOSException, EASBizException {
        return this.threadBuildException(ctx, Fid, exeception, type);
    }

    protected IObjectPK threadBuildException(Context ctx, IObjectPK Fid, Exception exeception, int type) throws BOSException, EASBizException {
        ExceptionThread thread = new ExceptionThread(ctx, Fid, exeception, type);
        thread.start();
        return Fid;
    }

    @Override
    protected void _buildExceptionBatch(Context ctx, Map batchPK, Exception exeception, int type) throws BOSException, EASBizException {
        Collection pks = batchPK.values();
        for (IObjectPK pk : pks) {
            this.buildException(ctx, pk, exeception, type);
        }
    }

    @Override
    protected void _detectLog(Context ctx, int days) throws BOSException, EASBizException {
        Date SECURITY = DateUtil.getDayBegin();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(SECURITY);
        ((Calendar)cal).add(5, 1 - days);
        Date beginDate = cal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = "delete from T_BE_BankLog where fbizDate <= {ts'" + sdf.format(beginDate) + "'}";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected IObjectPK _buildBaseMessage(Context ctx, BankLogBuildInfo buildInfo) throws BOSException, EASBizException {
        BankLogInfo info = new BankLogInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        newLogThread log = new newLogThread(ctx, info, buildInfo);
        log.start();
        return new ObjectUuidPK(info.getId());
    }

    private String getStringAcnt(String[] acnt) {
        if (EmptyUtil.isEmpty((Object[])acnt)) {
            return "";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < acnt.length; ++i) {
            strBuff.append(acnt[i] + ";");
            if (strBuff.length() < 250) continue;
            strBuff.append("...");
            break;
        }
        return strBuff.toString();
    }

    @Override
    protected IObjectPK _buildRequest(Context ctx, IObjectPK pk, EBRequest beRequest) throws BOSException, EASBizException {
        requestThread request = new requestThread(ctx, pk, beRequest);
        request.start();
        return pk;
    }

    @Override
    protected void _buildRequestBatch(Context ctx, Map batchPK, EBRequest beRequest) throws BOSException, EASBizException {
        block14: {
            block15: {
                block13: {
                    if (!(beRequest instanceof LinkPayRequest)) break block13;
                    LinkPayRequest req = (LinkPayRequest)beRequest;
                    for (Map.Entry entry : batchPK.entrySet()) {
                        EBRequest oneBeRequest;
                        try {
                            oneBeRequest = EBHelper.EBRequestDeepCopy(beRequest);
                        }
                        catch (Exception e) {
                            throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL", (Locale)ctx.getLocale())});
                        }
                        IObjectPK logpk = (IObjectPK)entry.getValue();
                        String seriID = (String)entry.getKey();
                        int detailCount = req.getBody().getDetails().length;
                        for (int i = 0; i < detailCount; ++i) {
                            if (!seriID.equals(req.getBody().getDetails()[i].getDetailSeqID())) continue;
                            ((LinkPayRequest)oneBeRequest).getBody().setDetails(new PaymentDetail[]{req.getBody().getDetails()[i]});
                            this.buildRequest(ctx, logpk, oneBeRequest);
                        }
                    }
                    break block14;
                }
                if (!(beRequest instanceof PayRequest)) break block15;
                PayRequest req = (PayRequest)beRequest;
                for (Map.Entry entry : batchPK.entrySet()) {
                    EBRequest oneBeRequest;
                    try {
                        oneBeRequest = EBHelper.EBRequestDeepCopy(beRequest);
                    }
                    catch (Exception e) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL", (Locale)ctx.getLocale())});
                    }
                    IObjectPK logpk = (IObjectPK)entry.getValue();
                    String seriID = (String)entry.getKey();
                    int detailCount = 0;
                    if (!CheckUtils.isEmpty((Object)req.getBody().getDetails())) {
                        detailCount = req.getBody().getDetails().length;
                    }
                    for (int i = 0; i < detailCount; ++i) {
                        if (!seriID.equals(req.getBody().getDetails()[i].getDetailSeqID())) continue;
                        ((PayRequest)oneBeRequest).getBody().setDetails(new PaymentDetail[]{req.getBody().getDetails()[i]});
                        this.buildRequest(ctx, logpk, oneBeRequest);
                    }
                }
                break block14;
            }
            if (!(beRequest instanceof OverseaPayRequest)) break block14;
            OverseaPayRequest req = (OverseaPayRequest)beRequest;
            for (Map.Entry entry : batchPK.entrySet()) {
                EBRequest oneBeRequest;
                try {
                    oneBeRequest = EBHelper.EBRequestDeepCopy(beRequest);
                }
                catch (Exception e) {
                    throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL", (Locale)ctx.getLocale())});
                }
                IObjectPK logpk = (IObjectPK)entry.getValue();
                String seriID = (String)entry.getKey();
                int detailCount = req.getBody().getDetails().length;
                for (int i = 0; i < detailCount; ++i) {
                    if (!seriID.equals(req.getBody().getDetails()[i].getDetailSeqID())) continue;
                    ((OverseaPayRequest)oneBeRequest).getBody().setDetails(new OverseaPayDetail[]{req.getBody().getDetails()[i]});
                    this.buildRequest(ctx, logpk, oneBeRequest);
                }
            }
        }
    }

    @Override
    protected void _buildResponse(Context ctx, IObjectPK pk, EBResponse beResponse) throws BOSException, EASBizException {
        responseThread request = new responseThread(ctx, pk, beResponse);
        request.start();
    }

    @Override
    protected void _buildResponseBatch(Context ctx, Map batchPK, EBResponse beResponse) throws BOSException, EASBizException {
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (!(beResponse instanceof LinkPayResponse)) break block17;
                        LinkPayResponse resp = (LinkPayResponse)beResponse;
                        for (Map.Entry entry : batchPK.entrySet()) {
                            EBResponse oneBeResponse;
                            try {
                                oneBeResponse = EBHelper.EBResponseDeepCopy(beResponse);
                            }
                            catch (Exception e) {
                                throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL")});
                            }
                            IObjectPK logpk = (IObjectPK)entry.getValue();
                            String seriID = (String)entry.getKey();
                            int detailCount = 0;
                            if (!CheckUtils.isEmpty((Object)resp.getBody().getLinkPayDetails())) {
                                detailCount = resp.getBody().getLinkPayDetails().length;
                            }
                            for (int i = 0; i < detailCount; ++i) {
                                if (!seriID.equals(resp.getBody().getLinkPayDetails()[i].getDetailSeqID())) continue;
                                ((LinkPayResponse)oneBeResponse).getBody().setLinkPayDetails(new LinkPayDetail[]{resp.getBody().getLinkPayDetails()[i]});
                                this.buildResponse(ctx, logpk, oneBeResponse);
                            }
                        }
                        break block18;
                    }
                    if (!(beResponse instanceof PayResponse)) break block19;
                    PayResponse resp = (PayResponse)beResponse;
                    for (Map.Entry entry : batchPK.entrySet()) {
                        EBResponse oneBeResponse;
                        try {
                            oneBeResponse = EBHelper.EBResponseDeepCopy(beResponse);
                        }
                        catch (Exception e) {
                            throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL")});
                        }
                        IObjectPK logpk = (IObjectPK)entry.getValue();
                        String seriID = (String)entry.getKey();
                        int detailCount = resp.getBody().getDetails().length;
                        for (int i = 0; i < detailCount; ++i) {
                            if (!seriID.equals(resp.getBody().getDetails()[i].getDetailSeqID())) continue;
                            ((PayResponse)oneBeResponse).getBody().setDetails(new PaymentDetail[]{resp.getBody().getDetails()[i]});
                            this.buildResponse(ctx, logpk, oneBeResponse);
                        }
                    }
                    break block18;
                }
                if (!(beResponse instanceof BusinessResponse)) break block20;
                BusinessResponse resp = (BusinessResponse)beResponse;
                for (Map.Entry entry : batchPK.entrySet()) {
                    EBResponse oneBeResponse;
                    try {
                        oneBeResponse = EBHelper.EBResponseDeepCopy(beResponse);
                    }
                    catch (Exception e) {
                        throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL")});
                    }
                    IObjectPK logpk = (IObjectPK)entry.getValue();
                    String seriID = (String)entry.getKey();
                    this.buildResponse(ctx, logpk, oneBeResponse);
                }
                break block18;
            }
            if (!(beResponse instanceof OverseaPayResponse)) break block18;
            OverseaPayResponse resp = (OverseaPayResponse)beResponse;
            for (Map.Entry entry : batchPK.entrySet()) {
                EBResponse oneBeResponse;
                try {
                    oneBeResponse = EBHelper.EBResponseDeepCopy(beResponse);
                }
                catch (Exception e) {
                    throw new BEException(BEException.COMMON, new String[]{EASResource.getString((String)resource, (String)"212_BANKLOGCOPY_FAIL")});
                }
                IObjectPK logpk = (IObjectPK)entry.getValue();
                String seriID = (String)entry.getKey();
                int detailCount = 0;
                if (!CheckUtils.isEmpty((Object)resp.getBody().getDetails())) {
                    detailCount = resp.getBody().getDetails().length;
                }
                for (int i = 0; i < detailCount; ++i) {
                    if (!seriID.equals(resp.getBody().getDetails()[i].getDetailSeqID())) continue;
                    ((OverseaPayResponse)oneBeResponse).getBody().setDetails(new OverseaPayDetail[]{resp.getBody().getDetails()[i]});
                    this.buildResponse(ctx, logpk, oneBeResponse);
                }
            }
        }
    }

    @Override
    protected IObjectPK _copyBeaseMessage(Context ctx, IObjectPK oldPK) throws BOSException, EASBizException {
        IObjectPK pk;
        block2: {
            pk = null;
            try {
                BankLogInfo oldInfo = BankLogFactory.getLocalInstance(ctx).getBankLogInfo(oldPK);
                BankLogInfo info = new BankLogInfo();
                info.setNumber(oldInfo.getNumber());
                info.setCompany(oldInfo.getCompany());
                info.setTime(oldInfo.getTime());
                info.setBizDate(oldInfo.getBizDate());
                info.setBankLogType(oldInfo.getBankLogType());
                info.setPayAcnt(oldInfo.getPayAcnt());
                info.setPayeeAcnt(oldInfo.getPayeeAcnt());
                info.setQueryAcnt(oldInfo.getQueryAcnt());
                pk = BankLogFactory.getLocalInstance(ctx).addnew(info);
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) break block2;
                logger.info((Object)e.getMessage());
            }
        }
        return pk;
    }

    @Override
    protected Map _unSerialMessage(Context ctx, String id) throws BOSException, EASBizException {
        BankLogAbstractInfo bankLogException;
        BankLogAbstractInfo bankLogAbstractInfo;
        BankLogInfo info = BankLogFactory.getLocalInstance(ctx).getBankLogInfo((IObjectPK)new ObjectUuidPK(id));
        HashMap<String, String> map = new HashMap<String, String>();
        if (info.getSendInfo() != null && info.getSendInfo().length > 0) {
            try {
                bankLogAbstractInfo = (BankLogAbstractInfo)BankLogFacadeControllerBean.getUnSerialValue(info.getSendInfo());
                map.put("send", bankLogAbstractInfo.toString());
            }
            catch (IOException e) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)e.getMessage());
                }
                map.put("send", "");
            }
        } else {
            map.put("send", "");
        }
        if (info.getReceiveInfo() != null && info.getReceiveInfo().length > 0) {
            try {
                bankLogAbstractInfo = (BankLogAbstractInfo)BankLogFacadeControllerBean.getUnSerialValue(info.getReceiveInfo());
                map.put("receive", bankLogAbstractInfo.toString());
            }
            catch (IOException e) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)e.getMessage());
                }
                map.put("receive", "");
            }
        } else {
            map.put("receive", "");
        }
        if (info.getSendExceptionInfo() != null && info.getSendExceptionInfo().length > 0) {
            try {
                bankLogException = (BankLogAbstractInfo)BankLogFacadeControllerBean.getUnSerialValue(info.getSendExceptionInfo());
                map.put("sendException", bankLogException.toString());
            }
            catch (IOException e) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)e.getMessage());
                }
                map.put("sendException", "");
            }
        } else {
            map.put("sendException", "");
        }
        if (info.getReceiveExceptionInfo() != null && info.getReceiveExceptionInfo().length > 0) {
            try {
                bankLogException = (BankLogAbstractInfo)BankLogFacadeControllerBean.getUnSerialValue(info.getReceiveExceptionInfo());
                map.put("receiveException", bankLogException.toString());
            }
            catch (IOException e) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)e.getMessage());
                }
                map.put("receiveException", "");
            }
        } else {
            map.put("receiveException", "");
        }
        return map;
    }

    @Override
    protected List _getAllLowLevelCompany(Context ctx, Map param) throws BOSException, EASBizException {
        OrgUnitInfo unit = (OrgUnitInfo)param.get("company");
        StringBuffer sql = new StringBuffer();
        sql.append("select flongnumber from T_ORG_Baseunit where fid ='").append(unit.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String longNumber = null;
        if (rs != null) {
            try {
                if (rs.next()) {
                    longNumber = rs.getString("flongnumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql = new StringBuffer();
        sql.append("select fid from T_ORG_Baseunit where flongnumber like ").append("'").append(longNumber).append("%'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> list = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    list.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return list;
    }

    @Override
    protected List _getBankInterfaceLog(Context ctx, String[] companyIds) throws BOSException, EASBizException {
        ArrayList bankLogExpParamList = null;
        if (companyIds != null && companyIds.length > 0) {
            GregorianCalendar fromDate = new GregorianCalendar();
            fromDate.setTimeInMillis(System.currentTimeMillis());
            fromDate.add(6, -7);
            HashSet companyIdSet = new HashSet(Arrays.asList((Object[])companyIds));
            EntityViewInfo bankLogEntity = new EntityViewInfo();
            SelectorItemCollection bankLogSic = new SelectorItemCollection();
            bankLogSic.add(new SelectorItemInfo("id"));
            bankLogSic.add(new SelectorItemInfo("time"));
            bankLogSic.add(new SelectorItemInfo("company"));
            bankLogSic.add(new SelectorItemInfo("isException"));
            bankLogSic.add(new SelectorItemInfo("bankInterFace"));
            bankLogSic.add(new SelectorItemInfo("bankInterFaceID"));
            bankLogSic.add(new SelectorItemInfo("payAcnt"));
            bankLogSic.add(new SelectorItemInfo("payeeAcnt"));
            bankLogSic.add(new SelectorItemInfo("paySourceId"));
            bankLogSic.add(new SelectorItemInfo("bankLogTranType"));
            bankLogSic.add(new SelectorItemInfo("BankLogType"));
            bankLogEntity.setSelector(bankLogSic);
            FilterInfo bankLogFilter = new FilterInfo();
            bankLogEntity.setFilter(bankLogFilter);
            bankLogFilter.getFilterItems().add(new FilterItemInfo("time", (Object)fromDate.getTime(), CompareType.GREATER_EQUALS));
            bankLogFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
            bankLogFilter.getFilterItems().add(new FilterItemInfo("isException", (Object)new Integer(1), CompareType.EQUALS));
            HashSet<Integer> tranTypeSet = new HashSet<Integer>();
            tranTypeSet.add(3);
            tranTypeSet.add(4);
            bankLogFilter.getFilterItems().add(new FilterItemInfo("bankLogTranType", tranTypeSet, CompareType.INCLUDE));
            bankLogFilter.getFilterItems().add(new FilterItemInfo("bankInterFaceID", null, CompareType.NOTEQUALS));
            BankLogCollection bankLogCollection = BankLogFactory.getLocalInstance(ctx).getBankLogCollection(bankLogEntity);
            if (bankLogCollection != null && bankLogCollection.size() > 0) {
                HashMap<String, BankLogInfo> bankLogMap = new HashMap<String, BankLogInfo>(bankLogCollection.size());
                HashMap<String, BankLogInfo> bankLogSourceIdMap = new HashMap<String, BankLogInfo>();
                for (int i = 0; i < bankLogCollection.size(); ++i) {
                    BankLogInfo bankLogInfo = bankLogCollection.get(i);
                    bankLogMap.put(bankLogInfo.getId().toString(), bankLogInfo);
                    if (bankLogInfo.getPaySourceId() == null || bankLogInfo.getPaySourceId().length() <= 0) continue;
                    bankLogSourceIdMap.put(bankLogInfo.getPaySourceId(), bankLogInfo);
                }
                EntityViewInfo bankPayEntity = new EntityViewInfo();
                SelectorItemCollection bankPaySic = new SelectorItemCollection();
                bankPaySic.add(new SelectorItemInfo("*"));
                bankPayEntity.setSelector(bankPaySic);
                FilterInfo bankPayFilter = new FilterInfo();
                bankPayEntity.setFilter(bankPayFilter);
                bankPayFilter.getFilterItems().add(new FilterItemInfo("id", bankLogSourceIdMap.keySet(), CompareType.INCLUDE));
                BankPayingBillCollection bankPayCollection = BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(bankPayEntity);
                HashMap<String, BigDecimal> paymentMap = new HashMap<String, BigDecimal>(bankPayCollection.size());
                HashMap<String, String> paymentStrMap = new HashMap<String, String>(bankPayCollection.size());
                for (int i = 0; i < bankPayCollection.size(); ++i) {
                    BankPayingBillInfo payBillInfo = bankPayCollection.get(i);
                    BigDecimal payAmount = payBillInfo.getPayAmount();
                    CurrencyInfo currencyInfo = payBillInfo.getCurrency();
                    currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()));
                    payAmount = payAmount.setScale(4, 4);
                    DecimalFormat df = new DecimalFormat(FORMAT_PATTERN);
                    String payAmountStr = currencyInfo.getSign() + df.format(payAmount);
                    paymentMap.put(payBillInfo.getId().toString(), payAmount);
                    paymentStrMap.put(payBillInfo.getId().toString(), payAmountStr);
                }
                HashMap<String, BankLogExpParam> bankLogParamMap = new HashMap<String, BankLogExpParam>();
                for (int i = 0; i < bankLogCollection.size(); ++i) {
                    BankLogExpParam expParam;
                    BankLogInfo bankLogInfo = bankLogCollection.get(i);
                    String bankInterFaceId = bankLogInfo.getBankInterFaceID();
                    if (!bankLogParamMap.containsKey(bankInterFaceId)) {
                        expParam = new BankLogExpParam();
                        expParam.setBankInterFaceId(bankInterFaceId);
                        expParam.setBankInterFace(bankLogInfo.getBankInterFace());
                        bankLogParamMap.put(bankInterFaceId, expParam);
                    }
                    expParam = (BankLogExpParam)bankLogParamMap.get(bankInterFaceId);
                    BankLogRowParam rowParam = bankLogInfo.getPaySourceId() == null ? new BankLogRowParam(bankLogInfo) : new BankLogRowParam(bankLogInfo, (BigDecimal)paymentMap.get(bankLogInfo.getPaySourceId()), (String)paymentStrMap.get(bankLogInfo.getPaySourceId()));
                    expParam.addBankLogRowParam(rowParam);
                }
                bankLogExpParamList = new ArrayList(bankLogParamMap.values());
                Collections.sort(bankLogExpParamList);
                for (BankLogExpParam aLogExpParam : bankLogExpParamList) {
                    Collections.sort(aLogExpParam.getRowList());
                    Collections.reverse(aLogExpParam.getRowList());
                }
            }
        }
        return bankLogExpParamList;
    }

    private BankLogTranTypeEnum convertBankLogType(Context ctx, BankLogTypeEnum bankLogType) {
        BankLogTranTypeEnum targetType = null;
        if (bankLogType != null) {
            targetType = bankLogType == BankLogTypeEnum.Balance ? BankLogTranTypeEnum.BALANCE : (bankLogType == BankLogTypeEnum.Detail ? BankLogTranTypeEnum.DETAIL : (bankLogType == BankLogTypeEnum.Pay || bankLogType == BankLogTypeEnum.privatePay || bankLogType == BankLogTypeEnum.transferDown || bankLogType == BankLogTypeEnum.transferUp || bankLogType == BankLogTypeEnum.linkPayment || bankLogType == BankLogTypeEnum.agentPayBill ? BankLogTranTypeEnum.PAY : (bankLogType == BankLogTypeEnum.syncBankPayBill || bankLogType == BankLogTypeEnum.fundTransferState || bankLogType == BankLogTypeEnum.syncAgentPayBill ? BankLogTranTypeEnum.PAYSYNC : BankLogTranTypeEnum.OTHERS)));
        }
        return targetType;
    }

    @Override
    protected void _updateBankLogPayBillId(Context ctx, String orgBillId, String newBillId) throws BOSException, EASBizException {
        updateBankLogThread thread = new updateBankLogThread(ctx, orgBillId, newBillId);
        thread.start();
    }

    private String setDescription(PaymentDetail[] details, String detailSeqID) {
        String desc = "";
        for (int i = 0; i < details.length; ++i) {
            if (detailSeqID == null || !detailSeqID.equals(details[i].getDetailSeqID())) continue;
            desc = details[i].getBankStatusMsg();
            break;
        }
        return desc;
    }

    private String setLinkDescription(LinkPayDetail[] details, String detailSeqID) {
        String desc = "";
        for (int i = 0; i < details.length; ++i) {
            if (detailSeqID == null || !detailSeqID.equals(details[i].getDetailSeqID())) continue;
            desc = details[i].getBankStatusMsg();
            break;
        }
        return desc;
    }

    @Override
    protected void _buildResponseAndRequest(Context ctx, IObjectPK pk, EBResponse beResponse, EBRequest beRequest, String detailSeqID) throws BOSException, EASBizException {
        RequestAndResponseQueryPayThread req = new RequestAndResponseQueryPayThread(ctx, pk, beResponse, beRequest, detailSeqID);
        req.start();
    }

    @Override
    protected void _clearBankLog(Context ctx) throws BOSException, EASBizException {
        Date SECURITY = DateUtil.getDayBegin();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(SECURITY);
        ((Calendar)cal).add(5, -89);
        Date beginDate = cal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = "delete from T_BE_BankLog where fid in (select top 200000 fid from T_BE_BankLog where fbizDate <= {ts '" + sdf.format(beginDate) + "'} order by FTIME ASC)";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "truncate table T_BE_BankLog_Dump";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    class LogDump
    extends Thread {
        private Context ctx;

        public LogDump(Context ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (addLogCount > 10000) {
                addLogCount = 0;
                LogDump logDump = this;
                synchronized (logDump) {
                    try {
                        Date endDate = DateUtil.getNextDay((Date)DateUtil.getDayBegin(), (int)-30);
                        String sSQL = "Insert into T_BE_BankLog_Dump SELECT * FROM T_BE_BankLog B Where FTime < ? and not Exists (Select Fid From T_BE_BankLog_Dump D Where B.Fid = D.Fid) ";
                        DbUtil.execute((Context)this.ctx, (String)sSQL, (Object[])new Object[]{new Timestamp(endDate.getTime())});
                        sSQL = "Delete FROM T_BE_BankLog Where FTime < ?  ";
                        DbUtil.execute((Context)this.ctx, (String)sSQL, (Object[])new Object[]{new Timestamp(endDate.getTime())});
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    class RequestAndResponseQueryPayThread
    extends Thread {
        private Context ctx;
        private IObjectPK pk;
        private EBResponse response;
        private EBRequest request;
        private String detailSeqID;

        public RequestAndResponseQueryPayThread(Context ctx, IObjectPK pk, EBResponse response, EBRequest request, String detailSeqID) {
            this.ctx = ctx;
            this.pk = pk;
            this.response = response;
            this.request = request;
            this.detailSeqID = detailSeqID;
        }

        @Override
        public void run() {
            block13: {
                if (this.pk == null) {
                    return;
                }
                try {
                    boolean isExist = BankLogFactory.getLocalInstance(this.ctx).exists(this.pk);
                    for (int i = 0; !isExist && i < 2; ++i) {
                        Thread.sleep(500L);
                    }
                    BankLogInfo info = BankLogFactory.getLocalInstance(this.ctx).getBankLogInfo(this.pk);
                    if (EmptyUtil.isEmpty((String)info.getNumber())) {
                        info.setNumber(this.pk.toString());
                    }
                    BankLogAbstractInfo reqBankLogInfo = new BankLogAbstractInfo();
                    BankLogAbstractInfo resBankLogInfo = new BankLogAbstractInfo();
                    if (this.request instanceof QueryPayRequest) {
                        reqBankLogInfo = new BankLogQueryPayRequestInfo();
                        ((BankLogQueryPayRequestInfo)reqBankLogInfo).setQueryPayRequest((QueryPayRequest)this.request);
                    } else if (this.request instanceof QueryLinkPayRequest) {
                        reqBankLogInfo = new BankLogQueryLinkPayRequestInfo();
                        ((BankLogQueryLinkPayRequestInfo)reqBankLogInfo).setQueryLinkPayRequest((QueryLinkPayRequest)this.request);
                    }
                    if (this.response instanceof QueryPayResponse) {
                        resBankLogInfo = new BankLogQueryPayResponseInfo(this.detailSeqID);
                        ((BankLogQueryPayResponseInfo)resBankLogInfo).setQueryPayResponse((QueryPayResponse)this.response);
                        QueryPayResponse resp = (QueryPayResponse)this.response;
                        if (resp.getBody() != null && resp.getBody().getDetails() != null && resp.getBody().getDetails().length > 0) {
                            info.setDescription(BankLogFacadeControllerBean.this.setDescription(resp.getBody().getDetails(), this.detailSeqID));
                        }
                    } else if (this.response instanceof QueryLinkPayResponse) {
                        resBankLogInfo = new BankLogQueryLinkPayResponseInfo(this.detailSeqID);
                        ((BankLogQueryLinkPayResponseInfo)resBankLogInfo).setQueryLinkPayResponse((QueryLinkPayResponse)this.response);
                        QueryLinkPayResponse resp = (QueryLinkPayResponse)this.response;
                        if (resp.getBody() != null && resp.getBody().getLinkPayDetails() != null && resp.getBody().getLinkPayDetails().length > 0) {
                            info.setDescription(BankLogFacadeControllerBean.this.setLinkDescription(resp.getBody().getLinkPayDetails(), this.detailSeqID));
                        }
                    }
                    info.setReceiveInfo(BankLogFacadeControllerBean.this.getSerialValue(resBankLogInfo));
                    info.setSendInfo(BankLogFacadeControllerBean.this.getSerialValue(reqBankLogInfo));
                    BankLogFactory.getLocalInstance(this.ctx).update(this.pk, info);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block13;
                    logger.info((Object)e.getMessage());
                }
            }
        }
    }

    class responseThread
    extends Thread {
        private Context ctx;
        private IObjectPK pk;
        private EBResponse response;

        public responseThread(Context ctx, IObjectPK pk, EBResponse response) {
            this.ctx = ctx;
            this.pk = pk;
            this.response = response;
        }

        @Override
        public void run() {
            block27: {
                if (this.pk == null) {
                    return;
                }
                try {
                    boolean isExist = BankLogFactory.getLocalInstance(this.ctx).exists(this.pk);
                    for (int i = 0; !isExist && i < 3; ++i) {
                        Thread.sleep(3000L);
                    }
                    BankLogInfo info = BankLogFactory.getLocalInstance(this.ctx).getBankLogInfo(this.pk);
                    if (EmptyUtil.isEmpty((String)info.getNumber())) {
                        info.setNumber(this.pk.toString());
                    }
                    BankLogAbstractInfo bankLogInfo = new BankLogAbstractInfo();
                    if (this.response instanceof BalanceResponse) {
                        bankLogInfo = new BankLogBalanceResponseInfo();
                        ((BankLogBalanceResponseInfo)bankLogInfo).setBalanceResponse((BalanceResponse)this.response);
                    } else if (this.response instanceof DetailResponse) {
                        bankLogInfo = new BankLogDetailResponseInfo();
                        ((BankLogDetailResponseInfo)bankLogInfo).setDetailResponse((DetailResponse)this.response);
                    } else if (this.response instanceof PayResponse) {
                        bankLogInfo = new BankLogPayResponseInfo();
                        ((BankLogPayResponseInfo)bankLogInfo).setPayResponse((PayResponse)this.response);
                        PayResponse resp = (PayResponse)this.response;
                        if (resp.getBody() != null && resp.getBody().getDetails() != null && resp.getBody().getDetails().length > 0) {
                            info.setDescription(((PayResponse)this.response).getBody().getDetails()[0].getBankStatusMsg());
                        }
                    } else if (this.response instanceof LinkPayResponse) {
                        bankLogInfo = new BankLogLinkPayResponseInfo();
                        ((BankLogLinkPayResponseInfo)bankLogInfo).setLinkPayResponse((LinkPayResponse)this.response);
                    } else if (this.response instanceof QueryPayResponse) {
                        bankLogInfo = new BankLogQueryPayResponseInfo("");
                        ((BankLogQueryPayResponseInfo)bankLogInfo).setQueryPayResponse((QueryPayResponse)this.response);
                        QueryPayResponse resp = (QueryPayResponse)this.response;
                        if (resp.getBody() != null && resp.getBody().getDetails() != null && resp.getBody().getDetails().length > 0) {
                            info.setDescription(((QueryPayResponse)this.response).getBody().getDetails()[0].getBankStatusMsg());
                        }
                    } else if (this.response instanceof PositionResponse) {
                        bankLogInfo = new VirtualDetailResponseInfo();
                        ((VirtualDetailResponseInfo)bankLogInfo).setPositionResponse((PositionResponse)this.response);
                    } else if (this.response instanceof BusinessResponse) {
                        bankLogInfo = new BankLogBusinessResponseInfo();
                        ((BankLogBusinessResponseInfo)bankLogInfo).setBusinessResponse((BusinessResponse)this.response);
                    } else if (this.response instanceof OverseaPayResponse) {
                        bankLogInfo = new BankLogOverseaPayResponseInfo();
                        ((BankLogOverseaPayResponseInfo)bankLogInfo).setOverseaPayResponse((OverseaPayResponse)this.response);
                    } else if (this.response instanceof QueryOverseaPayResponse) {
                        bankLogInfo = new BankLogQueryOverseaPayResponseInfo();
                        ((BankLogQueryOverseaPayResponseInfo)bankLogInfo).setQueryOverseaPayResponse((QueryOverseaPayResponse)this.response);
                        QueryOverseaPayResponse resp = (QueryOverseaPayResponse)this.response;
                        if (resp.getBody() != null && resp.getBody().getDetails() != null && resp.getBody().getDetails().length > 0) {
                            info.setDescription(((QueryOverseaPayResponse)this.response).getBody().getDetails()[0].getBankStatusMsg());
                        }
                    } else if (this.response instanceof BatchQueryPayResponse) {
                        bankLogInfo = new BankLogBatchQueryPayResponseInfo();
                        ((BankLogBatchQueryPayResponseInfo)bankLogInfo).setQueryPayResponse((BatchQueryPayResponse)this.response);
                    }
                    info.setReceiveInfo(BankLogFacadeControllerBean.this.getSerialValue(bankLogInfo));
                    BankLogFactory.getLocalInstance(this.ctx).update(this.pk, info);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block27;
                    logger.info((Object)e.getMessage());
                }
            }
        }
    }

    class requestThread
    extends Thread {
        private Context ctx;
        private IObjectPK pk;
        private EBRequest request;

        public requestThread(Context ctx, IObjectPK pk, EBRequest request) {
            this.ctx = ctx;
            this.pk = pk;
            this.request = request;
        }

        @Override
        public void run() {
            block26: {
                if (this.pk == null) {
                    return;
                }
                try {
                    boolean isExist = BankLogFactory.getLocalInstance(this.ctx).exists(this.pk);
                    for (int i = 0; !isExist && i < 3; ++i) {
                        Thread.sleep(3000L);
                    }
                    BankLogInfo info = BankLogFactory.getLocalInstance(this.ctx).getBankLogInfo(this.pk);
                    if (EmptyUtil.isEmpty((String)info.getNumber())) {
                        info.setNumber(this.pk.toString());
                    }
                    BankLogAbstractInfo bankLogInfo = new BankLogAbstractInfo();
                    if (this.request instanceof BalanceRequest) {
                        bankLogInfo = new BankLogBalanceRequestInfo();
                        ((BankLogBalanceRequestInfo)bankLogInfo).setBalanceRequest((BalanceRequest)this.request);
                    } else if (this.request instanceof BatchBalanceRequest) {
                        bankLogInfo = new BankLogBatchBalanceRequestInfo();
                        ((BankLogBatchBalanceRequestInfo)bankLogInfo).setBatchBalanceRequest((BatchBalanceRequest)this.request);
                    } else if (this.request instanceof DetailRequest) {
                        bankLogInfo = new BankLogDetailRequestInfo();
                        ((BankLogDetailRequestInfo)bankLogInfo).setDetailRequest((DetailRequest)this.request);
                    } else if (this.request instanceof PayRequest) {
                        bankLogInfo = new BankLogPayRequestInfo();
                        ((BankLogPayRequestInfo)bankLogInfo).setPayRequest((PayRequest)this.request);
                    } else if (this.request instanceof LinkPayRequest) {
                        bankLogInfo = new BankLogLinkPayRequestInfo();
                        ((BankLogLinkPayRequestInfo)bankLogInfo).setLinkPayRequest((LinkPayRequest)this.request);
                    } else if (this.request instanceof QueryPayRequest) {
                        bankLogInfo = new BankLogQueryPayRequestInfo();
                        ((BankLogQueryPayRequestInfo)bankLogInfo).setQueryPayRequest((QueryPayRequest)this.request);
                    } else if (this.request instanceof PositionRequest) {
                        bankLogInfo = new VirtualDetailRequestInfo();
                        ((VirtualDetailRequestInfo)bankLogInfo).setPositionRequest((PositionRequest)this.request);
                    } else if (this.request instanceof BusinessRequest) {
                        bankLogInfo = new BankLogBusinessRequestInfo();
                        ((BankLogBusinessRequestInfo)bankLogInfo).setBusinessRequest((BusinessRequest)this.request);
                    } else if (this.request instanceof OverseaPayRequest) {
                        bankLogInfo = new BankLogOverseaPayRequestInfo();
                        ((BankLogOverseaPayRequestInfo)bankLogInfo).setOverseaPayRequest((OverseaPayRequest)this.request);
                    } else if (this.request instanceof QueryOverseaPayRequest) {
                        bankLogInfo = new BankLogQueryOverseaPayRequestInfo();
                        ((BankLogQueryOverseaPayRequestInfo)bankLogInfo).setQueryOverseaPayRequest((QueryOverseaPayRequest)this.request);
                    } else if (this.request instanceof BatchQueryPayRequest) {
                        bankLogInfo = new BankLogQueryPayRequestInfo();
                        ((BankLogBatchQueryPayRequestInfo)bankLogInfo).setQueryPayRequest((BatchQueryPayRequest)this.request);
                    }
                    info.setSendInfo(BankLogFacadeControllerBean.this.getSerialValue(bankLogInfo));
                    BankLogFactory.getLocalInstance(this.ctx).update(this.pk, info);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block26;
                    logger.info((Object)e.getMessage());
                }
            }
        }
    }

    class newLogThread
    extends Thread {
        private Context ctx;
        private BankLogInfo info;
        private BankLogBuildInfo buildInfo;

        public newLogThread(Context ctx, BankLogInfo info, BankLogBuildInfo buildInfo) {
            this.ctx = ctx;
            this.info = info;
            this.buildInfo = buildInfo;
        }

        @Override
        public void run() {
            block2: {
                LogDump dump = new LogDump(this.ctx);
                dump.start();
                try {
                    this.info.setCompany(this.buildInfo.getCompany());
                    Timestamp bizDate = new Timestamp(Calendar.getInstance().getTime().getTime());
                    bizDate.setNanos(0);
                    this.info.setTime(bizDate);
                    this.info.setBizDate(Calendar.getInstance().getTime());
                    this.info.setBankLogType(this.buildInfo.getLogType());
                    this.info.setBankInterFace(this.buildInfo.getBankInterFace());
                    this.info.setBankInterFaceID(this.buildInfo.getBankInterFace());
                    this.info.setBankLogTranType(BankLogFacadeControllerBean.this.convertBankLogType(this.ctx, this.buildInfo.getLogType()));
                    this.info.setPayAcnt(BankLogFacadeControllerBean.this.getStringAcnt(this.buildInfo.getPayAcnt()));
                    this.info.setPayeeAcnt(BankLogFacadeControllerBean.this.getStringAcnt(this.buildInfo.getPayeeAcnt()));
                    this.info.setQueryAcnt(BankLogFacadeControllerBean.this.getStringAcnt(this.buildInfo.getQueryAcnt()));
                    this.info.setSourceBillId(this.buildInfo.getSourceBillId());
                    this.info.setPaySourceId(this.buildInfo.getPayBillId());
                    BankLogFactory.getLocalInstance(this.ctx).addnew(this.info);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block2;
                    logger.info((Object)e.getMessage());
                }
            }
            addLogCount++;
        }
    }

    class ExceptionThread
    extends Thread {
        private Context ctx;
        private IObjectPK pk;
        private Exception exeception;
        private int type;

        public ExceptionThread(Context ctx, IObjectPK pk, Exception exeception, int type) {
            this.ctx = ctx;
            this.pk = pk;
            this.exeception = exeception;
            this.type = type;
        }

        @Override
        public void run() {
            block7: {
                if (this.pk == null) {
                    return;
                }
                try {
                    boolean isExist = BankLogFactory.getLocalInstance(this.ctx).exists(this.pk);
                    for (int i = 0; !isExist && i < 3; ++i) {
                        Thread.sleep(3000L);
                    }
                    BankLogInfo info = BankLogFactory.getLocalInstance(this.ctx).getBankLogInfo(this.pk);
                    if (EmptyUtil.isEmpty((String)info.getNumber())) {
                        info.setNumber(this.pk.toString());
                    }
                    BankLogException bankLogException = new BankLogException();
                    StringWriter writer = new StringWriter();
                    this.exeception.printStackTrace(new PrintWriter(writer));
                    bankLogException.setExceptionInfo(writer.getBuffer().toString());
                    if (this.type == 0) {
                        info.setSendExceptionInfo(BankLogFacadeControllerBean.this.getSerialValue(bankLogException));
                    } else {
                        info.setReceiveExceptionInfo(BankLogFacadeControllerBean.this.getSerialValue(bankLogException));
                    }
                    info.setIsException(true);
                    String str = ConvertUtils.STR((Object)this.exeception.getMessage(), (int)80);
                    info.setDescription(str);
                    BankLogFactory.getLocalInstance(this.ctx).update(this.pk, info);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block7;
                    logger.info((Object)e.getMessage());
                }
            }
        }
    }

    class updateBankLogThread
    extends Thread {
        private Context ctx;
        private String orgBillId;
        private String newBillId;

        public updateBankLogThread(Context ctx, String orgBillId, String newBillId) {
            this.ctx = ctx;
            this.orgBillId = orgBillId;
            this.newBillId = newBillId;
        }

        @Override
        public void run() {
            try {
                if (this.orgBillId != null && this.newBillId != null && !this.orgBillId.equals(this.newBillId)) {
                    String sSQL = "update t_be_banklog set fsourcebillid= ?, FpaySourceId = ? where fsourcebillid = ?";
                    DbUtil.execute((Context)this.ctx, (String)sSQL, (Object[])new Object[]{this.newBillId, this.newBillId, this.orgBillId});
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

