/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteResult;
import com.kingdee.eas.fi.cas.app.mthread.TaskManager;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CasBosUtils;
import com.kingdee.eas.fm.be.AuditStatus;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BeServiceAddCollection;
import com.kingdee.eas.fm.be.BeServiceAddFactory;
import com.kingdee.eas.fm.be.BeServiceAddInfo;
import com.kingdee.eas.fm.be.BeServiceEntryCollection;
import com.kingdee.eas.fm.be.BeServiceEntryFactory;
import com.kingdee.eas.fm.be.ErrCodeHelper;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.be.app.AbstractBankPayWebFacadeControllerBean;
import com.kingdee.eas.fm.be.app.BankPayingBillCountFactory;
import com.kingdee.eas.fm.be.app.IBankPayingBillCnt;
import com.kingdee.eas.fm.be.app.mthread.task.BankPayingBillCommitToBeTask;
import com.kingdee.eas.fm.be.app.mthread.task.BankPaymentCommitToBeServiceWeb;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.bean.BankPayParam;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.model.BatchListResult;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class BankPayWebFacadeControllerBean
extends AbstractBankPayWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankPayWebFacadeControllerBean");
    private static final String BE_BANKPAYINGBILL_01VIEW = "bankPayingBill_01view";

    @Override
    protected Map _getBankPayBillCntInfo(Context ctx, BankPayParam bankPayParam) throws BOSException, EASBizException {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        String[] orgIdArr = bankPayParam.getOrgIdArr();
        HashSet<String> orgIdSet = new HashSet<String>(Arrays.asList(orgIdArr));
        Date startDate = bankPayParam.getStartDate();
        Date endDate = bankPayParam.getEndDate();
        int billState = 0;
        billState = 1;
        IBankPayingBillCnt pubOP = BankPayingBillCountFactory.getPublicBillCount(billState);
        int pubOPCnt = pubOP.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("pubOPCnt", pubOPCnt);
        resultMap.put("pubOPState", billState);
        billState = 2;
        IBankPayingBillCnt pubOS = BankPayingBillCountFactory.getPublicBillCount(billState);
        int pubOSCnt = pubOS.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("pubOSCnt", pubOSCnt);
        resultMap.put("pubOSState", billState);
        billState = 7;
        IBankPayingBillCnt pubBP = BankPayingBillCountFactory.getPublicBillCount(billState);
        int pubBPCnt = pubBP.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("pubBPCnt", pubBPCnt);
        resultMap.put("pubBPState", billState);
        billState = 5;
        IBankPayingBillCnt pubTF = BankPayingBillCountFactory.getPublicBillCount(billState);
        int pubTFCnt = pubTF.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("pubTFCnt", pubTFCnt);
        resultMap.put("pubTFState", billState);
        billState = 4;
        IBankPayingBillCnt pubNC = BankPayingBillCountFactory.getPublicBillCount(billState);
        int pubNCCnt = pubNC.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("pubNCCnt", pubNCCnt);
        resultMap.put("pubNCState", billState);
        billState = 6;
        IBankPayingBillCnt pubTS = BankPayingBillCountFactory.getPublicBillCount(billState);
        int pubTSCnt = pubTS.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("pubTSCnt", pubTSCnt);
        resultMap.put("pubTSState", billState);
        billState = 1;
        IBankPayingBillCnt perOP = BankPayingBillCountFactory.getPersonBillCount(billState);
        int perOPCnt = perOP.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("perOPCnt", perOPCnt);
        resultMap.put("perOPState", billState);
        billState = 2;
        IBankPayingBillCnt perOS = BankPayingBillCountFactory.getPersonBillCount(billState);
        int perOSCnt = perOS.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("perOSCnt", perOSCnt);
        resultMap.put("perOSState", billState);
        billState = 7;
        IBankPayingBillCnt perBP = BankPayingBillCountFactory.getPersonBillCount(billState);
        int perBPCnt = perBP.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("perBPCnt", perBPCnt);
        resultMap.put("perBPState", billState);
        billState = 5;
        IBankPayingBillCnt perTF = BankPayingBillCountFactory.getPersonBillCount(billState);
        int perTFCnt = perTF.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("perTFCnt", perTFCnt);
        resultMap.put("perTFState", billState);
        billState = 4;
        IBankPayingBillCnt perNC = BankPayingBillCountFactory.getPersonBillCount(billState);
        int perNCCnt = perNC.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("perNCCnt", perNCCnt);
        resultMap.put("perNCState", billState);
        billState = 6;
        IBankPayingBillCnt perTS = BankPayingBillCountFactory.getPersonBillCount(billState);
        int perTSCnt = perTS.getBankPayingBillCnt(ctx, orgIdSet, startDate, endDate);
        resultMap.put("perTSCnt", perTSCnt);
        resultMap.put("perTSState", billState);
        return resultMap;
    }

    @Override
    protected Map _getMainPageInitData(Context ctx, BankPayParam bankPayParam) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map billCountMap = this.getBankPayBillCntInfo(ctx, bankPayParam);
        resultMap.put("bankPayBillCnt", billCountMap);
        List bankTransLogs = BankLogFacadeFactory.getLocalInstance(ctx).getBankInterfaceLog(bankPayParam.getOrgIdArr());
        resultMap.put("bankTransLogs", bankTransLogs);
        return resultMap;
    }

    @Override
    protected Map _getSumInfo(Context ctx, String filter) throws BOSException, EASBizException {
        CompanyOrgUnitCollection orgUnitCollection = this._getAuthrizedCompanyOrg(ctx, ctx.getCaller().toString(), BE_BANKPAYINGBILL_01VIEW, false);
        StringBuffer where = new StringBuffer("company.id in ('NE',");
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            where.append("'" + orgUnitCollection.get(i).getId().toString() + "',");
        }
        where.deleteCharAt(where.length() - 1);
        where.append(")");
        filter = filter == null || filter.equals("") ? where.toString() : filter + " AND " + where.toString();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.be.BankPayingBillSumQuery"));
        queryExecutor.setObjectView("SELECT billCount,moneySum where " + filter);
        logger.info((Object)("BankPayingBill SumInfo SQL: " + queryExecutor.getSQL()));
        IRowSet rowSet = queryExecutor.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        HashMap<String, BigDecimal> idMap = new HashMap<String, BigDecimal>();
        queryExecutor.setObjectView("SELECT id,payamount where " + filter);
        logger.info((Object)("BankPayingBill selectid SQL: " + queryExecutor.getSQL()));
        try {
            rowSet = queryExecutor.executeQuery();
            while (rowSet.next()) {
                idMap.put(rowSet.getString("id"), rowSet.getBigDecimal("payamount"));
            }
            result.put("idMap", idMap);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected CompanyOrgUnitCollection _getAuthrizedCompanyOrg(Context ctx, String userID, String permItemName, boolean includeVirtual) throws BOSException, EASBizException {
        try {
            String sql = "SELECT FID FROM T_PM_PermItem WHERE FNAME = ? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{permItemName});
            String permItemID = null;
            if (!rowSet.next()) {
                return new CompanyOrgUnitCollection();
            }
            permItemID = rowSet.getString("FID");
            if (userID == null) {
                userID = ctx.getCaller().toString();
            }
            sql = "SELECT UserRoleOrg.FOrgID as FOrgID FROM T_PM_RolePerm RolePerm INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID= ? UNION SELECT UserOrgPerm.FOrgID as FOrgID FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = ? ";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userID, permItemID, userID, permItemID});
            HashSet<String> idSet = new HashSet<String>();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("FOrgID"));
            }
            if (idSet.size() == 0) {
                return new CompanyOrgUnitCollection();
            }
            CasBosUtils.EntityViewBuilder viewBuilder = CasBosUtils.entityViewBuilder();
            viewBuilder.select(new String[]{"id", "number", "name", "longNumber", "level", "isBizUnit"}).sort("longNumber", SortType.ASCEND).sort("number", SortType.ASCEND).filter("id", idSet, CompareType.INCLUDE);
            if (!includeVirtual) {
                viewBuilder.filter("isBizUnit", (Object)true, CompareType.EQUALS);
            }
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewBuilder.build());
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected boolean _checkPermission(Context ctx, String orgID, String userID, String permItemName) throws BOSException, EASBizException {
        try {
            String sql = "SELECT FID FROM T_PM_PermItem WHERE FNAME = ? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{permItemName});
            String permItemID = null;
            if (!rowSet.next()) {
                return true;
            }
            permItemID = rowSet.getString("FID");
            sql = "SELECT UserRoleOrg.FOrgID as FOrgID FROM T_PM_RolePerm RolePerm INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID= ? AND UserRoleOrg.FOrgID = ? UNION SELECT UserOrgPerm.FOrgID as FOrgID FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = ? AND UserOrgPerm.FOrgID = ? ";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userID, permItemID, orgID, userID, permItemID, orgID});
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void checkGetVersion(Context ctx) throws FMException {
        block7: {
            try {
                BeServiceAddInfo beServiceAddInfo = new BeServiceAddInfo();
                if (FmBeHelper.isNotExistsMulBeService(ctx)) {
                    BeServiceAddCollection beServiceAddCollection = BeServiceAddFactory.getRemoteInstance().getBeServiceAddCollection();
                    beServiceAddInfo = beServiceAddCollection.get(0);
                    break block7;
                }
                try {
                    CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
                    BeServiceEntryCollection coll = null;
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)companyInfo)) {
                        EntityViewInfo view1 = new EntityViewInfo();
                        FilterInfo filter1 = new FilterInfo();
                        view1.setFilter(filter1);
                        filter1.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
                        coll = BeServiceEntryFactory.getLocalInstance(ctx).getBeServiceEntryCollection(view1);
                    }
                    if (coll != null && coll.size() > 0) {
                        beServiceAddInfo = BeServiceAddFactory.getLocalInstance(ctx).getBeServiceAddInfo((IObjectPK)new ObjectUuidPK(coll.get(0).getParent().getId().toString()));
                    }
                    BankFacadeFactory.getRemoteInstance().getVersion(beServiceAddInfo);
                }
                catch (Exception ex) {
                    throw new BEException(BEException.TESTVERSION);
                }
            }
            catch (Exception e1) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ErrCodeHelper.getResourceByErrCode("BE1002", e1.getMessage())});
            }
        }
    }

    private BatchExecuteResult buildCommitReturnMsgNew(Context ctx, int idLength, List<BankPayResult> results, List<String> correctList) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{idLength + ""});
        int success = correctList.size();
        for (int i = 0; i < results.size(); ++i) {
            BankPayResult executeResult = results.get(i);
            if (EmptyUtil.isEmpty((String)executeResult.getErrorDetail())) continue;
            --success;
            result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"PAYMENTBILL_COMMITTOBE_FAILED_NEW", (String[])new String[]{executeResult.getNumber(), executeResult.getErrorDetail()}));
        }
        summary = success == idLength ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_COMMITTOBE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"COMMITTOBE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idLength - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        this.checkGetVersion(ctx);
        List idList = FMHelper.Array2List((String[])ids);
        HashSet idset = new HashSet();
        CollectionUtils.addAll(idset, (Object[])ids);
        BankPaymentCommitToBeServiceWeb paymentCommitToBeServiceWeb = new BankPaymentCommitToBeServiceWeb(ctx);
        ArrayList results = paymentCommitToBeServiceWeb.commitToBENewBatchWithThread(ctx, idset);
        BatchExecuteResult result = new BatchExecuteResult();
        int idLength = ids.length;
        return this.buildCommitReturnMsgNew(ctx, idLength, results, idList);
    }

    @Override
    protected Map _batchSyncState(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("isCBPay"));
        sic.add(new SelectorItemInfo("isBitBack"));
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IBankFacade bankFacade = BankFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < ids.length; ++i) {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(ids[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingBill_03sync");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_SYNC_AUTHRIZED);
                }
                if (info.isIsBitBack()) {
                    throw new RuntimeException("\u5df2\u7ecf\u6253\u56de\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u72b6\u6001!");
                }
                if (info.getState() == BankPayingBillStateEnum.OP) {
                    throw new RuntimeException(FmBeWebUtils.getResource(ctx, "105_BANKPAYINGBILL_STATE_OP_NOT_SYNC"));
                }
                if (info.getState() == BankPayingBillStateEnum.OF) {
                    throw new RuntimeException(FmBeWebUtils.getResource(ctx, "126_BANKPAYINGBILL_STATE_OF_NOT_SYNC"));
                }
                Map map = bankFacade.syncStateByBillIds(idList);
                BankPayResult bankInfo = (BankPayResult)map.get(ids[i]);
                String errMsg = bankInfo.getErrorDetail();
                if (!EmptyUtil.isEmpty((String)errMsg)) {
                    throw new RuntimeException(errMsg.substring(errMsg.indexOf(FmBeWebUtils.getResource(ctx, "109_COMMA")) + 1));
                }
                ++success;
                continue;
            }
            catch (Exception e) {
                if (!info.isIsCBPay()) {
                    result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "106_BANKPAYINGBILL_SYNC_FAILED", new String[]{info.getNumber(), e.getMessage()}));
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "215_CBBANKPAYINGBILL_SYNC_FAILED", new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (success == ids.length) {
            summary = summary + FmBeWebUtils.getResource(ctx, "107_ALL_SYNC_SUCCESS");
            result.setError(0);
        } else {
            summary = summary + FmBeWebUtils.getResource(ctx, "108_SYNC_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
            result.setError(ids.length - success);
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchBitBack(Context ctx, String[] ids, String msg) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingBill_bitBack");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_BITBACK_AUTHRIZED);
                }
                ArrayList resultList = pay.bitBack(idList, msg);
                BankPayResult resultInfo = (BankPayResult)resultList.get(0);
                if (resultInfo.getErrorDetail() != null) {
                    String detailMsg = FmBeWebUtils.getResource(ctx, "110_BANKPAYINGBILL_BITBACK_FAILED", new String[]{resultInfo.getNumber(), resultInfo.getErrorDetail()});
                    throw new RuntimeException(detailMsg);
                }
                ++success;
                continue;
            }
            catch (Exception e) {
                if (e instanceof CasWebException) {
                    result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "110_BANKPAYINGBILL_BITBACK_FAILED", new String[]{info.getNumber(), e.getMessage()}));
                    continue;
                }
                result.getDetailMsgList().add(e.getMessage());
            }
        }
        summary = success == ids.length ? summary + FmBeWebUtils.getResource(ctx, "111_ALL_BITBACK_SUCCESS") : summary + FmBeWebUtils.getResource(ctx, "112_BITBACK_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchBitBack(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingBill_bitBack");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_BITBACK_AUTHRIZED);
                }
                ArrayList resultList = pay.bitBack(idList);
                BankPayResult resultInfo = (BankPayResult)resultList.get(0);
                if (resultInfo.getErrorDetail() != null) {
                    String detailMsg = FmBeWebUtils.getResource(ctx, "110_BANKPAYINGBILL_BITBACK_FAILED", new String[]{resultInfo.getNumber(), resultInfo.getErrorDetail()});
                    throw new RuntimeException(detailMsg);
                }
                ++success;
                continue;
            }
            catch (Exception e) {
                if (e instanceof CasWebException) {
                    result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "110_BANKPAYINGBILL_BITBACK_FAILED", new String[]{info.getNumber(), e.getMessage()}));
                    continue;
                }
                result.getDetailMsgList().add(e.getMessage());
            }
        }
        summary = success == ids.length ? summary + FmBeWebUtils.getResource(ctx, "111_ALL_BITBACK_SUCCESS") : summary + FmBeWebUtils.getResource(ctx, "112_BITBACK_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchEditState(Context ctx, String[] ids, String state) throws BOSException, EASBizException {
        BatchListResult result = new BatchListResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        try {
            IObjectPK[] orgIdPks = this.getOrgIdPKs(ctx, ids);
            if (orgIdPks != null) {
                for (int i = 0; i < orgIdPks.length; ++i) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)orgIdPks[i], (String)"bankPayingbill_editState");
                    if (isPermission) continue;
                    throw new CasWebException(CasWebException.NO_EDITSTATE_AUTHRIZED);
                }
            }
            IObjectPK[] pks = new IObjectPK[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                pks[i] = new ObjectUuidPK(ids[i]);
            }
            BankPayingBillStateEnum stateEnum = BankPayingBillStateEnum.getEnum(Integer.valueOf(state));
            Map ret = pay.updateState(pks, stateEnum);
            int fail = 0;
            List resultList = (List)ret.get("resultList");
            for (BankPayResult bankPayResult : resultList) {
                if (EmptyUtil.isEmpty((String)bankPayResult.getErrorDetail())) continue;
                result.getDetailObjList().add(bankPayResult);
                ++fail;
            }
            if (fail == 0) {
                result.setError(0);
                summary = summary + FmBeWebUtils.getResource(ctx, "133_ALL_UPDATESTATE_SUCCESS");
            } else {
                result.setError(1);
                summary = summary + FmBeWebUtils.getResource(ctx, "134_UPDATESTATE_RESULT", new String[]{String.valueOf(ids.length - fail), String.valueOf(fail)});
            }
            result.setSummaryMsg(summary);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(FmBeWebUtils.getResource(ctx, "117_UPDATESTATE_FAILED", new String[]{e.getMessage()}));
        }
        return result;
    }

    private IObjectPK[] getOrgIdPKs(Context ctx, String[] ids) throws BOSException, EASBizException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("SELECT FCompanyID from T_BE_BankPayingBill WHERE ");
        sql.append("FID in (");
        for (int idx = 0; idx < ids.length; ++idx) {
            if (idx > 0) {
                sql.append(",");
            }
            sql.append("?");
            params.add(ids[idx]);
        }
        sql.append(") ");
        sql.append("GROUP BY FCompanyID");
        IRowSet rowSet = null;
        IObjectPK[] pks = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            pks = new IObjectPK[rowSet.size()];
            int i = 0;
            while (rowSet.next()) {
                pks[i] = new ObjectUuidPK(rowSet.getString("FCompanyID"));
                ++i;
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            boolean isLock = false;
            BankPayingBillInfo info = null;
            try {
                isLock = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isLock) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean", (Locale)ctx.getLocale())});
                }
                if (!pay.exists((IObjectPK)new ObjectUuidPK(ids[i]))) {
                    throw new BEException(BEException.COMMON, new Object[]{FmBeWebUtils.getResource(ctx, "113_BANKPAYINGBILL_DELETE_FAILED")});
                }
                info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
                pay.delete((IObjectPK)new ObjectUuidPK(ids[i]));
                ++success;
                continue;
            }
            catch (Exception e) {
                if (info != null) {
                    result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "113_BANKPAYINGBILL_DELETE_FAILED", new String[]{info.getNumber(), e.getMessage()}));
                    continue;
                }
                result.getDetailMsgList().add(FmBeWebUtils.getResource(ctx, "113_BANKPAYINGBILL_DELETE_FAILED", new String[]{"", e.getMessage()}));
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + FmBeWebUtils.getResource(ctx, "114_ALL_DELETE_SUCCESS") : summary + FmBeWebUtils.getResource(ctx, "115_DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _submit(Context ctx, String id) throws BOSException, EASBizException {
        TaskManager taskManager = new TaskManager();
        List results = taskManager.batchExecute(ctx, new String[]{id}, BankPayingBillCommitToBeTask.class);
        BatchExecuteResult result = new BatchExecuteResult();
        if (((ExecuteResult)results.get(0)).isSuccess()) {
            result.setError(0);
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)"332_COMMITTOBE_SUCCESS"));
        } else {
            result.setError(1);
            result.setSummaryMsg(FmBeWebUtils.getResource(ctx, "129_SUBMIT_FAILED"));
            result.getDetailMsgList().add(((ExecuteResult)results.get(0)).getMsg());
        }
        return result;
    }

    @Override
    protected Map _syncState(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("isCBPay"));
        sic.add(new SelectorItemInfo("isBitBack"));
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        IBankFacade bankFacade = BankFacadeFactory.getLocalInstance(ctx);
        BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        String summary = null;
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingBill_03sync");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_SYNC_AUTHRIZED);
            }
            if (info.isIsBitBack()) {
                throw new RuntimeException("\u5df2\u7ecf\u6253\u56de\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u72b6\u6001!");
            }
            if (info.getState() == BankPayingBillStateEnum.OP) {
                throw new RuntimeException(FmBeWebUtils.getResource(ctx, "105_BANKPAYINGBILL_STATE_OP_NOT_SYNC"));
            }
            if (info.getState() == BankPayingBillStateEnum.OF) {
                throw new RuntimeException(FmBeWebUtils.getResource(ctx, "126_BANKPAYINGBILL_STATE_OF_NOT_SYNC"));
            }
            Map map = bankFacade.syncStateByBillIds(idList);
            String errMsg = (String)map.get("error");
            if (!EmptyUtil.isEmpty((String)errMsg)) {
                throw new RuntimeException(errMsg.substring(errMsg.indexOf(FmBeWebUtils.getResource(ctx, "109_COMMA")) + 1));
            }
            summary = FmBeWebUtils.getResource(ctx, "127_SYNC_SUCCESS");
            result.setError(0);
        }
        catch (Exception e) {
            summary = FmBeWebUtils.getResource(ctx, "128_SYNC_FAILED");
            result.setError(1);
            result.getDetailMsgList().add(e.getMessage());
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _bitBack(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        String summary = null;
        try {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingBill_bitBack");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_BITBACK_AUTHRIZED);
            }
            ArrayList resultList = pay.bitBack(idList);
            BankPayResult resultInfo = (BankPayResult)resultList.get(0);
            if (resultInfo.getErrorDetail() != null) {
                throw new RuntimeException(resultInfo.getErrorDetail());
            }
            summary = FmBeWebUtils.getResource(ctx, "130_BITBACK_SUCCESS");
            result.put("id", resultInfo.getId().toString());
            result.setError(0);
        }
        catch (Exception e) {
            summary = FmBeWebUtils.getResource(ctx, "131_BITBACK_FAILED");
            result.setError(1);
            result.getDetailMsgList().add(e.getMessage());
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _editState(Context ctx, String id, String state) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        String summary = null;
        try {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingbill_editState");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_EDITSTATE_AUTHRIZED);
            }
            IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(id)};
            BankPayingBillStateEnum stateEnum = BankPayingBillStateEnum.getEnum(Integer.valueOf(state));
            Map ret = pay.updateState(pks, stateEnum);
            BankPayResult bankPayResult = (BankPayResult)((List)ret.get("resultList")).get(0);
            if (!EmptyUtil.isEmpty((String)bankPayResult.getErrorDetail())) {
                result.setError(1);
                result.getDetailMsgList().add(bankPayResult.getBankDetail());
                summary = FmBeWebUtils.getResource(ctx, "132_UPDATESTATE_FAILED");
            } else {
                result.setError(0);
                summary = FmBeWebUtils.getResource(ctx, "116_UPDATESTATE_SUCCESS");
            }
        }
        catch (Exception e) {
            result.setError(1);
            summary = FmBeWebUtils.getResource(ctx, "132_UPDATESTATE_FAILED");
            result.getDetailMsgList().add(e.getMessage());
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("creator");
        sic.add("state");
        sic.add("status");
        sic.add("company.id");
        sic.add("company.name");
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        UserInfo curUser = iContextHelper.getCurrentUser();
        HashMap<BOSUuid, String> mapTM018 = new HashMap<BOSUuid, String>();
        HashMap<BOSUuid, Boolean> mapBE001 = new HashMap<BOSUuid, Boolean>();
        HashMap<BOSUuid, Boolean> mapBE002 = new HashMap<BOSUuid, Boolean>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            BOSUuid companyId = info.getCompany().getId();
            if (EmptyUtil.isEmpty((String)((String)mapTM018.get(companyId)))) {
                String TM018 = iContextHelper.getStringParam("TM018", (IObjectPK)new ObjectUuidPK(companyId));
                mapTM018.put(companyId, TM018);
            }
            if (EmptyUtil.isEmpty(mapBE001.get(companyId))) {
                boolean BE001 = iContextHelper.getBooleanParam("BE001", (IObjectPK)new ObjectUuidPK(companyId));
                mapBE001.put(companyId, BE001);
            }
            if (EmptyUtil.isEmpty(mapBE002.get(companyId))) {
                boolean BE002 = iContextHelper.getBooleanParam("BE002", (IObjectPK)new ObjectUuidPK(companyId));
                mapBE002.put(companyId, BE002);
            }
            HashSet<String> idList = new HashSet<String>();
            boolean isLock = false;
            try {
                isLock = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isLock) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean", (Locale)ctx.getLocale())});
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingbill_audit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                }
                String TM018 = (String)mapTM018.get(companyId);
                if (TM018 == null || "0".equals(TM018)) {
                    throw new BEException(BEException.PARAMNOTALLOWAUDIT, new Object[]{info.getNumber(), info.getCompany().getName()});
                }
                if (!((Boolean)mapBE001.get(companyId)).booleanValue()) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"303_Company", (Locale)ctx.getLocale()) + info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"494_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale())});
                }
                if (info.getStatus() == AuditStatus.audited) {
                    throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"69_BankPayingBillListUI", (Locale)ctx.getLocale()));
                }
                if (info.getState() != BankPayingBillStateEnum.OP) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"68_BankPayingBillListUI", (Locale)ctx.getLocale())});
                }
                if (((Boolean)mapBE002.get(companyId)).booleanValue() && info.getCreator() != null && info.getCreator().getId().equals((Object)curUser.getId())) {
                    throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"67_BankPayingBillListUI", (Locale)ctx.getLocale()));
                }
                idList.add(ids[i]);
                pay.audit(idList, AuditStatus.audited);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!info.isIsCBPay()) {
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"495_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"496_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                    continue;
                }
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"497_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"496_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        if (success == ids.length) {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"498_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale());
        } else {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"499_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(success) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"413_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(ids.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"500_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setError(ids.length - success);
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAntiAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        selectors.add("creator");
        selectors.add("state");
        selectors.add("status");
        selectors.add("company.id");
        selectors.add("company.name");
        IBankPayingBill pay = BankPayingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource(ctx, "104_BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        HashMap<BOSUuid, String> mapTM018 = new HashMap<BOSUuid, String>();
        HashMap<BOSUuid, Boolean> mapBE001 = new HashMap<BOSUuid, Boolean>();
        HashMap<BOSUuid, Boolean> mapBE002 = new HashMap<BOSUuid, Boolean>();
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            BankPayingBillInfo info = pay.getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), selectors);
            BOSUuid companyId = info.getCompany().getId();
            if (EmptyUtil.isEmpty((String)((String)mapTM018.get(companyId)))) {
                String TM018 = iContextHelper.getStringParam("TM018", (IObjectPK)new ObjectUuidPK(companyId));
                mapTM018.put(companyId, TM018);
            }
            if (EmptyUtil.isEmpty(mapBE001.get(companyId))) {
                boolean BE001 = iContextHelper.getBooleanParam("BE001", (IObjectPK)new ObjectUuidPK(companyId));
                mapBE001.put(companyId, BE001);
            }
            if (EmptyUtil.isEmpty(mapBE002.get(companyId))) {
                boolean BE002 = iContextHelper.getBooleanParam("BE002", (IObjectPK)new ObjectUuidPK(companyId));
                mapBE002.put(companyId, BE002);
            }
            HashSet<String> idList = new HashSet<String>();
            boolean isLock = false;
            try {
                isLock = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isLock) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean", (Locale)ctx.getLocale())});
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"bankPayingbill_untiAudit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_UNAUDIT_AUTHRIZED);
                }
                String TM018 = (String)mapTM018.get(companyId);
                if (TM018 == null || "0".equals(TM018)) {
                    throw new BEException(BEException.PARAMNOTALLOWAUDIT, new Object[]{info.getNumber(), info.getCompany().getName()});
                }
                if (!((Boolean)mapBE001.get(companyId)).booleanValue()) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"303_Company", (Locale)ctx.getLocale()) + info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"494_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale())});
                }
                if (info.getState() != BankPayingBillStateEnum.OP) {
                    throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"68_BankPayingBillListUI", (Locale)ctx.getLocale()));
                }
                if (info.getStatus().equals((Object)AuditStatus.unAudit)) {
                    throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"70_BankPayingBillListUI", (Locale)ctx.getLocale()));
                }
                idList.add(ids[i]);
                pay.audit(idList, AuditStatus.unAudit);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!info.isIsCBPay()) {
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"495_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"501_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                    continue;
                }
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"497_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"501_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        if (success == ids.length) {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"502_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale());
        } else {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"503_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(success) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"413_BankAgentPayWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(ids.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"500_BankPayWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setError(ids.length - success);
        }
        result.setSummaryMsg(summary);
        return result;
    }
}

