/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.AuditStatus;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankLogFacadeFactory;
import com.kingdee.eas.fm.be.BankPayBillBuilderFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankPayBillBuilder;
import com.kingdee.eas.fm.be.IBankPayBillCollectionBuilder;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.fm.be.PayBitBackRecordFactory;
import com.kingdee.eas.fm.be.PayBitBackRecordInfo;
import com.kingdee.eas.fm.be.app.AbstractBankPayingBillControllerBean;
import com.kingdee.eas.fm.be.app.BankCommitToBeService;
import com.kingdee.eas.fm.be.app.CommitToBeCache;
import com.kingdee.eas.fm.be.app.bankpay.BankPayingBillSateUtil;
import com.kingdee.eas.fm.cbs.CBPaymentFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.DynamicUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.util.MessageDigestTools;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankPayingBillControllerBean
extends AbstractBankPayingBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankPayingBillControllerBean");
    private static final String resource = "com.kingdee.eas.fm.be.BEAutoGenerateResource";
    private static String UPDATE_BANKPAYBILL_STATUS = "UPDATE T_BE_BankPayingBill Set FStatus = {0}, FAuditerID = {1} WHERE FState = 1 And FId IN {2}";
    private static String SELECT_BANKPAYBILL_NUMBER = "Select FNumber From T_BE_BankPayingBill WHERE FState = 1 And FId IN {0}";

    @Override
    protected void _genSerial(Context ctx) throws BOSException {
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String s;
        BankPayingBillInfo info = (BankPayingBillInfo)model;
        this.verifyDataAdd(ctx, (IObjectValue)info);
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            } else {
                throw new BEException(BEException.HASNOCODINGRULE);
            }
        }
        if ((s = info.getRecCompany()) != null && s.length() > 255) {
            info.setRecCompany(s.substring(0, 255));
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.updateEditFlag(ctx, info);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankPayingBillInfo info = (BankPayingBillInfo)model;
        info.setHandler(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        return super.submit(ctx, (CoreBaseInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankPayingBillInfo info = (BankPayingBillInfo)this._getValue(ctx, pk);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u5220\u9664", (BOSObjectType)new BankPayingBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getNumber().toString(), (String)"bankPayingBill_delete");
        if (info.getState() != BankPayingBillStateEnum.TF && info.getState() != BankPayingBillStateEnum.OP) {
            throw new BEException(BEException.BANKPAYINGDELETEERR);
        }
        if (!info.isIsBitBack()) {
            throw new BEException(BEException.BANKPAYINGDELETEERR);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestObjIDForUpdate(pk.toString());
            if (!isLock) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean", (Locale)ctx.getLocale())});
            }
            super._delete(ctx, pk);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            String bankLogOrgBillId = info.getId().toString();
            BankLogFacadeFactory.getLocalInstance(ctx).updateBankLogPayBillId(bankLogOrgBillId, null);
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(pk.toString());
            }
        }
    }

    private void rever4Remove(Context ctx, BankPayingBillInfo info, String sbillId) throws BOSException, EASBizException {
        BOSUuid id = BOSUuid.read((String)sbillId);
        SettlementBillInfo sett = new SettlementBillInfo();
        PaymentBillInfo paybill = new PaymentBillInfo();
        if (id.getType().equals((Object)sett.getBOSType())) {
            SettleFacadeFactory.getLocalInstance((Context)ctx).cancelCommitToBE(sbillId);
        } else if (id.getType().equals((Object)paybill.getBOSType())) {
            PaymentBillFactory.getLocalInstance((Context)ctx).cancelCommitToBE(sbillId);
        } else {
            logger.error((Object)info);
        }
    }

    private boolean verifyDataAdd(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String srcBillId;
        BankPayingBillInfo newInfo = (BankPayingBillInfo)model;
        if (newInfo == null) {
            throw new BEException(BEException.DATAISNULL);
        }
        if (!newInfo.isIsCBPay()) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)newInfo, (String)"recAccountBank");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)newInfo, (String)"recBank");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)newInfo, (String)"recCompany");
            if ((newInfo.getRecProvinceStr() == null || newInfo.getRecCityStr() == null) && newInfo.getRecOpenArea() == null) {
                throw new BEException(BEException.ADDRESSERROR);
            }
        }
        if (this.hasGenPayInfo(ctx, srcBillId = newInfo.getSourceBillId())) {
            throw new BEException(BEException.HASCOMMIT);
        }
        return false;
    }

    private boolean hasGenPayInfo(Context ctx, String srcBillId) throws BOSException {
        if (EmptyUtil.isEmpty((String)srcBillId)) {
            return false;
        }
        BankPayingBillCollection oldColl = this.getOldColl(ctx, srcBillId);
        return oldColl != null && !oldColl.isEmpty();
    }

    private BankPayingBillCollection getOldColl(Context ctx, String srcBillId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)srcBillId));
        filter.getFilterItems().add(new FilterItemInfo("isBitBack", (Object)0));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        BankPayingBillCollection oldColl = this.getBankPayingBillCollection(ctx, evi);
        return oldColl;
    }

    @Override
    protected IObjectPK _commit2BankPayBill(Context ctx, String billId, String builderName) throws BOSException, EASBizException {
        IBankPayBillBuilder builder = BankPayBillBuilderFactory.getInstance(builderName);
        BankPayingBillInfo info = builder.getBankPayBillInfo(ctx, billId);
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        String value = contextHelper.getStringParam("BE009", (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId()));
        return this._commit2BankPayBill(ctx, info, value);
    }

    @Override
    protected IObjectPK _commit2BankPayBill(Context ctx, BankPayingBillInfo info, String BE009) throws BOSException, EASBizException {
        if (BE009 != null && "1".equals(BE009)) {
            if (info.getRecOpenArea() == null && info.getRecProvinceStr() == null && info.getRecCityStr() == null) {
                throw new BEException(BEException.RECAREAISNOTNULL);
            }
            if (info.getRecOpenArea() != null && info.getRecOpenArea().getProvince() == null && info.getRecOpenArea().getName() == null && info.getRecProvinceStr() == null && info.getRecCityStr() == null) {
                throw new BOSException("province or city is null!");
            }
            if (info.getRecOpenArea() != null) {
                info.setRecProvinceStr(info.getRecOpenArea().getProvince());
                info.setRecCityStr(info.getRecOpenArea().getName());
            }
        }
        if (info.getPayAccountBank().isIsOnlyRead()) {
            throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{info.getPayAccountBank().getName()});
        }
        if (info.getPayAccountBank().getMaxPayAmount() != null && Constants.ZERO.compareTo(info.getPayAccountBank().getMaxPayAmount()) < 0 && info.getPayAmount().compareTo(info.getPayAccountBank().getMaxPayAmount()) > 0) {
            throw new BEException(BEException.OVERMAXPAYAMOUNT, new Object[]{info.getPayAccountBank().getName(), info.getPayAccountBank().getMaxPayAmount()});
        }
        IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(info.getSourceBillId(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, map);
        return pk;
    }

    private SelectorItemCollection getSelectorForBe() {
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("company.id");
        sele.add("company.name");
        sele.add("payAccountBank.id");
        sele.add("payAccountBank.name");
        sele.add("payAccountBank.isOnlyRead");
        sele.add("payAccountBank.maxPayAmount");
        sele.add("payAccountBank.bankAccountNumber");
        return sele;
    }

    @Override
    protected ArrayList _bitBack(Context ctx, Set idSet, String Msg) throws BOSException, EASBizException {
        StringBuffer sb;
        HashSet<String> srcPay = new HashSet<String>();
        HashSet<String> srcSettle = new HashSet<String>();
        ArrayList resultList = super.bitBack(ctx, idSet);
        if (FMHelper.isEmpty((String)Msg)) {
            return resultList;
        }
        if (Msg.length() > 160) {
            Msg = Msg.substring(0, 159);
        }
        if (!EmptyUtil.isEmpty((Collection)resultList)) {
            for (Object obj : resultList) {
                BankPayResult result = (BankPayResult)obj;
                if (result.getBankResult().equals("bitbackfail") || EmptyUtil.isEmpty((String)result.getSrcId())) continue;
                BOSObjectType bosType = BOSUuid.read((String)result.getSrcId()).getType();
                if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
                    srcPay.add(result.getSrcId());
                    continue;
                }
                if (!bosType.equals((Object)new SettlementBillInfo().getBOSType())) continue;
                srcSettle.add(result.getSrcId());
            }
        }
        if (srcPay.size() > 0) {
            sb = new StringBuffer();
            sb.append("update t_cas_paymentbill set FConceit=? where ");
            sb.append(FMHelper.buildIn((String)"fid", (Object[])srcPay.toArray()));
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{Msg});
        }
        if (srcSettle.size() > 0) {
            sb = new StringBuffer();
            sb.append("update t_fs_settlementbill set FBITBACKADVICE=? where ");
            sb.append(FMHelper.buildIn((String)"fid", (Object[])srcSettle.toArray()));
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{Msg});
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _bitBack(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            throw new BEException(BEException.NOSUITRECORD);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add(new SelectorItemInfo("payAccountBank.*"));
        ev.setSelector(selector);
        BankPayingBillCollection coll = this.getBankPayingBillCollection(ctx, ev);
        ArrayList<BankPayResult> resultList = new ArrayList<BankPayResult>();
        IJournal iJournal = JournalFactory.getLocalInstance((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            BankPayResult resultInfo = new BankPayResult();
            BankPayingBillInfo info = coll.get(i);
            String sbillId = info.getSourceBillId();
            String fid = info.getId().toString();
            boolean isLock = false;
            try {
                isLock = iMutex.requestObjIDForUpdate(fid);
                if (!isLock) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean", (Locale)ctx.getLocale())});
                }
                if (info.getState() != BankPayingBillStateEnum.TF && info.getState() != BankPayingBillStateEnum.OP && info.getState() != BankPayingBillStateEnum.OF) {
                    throw new BEException(BEException.BANKPAYINGBILLCANNOTDELETE, new Object[]{""});
                }
                if (info.getState().equals((Object)BankPayingBillStateEnum.OP) && info.getStatus().equals((Object)AuditStatus.audited)) {
                    throw new BEException(BEException.BANKPAYINGBILLCANNOTDELETEBYAUDIT, new Object[]{""});
                }
                if (info.isIsBitBack()) {
                    throw new BEException(BEException.BANKPAYINGBILLHASBITBACK, new Object[]{""});
                }
                if (iJournal.isSourceBillMerged(sbillId)) {
                    throw new BEException(BEException.HASMERGEDBYBATCHNO, new Object[]{""});
                }
                BankPayingBillFactory.getLocalInstance(ctx).singleBitBack(info);
                resultInfo.setBankResult("bitbacksuccess");
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BankPayingBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getNumber().toString(), (String)"bankPayingBill_bitBack");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)"bitbackfail! exception is:", (Throwable)e);
                resultInfo.setBankResult("bitbackfail");
                resultInfo.setErrorDetail(e.getMessage());
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(fid);
                }
            }
            resultInfo.setNumber(info.getNumber());
            if (info.getId() != null) {
                resultInfo.setId(info.getId().toString());
            } else {
                resultInfo.setId(fid);
            }
            resultInfo.setSrcId(sbillId);
            resultList.add(resultInfo);
        }
        return resultList;
    }

    @Override
    protected void _singleBitBack(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException {
        String sbillId = info.getSourceBillId();
        if (!EmptyUtil.isEmpty((String)sbillId)) {
            String sql = "SELECT p.Fid FROM T_BOT_relation r INNER JOIN T_CAS_PaymentBill p on r.FDESTOBJECTID =p.Fid where r.FSRCOBJECTID =? and p.FISREFUNDMENTPAY =1";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{sbillId});
            try {
                if (result.next()) {
                    throw new BEException(BEException.NOT_ALLOW_BIT_REFUND);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (!EmptyUtil.isEmpty((String)info.getSourceBillId())) {
                BOSUuid id = BOSUuid.read((String)info.getSourceBillId());
                SettlementBillInfo sett = new SettlementBillInfo();
                PaymentBillInfo paybill = new PaymentBillInfo();
                if (id.getType().equals((Object)sett.getBOSType()) && !SettlementBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)resource, (String)"BitBack_Fail", (Locale)ctx.getLocale())});
                }
                if (id.getType().equals((Object)paybill.getBOSType()) && !PaymentBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                    throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)resource, (String)"BitBack_Fail", (Locale)ctx.getLocale())});
                }
            }
            this.rever4Remove(ctx, info, sbillId);
        }
        String bankLogOrgBillId = info.getId().toString();
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        info.setId(null);
        info.setSourceBillId(null);
        info.setIsBitBack(true);
        info.setBitBacker(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setBitBackTime(DateHelper.getTime());
        IObjectPK pk = super.addnew(ctx, (CoreBaseInfo)info);
        this.recordPayBilBack(ctx, sbillId, pk.toString());
        String bankLogNewBillId = info.getId().toString();
        BankLogFacadeFactory.getLocalInstance(ctx).updateBankLogPayBillId(bankLogOrgBillId, bankLogNewBillId);
    }

    private void recordPayBilBack(Context ctx, String payBillId, String bankPayBillId) throws BOSException, EASBizException {
        PayBitBackRecordInfo bitBackRecord = new PayBitBackRecordInfo();
        bitBackRecord.setPayBillId(payBillId);
        bitBackRecord.setBankPayBillId(bankPayBillId);
        PayBitBackRecordFactory.getLocalInstance(ctx).addnew(bitBackRecord);
    }

    @Override
    protected void _commit2Bank(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
    }

    private void checkIfByEdited(Context ctx, BankPayingBillInfo info) throws BOSException, EASBizException, RecPayException {
        boolean editFlagValid;
        String srcPayerBankAcct = info.getPayAccountBank() != null ? info.getPayAccountBank().getBankAccountNumber() : "";
        String srcPayerBankAcctNum = "";
        String srcPayeeBankAcctNum = info.getRecAccountBank();
        String srcCurrency = info.getCurrency().getId().toString();
        String srcAmout = info.getPayAmount().toString();
        String editFlag = EmptyUtil.isEmpty((String)info.getEditFlagNew()) ? info.getEditFlag() : info.getEditFlagNew();
        String srcString = srcPayerBankAcct + srcPayerBankAcctNum + srcPayeeBankAcctNum + srcCurrency + srcAmout;
        if (info.isIsCBPay() && info.getCbPayInfo() != null && !EmptyUtil.isEmpty((String)info.getEditFlagNew())) {
            SelectorItemCollection selCol = new SelectorItemCollection();
            selCol.add(new SelectorItemInfo("id"));
            selCol.add(new SelectorItemInfo("payeeCurrency.id"));
            selCol.add(new SelectorItemInfo("payeeAmount"));
            CBPaymentInfo cbInfo = CBPaymentFactory.getLocalInstance((Context)ctx).getCBPaymentInfo((IObjectPK)new ObjectUuidPK(info.getCbPayInfo().getId().toString()), selCol);
            if (cbInfo != null) {
                String srcPayeeCurrency = cbInfo.getPayeeCurrency().getId().toString();
                String srcPayeeAmount = cbInfo.getPayeeAmount().toString();
                srcString = srcPayerBankAcct + srcPayerBankAcctNum + srcPayeeBankAcctNum + srcCurrency + srcAmout + srcPayeeCurrency + srcPayeeAmount;
            }
        }
        if (!(editFlagValid = MessageDigestTools.checkIfValid((String)srcString, (String)editFlag))) {
            throw new BEException(BEException.BANKPAYBILLINFOBYEDITED, new String[]{info.getNumber()});
        }
    }

    public void updateEditFlag(Context ctx, BankPayingBillInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        String srcPayerBankAcct = info.getPayAccountBank() != null ? info.getPayAccountBank().getBankAccountNumber() : "";
        String srcPayerBankAcctNum = "";
        String srcPayeeBankAcctNum = info.getRecAccountBank();
        String srcCurrency = info.getCurrency().getId().toString();
        String srcamout = info.getPayAmount().toString();
        String srcString = srcPayerBankAcct + srcPayerBankAcctNum + srcPayeeBankAcctNum + srcCurrency + srcamout;
        if (info.isIsCBPay() && info.getCbPayInfo() != null) {
            SelectorItemCollection selCol = new SelectorItemCollection();
            selCol.add(new SelectorItemInfo("id"));
            selCol.add(new SelectorItemInfo("payeeCurrency.id"));
            selCol.add(new SelectorItemInfo("payeeAmount"));
            CBPaymentInfo cbInfo = CBPaymentFactory.getLocalInstance((Context)ctx).getCBPaymentInfo((IObjectPK)new ObjectUuidPK(info.getCbPayInfo().getId().toString()), selCol);
            if (cbInfo != null) {
                String srcPayeeCurrency = cbInfo.getPayeeCurrency().getId().toString();
                String srcPayeeAmount = cbInfo.getPayeeAmount().toString();
                srcString = srcPayerBankAcct + srcPayerBankAcctNum + srcPayeeBankAcctNum + srcCurrency + srcamout + srcPayeeCurrency + srcPayeeAmount;
            }
        }
        String editFlag = MessageDigestTools.getSpecialFlag((String)srcString);
        String sql = "UPDATE T_BE_BankPayingBill SET  FEditFlag = ? ,FEditFlagNew = ?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{editFlag, editFlag, info.getId().toString()});
    }

    @Override
    protected void _reserveForBE(Context ctx, String bankPayingbillId, BankPayingBillStateEnum state) throws BOSException, EASBizException {
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        BankPayingBillInfo info = (BankPayingBillInfo)DynamicUtils.getInfo((Object[])new Object[]{bankPayingbillId});
        payingBillSateUtil.updateBankPayingBillInfo(ctx, info, ContextUtil.getCurrentUserInfo((Context)ctx), DateUtil.getTime(), state.getValue(), "", "");
    }

    @Override
    protected Map _updateState(Context ctx, IObjectPK[] pks, BankPayingBillStateEnum state) throws BOSException, EASBizException {
        if (CheckUtils.isEmpty((Object)pks)) {
            throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{EASResource.getString((String)resource, (String)"217_ID_LENGTH_ZERO", (Locale)ctx.getLocale())});
        }
        if (!CheckUtils.sameIn((Object)((Object)state), (Object[])new Object[]{BankPayingBillStateEnum.TS, BankPayingBillStateEnum.TF})) {
            throw new BEException(BEException.UPDATESTATEERROR2);
        }
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        return payingBillSateUtil.batchUpdateBankPayState(ctx, pks, state);
    }

    @Override
    protected boolean _audit(Context ctx, Set idSet, AuditStatus status) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return false;
        }
        String idFilter = FMHelper.setTran2String((Set)idSet);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Object[] args = status == AuditStatus.audited ? new Object[]{new Integer(status.getValue()), "'" + userInfo.getId().toString() + "'", idFilter} : new Object[]{new Integer(status.getValue()), null, idFilter};
        String sql = MessageFormat.format(UPDATE_BANKPAYBILL_STATUS, args);
        DbUtil.execute((Context)ctx, (String)sql);
        StringBuilder numberBuilder = new StringBuilder();
        sql = MessageFormat.format(SELECT_BANKPAYBILL_NUMBER, idFilter);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowset.next()) {
                numberBuilder.append(",").append(rowset.getString("FNumber"));
            }
            if (numberBuilder.length() > 0) {
                numberBuilder.delete(0, 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (status == AuditStatus.audited) {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BankPayingBillInfo().getBOSType(), null, (String)numberBuilder.toString(), (String)"bankPayingBill_audit");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        } else {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BankPayingBillInfo().getBOSType(), null, (String)numberBuilder.toString(), (String)"bankPayingBill_antiAudit");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return true;
    }

    @Override
    protected IObjectPK[] _commit2BankPayBill(Context ctx, Set idSet, String builderName) throws BOSException, EASBizException {
        IBankPayBillCollectionBuilder builder = BankPayBillBuilderFactory.getCollectionInstance(builderName);
        BankPayingBillCollection coll = builder.getBankPayBillCollection(ctx, idSet);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            BankPayingBillInfo info = (BankPayingBillInfo)it.next();
            if (info.getRecOpenArea() != null) {
                if (info.getRecOpenArea().getProvince() == null || info.getRecOpenArea().getName() == null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("province"));
                    selector.add(new SelectorItemInfo("name"));
                    OpenAreaInfo openArea = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaInfo((IObjectPK)new ObjectUuidPK(info.getRecOpenArea().getId()), selector);
                    info.setRecProvinceStr(openArea.getProvince());
                    info.setRecCityStr(openArea.getName());
                } else {
                    info.setRecProvinceStr(info.getRecOpenArea().getProvince());
                    info.setRecCityStr(info.getRecOpenArea().getName());
                }
            }
            if (info.getPayAccountBank().isIsOnlyRead()) {
                throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{info.getPayAccountBank().getName()});
            }
            if (info.getPayAccountBank().getMaxPayAmount() == null || Constants.ZERO.compareTo(info.getPayAccountBank().getMaxPayAmount()) >= 0 || info.getPayAmount().compareTo(info.getPayAccountBank().getMaxPayAmount()) <= 0) continue;
            throw new BEException(BEException.OVERMAXPAYAMOUNT, new Object[]{info.getPayAccountBank().getName(), info.getPayAccountBank().getMaxPayAmount()});
        }
        IObjectPK[] objPK = this._addnewBatchData(ctx, (IObjectCollection)coll);
        HashSet<String> newIdSet = new HashSet<String>(objPK.length);
        for (int i = 0; i < objPK.length; ++i) {
            newIdSet.add(objPK[i].toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", newIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        BankPayingBillCollection newColl = this.getBankPayingBillCollection(ctx, evi);
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator newIt = newColl.iterator();
        while (newIt.hasNext()) {
            BankPayingBillInfo info = (BankPayingBillInfo)newIt.next();
            map.put(info.getSourceBillId(), info.getId().toString());
        }
        BOTPUtil.saveBOTRelation((Context)ctx, map);
        return objPK;
    }

    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (BankPayingBillInfo info : colls) {
            this.verifyDataAdd(ctx, (IObjectValue)info);
            if (!EmptyUtil.isEmpty((String)info.getNumber())) continue;
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                info.setNumber(NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
                continue;
            }
            throw new BEException(BEException.HASNOCODINGRULE);
        }
        IObjectPK[] pks = super._addnewBatchData(ctx, colls);
        for (int i = 0; i < colls.size(); ++i) {
            BankPayingBillInfo info = (BankPayingBillInfo)colls.getObject(i);
            this.updateEditFlag(ctx, info);
        }
        return pks;
    }

    @Override
    protected ArrayList _commitToBENewBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        BankCommitToBeService commitToBeService = new BankCommitToBeService();
        ArrayList<BankPayResult> list = commitToBeService.bankToBEBatch(ctx, idSet);
        try {
            int i;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            view.setSelector(selector);
            BankPayingBillCollection BankPayingCol = this.getBankPayingBillCollection(ctx, view);
            HashMap<String, IObjectPK> pkOutMap = new HashMap<String, IObjectPK>();
            for (i = 0; i < BankPayingCol.size(); ++i) {
                String billId = BankPayingCol.get(i).getId().toString();
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BankPayingBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(billId), (String)BankPayingCol.get(i).getNumber(), (String)"bankPayingBill_submit");
                if (pkOutMap.containsKey(billId)) continue;
                pkOutMap.put(billId, pkOut);
            }
            for (i = 0; i < list.size(); ++i) {
                BankPayResult rlt = list.get(i);
                if (!EmptyUtil.isEmpty((String)rlt.getErrorDetail()) || !pkOutMap.containsKey(rlt.getId().toString())) continue;
                LogUtil.afterLog((Context)ctx, (IObjectPK)((IObjectPK)pkOutMap.get(rlt.getId().toString())));
            }
        }
        catch (Exception e) {
            logger.error((Object)"commitToBENewBatch LogUtil log bankPayingBill_submit error: ", (Throwable)e);
        }
        return list;
    }

    public void beforeCommit2Bank(Context ctx, String id) throws EASBizException, BOSException {
        String sql = "UPDATE T_BE_BankPayingBill SET FLastUpdateTime = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(Calendar.getInstance().getTimeInMillis()), id});
        String sql2 = "UPDATE T_BE_BankPayingBill SET FPriorityPay = 0 WHERE FID = ? and FIsSmart = 5 ";
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{id});
    }

    @Override
    protected IObjectPK _commit2BankNew(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        String id = info.get("id").toString();
        this.beforeCommit2Bank(ctx, id);
        BankPayingBillInfo bankPayingBillInfo = BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectorForBe());
        this.checkBankPayingNew(ctx, bankPayingBillInfo);
        String batchNo = StringUtils.cnulls((String)bankPayingBillInfo.getBatchNo());
        Timestamp subtmitTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        payingBillSateUtil.updateSourceBillState(ctx, bankPayingBillInfo.getSourceBillId(), 2, "", subtmitTime, batchNo, null, false, false);
        payingBillSateUtil.updateBankPayingBillInfo(ctx, bankPayingBillInfo, 2, ContextUtil.getCurrentUserInfo((Context)ctx), subtmitTime, null, batchNo);
        return new ObjectUuidPK(bankPayingBillInfo.getId());
    }

    @Override
    protected void _reserveForBeException(Context ctx, String bankPayingbillId) throws BOSException, EASBizException {
        BankPayingBillInfo info = this.getBankPayingBillInfo(ctx, (IObjectPK)new ObjectUuidPK(bankPayingbillId));
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        payingBillSateUtil.reserveForBeException(ctx, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)resource, (String)"218_BANKPAYING_FUNCTION"), (BOSObjectType)new BankPayingBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"be_bankpayingBill_cancel_commitToBe");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _reserveForOtherException(Context ctx, IObjectValue info, String returnMsg) throws BOSException, EASBizException {
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        payingBillSateUtil.reserveForOtherException(ctx, (BankPayingBillInfo)info, returnMsg);
    }

    @Override
    protected void _makeCommitToBeCache(Context ctx, Set bizBillIdSet, boolean isCreate) throws BOSException, EASBizException {
        Iterator iter1 = bizBillIdSet.iterator();
        String oneBizBillId = "";
        if (iter1.hasNext()) {
            oneBizBillId = (String)iter1.next();
        }
        if (BOSUuid.read((String)oneBizBillId).getType().equals((Object)new SettlementBillInfo().getBOSType())) {
            if (isCreate) {
                CommitToBeCache settleParamMap = new CommitToBeCache();
                settleParamMap.init(ctx, bizBillIdSet);
                ctx.put((Object)"settleParamMap", (Object)settleParamMap);
            } else {
                ctx.put((Object)"settleParamMap", null);
            }
        }
    }

    private void checkBankPayingNew(Context ctx, BankPayingBillInfo info) throws BEException, BOSException, EASBizException, RecPayException {
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        String TM018 = iContextHelper.getStringParam("TM018", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        if (TM018 == null || "0".equals(TM018)) {
            throw new BEException(BEException.PARAMNOTALLOWSUMBIT, new Object[]{info.getNumber(), info.getCompany().getName()});
        }
        this.checkBankPaying(ctx, info);
        boolean mustAuditParam = iContextHelper.getBooleanParam("BE001", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (mustAuditParam && info.getStatus() != AuditStatus.audited) {
            throw new BEException(BEException.MUSTAUDIT, new Object[]{info.getNumber()});
        }
    }

    private void checkBankPaying(Context ctx, BankPayingBillInfo info) throws BEException, BOSException, EASBizException, RecPayException {
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            BOSUuid id = BOSUuid.read((String)info.getSourceBillId());
            SettlementBillInfo sett = new SettlementBillInfo();
            PaymentBillInfo paybill = new PaymentBillInfo();
            if (id.getType().equals((Object)sett.getBOSType()) && !SettlementBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                throw new BEException(BEException.SRCBILLNOTFOUND, new Object[]{""});
            }
            if (id.getType().equals((Object)paybill.getBOSType()) && !PaymentBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                throw new BEException(BEException.SRCBILLNOTFOUND, new Object[]{""});
            }
        }
        if (info.isIsBitBack()) {
            throw new BEException(BEException.ALREADYBITBACK, new Object[]{info.getNumber()});
        }
        if (info.getState() != BankPayingBillStateEnum.OP && info.getState() != BankPayingBillStateEnum.OF) {
            throw new BEException(BEException.ONLYPREPSUBMIT, new Object[]{info.getNumber()});
        }
        if (info.getPayAccountBank().isIsOnlyRead()) {
            throw new BEException(BEException.ACCOUNTBANKONLYREAD, new Object[]{info.getPayAccountBank().getName()});
        }
        if (!EmptyUtil.isEmpty((Object)info.getPayAccountBank().getMaxPayAmount()) && info.getPayAccountBank().getMaxPayAmount().compareTo(Constants.ZERO) > 0 && info.getPayAmount().compareTo(info.getPayAccountBank().getMaxPayAmount()) > 0) {
            throw new BEException(BEException.OVERMAXPAYAMOUNT, new Object[]{info.getPayAccountBank().getName(), info.getPayAccountBank().getMaxPayAmount()});
        }
        this.checkIfByEdited(ctx, info);
    }

    @Override
    protected void _updateBillStateAndReturnMsg(Context ctx, String bankPayingBillId, int state, String returnMsg) throws EASBizException, BOSException {
        BankPayingBillSateUtil payingBillSateUtil = new BankPayingBillSateUtil();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        BankPayingBillInfo info = this.getBankPayingBillInfo(ctx, (IObjectPK)new ObjectUuidPK(bankPayingBillId));
        payingBillSateUtil.updateBankPayingBillInfo(ctx, info, state, currentUserInfo, DateUtil.getTime(), returnMsg, null);
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            payingBillSateUtil.updateSourceBillState(ctx, info.getSourceBillId(), state, returnMsg, DateUtil.getTime(), info.getBatchNo(), null, false, false);
        }
    }

    @Override
    protected void _modifyReason(Context ctx, Set idSet, String reason) throws BOSException, EASBizException {
        String ids = "";
        for (Object id : idSet) {
            ids = ids + ", '" + id.toString() + "'";
        }
        String sql = "update T_BE_BankPayingBill set freason = ? where fid in (" + ids.substring(1) + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{reason});
    }

    protected String _getAppSolutionID(Context ctx, IObjectPK id, IObjectValue model, String type) throws BOSException, EASBizException {
        String appSolutionID = null;
        BankPayingBillInfo info = null;
        if (model != null) {
            info = (BankPayingBillInfo)model;
        } else if (id != null) {
            info = (BankPayingBillInfo)this.getValue(ctx, id);
        }
        if (info != null) {
            appSolutionID = info.isIsCBPay() ? "8r0AAAAG/RQ7dcWQ" : "8r0AAAAOhsA7dcWQ";
        }
        return appSolutionID;
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        BankPayingBillInfo info = (BankPayingBillInfo)model;
        if (info != null) {
            if (info.isIsCBPay()) {
                if ("list".equals(viewType)) {
                    return "com.kingdee.eas.fm.cbs.fm_cbs_bankpay_list";
                }
            } else if ("list".equals(viewType)) {
                return "com.kingdee.eas.fm.be.fm_be_bankpay_list";
            }
        }
        return null;
    }

    @Override
    protected Map _openSmart(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<String> validIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isSmart"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BankPayingBillCollection payCol = BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(view);
        BatchExecuteResult result = new BatchExecuteResult();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)payCol)) {
            for (int i = 0; i < payCol.size(); ++i) {
                BankPayingBillInfo info = payCol.get(i);
                if (info.getIsSmart().getValue() == 2 || info.getIsSmart().getValue() == 4) {
                    validIds.add(info.getId().toString());
                    IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)resource, (String)"482_BankPayingBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"be_bankpayingBill_openSmart");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                    continue;
                }
                result.getDetailMsgList().add(info.getNumber() + ResourceBase.getString((String)resource, (String)"483_BankPayingBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (!EmptyUtil.isEmpty(validIds)) {
            String sql = "update T_BE_BankPayingBill set FIsSmart=1  where fid in ('" + validIds.toArray()[0] + "'";
            for (int i = 1; i < validIds.toArray().length; ++i) {
                sql = sql + ", '" + validIds.toArray()[i] + "'";
            }
            sql = sql + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (!EmptyUtil.isEmpty(validIds) && validIds.size() == idSet.size()) {
            result.setError(0);
            result.setSummaryMsg(idSet.size() + ResourceBase.getString((String)resource, (String)"484_BankPayingBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setError(1);
            int success = validIds == null ? 0 : validIds.size();
            result.setSummaryMsg(success + ResourceBase.getString((String)resource, (String)"485_BankPayingBillControllerBean", (Locale)ctx.getLocale()) + (idSet.size() - success) + ResourceBase.getString((String)resource, (String)"486_BankPayingBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    @Override
    protected Map _closeSmart(Context ctx, Set idSet) throws BOSException {
        HashSet<String> validIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("isSmart"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BankPayingBillCollection payCol = BankPayingBillFactory.getLocalInstance(ctx).getBankPayingBillCollection(view);
        BatchExecuteResult result = new BatchExecuteResult();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)payCol)) {
            for (int i = 0; i < payCol.size(); ++i) {
                BankPayingBillInfo info = payCol.get(i);
                if (info.getIsSmart().getValue() == 1 || info.getIsSmart().getValue() == 3) {
                    validIds.add(info.getId().toString());
                    IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)resource, (String)"487_BankPayingBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"be_bankpayingBill_closeSmart");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                    continue;
                }
                result.getDetailMsgList().add(info.getNumber() + ResourceBase.getString((String)resource, (String)"488_BankPayingBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if (!EmptyUtil.isEmpty(validIds)) {
            String sql = "update T_BE_BankPayingBill set FIsSmart=2  where fid in ('" + validIds.toArray()[0] + "'";
            for (int i = 1; i < validIds.toArray().length; ++i) {
                sql = sql + ", '" + validIds.toArray()[i] + "'";
            }
            sql = sql + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (!EmptyUtil.isEmpty(validIds) && validIds.size() == idSet.size()) {
            result.setError(0);
            result.setSummaryMsg(idSet.size() + ResourceBase.getString((String)resource, (String)"489_BankPayingBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setError(1);
            int success = validIds == null ? 0 : validIds.size();
            result.setSummaryMsg(success + ResourceBase.getString((String)resource, (String)"490_BankPayingBillControllerBean", (Locale)ctx.getLocale()) + (idSet.size() - success) + ResourceBase.getString((String)resource, (String)"491_BankPayingBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }
}

