/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.AuditStatus;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankPaymentSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankPaymentSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = "";
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("BankPaymentSmartFilter====" + iexec.getSQL() + " and fissmart in (1,3) "));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL() + " and fissmart in (1,3) ");
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        BusinessTypeInfo busiType;
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"492_BankPaymentSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"493_BankPaymentSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        if ((busiType = busiInfo.getBusinessType()) != null && !EmptyUtil.isEmpty((String)busiInfo.getOperatorNumber())) {
            String operatorNumber = busiInfo.getOperatorNumber();
            if ("bankpay_aduit".equals(operatorNumber)) {
                result.append(" and state = 1 and Status = 0 ");
            }
            if ("bankpay_aduit_submit".equals(operatorNumber)) {
                result.append(" and state = 1 ");
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        result = new HashMap<String, Object>();
        map = new HashMap<K, V>();
        busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        busiType = busiInfo.getBusinessType();
        billList = (List)paramMap.get("billList");
        companyID = "" + paramMap.get("companyID");
        auditor = "";
        if (schemaInfo != null && schemaInfo.getAuditor() != null) {
            auditor = schemaInfo.getAuditor().getId().toString();
        }
        success = 0;
        failure = 0;
        errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            operatorNumber = busiInfo.getOperatorNumber();
            mustAuditParam = false;
            if (!EmptyUtil.isEmpty((String)companyID)) {
                mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("BE001", (IObjectPK)new ObjectUuidPK(companyID));
            }
            biz = BankPayingBillFactory.getLocalInstance(ctx);
            if ("bankpay_aduit".equals(operatorNumber)) {
                auditSet = new HashSet<E>();
                for (i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet<E>();
                        set.add(billList.get(i));
                        if (mustAuditParam) {
                            biz.audit(set, AuditStatus.audited);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    sb = new StringBuffer();
                    sb.append("UPDATE T_BE_BankPayingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
            }
            if ("bankpay_aduit_submit".equals(operatorNumber)) {
                bankSet = new HashSet<String>();
                auditSet = new HashSet<E>();
                for (i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet<E>();
                        set.add(billList.get(i));
                        if (mustAuditParam) {
                            biz.audit(set, AuditStatus.audited);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        bankSet.add(billList.get(i) + "");
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    sb = new StringBuffer();
                    sb.append("UPDATE T_BE_BankPayingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    sb = new StringBuffer();
                    sb.append("UPDATE T_BE_BankPayingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    try {
                        biz.commitToBENewBatch(bankSet);
                        success = bankSet.size();
                    }
                    catch (Exception e) {
                        try {
                            failure += bankSet.size();
                            errorMsg = errorMsg + e.getMessage();
                        }
                        catch (Throwable var21_32) {
                            if (!EmptyUtil.isEmpty(bankSet)) {
                                sb = new StringBuffer();
                                sb.append("UPDATE T_BE_BankPayingBill SET fissmart = ? WHERE");
                                sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{1});
                            }
                            throw var21_32;
                        }
                        if (!EmptyUtil.isEmpty(bankSet)) {
                            sb = new StringBuffer();
                            sb.append("UPDATE T_BE_BankPayingBill SET fissmart = ? WHERE");
                            sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{1});
                        } else {
                            ** GOTO lbl115
                        }
                    }
                    if (!EmptyUtil.isEmpty(bankSet)) {
                        sb = new StringBuffer();
                        sb.append("UPDATE T_BE_BankPayingBill SET fissmart = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + " ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{1});
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    public static void main(String args) {
        System.out.println("8");
    }
}

