/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ebgateway.common.VirtualInfo;
import com.kingdee.eas.fm.be.app.EBWSAbstractUtil;
import com.kingdee.eas.fm.be.ws.AgencySalaryInfo;
import com.kingdee.eas.fm.be.ws.BalanceInfo;
import com.kingdee.eas.fm.be.ws.BankAcnt;
import com.kingdee.eas.fm.be.ws.CallerTag;
import com.kingdee.eas.fm.be.ws.DetailInfo;
import com.kingdee.eas.fm.be.ws.FundTransferInfo;
import com.kingdee.eas.fm.be.ws.PayStateInfo;
import com.kingdee.eas.fm.be.ws.PaymentCheckResult;
import com.kingdee.eas.fm.be.ws.PaymentInfo;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;

public class BankServiceUtil
extends EBWSAbstractUtil {
    public BankServiceUtil(Context ctx) {
        this.wsName = "/services/BankService";
        this.nameSpace = "bankservice.ws.ebgateway.bos.kingdee.com";
        this.setHostAndPortAndUser(ctx);
    }

    public BankServiceUtil(Context ctx, String wsName, String nameSpace) {
        this.wsName = wsName;
        this.nameSpace = nameSpace;
        this.setHostAndPortAndUser(ctx);
    }

    public String[] getSerialNumber(BankAcnt acnt, boolean isPayment, int count) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("getSerialNumber");
        return (String[])call.invoke(new Object[]{acnt, new Boolean(isPayment), new Integer(count)});
    }

    public PaymentCheckResult checkFundTransfer(FundTransferInfo info) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("checkFundTransfer");
        return (PaymentCheckResult)call.invoke(new Object[]{info});
    }

    public PaymentCheckResult checkPayment(PaymentInfo paymentInfo) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("checkPayment");
        return (PaymentCheckResult)call.invoke(new Object[]{paymentInfo});
    }

    public PayStateInfo[] getFundTransferState(CallerTag callerTag, BankAcnt acnt, String[] packageIDArray) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("getFundTransferState");
        return (PayStateInfo[])call.invoke(new Object[]{callerTag, acnt, packageIDArray});
    }

    public PayStateInfo[] getPaymentState(CallerTag callerTag, BankAcnt acnt, String[] packageIDArray) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("getPaymentState");
        return (PayStateInfo[])call.invoke(new Object[]{callerTag, acnt, packageIDArray});
    }

    public PaymentInfo submitPayment(CallerTag callerTag, PaymentInfo paymentInfo) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("submitPayment");
        PaymentInfo info = (PaymentInfo)call.invoke(new Object[]{callerTag, paymentInfo});
        return info;
    }

    public FundTransferInfo transferDown(CallerTag callerTag, FundTransferInfo info) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("transferDown");
        return (FundTransferInfo)call.invoke(new Object[]{callerTag, info});
    }

    public FundTransferInfo transferUp(CallerTag callerTag, FundTransferInfo info) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("transferUp");
        return (FundTransferInfo)call.invoke(new Object[]{callerTag, info});
    }

    public BalanceInfo[] getBalance(CallerTag callerTag, BankAcnt[] acnts, String currency, Date beginDate, Date endDate) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("getBalance");
        return (BalanceInfo[])call.invoke(new Object[]{callerTag, acnts, currency, beginDate, endDate});
    }

    public DetailInfo[] getDetails(CallerTag callerTag, BankAcnt acnt, String currency, Date beginDate, Date endDate) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("getDetails");
        return (DetailInfo[])call.invoke(new Object[]{callerTag, acnt, currency, beginDate, endDate});
    }

    public AgencySalaryInfo agencySalary(CallerTag callerTag, AgencySalaryInfo info) throws ServiceException, RemoteException {
        Call call = this.createCallByWSS("agencySalary");
        return (AgencySalaryInfo)call.invoke(new Object[]{callerTag, info});
    }

    public PayStateInfo[] getAgencySalaryState(CallerTag callerTag, BankAcnt acnt, String packageID, Date payDate) throws ServiceException, RemoteException {
        return null;
    }

    public VirtualInfo[] getVirtualDetails(CallerTag callerTag, VirtualInfo[] virtualInfos) throws RemoteException, ServiceException {
        Call call = this.createCallByWSS("getMaxQuerySize");
        int maxSize = (Integer)call.invoke(new Object[]{callerTag, virtualInfos[0].getAcnt()});
        call = this.createCallByWSS("getVirtualDetails");
        ArrayList<VirtualInfo> tmpList = new ArrayList<VirtualInfo>();
        for (int i = 0; i < virtualInfos.length; ++i) {
            int j;
            if (tmpList.size() <= maxSize) {
                tmpList.add(virtualInfos[i]);
            }
            if (tmpList.size() != maxSize && i != virtualInfos.length - 1) continue;
            VirtualInfo[] tmp = new VirtualInfo[tmpList.size()];
            for (j = 0; j < tmpList.size(); ++j) {
                tmp[j] = (VirtualInfo)tmpList.get(j);
            }
            tmp = (VirtualInfo[])call.invoke(new Object[]{callerTag, tmp});
            tmpList.clear();
            for (j = 0; j < tmp.length; ++j) {
                virtualInfos[i - tmp.length + j + 1] = tmp[j];
            }
        }
        return virtualInfos;
    }
}

