/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransDownBillBuilderFactory;
import com.kingdee.eas.fm.be.BankTransDownBillCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.IBankTransDownBillBuilder;
import com.kingdee.eas.fm.be.app.AbstractBankTransDownBillControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BankTransDownBillControllerBean
extends AbstractBankTransDownBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankTransDownBillControllerBean");

    @Override
    protected IObjectPK _commit2BankTransDownBill(Context ctx, String billId, String builderName) throws BOSException, EASBizException {
        IBankTransDownBillBuilder builder = BankTransDownBillBuilderFactory.getInstance(builderName);
        BankTransDownBillInfo info = builder.getBankTransDownBillInfo(ctx, billId);
        if (info.getMotherAcctBank() != null && info.getTotalAmt() != null && info.getMotherAcctBank().getMaxPayAmount() != null && info.getMotherAcctBank().getMaxPayAmount().compareTo(Constants.ZERO) > 0 && info.getTotalAmt().compareTo(info.getMotherAcctBank().getMaxPayAmount()) > 0) {
            throw new BEException(BEException.OVERMAXPAYAMOUNT, new Object[]{info.getMotherAcctBank().getName(), info.getMotherAcctBank().getMaxPayAmount()});
        }
        IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(billId, pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, map);
        BankTransDownBillCollection coll = new BankTransDownBillCollection();
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("currency.*");
        sele.add("payAccountBank.*");
        sele.add("recProvince.*");
        sele.add("recCity.*");
        sele.add("recRegion.*");
        sele.add("recOpenArea.*");
        sele.add("motherAcctBank.*");
        sele.add("entrys.*");
        info = this.getBankTransDownBillInfo(ctx, pk, sele);
        coll.add(info);
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankTransDownBillInfo info = (BankTransDownBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            } else {
                throw new BEException(BEException.NOTRANSDOWNRULECODE);
            }
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankTransDownBillInfo info = (BankTransDownBillInfo)this._getValue(ctx, pk);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getState() == BankPayingBillStateEnum.TF) continue;
            throw new BEException(BEException.BANKTRANSDOWNDELETEERR);
        }
        if (!info.isIsBitBack()) {
            throw new BEException(BEException.BANKTRANSDOWNDELETEERR);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _bitBack(Context ctx, List ids) throws BOSException, EASBizException {
        BankTransDownBillCollection coll = this.getColl4BitBack(ctx, ids);
        if (FMHelper.isEmpty((AbstractObjectCollection)coll)) {
            throw new BEException(BEException.NOSUITRECORD);
        }
        for (int i = 0; i < coll.size(); ++i) {
            BankTransDownBillInfo info = coll.get(i);
            for (int k = 0; k < info.getEntrys().size(); ++k) {
                BankTransDownBillEntryInfo entryInfo = info.getEntrys().get(k);
                if (entryInfo.getState() == BankPayingBillStateEnum.TF || entryInfo.getState() == BankPayingBillStateEnum.OF) continue;
                throw new BEException(BEException.BANKTRANSDOWNBILLCANNOTDELETE, new Object[]{info.getNumber()});
            }
            if (info.isIsBitBack()) {
                throw new BEException(BEException.BANKTRANSDOWNBILLHASBITBACK, new Object[]{info.getNumber()});
            }
            if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && !TransDownBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                throw new BEException(BEException.SOURCENULLNOTBITBACK, new Object[]{info.getNumber()});
            }
            String sbillId = info.getSourceBillId();
            if (!FMHelper.isEmpty((String)sbillId)) {
                this.rever4Remove(ctx, info, sbillId);
            }
            super._delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            info.setId(null);
            info.setSourceBillId(null);
            info.setIsBitBack(true);
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                info.getEntrys().get(j).setIsBitBack(true);
            }
            super.addnew(ctx, (CoreBaseInfo)info);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BankTransDownBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_bankTransDownbill_BitBack");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
    }

    private void rever4Remove(Context ctx, BankTransDownBillInfo info, String sbillId) throws BOSException, EASBizException {
        TransDownBillFacadeFactory.getLocalInstance((Context)ctx).cancelCommitToBE(sbillId);
    }

    private BankTransDownBillCollection getColl4BitBack(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        BankTransDownBillCollection coll = this.getBankTransDownBillCollection(ctx, ev);
        return coll;
    }
}

