/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransDownBillCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryCollection;
import com.kingdee.eas.fm.be.BankTransDownBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransDownBillFactory;
import com.kingdee.eas.fm.be.BankTransDownBillInfo;
import com.kingdee.eas.fm.be.app.AbstractBankTransDownBillEntryControllerBean;
import com.kingdee.eas.fm.be.app.service.BusinessTollUtil;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.TransDownBillEntryCollection;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankTransDownBillEntryControllerBean
extends AbstractBankTransDownBillEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankTransDownBillEntryControllerBean");

    @Override
    protected Map _updateState(Context ctx, Set idSet, BankPayingBillStateEnum state) throws BOSException, EASBizException {
        Map resultMap = ConvertUtils.JSMAP((Object[])new Object[0]);
        if (idSet == null || idSet.isEmpty()) {
            return resultMap;
        }
        if (state.getValue() != 6 && state.getValue() != 5) {
            throw new BEException(BEException.UPDATESTATEERROR2);
        }
        HashSet<String> bankTransDownBillIds = new HashSet<String>();
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.setFilter(entryFilter);
        entryView.getSelector().add("*");
        entryView.getSelector().add("unitAcctBank.bankAccountNumber");
        entryView.getSelector().add("parent.id");
        entryView.getSelector().add("parent.sourcebillid");
        BankTransDownBillEntryCollection coll = this.getBankTransDownBillEntryCollection(ctx, entryView);
        HashMap<String, BankTransDownBillEntryCollection> updateMap = new HashMap<String, BankTransDownBillEntryCollection>();
        for (int i = 0; i < coll.size(); ++i) {
            BankPayResult result = new BankPayResult();
            BankTransDownBillEntryInfo entryInfo = coll.get(i);
            if (!entryInfo.getState().equals((Object)BankPayingBillStateEnum.NC)) {
                result.setErrorDetail("\u72b6\u6001\u4e0d\u4e3a\u3010\u4ea4\u6613\u672a\u786e\u8ba4\u3011");
            } else {
                BankTransDownBillEntryCollection needUpdate2EBGCol;
                String bankTransDownBillId = entryInfo.getParent().getId().toString();
                bankTransDownBillIds.add(bankTransDownBillId);
                if (updateMap.containsKey(bankTransDownBillId)) {
                    needUpdate2EBGCol = (BankTransDownBillEntryCollection)((Object)updateMap.get(bankTransDownBillId));
                    needUpdate2EBGCol.add(entryInfo);
                } else {
                    needUpdate2EBGCol = new BankTransDownBillEntryCollection();
                    needUpdate2EBGCol.add(entryInfo);
                    updateMap.put(bankTransDownBillId, needUpdate2EBGCol);
                }
            }
            result.setId(entryInfo.getId().toString());
            result.setState(entryInfo.getState());
            result.setSubmitToBe(false);
            resultMap.put(entryInfo.getId().toString(), result);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bankTransDownBillIds, CompareType.INCLUDE));
        evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("entrys.*");
        evi.getSelector().add("company.name");
        evi.getSelector().add("motherAcctBank.bankAccountNumber");
        evi.getSelector().add("*");
        BankTransDownBillCollection billColl = BankTransDownBillFactory.getLocalInstance(ctx).getBankTransDownBillCollection(evi);
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isNeedConfirm = false;
        HashMap<BOSUuid, Boolean> paramMap = new HashMap<BOSUuid, Boolean>();
        BusinessTollUtil util = new BusinessTollUtil();
        for (int i = 0; i < billColl.size(); ++i) {
            HashSet<String> bankTransDownEntryIds = new HashSet<String>();
            HashSet<String> TransDownBillEntryIds = new HashSet<String>();
            BankTransDownBillInfo info = billColl.get(i);
            if (paramMap.containsKey(info.getCompany().getId())) {
                isNeedConfirm = (Boolean)paramMap.get(info.getCompany().getId());
            } else {
                isNeedConfirm = localInstance.getBooleanParam("TM019", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put(info.getCompany().getId(), isNeedConfirm);
            }
            BankTransDownBillEntryCollection updateEntry = (BankTransDownBillEntryCollection)((Object)updateMap.get(info.getId().toString()));
            Map ret = util.updateTransDownState2EBS(ctx, info, updateEntry, state);
            for (int t = 0; t < updateEntry.size(); ++t) {
                BankTransDownBillEntryInfo entryInfo = updateEntry.get(t);
                Map entry = (Map)ret.get(ConvertUtils.IDSTR((Object)entryInfo));
                BankPayResult result = (BankPayResult)resultMap.get(ConvertUtils.IDSTR((Object)entryInfo));
                result.setSubmitToBe(ConvertUtils.BOOL(entry.get("submit2EBS")));
                result.setErrorDetail(ConvertUtils.STR(entry.get("errorMsg")));
                result.setNumber(info.getNumber());
                if (!CheckUtils.same((Object)"SUCCESS", entry.get("result"))) continue;
                bankTransDownEntryIds.add(entryInfo.getId().toString());
                TransDownBillEntryIds.add(entryInfo.getSrcBillNumber());
            }
            String sql = "Update T_BE_BankTransDownBillEntry set FState = ? where FId in " + FMHelper.setTran2String(bankTransDownEntryIds);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{state.getValue()});
            String srcSql = "UPDATE T_FS_TransDownBillEntry Set FBankState=?, FIsSuccessed = ? WHERE FID in " + FMHelper.setTran2String(TransDownBillEntryIds);
            String upState = state.getValue() == 6 ? "1" : "0";
            DbUtil.execute((Context)ctx, (String)srcSql, (Object[])new Object[]{state.getValue(), upState});
            Iterator iter = bankTransDownEntryIds.iterator();
            while (iter.hasNext()) {
                String number = info.getNumber() + "_" + (String)iter.next();
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)number, (String)"fs_bankTransDownbill_UpdateState");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            if (!isNeedConfirm) continue;
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("entrys.*");
                TransDownBillInfo tranDownBillInfo = TransDownBillFactory.getLocalInstance((Context)ctx).getTransDownBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), selector);
                if (tranDownBillInfo.getState() == TransDownBillStateEnum.CONFIRMED) continue;
                int successCount = 0;
                int failCount = 0;
                BigDecimal amt = BigDecimal.ZERO;
                BigDecimal localAmt = BigDecimal.ZERO;
                TransDownBillEntryCollection entrys = tranDownBillInfo.getEntrys();
                for (int j = 0; j < entrys.size(); ++j) {
                    TransDownBillEntryInfo entry = entrys.get(j);
                    if (entry.getBankState() == BankPayingBillStateEnum.TS) {
                        ++successCount;
                        amt = amt.add(entry.getAmount());
                        localAmt = localAmt.add(entry.getLocalAmt());
                        continue;
                    }
                    if (entry.getBankState() != BankPayingBillStateEnum.TF) continue;
                    ++failCount;
                }
                if (successCount <= 0 || successCount + failCount != entrys.size()) continue;
                tranDownBillInfo.setConfirmedAmt(amt);
                tranDownBillInfo.setConfirmedCounts(successCount);
                tranDownBillInfo.setConfirmedLocalAmt(localAmt);
                TransDownBillFacadeFactory.getLocalInstance((Context)ctx).confirm(tranDownBillInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("confirm failed\uff01" + e));
            }
        }
        return ConvertUtils.JSMAP((Object[])new Object[]{"resultList", ConvertUtils.LIST((Object)resultMap)});
    }
}

