/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransUpBillBuilderFactory;
import com.kingdee.eas.fm.be.BankTransUpBillCollection;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.IBankTransUpBillBuilder;
import com.kingdee.eas.fm.be.app.AbstractBankTransUpBillControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BankTransUpBillControllerBean
extends AbstractBankTransUpBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.app.BankTransUpBillControllerBean");

    @Override
    protected IObjectPK _commit2BankTransUpBill(Context ctx, String billId, String builderName) throws BOSException, EASBizException {
        IBankTransUpBillBuilder builder = BankTransUpBillBuilderFactory.getInstance(builderName);
        BankTransUpBillInfo info = builder.getBankTransUpBillInfo(ctx, billId);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            BankTransUpBillEntryInfo entryInfo = info.getEntrys().get(i);
            if (entryInfo.getUnitAcctBank() == null || entryInfo.getAmount() == null || entryInfo.getUnitAcctBank().getMaxPayAmount() == null || entryInfo.getUnitAcctBank().getMaxPayAmount().compareTo(Constants.ZERO) <= 0 || entryInfo.getAmount().compareTo(entryInfo.getUnitAcctBank().getMaxPayAmount()) <= 0) continue;
            throw new BEException(BEException.OVERMAXPAYAMOUNT, new Object[]{entryInfo.getUnitAcctBank().getName(), entryInfo.getUnitAcctBank().getMaxPayAmount()});
        }
        IObjectPK pk = this._addnew(ctx, (IObjectValue)info);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(billId, pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, map);
        BankTransUpBillCollection coll = new BankTransUpBillCollection();
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("currency.*");
        sele.add("payAccountBank.*");
        sele.add("motherAcctBank.*");
        sele.add("entrys.*");
        sele.add("entrys.unitAcctBank.*");
        info = this.getBankTransUpBillInfo(ctx, pk, sele);
        coll.add(info);
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankTransUpBillInfo info = (BankTransUpBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            } else {
                throw new BEException(BEException.NOTRANSUPRULECODE);
            }
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankTransUpBillInfo info = (BankTransUpBillInfo)this._getValue(ctx, pk);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getState() == BankPayingBillStateEnum.TF) continue;
            throw new BEException(BEException.BANKTRANSUPDELETEERR);
        }
        if (!info.isIsBitBack()) {
            throw new BEException(BEException.BANKTRANSUPDELETEERR);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _bitBack(Context ctx, List ids) throws BOSException, EASBizException {
        BankTransUpBillCollection coll = this.getColl4BitBack(ctx, ids);
        if (FMHelper.isEmpty((AbstractObjectCollection)coll)) {
            throw new BEException(BEException.NOSUITRECORD);
        }
        for (int i = 0; i < coll.size(); ++i) {
            BankTransUpBillInfo info = coll.get(i);
            for (int k = 0; k < info.getEntrys().size(); ++k) {
                BankTransUpBillEntryInfo entryInfo = info.getEntrys().get(k);
                if (entryInfo.getState() == BankPayingBillStateEnum.TF || entryInfo.getState() == BankPayingBillStateEnum.OF) continue;
                throw new BEException(BEException.BANKTRANSUPBILLCANNOTDELETE, new Object[]{info.getNumber()});
            }
            if (info.isIsBitBack()) {
                throw new BEException(BEException.BANKTRANSUPBILLHASBITBACK, new Object[]{info.getNumber()});
            }
            if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && !TransUpBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))) {
                throw new BEException(BEException.SOURCENULLNOTBITBACK, new Object[]{info.getNumber()});
            }
            String sbillId = info.getSourceBillId();
            if (!FMHelper.isEmpty((String)sbillId)) {
                this.rever4Remove(ctx, info, sbillId);
            }
            super._delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            info.setId(null);
            info.setSourceBillId(null);
            info.setIsBitBack(true);
            super.addnew(ctx, (CoreBaseInfo)info);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new BankTransUpBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fs_bankTransupbill_BitBack");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
    }

    private void rever4Remove(Context ctx, BankTransUpBillInfo info, String sbillId) throws BOSException, EASBizException {
        TransUpBillFacadeFactory.getLocalInstance((Context)ctx).cancelCommitToBE(sbillId);
    }

    private BankTransUpBillCollection getColl4BitBack(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        BankTransUpBillCollection coll = this.getBankTransUpBillCollection(ctx, ev);
        return coll;
    }
}

